/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.user.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.tydic.nicc.base.bo.user.UserAuthInfo;
import com.tydic.nicc.base.constant.RedisCacheKeyConstant;
import com.tydic.nicc.base.eum.SystemModelType;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.user.config.NiccUserConfigPropertiesBean;
import com.tydic.nicc.user.intfce.UserAuthService;
import com.tydic.nicc.user.intfce.bo.UserJoinInfoBO;
import com.tydic.nicc.user.mapper.BsCustomerMapper;
import com.tydic.nicc.user.mapper.UserAuthMapper;
import com.tydic.nicc.user.mapper.po.BsCustomerPO;
import com.tydic.nicc.user.mapper.po.UserAuthConfig;
import com.tydic.nicc.user.service.AuthStrategyFactory;
import com.tydic.nicc.user.utils.UserCenterBaseUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

@DS(value="nicc-user")
@DubboService(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=10000)
public class UserAuthServiceImpl
implements UserAuthService {
    private static final Logger log = LoggerFactory.getLogger(UserAuthServiceImpl.class);
    @Resource
    private NiccUserConfigPropertiesBean niccUserConfigPropertiesBean;
    @Resource
    private UserAuthMapper userAuthMapper;
    @Resource
    private BsCustomerMapper bsCustomerMapper;
    @Resource
    private AuthStrategyFactory authStrategyFactory;
    @Resource
    private RedisHelper redisHelper;

    public UserAuthConfig initUserAuthConfig(String tenantCode, String channelCode) {
        UserAuthConfig authConfig = new UserAuthConfig();
        authConfig.setTenantCode(tenantCode);
        authConfig.setChannelCode(channelCode);
        return this.userAuthMapper.selectByTenantCode(authConfig);
    }

    public Rsp<UserAuthInfo> authUser(String connectParam) {
        Rsp authInfoRsp = null;
        String jsonData = null;
        try {
            UserAuthConfig authConfig;
            jsonData = URLDecoder.decode(connectParam, "UTF-8");
            UserJoinInfoBO userJoinInfoBO = (UserJoinInfoBO)JSONObject.parseObject((String)jsonData, UserJoinInfoBO.class);
            userJoinInfoBO.setUserNoticeType("WEBSOCKET");
            log.info("\u7528\u6237\u53c2\u6570:{}", (Object)userJoinInfoBO);
            if (SystemModelType.TENANT.getCode().equals(this.niccUserConfigPropertiesBean.getSystemModel())) {
                if (StringUtils.isEmpty((CharSequence)userJoinInfoBO.getTenantCode())) {
                    return BaseRspUtils.createErrorRsp((String)"\u79df\u6237\u6a21\u5f0f\u4e0btenantCode\u4e0d\u5f97\u4e3a\u7a7a!");
                }
            } else {
                userJoinInfoBO.setTenantCode(SystemModelType.PLATFORM.getCode());
            }
            if (StringUtils.isEmpty((CharSequence)userJoinInfoBO.getUserId())) {
                if (this.niccUserConfigPropertiesBean.getAllowGuest().booleanValue()) {
                    UserAuthInfo authInfo = new UserAuthInfo();
                    authInfo.setTenantCode(userJoinInfoBO.getTenantCode());
                    authInfo.setChannelCode(userJoinInfoBO.getChannelCode());
                    authInfo.setUserId(UserCenterBaseUtil.createGuestUID());
                    authInfo.setNickName(UserCenterBaseUtil.createGuestNickName());
                    authInfo.setUserType("6");
                    authInfo.setUserHeadImg(this.niccUserConfigPropertiesBean.getGuestHeadimg());
                    return BaseRspUtils.createSuccessRsp((Object)authInfo, (String)"\u6e38\u5ba2\u8bbf\u95ee\u8ba4\u8bc1\u901a\u8fc7!");
                }
                log.warn("\u5f53\u524d\u7cfb\u7edf\u4e0d\u5141\u8bb8\u6e38\u5ba2\u8bbf\u95ee\uff0c\u8bf7\u4f20\u5165\u7528\u6237ID!");
                return BaseRspUtils.createErrorRsp((String)"\u5f53\u524d\u7cfb\u7edf\u4e0d\u5141\u8bb8\u6e38\u5ba2\u8bbf\u95ee\uff0c\u8bf7\u4f20\u5165\u7528\u6237ID!");
            }
            if (StringUtils.isNotEmpty((CharSequence)userJoinInfoBO.getExtraData()) && (authConfig = this.initUserAuthConfig(userJoinInfoBO.getTenantCode(), userJoinInfoBO.getChannelCode())) != null) {
                log.info("\u6267\u884c\u7b2c\u4e09\u65b9\u8ba4\u8bc1:{}", (Object)authConfig);
                authInfoRsp = this.authStrategyFactory.handlerAuthMethod(authConfig.getAuthType(), userJoinInfoBO.getExtraData(), authConfig);
                if (authInfoRsp.isSuccess()) {
                    BsCustomerPO record = new BsCustomerPO();
                    record.setTenantCode(userJoinInfoBO.getTenantCode());
                    record.setExtUid(((UserAuthInfo)authInfoRsp.getData()).getExtUid());
                    BsCustomerPO customerPO = this.bsCustomerMapper.selectByExUidAndTCode(record);
                    if (customerPO == null) {
                        return BaseRspUtils.createErrorRsp((String)"\u672a\u67e5\u8be2\u5230\u7528\u6237\uff0c\u8bf7\u5148\u5bfc\u5165\u7528\u6237\u6570\u636e!");
                    }
                    BeanUtils.copyProperties((Object)customerPO, (Object)authInfoRsp.getData());
                    ((UserAuthInfo)authInfoRsp.getData()).setUserType(String.valueOf(customerPO.getUserType()));
                    return authInfoRsp;
                }
            }
            if (this.checkSign(userJoinInfoBO)) {
                BsCustomerPO record = new BsCustomerPO();
                record.setTenantCode(userJoinInfoBO.getTenantCode());
                record.setChannelCode(userJoinInfoBO.getChannelCode());
                record.setUserId(userJoinInfoBO.getUserId());
                BsCustomerPO customerPO = this.bsCustomerMapper.selectByUserIdAndTCode(record);
                if (customerPO != null) {
                    UserAuthInfo authInfo = new UserAuthInfo();
                    authInfo.setUserId(userJoinInfoBO.getUserId());
                    authInfo.setNickName(customerPO.getCustNickName());
                    authInfo.setUserHeadImg(customerPO.getHeadPhoto());
                    authInfo.setTenantCode(userJoinInfoBO.getTenantCode());
                    authInfo.setChannelCode(userJoinInfoBO.getChannelCode());
                    authInfo.setUserType(String.valueOf(customerPO.getUserType()));
                    if (StringUtils.isEmpty((CharSequence)customerPO.getHeadPhoto())) {
                        authInfo.setUserHeadImg(this.niccUserConfigPropertiesBean.getDefaultHeadimg());
                    }
                    String cacheKey = RedisCacheKeyConstant.getUserInfoCacheKey((String)authInfo.getUserId());
                    this.redisHelper.set(cacheKey, (Object)authInfo, (long)RedisCacheKeyConstant.USER_INFO_CACHE_TIME.intValue());
                    return BaseRspUtils.createSuccessRsp((Object)authInfo, (String)"\u7528\u6237\u8ba4\u8bc1\u901a\u8fc7");
                }
                return BaseRspUtils.createErrorRsp((String)"\u672a\u67e5\u8be2\u5230\u7528\u6237!");
            }
            log.error("\u7528\u6237\u7b7e\u540d\u8ba4\u8bc1\u5931\u8d25:{}", (Object)userJoinInfoBO);
            return BaseRspUtils.createErrorRsp((String)"\u7b7e\u540d\u8ba4\u8bc1\u5931\u8d25!");
        }
        catch (UnsupportedEncodingException e) {
            return BaseRspUtils.createErrorRsp((String)("\u8fde\u63a5\u53c2\u6570\u89e3\u7801\u9519\u8bef:" + e.getMessage()));
        }
    }

    private boolean checkSign(UserJoinInfoBO userJoinInfoBO) {
        return true;
    }
}

