/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.user.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.tydic.nicc.base.bo.user.UserAuthInfo;
import com.tydic.nicc.base.constant.RedisCacheKeyConstant;
import com.tydic.nicc.base.eum.UserOnlineStatus;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.user.config.NiccUserConfigPropertiesBean;
import com.tydic.nicc.user.intfce.UserOptionService;
import com.tydic.nicc.user.intfce.bo.UserOfflineReqBO;
import com.tydic.nicc.user.intfce.bo.UserOnlineReqBO;
import com.tydic.nicc.user.mapper.BsCustomerMapper;
import com.tydic.nicc.user.mapper.UserConnectRecordMapper;
import com.tydic.nicc.user.mapper.po.BsCustomerPO;
import com.tydic.nicc.user.mapper.po.UserConnectRecord;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

@DS(value="nicc-user")
@DubboService(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=10000)
public class UserOptionServiceImpl
implements UserOptionService {
    private static final Logger log = LoggerFactory.getLogger(UserOptionServiceImpl.class);
    @Resource
    private RedisHelper redisHelper;
    @Resource
    private UserConnectRecordMapper userConnectRecordMapper;
    @Resource
    private BsCustomerMapper bsCustomerMapper;
    @Resource
    private NiccUserConfigPropertiesBean niccUserConfigPropertiesBean;

    public Rsp userOnline(UserOnlineReqBO userOnlineReqBO) {
        log.info("\u7528\u6237\u4e0a\u7ebf:{}", (Object)userOnlineReqBO);
        String cacheKey = RedisCacheKeyConstant.getUserStatusKey((String)userOnlineReqBO.getUserId());
        this.redisHelper.set(cacheKey, (Object)UserOnlineStatus.ONLINE.getCode());
        UserConnectRecord record = new UserConnectRecord();
        record.setPid(IdWorker.nextAutoId());
        BeanUtils.copyProperties((Object)userOnlineReqBO, (Object)record);
        this.userConnectRecordMapper.insertSelective(record);
        return BaseRspUtils.createSuccessRsp((Object)"\u7528\u6237\u4e0a\u7ebf");
    }

    public Rsp userOffline(UserOfflineReqBO userOfflineReqBO) {
        String cacheKey = RedisCacheKeyConstant.getUserStatusKey((String)userOfflineReqBO.getUserId());
        this.redisHelper.del(new String[]{cacheKey});
        return BaseRspUtils.createSuccessRsp((Object)"\u7528\u6237\u4e0b\u7ebf");
    }

    public Rsp getOnlineStatus(String userId) {
        String cacheKey = RedisCacheKeyConstant.getUserStatusKey((String)userId);
        String status = (String)this.redisHelper.get(cacheKey);
        if (StringUtils.isEmpty((CharSequence)status)) {
            return BaseRspUtils.createSuccessRsp((Object)UserOnlineStatus.OFFLINE.getCode());
        }
        return BaseRspUtils.createSuccessRsp((Object)status);
    }

    public Rsp getUserAuthInfo(String userId) {
        String cacheKey = RedisCacheKeyConstant.getUserInfoCacheKey((String)userId);
        UserAuthInfo authInfo = (UserAuthInfo)this.redisHelper.get(cacheKey);
        if (authInfo == null) {
            BsCustomerPO record = new BsCustomerPO();
            record.setUserId(userId);
            BsCustomerPO customerPO = this.bsCustomerMapper.selectByUserId(userId);
            authInfo = new UserAuthInfo();
            authInfo.setUserId(customerPO.getUserId());
            authInfo.setNickName(customerPO.getCustNickName());
            authInfo.setUserHeadImg(customerPO.getHeadPhoto());
            authInfo.setTenantCode(customerPO.getTenantCode());
            authInfo.setChannelCode(customerPO.getChannelCode());
            authInfo.setUserType(String.valueOf(customerPO.getUserType()));
            if (StringUtils.isEmpty((CharSequence)customerPO.getHeadPhoto())) {
                authInfo.setUserHeadImg(this.niccUserConfigPropertiesBean.getDefaultHeadimg());
            }
            this.redisHelper.set(cacheKey, (Object)authInfo);
        }
        return BaseRspUtils.createSuccessRsp((Object)authInfo);
    }
}

