/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.user.service;

import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.exception.DcBusinessException;
import com.tydic.nicc.user.mapper.po.UserAuthConfig;
import com.tydic.nicc.user.service.OtherAuthService;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuthStrategyFactory {
    private static final Logger log = LoggerFactory.getLogger(AuthStrategyFactory.class);
    @Autowired
    private List<OtherAuthService> otherAuthServices;
    private static Map<String, OtherAuthService> otherAuthServiceMap;

    @PostConstruct
    public void init() {
        log.info("\u52a0\u8f7d\u4e1a\u52a1\u5904\u7406\u670d\u52a1:{}", this.otherAuthServices);
        otherAuthServiceMap = this.otherAuthServices.stream().collect(Collectors.toMap(OtherAuthService::authType, a -> a));
    }

    public OtherAuthService getStrategy(String authType) {
        return otherAuthServiceMap.get(authType);
    }

    public Rsp handlerAuthMethod(String authType, String extData, UserAuthConfig authConfig) throws DcBusinessException {
        OtherAuthService service = this.getStrategy(authType);
        if (ObjectUtils.anyNotNull((Object[])new Object[]{service})) {
            return service.otherAuthApi(extData, authConfig);
        }
        throw new DcBusinessException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5b9e\u73b0\u7c7b: authType = " + authType);
    }
}

