/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.user.controller;

import com.google.common.collect.Lists;
import com.tydic.nicc.common.bo.user.BatchUserAddReqBO;
import com.tydic.nicc.common.bo.user.GuestUserAddReqBO;
import com.tydic.nicc.common.bo.user.OtherUserAuthReqBO;
import com.tydic.nicc.common.bo.user.SaveUserInfoReqBO;
import com.tydic.nicc.common.bo.user.UserAccessLogQueryReqBO;
import com.tydic.nicc.common.bo.user.UserAccessLogSaveReqBO;
import com.tydic.nicc.common.bo.user.UserAuthInfo;
import com.tydic.nicc.common.bo.user.UserConditionQueryReqBO;
import com.tydic.nicc.common.bo.user.UserInfoQueryReqBO;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.user.api.UserAccessLogService;
import com.tydic.nicc.user.api.UserAuthService;
import com.tydic.nicc.user.api.UserOptionService;
import com.tydic.nicc.user.util.ImUserOpHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/user-center"})
public class UserCenterController {
    private static final Logger log = LoggerFactory.getLogger(UserCenterController.class);
    @Resource
    private UserOptionService userOptionService;
    @Resource
    private UserAuthService userAuthService;
    @Resource
    private UserAccessLogService userAccessLogService;
    @Resource
    private ImUserOpHelper imUserOpHelper;
    @Resource
    private RedisHelper redisHelper;

    @GetMapping(value={"/redis/test/{key}/{value}"})
    public Rsp testRedis(@PathVariable(value="key") String key, @PathVariable(value="value") String value) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{key, value})) {
            this.redisHelper.set(key, (Object)value, 300L);
            return BaseRspUtils.createSuccessRsp((Object)(key + "|" + value));
        }
        return BaseRspUtils.createErrorRsp((String)"must not null!");
    }

    @PostMapping(value={"/user/online/status"})
    public Rsp userOnlineStatus(@RequestBody UserInfoQueryReqBO reqBO) {
        try {
            if (reqBO.getUsers() == null || reqBO.getUsers().isEmpty()) {
                return BaseRspUtils.createErrorRsp((String)"\u7528\u6237\u72b6\u6001\u67e5\u8be2\u5931\u8d25:\u53c2\u6570\u5f02\u5e38!");
            }
            return BaseRspUtils.createSuccessRsp(this.imUserOpHelper.getUserStatus(reqBO.getUsers()));
        }
        catch (Exception e) {
            log.error("\u7528\u6237\u72b6\u6001\u67e5\u8be2\u5931\u8d25:", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)("\u7528\u6237\u72b6\u6001\u67e5\u8be2\u5931\u8d25:" + e.getMessage()));
        }
    }

    @PostMapping(value={"/online/group/addUser"})
    public Rsp addOnlineGroup(@RequestBody UserAccessLogSaveReqBO saveReqBO) {
        this.imUserOpHelper.addOnlineGroup(saveReqBO.getTenantCode(), saveReqBO.getUserType(), saveReqBO.getUserId());
        return BaseRspUtils.createSuccessRsp((Object)saveReqBO.getUserId());
    }

    @PostMapping(value={"/online/group/removeUser"})
    public Rsp removeOnlineGroup(@RequestBody UserAccessLogSaveReqBO saveReqBO) {
        this.imUserOpHelper.removeOnlineGroup(saveReqBO.getTenantCode(), saveReqBO.getUserType(), saveReqBO.getUserId());
        return BaseRspUtils.createSuccessRsp((Object)saveReqBO.getUserId());
    }

    @PostMapping(value={"/online/groups"})
    public Rsp getOnlineUsers(@RequestBody UserAccessLogSaveReqBO saveReqBO) {
        Set<Object> set = this.imUserOpHelper.getOnlineUsers(saveReqBO.getTenantCode(), saveReqBO.getUserType());
        return BaseRspUtils.createSuccessRsp(set);
    }

    @PostMapping(value={"/accessLog/save"})
    public Rsp saveAccessLog(@RequestBody UserAccessLogSaveReqBO saveReqBO) {
        return this.userAccessLogService.saveAccessLog(saveReqBO);
    }

    @PostMapping(value={"/accessLog/info"})
    public Rsp getAccessLog(@RequestBody UserAccessLogQueryReqBO queryReqBO) {
        return this.userAccessLogService.getAccessLog(queryReqBO);
    }

    @PostMapping(value={"/auth/trigger"})
    public Rsp authTrigger(@RequestParam(value="param") String param) {
        return this.userAuthService.authUser(param);
    }

    @PostMapping(value={"/user/info"})
    public Rsp<UserAuthInfo> userInfo(@RequestBody UserInfoQueryReqBO queryReqBO) {
        if (StringUtils.isNotBlank((CharSequence)queryReqBO.getExtUid())) {
            return this.userOptionService.getUserAuthInfoByEuid("", queryReqBO.getExtUid(), queryReqBO.getUserType());
        }
        return this.userOptionService.getUserAuthInfo("", queryReqBO.getUserId());
    }

    @PostMapping(value={"/users"})
    public RspList<UserAuthInfo> getUsers(@RequestBody UserInfoQueryReqBO userInfoQueryReqBO) {
        ArrayList userAuthInfoList = Lists.newArrayList();
        if (userInfoQueryReqBO.getUsers() != null && !userInfoQueryReqBO.getUsers().isEmpty()) {
            for (String user : userInfoQueryReqBO.getUsers()) {
                Rsp userRsp = this.userOptionService.getUserAuthInfo("", user);
                if (!userRsp.isSuccess()) continue;
                userAuthInfoList.add((UserAuthInfo)userRsp.getData());
            }
        }
        return BaseRspUtils.createSuccessRspList((List)userAuthInfoList);
    }

    @PostMapping(value={"/info/users"})
    public RspList<UserAuthInfo> getUsers2(@RequestBody UserConditionQueryReqBO queryReqBO) {
        return this.userOptionService.getUsers(queryReqBO);
    }

    @PostMapping(value={"/user/guest/add"})
    public Rsp addUserGuest(@RequestBody GuestUserAddReqBO userAddReqBO) {
        return this.userOptionService.createGuestUser(userAddReqBO);
    }

    @PostMapping(value={"/user/guest/name"})
    public Rsp getGuestName(@RequestBody GuestUserAddReqBO userAddReqBO) {
        return this.userOptionService.getGuestName(userAddReqBO);
    }

    @PostMapping(value={"/batch/add"})
    public RspList batchAddUsers(@RequestBody BatchUserAddReqBO batchUserAddReqBO) {
        try {
            return this.userOptionService.batchAddUsers(batchUserAddReqBO);
        }
        catch (Exception e) {
            log.warn("\u521b\u5efa\u7528\u6237\u5f02\u5e38:", (Throwable)e);
            ArrayList batchList = Lists.newArrayList();
            return BaseRspUtils.createSuccessRspList((List)batchList);
        }
    }

    @PostMapping(value={"/user/update"})
    public Rsp userInfo(@RequestBody SaveUserInfoReqBO saveUserInfoReqBO) {
        return this.userOptionService.updateUserInfo(saveUserInfoReqBO);
    }

    @PostMapping(value={"/auth/test"})
    public Rsp authTest(@RequestBody OtherUserAuthReqBO otherUserAuthReqBO) {
        log.info("\u6267\u884c\u6d4b\u8bd5\u65b9\u6cd5:{}", (Object)otherUserAuthReqBO);
        UserAuthInfo authInfo = new UserAuthInfo();
        authInfo.setChannelCode(otherUserAuthReqBO.getChannelCode());
        authInfo.setTenantCode(otherUserAuthReqBO.getChannelCode());
        authInfo.setExtUid(otherUserAuthReqBO.getExtUid());
        authInfo.setUserId(otherUserAuthReqBO.getUserId());
        authInfo.setNickName("\u5f20\u4e09");
        authInfo.setUserAvatar("\u5934\u50cf");
        authInfo.setExtData("{}");
        return BaseRspUtils.createSuccessRsp((Object)authInfo);
    }
}

