/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.data.acontact.schedule;

import com.tydic.nicc.data.acontact.config.AcontactPropertiesHolder;
import com.tydic.nicc.data.acontact.service.AcontactFeedBackService;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class AcontactFeedBackFileScheduleTask {
    private static final Logger log = LoggerFactory.getLogger(AcontactFeedBackFileScheduleTask.class);
    @Resource
    private AcontactPropertiesHolder holder;
    private static final String SINGLE = "single";
    private static final String PLATFORM = "platform";
    private static final String PLATFORM0403 = "platform0403";
    @Resource
    private AcontactFeedBackService acontactFeedBackService;

    @Scheduled(cron="${ob-data-center.acontact.corn.feedback-corn}")
    @Async
    public void acontactSingleFeedBackTask() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (this.holder.isShcduleByAcontact()) {
            log.info("\u5355\u6e20\u9053\u6570\u636e\u53cd\u9988\u5f00\u59cb\uff0c\u5f00\u59cb\u65f6\u95f4={}\uff0c\u7ebf\u7a0b\u540d\u79f0={}", (Object)dateFormat.format(new Date()), (Object)Thread.currentThread().getName());
            this.acontactFeedBackService.feedBack(SINGLE);
        }
    }

    @Scheduled(cron="${ob-data-center.acontact.corn.feedback-corn}")
    @Async
    public void acontactPlatformFeedBackTask() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (this.holder.isShcduleByAcontact()) {
            log.info("\u591a\u89e6\u70b9\u6570\u636e\u53cd\u9988\u5f00\u59cb\uff0c\u5f00\u59cb\u65f6\u95f4={}\uff0c\u7ebf\u7a0b\u540d\u79f0={}", (Object)dateFormat.format(new Date()), (Object)Thread.currentThread().getName());
            this.acontactFeedBackService.feedBack(PLATFORM);
        }
    }

    @Scheduled(cron="${ob-data-center.acontact.corn.feedback-corn}")
    @Async
    public void acontactPlatform0403FeedBackTask() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (this.holder.isShcduleByAcontact()) {
            log.info("\u5c5e\u5730\u5316\u6570\u636e\u53cd\u9988\u5f00\u59cb\uff0c\u5f00\u59cb\u65f6\u95f4={}\uff0c\u7ebf\u7a0b\u540d\u79f0={}", (Object)dateFormat.format(new Date()), (Object)Thread.currentThread().getName());
            this.acontactFeedBackService.feedBack(PLATFORM0403);
        }
    }
}

