/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.data.acontact.schedule;

import com.tydic.nicc.data.acontact.config.AcontactPropertiesHolder;
import com.tydic.nicc.data.acontact.service.AcontactDealFileService;
import com.tydic.nicc.data.acontact.service.ObCenterDataAcontactService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class AcontactFilePullScheduleTask {
    private static final Logger log = LoggerFactory.getLogger(AcontactFilePullScheduleTask.class);
    @Resource
    private AcontactPropertiesHolder holder;
    @Resource
    private AcontactDealFileService acontactDealFileService;
    @Resource
    private ObCenterDataAcontactService obCenterDataAcontactService;

    @Scheduled(cron="${ob-data-center.acontact.corn.getfile-corn}")
    public void acontactFilePullTask() {
        try {
            if (!this.holder.isShcduleByAcontact()) {
                return;
            }
            log.info("\u5168\u89e6\u70b9\u6570\u636e\u5bfc\u5165\u5f00\u59cb");
            log.info("###################################");
            long funcStartTime = System.currentTimeMillis();
            this.acontactDealFileService.importData();
            long funcEndTime = System.currentTimeMillis();
            log.info("###################################");
            float excTime = (float)(funcEndTime - funcStartTime) / 1000.0f;
            log.info("\u5168\u89e6\u70b9\u6570\u636e\u5bfc\u5165\u5b8c\u6210,\u8017\u65f6={}\u79d2", (Object)Float.valueOf(excTime));
        }
        catch (Exception e) {
            log.error("\u5e73\u53f0\u6570\u636e\u5bfc\u5165 exception,{}", (Throwable)e);
        }
    }

    @Scheduled(cron="${ob-data-center.acontact.corn.clear-data-corn}")
    public void acontactDataDeleteTask() {
        if (this.holder.isShcduleByAcontact()) {
            log.info("\u5b9a\u65f6\u6e05\u7406\u6570\u636e\u4efb\u52a1\u5f00\u542f");
            this.obCenterDataAcontactService.truncateTable();
            log.info("\u5b9a\u65f6\u6e05\u7406\u6570\u636e\u4efb\u52a1\u7ed3\u675f");
        }
    }
}

