/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.data.acontact.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.aliyun.oss.common.utils.StringUtils;
import com.tydic.nicc.data.acontact.config.AcontactChannelTenantConfig;
import com.tydic.nicc.data.acontact.entity.DataInfo;
import com.tydic.nicc.data.acontact.entity.FmortDataResult;
import com.tydic.nicc.data.acontact.entity.SingleChannelParam;
import com.tydic.nicc.data.acontact.mapper.po.ObCenterDataAcontact;
import com.tydic.nicc.data.acontact.mapper.po.ObCenterDataAcontactFileLog;
import com.tydic.nicc.data.acontact.mapper.po.ObCenterDataAcontactMultiChannel;
import com.tydic.nicc.data.acontact.mapper.po.ObCenterDataAcontactMultiChannel0403;
import com.tydic.nicc.data.acontact.service.AcontactDealDataService;
import com.tydic.nicc.data.acontact.service.ObCenterDataAcontactFileLogService;
import com.tydic.nicc.data.acontact.service.ObCenterDataAcontactMultiChannel0403Service;
import com.tydic.nicc.data.acontact.service.ObCenterDataAcontactMultiChannelService;
import com.tydic.nicc.data.acontact.service.ObCenterDataAcontactService;
import com.tydic.nicc.data.acontact.util.CoderUtils;
import com.tydic.nicc.data.mapper.po.ObCenterDataTaskData;
import com.tydic.nicc.data.mapper.po.ObCenterDataTaskInfo;
import com.tydic.nicc.data.service.task.ObCenterDataTaskDataService;
import com.tydic.nicc.data.service.task.ObCenterDataTaskInfoService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;

@Service
public class AcontactDealDataServiceImpl
implements AcontactDealDataService {
    private static final Logger log = LoggerFactory.getLogger(AcontactDealDataServiceImpl.class);
    private static final String POSITION_01_08 = "POSITION_01_08";
    private static final String POSITION_04_03 = "POSITION_04_03";
    private static final String PLATFORM = "platform";
    private static final String PLATFORM0403 = "platform0403";
    private static final String SINGLE = "single";
    private static final String NAME_HEAD = "XJZD";
    private List insertFailList = new ArrayList();
    @Resource
    ObCenterDataTaskInfoService obCenterDataTaskInfoService;
    @Resource
    ObCenterDataTaskDataService obCenterDataTaskDataService;
    @Resource
    ObCenterDataAcontactFileLogService obCenterDataAcontactFileLogService;
    @Resource
    ObCenterDataAcontactService obCenterDataAcontactService;
    @Resource
    ObCenterDataAcontactMultiChannelService obCenterDataAcontactMultiChannelService;
    @Resource
    ObCenterDataAcontactMultiChannel0403Service obCenterDataAcontactMultiChannel0403Service;

    @Override
    public void importData(List<String[]> dataList, String fileName) {
        block14: {
            log.info("\u6587\u4ef6\u540d\u79f0={},\u6570\u91cf={}", (Object)fileName, (Object)dataList.size());
            log.info("\u9519\u8bef\u6587\u4ef6\u91cf=" + this.insertFailList.size());
            if (fileName.contains(".chk")) {
                return;
            }
            ObCenterDataAcontactFileLog fileLog = new ObCenterDataAcontactFileLog();
            fileLog.setFileName(fileName);
            if (fileName.contains(".txt")) {
                fileName = fileName.replaceAll(".txt", "");
            }
            fileName = fileName.trim();
            fileName = fileName.substring(fileName.length() - 48);
            String type = fileName.substring(fileName.length() - 1);
            String opChannelCoding = fileName.substring(2, 16);
            String activityCode = fileName.substring(16, fileName.length() - 1);
            String channelType = "";
            channelType = opChannelCoding.equals(POSITION_01_08) ? PLATFORM : SINGLE;
            String channelCodeByFile = fileName.substring(0, 2);
            if (dataList.size() < 0 || dataList == null) {
                log.info("\u6587\u4ef6={}\uff0c\u6587\u4ef6\u4e3a\u7a7a", (Object)fileName);
                return;
            }
            try {
                if (!opChannelCoding.equals(POSITION_01_08)) {
                    long dealBegin = System.currentTimeMillis();
                    String tenantOtherNames = AcontactChannelTenantConfig.channelTenantMap.get(opChannelCoding);
                    Map<String, String> contentField = this.analysisContent(dataList, opChannelCoding, type, tenantOtherNames);
                    String startTime = contentField.get("startTime");
                    String endTime = contentField.get("endTime");
                    String taskName = contentField.get("taskName");
                    String speechContent = contentField.get("speechContent");
                    String gearPosition = contentField.get("gearPosition");
                    String classificationActivityName = contentField.get("classificationActivityName");
                    log.info("\u89e3\u6790\u6587\u4ef6\u5185\u5bb9\u5b57\u6bb5\uff0c\u5f00\u59cb\u65f6\u95f4={}\uff0c\u7ed3\u675f\u65f6\u95f4={}\uff0c\u8425\u9500\u6d3b\u52a8\u540d\u79f0={}\uff0c\u8425\u9500\u8bdd\u672f={}\uff0c\u6863\u4f4d={}", new Object[]{startTime, endTime, taskName, speechContent, gearPosition});
                    log.info("\u5f00\u59cb\u67e5\u8be2\u79df\u6237\u4fe1\u606f,tenantOtherName={}", (Object)tenantOtherNames);
                    String tenantIdByXJ = this.obCenterDataTaskDataService.selectTenantIdByotherName(tenantOtherNames);
                    if (StringUtils.hasValue((String)tenantIdByXJ)) {
                        log.error("\u627e\u4e0d\u5230\u8be5\u79df\u6237\u4fe1\u606f\uff0c\u8bf7\u521b\u5efa\u8be5\u79df\u6237,\u6587\u4ef6\u540d\u79f0\u3010{}\u3011", (Object)fileName);
                        return;
                    }
                    String taskId = this.obCenterDataTaskInfoService.selectTaskIdByTaskName(taskName);
                    SingleChannelParam singleChannelParam = new SingleChannelParam();
                    singleChannelParam.setTaskId(taskId);
                    singleChannelParam.setFileName(fileName);
                    singleChannelParam.setStartTime(startTime);
                    singleChannelParam.setEndTime(endTime);
                    singleChannelParam.setTaskName(taskName);
                    singleChannelParam.setTenantId(tenantIdByXJ);
                    singleChannelParam.setSpeechContent(speechContent);
                    singleChannelParam.setDataList(dataList);
                    singleChannelParam.setTenantOtherName(tenantOtherNames);
                    singleChannelParam.setChannelType(channelType);
                    singleChannelParam.setActivityCode(activityCode);
                    singleChannelParam.setType(type);
                    singleChannelParam.setOpChannelCoding(opChannelCoding);
                    singleChannelParam.setChannelCodeByFile(channelCodeByFile);
                    singleChannelParam.setGearPosition(gearPosition);
                    singleChannelParam.setClassificationActivityName(classificationActivityName);
                    String newTaskId = this.dealSingleChannelData(singleChannelParam);
                    fileLog.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                    fileLog.setDataNum(dataList.size());
                    fileLog.setTaskId(newTaskId);
                    fileLog.setTenantAlias(tenantOtherNames);
                    this.obCenterDataAcontactFileLogService.insert(fileLog);
                    break block14;
                }
                ArrayList<ObCenterDataAcontactMultiChannel> multiChannelList = new ArrayList<ObCenterDataAcontactMultiChannel>();
                SimpleDateFormat format3 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String createdTime = format3.format(new Date());
                String gearPosition = null;
                long loopBegin = System.currentTimeMillis();
                for (String[] fields : dataList) {
                    if (fields.length != 14 || fields[13].equals("01")) continue;
                    String marketingActivityName = fields[6].split("_")[0];
                    if (StringUtils.isNullOrEmpty(gearPosition)) {
                        gearPosition = fields[6].contains("_") ? fields[6].split("_")[1] : fields[12];
                    }
                    ObCenterDataAcontactMultiChannel multiChannel = new ObCenterDataAcontactMultiChannel();
                    multiChannel.setMobile(fields[0]);
                    multiChannel.setArea(fields[1]);
                    multiChannel.setMarketingTaskCode(fields[2]);
                    multiChannel.setClassifyActivityCode(fields[3]);
                    multiChannel.setClassifyActivityName(fields[4]);
                    multiChannel.setMarketingActivityCode(fields[5]);
                    multiChannel.setMarketingActivityName(marketingActivityName);
                    multiChannel.setStartTime(fields[7]);
                    multiChannel.setEndTime(fields[8]);
                    multiChannel.setRecommendProduct(fields[9]);
                    multiChannel.setProductName(fields[10]);
                    multiChannel.setSpeechContent(fields[11]);
                    multiChannel.setGearPosition(gearPosition);
                    multiChannel.setChannelCode(fields[13]);
                    multiChannel.setCreatedTime(createdTime);
                    multiChannel.setType(type);
                    multiChannel.setFileName(fileName);
                    multiChannelList.add(multiChannel);
                }
                long loopEnd = System.currentTimeMillis();
                double loopTime = (double)(loopEnd - loopBegin) / 1000.0;
                log.info("multiChannelList Size\u3010{}\u3011,fileName\u3010{}\u3011", (Object)multiChannelList.size(), (Object)fileName);
                long funcStartTime = System.currentTimeMillis();
                try {
                    this.batchWriteMultiChannelXj(multiChannelList);
                }
                catch (Exception e) {
                    log.error("\u6279\u91cf\u5199\u5165\u63a5\u53e3\u6587\u4ef6\u6570\u636e\u5f02\u5e38,{}", (Throwable)e);
                }
                long funcEndTime = System.currentTimeMillis();
                double excTime = (double)(funcEndTime - funcStartTime) / 1000.0;
                log.info("\u5904\u7406\u5168\u89e6\u70b9\u5916\u547c,\u6587\u4ef6\u540d\u79f0\u3010{}\u3011,\u5355\u4e2a\u6587\u4ef6\u7528\u65f6\u3010{}\u3011\u79d2", (Object)fileName, (Object)excTime);
                List<ObCenterDataAcontactMultiChannel> multiChannels = this.obCenterDataAcontactMultiChannelService.selectGroupByTenantAndTask(fileName, createdTime);
                log.info("multiChannelXjs Size\u3010{}\u3011,fileName\u3010{}\u3011", (Object)multiChannels.size(), (Object)fileName);
                for (ObCenterDataAcontactMultiChannel multiChannel : multiChannels) {
                    String tenantOtherNames = AcontactChannelTenantConfig.channelTenantMap.get(multiChannel.getChannelCode() + "01_08");
                    String taskName = NAME_HEAD + multiChannel.getMarketingActivityName() + multiChannel.getType() + tenantOtherNames;
                    String taskId = this.obCenterDataTaskInfoService.selectTaskIdByTaskName(taskName);
                    log.info("\u5f00\u59cb\u67e5\u8be2\u79df\u6237\u4fe1\u606f,tenantOtherNames\u3010{}\u3011", (Object)tenantOtherNames);
                    String tenantIdByXJ = this.obCenterDataTaskDataService.selectTenantIdByotherName(tenantOtherNames);
                    if (StringUtils.hasValue((String)tenantIdByXJ)) {
                        log.error("\u627e\u4e0d\u5230\u8be5\u79df\u6237\u4fe1\u606f\uff0c\u8bf7\u521b\u5efa\u8be5\u79df\u6237,\u6587\u4ef6\u540d\u79f0\u3010{}\u3011", (Object)fileName);
                        return;
                    }
                    ArrayList<String[]> mulDataList = new ArrayList<String[]>();
                    String channelCode = multiChannel.getChannelCode();
                    String marketingActivityName = multiChannel.getMarketingActivityName();
                    String classifyActivityName = multiChannel.getClassifyActivityName();
                    List<ObCenterDataAcontactMultiChannel> multiChannelListByTT = this.obCenterDataAcontactMultiChannelService.selectTenantAndTask(channelCode, marketingActivityName, type, fileName, createdTime);
                    log.info("multiChannelXjListByTT Size\u3010{}\u3011,fileName\u3010{}\u3011,tenantOtherName\u3010{}\u3011", new Object[]{multiChannelListByTT.size(), fileName, tenantOtherNames});
                    for (ObCenterDataAcontactMultiChannel multiChannel1 : multiChannelListByTT) {
                        String[] s = new String[]{multiChannel1.getMobile(), multiChannel1.getArea(), multiChannel1.getMarketingTaskCode(), multiChannel1.getClassifyActivityCode(), multiChannel1.getClassifyActivityName(), multiChannel1.getMarketingActivityCode(), multiChannel1.getMarketingActivityName(), multiChannel1.getStartTime(), multiChannel1.getEndTime(), multiChannel1.getRecommendProduct(), multiChannel1.getProductName(), multiChannel1.getSpeechContent(), multiChannel1.getGearPosition(), multiChannel1.getChannelCode()};
                        mulDataList.add(s);
                    }
                    log.info("mulDataList Size\u3010{}\u3011,fileName\u3010{}\u3011,tenantOtherName\u3010{}\u3011,", new Object[]{mulDataList.size(), fileName, tenantOtherNames});
                    SingleChannelParam singleChannelParam = new SingleChannelParam();
                    singleChannelParam.setTaskId(taskId);
                    singleChannelParam.setFileName(fileName);
                    singleChannelParam.setStartTime(multiChannel.getStartTime());
                    singleChannelParam.setEndTime(multiChannel.getEndTime());
                    singleChannelParam.setTaskName(taskName);
                    singleChannelParam.setTenantId(tenantIdByXJ);
                    singleChannelParam.setSpeechContent(multiChannel.getSpeechContent());
                    singleChannelParam.setDataList(mulDataList);
                    singleChannelParam.setTenantOtherName(tenantOtherNames);
                    singleChannelParam.setChannelType(channelType);
                    singleChannelParam.setActivityCode(activityCode);
                    singleChannelParam.setType(type);
                    singleChannelParam.setOpChannelCoding(opChannelCoding);
                    singleChannelParam.setChannelCode(channelCode);
                    singleChannelParam.setGearPosition(gearPosition);
                    singleChannelParam.setClassificationActivityName(classifyActivityName);
                    String newTaskId = this.dealSingleChannelData(singleChannelParam);
                    long dealEndTime = System.currentTimeMillis();
                    double dealTime = (double)(dealEndTime - funcEndTime) / 1000.0;
                    fileLog.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                    fileLog.setDataNum(dataList.size());
                    fileLog.setTaskId(newTaskId);
                    fileLog.setTenantAlias(tenantOtherNames);
                    this.obCenterDataAcontactFileLogService.insert(fileLog);
                }
                this.obCenterDataAcontactMultiChannelService.truncateTable();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String dealSingleChannelData(SingleChannelParam singleChannelParam) {
        String taskId = singleChannelParam.getTaskId();
        if (StringUtils.isNullOrEmpty((String)taskId)) {
            ObCenterDataTaskInfo taskInfo = this.createTask(singleChannelParam);
            String string = taskId = taskInfo == null ? null : taskInfo.getTaskId();
        }
        if (!StringUtils.isNullOrEmpty((String)taskId)) {
            singleChannelParam.setTaskId(taskId);
            this.singleChannelDealing(singleChannelParam);
        } else {
            log.error("dealSingleChannelData exception, taskId is null");
        }
        return taskId;
    }

    public void singleChannelDealing(SingleChannelParam singleChannelParam) {
        try {
            if (null != singleChannelParam.getTaskDataList()) {
                String tenantOtherName = singleChannelParam.getTenantOtherName();
                List<ObCenterDataTaskData> dataList = singleChannelParam.getTaskDataList();
                FmortDataResult fmortDataResult = new FmortDataResult();
                fmortDataResult.setTaskId(singleChannelParam.getTaskId());
                fmortDataResult.setFileName(singleChannelParam.getFileName());
                fmortDataResult.setTenantOtherName(tenantOtherName);
                fmortDataResult.setDataRealList(singleChannelParam.getTaskDataList());
                this.writeBatchList(fmortDataResult, singleChannelParam.getTenantOtherName());
                return;
            }
            String taskId = singleChannelParam.getTaskId();
            String fileName = singleChannelParam.getFileName();
            String startTime = singleChannelParam.getStartTime();
            String endTime = singleChannelParam.getEndTime();
            String taskName = singleChannelParam.getTaskName();
            String tenantId = singleChannelParam.getTenantId();
            String speechContent = singleChannelParam.getSpeechContent();
            List<String[]> dataList = singleChannelParam.getDataList();
            String tenantOtherName = singleChannelParam.getTenantOtherName();
            String channelType = singleChannelParam.getChannelType();
            String activityCode = singleChannelParam.getActivityCode();
            String type = singleChannelParam.getType();
            String opChannelCoding = singleChannelParam.getOpChannelCoding();
            String channelCodeByFile = singleChannelParam.getChannelCodeByFile();
            String channelCode = singleChannelParam.getChannelCode();
            String gearPosition = singleChannelParam.getGearPosition();
            String classificationActivityName = singleChannelParam.getClassificationActivityName();
            if (StringUtils.isNullOrEmpty((String)channelCode)) {
                channelCode = channelCodeByFile;
            }
            this.insertFileTaskLog(taskId, tenantOtherName, dataList.size(), fileName, "\u4efb\u52a1\u6570\u636e\u91cf");
            if (StringUtils.isNullOrEmpty((String)taskId)) {
                String newTaskId;
                ObCenterDataTaskInfo taskInfo = this.createTask(singleChannelParam);
                String string = newTaskId = taskInfo != null ? taskInfo.getTaskId() : null;
                if (!StringUtils.isNullOrEmpty((String)newTaskId)) {
                    this.structureAndDealData(dataList, newTaskId, fileName, tenantOtherName, tenantId, channelType, activityCode, type, opChannelCoding, channelCode, gearPosition);
                } else {
                    log.error("\u4efb\u52a1ID\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u63d2\u5165\uff0c\u6570\u636e\u91cf=" + dataList.size());
                }
            } else {
                ObCenterDataTaskInfo obTaskInfo = this.obCenterDataTaskInfoService.selectById(taskId);
                if (obTaskInfo != null) {
                    log.info("\u8001\u4efb\u52a1\uff0c\u79df\u6237={},dataListSize={}", (Object)tenantOtherName, (Object)dataList.size());
                    this.structureAndDealData(dataList, taskId, fileName, tenantOtherName, tenantId, channelType, activityCode, type, opChannelCoding, channelCode, gearPosition);
                }
            }
        }
        catch (Exception e) {
            log.error("\u5199\u5165data_target_task\u6570\u636e\u5f02\u5e38,{}", (Throwable)e);
        }
    }

    private Map<String, String> analysisContent(List<String[]> dataList, String opChannelCoding, String type, String tenantOtherName) {
        log.info("\u5f00\u59cb\u89e3\u6790\u6587\u4ef6\u540d\u79f0\u548c\u5185\u5bb9,opChannelCoding={},type={}", (Object)opChannelCoding, (Object)type);
        HashMap<String, String> contentField = new HashMap<String, String>();
        Object channelCode = null;
        if (opChannelCoding.equals("POSITION_04_02")) {
            for (String[] content : dataList) {
                if (content.length != 12) continue;
                String taskName = content[5];
                String gearPosition = null;
                gearPosition = taskName.contains("_") ? taskName.split("_")[1] : content[11];
                taskName = NAME_HEAD + taskName.split("_")[0] + type + tenantOtherName;
                String startTime = content[6];
                String endTime = content[7];
                String speechContent = content[10];
                String classificationActivityName = content[3];
                contentField.put("startTime", startTime);
                contentField.put("endTime", endTime);
                contentField.put("taskName", taskName);
                contentField.put("speechContent", speechContent);
                contentField.put("gearPosition", gearPosition);
                contentField.put("classificationActivityName", classificationActivityName);
                break;
            }
        } else {
            for (String[] content : dataList) {
                if (content.length != 13) continue;
                String taskName = content[6];
                String gearPosition = null;
                gearPosition = taskName.contains("_") ? taskName.split("_")[1] : content[12];
                taskName = NAME_HEAD + taskName.split("_")[0] + type + tenantOtherName;
                String startTime = content[7];
                String endTime = content[8];
                String speechContent = content[11];
                String classificationActivityName = content[4];
                contentField.put("startTime", startTime);
                contentField.put("endTime", endTime);
                contentField.put("taskName", taskName);
                contentField.put("speechContent", speechContent);
                contentField.put("gearPosition", gearPosition);
                contentField.put("classificationActivityName", classificationActivityName);
                break;
            }
        }
        return contentField;
    }

    private void insertFileTaskLog(String taskId, String tenantOtherName, int num, String fileName, String remark) {
        ObCenterDataAcontactFileLog fileTask = new ObCenterDataAcontactFileLog();
        fileTask.setFileName(fileName);
        fileTask.setTaskId(taskId);
        fileTask.setTenantAlias(tenantOtherName);
        fileTask.setDataNum(num);
        fileTask.setRemark(remark);
        fileTask.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        try {
            this.obCenterDataAcontactFileLogService.insert(fileTask);
        }
        catch (Exception e) {
            log.error("insertFileTaskLog exception,{}", (Throwable)e);
        }
    }

    private ObCenterDataTaskInfo createTask(SingleChannelParam singleChannelParam) {
        String taskId = singleChannelParam.getTaskId();
        String fileName = singleChannelParam.getFileName();
        String startTime = singleChannelParam.getStartTime();
        String endTime = singleChannelParam.getEndTime();
        String taskName = singleChannelParam.getTaskName();
        String tenantId = singleChannelParam.getTenantId();
        String speechContent = singleChannelParam.getSpeechContent();
        List<String[]> dataList = singleChannelParam.getDataList();
        String tenantOtherName = singleChannelParam.getTenantOtherName();
        String channelType = singleChannelParam.getChannelType();
        String activityCode = singleChannelParam.getActivityCode();
        String type = singleChannelParam.getType();
        String opChannelCoding = singleChannelParam.getOpChannelCoding();
        String channelCodeByFile = singleChannelParam.getChannelCodeByFile();
        String channelCode = singleChannelParam.getChannelCode();
        String gearPosition = singleChannelParam.getGearPosition();
        String classificationActivityName = singleChannelParam.getClassificationActivityName();
        log.info("\u5f00\u59cb\u521b\u5efa\u65b0\u4efb\u52a1\uff0c\u6587\u4ef6\u540d\u79f0={}", (Object)fileName);
        SimpleDateFormat format1 = new SimpleDateFormat("yyyyMMddHHmmss");
        SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            startTime = format2.format(format1.parse(startTime));
            endTime = format2.format(format1.parse(endTime));
        }
        catch (Exception e) {
            log.error("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38\uff0c\u6587\u4ef6\u540d\u79f0={}", (Object)fileName);
        }
        try {
            String newTaskId = "Aco" + UUID.randomUUID().toString().replaceAll("-", "");
            ObCenterDataTaskInfo obTaskInfo = new ObCenterDataTaskInfo();
            obTaskInfo.setTaskId(newTaskId);
            obTaskInfo.setTaskStatus("0");
            obTaskInfo.setTaskName(taskName);
            obTaskInfo.setTaskType("0");
            obTaskInfo.setStartTime(startTime);
            obTaskInfo.setEndTime(endTime);
            obTaskInfo.setHandleResults("1003,1005,1004,agree,1002");
            obTaskInfo.setIsUse("0");
            obTaskInfo.setTenantId(tenantId);
            obTaskInfo.setTaskSource("acontact");
            obTaskInfo.setSourceFileName(fileName);
            obTaskInfo.setCallType("0");
            obTaskInfo.setCreateTime(format2.format(new Date()));
            obTaskInfo.setTaskBak1(classificationActivityName);
            obTaskInfo.setTaskBak2(tenantOtherName);
            obTaskInfo.setTaskBak3("");
            this.obCenterDataTaskInfoService.insert(obTaskInfo);
            log.info("\u521b\u5efa\u65b0\u4efb\u52a1\u5b8c\u6210\uff0c\u6587\u4ef6\u540d\u79f0={}", (Object)fileName);
            log.info("\u65b0\u4efb\u52a1\uff0c\u79df\u6237={},dataListSize={}", (Object)tenantOtherName, (Object)dataList.size());
            return obTaskInfo;
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u65b0\u4efb\u52a1 exception,{}", (Throwable)e);
            return null;
        }
    }

    private void structureAndDealData(List<String[]> dataList, String taskId, String fileName, String tenantOtherName, String tenantId, String channelType, String activityCode, String type, String opChannelCoding, String channelCodeByFile, String gearPosition) {
        log.info("\u5f00\u59cb\u6784\u9020\u6570\u636e\u4fe1\u606f:taskId={},fileName={},tenantOtherName={},channelType={},dataList Size={}", new Object[]{taskId, fileName, tenantOtherName, channelType, dataList.size()});
        FmortDataResult structDataResult = this.structDataAll(dataList, taskId, fileName, tenantOtherName, tenantId, channelType, activityCode, type, opChannelCoding, channelCodeByFile, gearPosition);
        long funcStartTime = System.currentTimeMillis();
        this.dealDataAll(structDataResult, tenantOtherName);
        long funcEndTime = System.currentTimeMillis();
        float excTime = (float)(funcEndTime - funcStartTime) / 1000.0f;
        log.info("\u6279\u91cf\u63d2\u5165\u6570\u636e\u6210\u529f\uff0c\u6587\u4ef6\u540d\u79f0={},taskId={},\u7528\u65f6={}\u79d2", new Object[]{fileName, taskId, Float.valueOf(excTime)});
        log.info("\u6784\u9020\u6570\u636e\u4fe1\u606f\u7ed3\u675f:taskId={},fileName={},tenantOtherName={},channelType={}", new Object[]{taskId, fileName, tenantOtherName, channelType});
    }

    private FmortDataResult structDataAll(List<String[]> dataList, String taskId, String fileName, String tenantOtherName, String tenantId, String channelType, String activityCode, String type, String opChannelCoding, String channelCodeByFile, String gearPosition) {
        log.info("\u5f00\u59cb\u65b0\u7586\u6570\u636e\u89e3\u6790\uff0c\u6587\u4ef6\u540d\u79f0\u3010{}\u3011,taskId:\u3010{}\u3011,\u79df\u6237\u522b\u540d\u3010{}\u3011", new Object[]{fileName, taskId, tenantOtherName});
        long startTime = System.currentTimeMillis();
        FmortDataResult fmortDataResult = new FmortDataResult();
        fmortDataResult.setTaskId(taskId);
        fmortDataResult.setFileName(fileName);
        fmortDataResult.setTenantOtherName(tenantOtherName);
        List<ObCenterDataAcontact> acontactList = fmortDataResult.getAcontactList();
        List<ObCenterDataTaskData> dataRealList = fmortDataResult.getDataRealList();
        String batchNo = this.makeBatchNo(fileName, null);
        HashSet phoneNos = new HashSet();
        List<String> lstSpecialPhone = this.getSpecialPhoneList(tenantId);
        if (lstSpecialPhone == null) {
            lstSpecialPhone = new ArrayList<String>();
        }
        List<String> finalLstSpecialPhone = lstSpecialPhone;
        ArrayList finalListAntiPhone = new ArrayList();
        dataList.forEach(content -> {
            if (channelType.equals(SINGLE) && !opChannelCoding.equals("POSITION_04_02") && ((String[])content).length != 13 || channelType.equals("plantform") && ((String[])content).length != 14 || opChannelCoding.equals("POSITION_04_02") && ((String[])content).length != 12) {
                log.info("\u6570\u636e\u4e0d\u89c4\u5219\uff0c\u6587\u4ef6\u540d={}", (Object)fileName);
            } else if (finalLstSpecialPhone.contains(content[0])) {
                log.info("\u7279\u6b8a\u53f7\u7801\u8df3\u8fc7");
            } else if (phoneNos.contains(content[0])) {
                log.info("\u5916\u547c\u53f7\u7801\u5c5e\u4e8e\u91cd\u590d\u53f7\u7801! \u6587\u4ef6\u540d={},\u53f7\u7801={}", (Object)fileName, (Object)content[0]);
            } else if (finalListAntiPhone.contains(content[0])) {
                log.info("\u9632\u9a9a\u6270\u53f7\u7801\u8df3\u8fc7");
            } else {
                String title = null;
                phoneNos.add(content[0]);
                String productId = "";
                String productName = "";
                String speechTemplate = "";
                String area = "";
                if (channelType.equals(SINGLE)) {
                    if (opChannelCoding.equals("POSITION_04_02")) {
                        title = "\u7528\u6237\u53f7\u7801|\u8425\u9500\u4efb\u52a1\u7f16\u53f7|\u5f52\u7c7b\u6d3b\u52a8\u7f16\u7801|\u5f52\u7c7b\u6d3b\u52a8\u540d\u79f0|\u8425\u9500\u6d3b\u52a8\u7f16\u53f7|\u8425\u9500\u6d3b\u52a8\u540d\u79f0|\u5f00\u59cb\u65f6\u95f4|\u7ed3\u675f\u65f6\u95f4|\u63a8\u8350\u4ea7\u54c1\u4ee3\u78011:\u63a8\u8350\u4ea7\u54c1\u4ee3\u78012:\u63a8\u8350\u4ea7\u54c1\u4ee3\u78013|\u4ea7\u54c1\u540d\u79f01:\u4ea7\u54c1\u540d\u79f02:\u4ea7\u54c1\u540d\u79f03|\u8425\u9500\u8bdd\u672f|\u6321\u4f4d\u8bf4\u660e";
                        productId = content[8];
                        productName = content[9];
                        speechTemplate = content[10];
                    } else {
                        title = "\u7528\u6237\u53f7\u7801|\u5730\u5e02\u7f16\u7801|\u8425\u9500\u4efb\u52a1\u7f16\u53f7|\u5f52\u7c7b\u6d3b\u52a8\u7f16\u7801|\u5f52\u7c7b\u6d3b\u52a8\u540d\u79f0|\u8425\u9500\u6d3b\u52a8\u7f16\u53f7|\u8425\u9500\u6d3b\u52a8\u540d\u79f0|\u5f00\u59cb\u65f6\u95f4|\u7ed3\u675f\u65f6\u95f4|\u63a8\u8350\u4ea7\u54c1\u4ee3\u78011:\u63a8\u8350\u4ea7\u54c1\u4ee3\u78012:\u63a8\u8350\u4ea7\u54c1\u4ee3\u78013|\u4ea7\u54c1\u540d\u79f01:\u4ea7\u54c1\u540d\u79f02:\u4ea7\u54c1\u540d\u79f03|\u8425\u9500\u8bdd\u672f|\u6321\u4f4d\u8bf4\u660e";
                        productId = content[9];
                        productName = content[10];
                        speechTemplate = content[11];
                        area = content[1];
                    }
                } else if (channelType.equals(PLATFORM0403)) {
                    title = "\u7528\u6237\u53f7\u7801|\u7528\u6237\u5730\u5e02\u5f52\u5c5e|\u8425\u9500\u4efb\u52a1\u7f16\u53f7|\u5f52\u7c7b\u6d3b\u52a8\u7f16\u7801|\u5f52\u7c7b\u6d3b\u52a8\u540d\u79f0|\u8425\u9500\u6d3b\u52a8\u7f16\u53f7|\u8425\u9500\u6d3b\u52a8\u540d\u79f0|\u6d3b\u52a8\u5f52\u5c5e|\u5f00\u59cb\u65f6\u95f4|\u7ed3\u675f\u65f6\u95f4|\u63a8\u8350\u4ea7\u54c1\u4ee3\u78011:\u63a8\u8350\u4ea7\u54c1\u4ee3\u78012:\u63a8\u8350\u4ea7\u54c1\u4ee3\u78013|\u4ea7\u54c1\u540d\u79f01:\u4ea7\u54c1\u540d\u79f02:\u4ea7\u54c1\u540d\u79f03|\u8425\u9500\u8bdd\u672f|\u6863\u4f4d\u8bf4\u660e";
                    productId = content[10];
                    productName = content[11];
                    speechTemplate = content[12];
                    area = content[1];
                } else {
                    title = "\u7528\u6237\u53f7\u7801|\u5730\u5e02\u7f16\u7801|\u8425\u9500\u4efb\u52a1\u7f16\u53f7|\u5f52\u7c7b\u6d3b\u52a8\u7f16\u7801|\u5f52\u7c7b\u6d3b\u52a8\u540d\u79f0|\u8425\u9500\u6d3b\u52a8\u7f16\u53f7|\u8425\u9500\u6d3b\u52a8\u540d\u79f0|\u5f00\u59cb\u65f6\u95f4|\u7ed3\u675f\u65f6\u95f4|\u63a8\u8350\u4ea7\u54c1\u4ee3\u78011:\u63a8\u8350\u4ea7\u54c1\u4ee3\u78012:\u63a8\u8350\u4ea7\u54c1\u4ee3\u78013|\u4ea7\u54c1\u540d\u79f01:\u4ea7\u54c1\u540d\u79f02:\u4ea7\u54c1\u540d\u79f03|\u8425\u9500\u8bdd\u672f|\u6863\u4f4d\u8bf4\u660e|\u5f52\u5c5e\u89e6\u70b9\u6807\u8bc6";
                    productId = content[9];
                    productName = content[10];
                    speechTemplate = content[11];
                    area = content[1];
                }
                ObCenterDataTaskData obCenterDataTaskData = new ObCenterDataTaskData();
                String dataId = "qcd" + AcontactDealDataServiceImpl.getuuid();
                obCenterDataTaskData.setDataId(dataId);
                obCenterDataTaskData.setTaskId(taskId);
                obCenterDataTaskData.setMobileNo(content[0]);
                obCenterDataTaskData.setSpeechTemplate(speechTemplate);
                obCenterDataTaskData.setProductId(this.dealWithProduct(productId));
                obCenterDataTaskData.setProductName(this.dealWithProduct(productName));
                obCenterDataTaskData.setCallsmsRingoff("0");
                obCenterDataTaskData.setCallsmsRingoffContent("");
                obCenterDataTaskData.setDataStartTime(new SimpleDateFormat("yyyy-MM-dd").format(new Date()) + "00:00:00");
                obCenterDataTaskData.setDataEndTime(new SimpleDateFormat("yyyy-MM-dd").format(new Date()) + "23:59:59");
                obCenterDataTaskData.setImportTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                obCenterDataTaskData.setArea(area);
                obCenterDataTaskData.setBak1("");
                obCenterDataTaskData.setBak2("");
                obCenterDataTaskData.setBak3("");
                dataRealList.add(obCenterDataTaskData);
                ObCenterDataAcontact acontact = new ObCenterDataAcontact();
                acontact.setDataId(dataId);
                acontact.setTaskId(taskId);
                acontact.setTenantId(tenantId);
                acontact.setMobileNo(content[0]);
                acontact.setSpeechTemplate(speechTemplate);
                acontact.setProductId(this.dealWithProduct(productId));
                acontact.setProductName(this.dealWithProduct(productName));
                acontact.setCallsmsRingoff("0");
                acontact.setCallsmsRingoffContent("");
                acontact.setChannelCode(channelCodeByFile);
                acontact.setSystemCode(opChannelCoding);
                acontact.setDataFileName(fileName);
                ArrayList<DataInfo> dataInfos = new ArrayList<DataInfo>();
                String[] titleName = title.split("\\|");
                for (int i = 0; i < ((String[])content).length; ++i) {
                    DataInfo dataInfo;
                    if (channelType.equals(PLATFORM0403)) {
                        if (i == 13) {
                            dataInfo = new DataInfo();
                            dataInfo.setName(titleName[i]);
                            dataInfo.setValue(gearPosition);
                            dataInfos.add(dataInfo);
                            continue;
                        }
                        dataInfo = new DataInfo();
                        dataInfo.setName(titleName[i]);
                        dataInfo.setValue(content[i]);
                        dataInfos.add(dataInfo);
                        continue;
                    }
                    if (opChannelCoding.equals("POSITION_04_02")) {
                        if (i == 11) {
                            dataInfo = new DataInfo();
                            dataInfo.setName(titleName[i]);
                            dataInfo.setValue(gearPosition);
                            dataInfos.add(dataInfo);
                            continue;
                        }
                        dataInfo = new DataInfo();
                        dataInfo.setName(titleName[i]);
                        dataInfo.setValue(content[i]);
                        dataInfos.add(dataInfo);
                        continue;
                    }
                    if (i == 12) {
                        dataInfo = new DataInfo();
                        dataInfo.setName(titleName[i]);
                        dataInfo.setValue(gearPosition);
                        dataInfos.add(dataInfo);
                        continue;
                    }
                    dataInfo = new DataInfo();
                    dataInfo.setName(titleName[i]);
                    dataInfo.setValue(content[i]);
                    dataInfos.add(dataInfo);
                }
                acontact.setDataJson(JSONArray.toJSONString(dataInfos));
                acontactList.add(acontact);
            }
        });
        long endTime = System.currentTimeMillis();
        float excTime = (float)(endTime - startTime) / 1000.0f;
        log.info("\u6570\u636e\u89e3\u6790\u5b8c\u6210\uff0c\u6587\u4ef6\u540d\u79f0\u3010{}\u3011,taskId:\u3010{}\u3011,\u79df\u6237\u522b\u540d\u3010{}\u3011,\u7528\u65f6\u3010{}\u3011\u79d2,dataTargetRealList Size\u3010{}\u3011", new Object[]{fileName, taskId, tenantOtherName, Float.valueOf(excTime), dataRealList.size()});
        return fmortDataResult;
    }

    private String dealWithProduct(String product) {
        if (StringUtils.isNullOrEmpty((String)product)) {
            return null;
        }
        String[] split = product.split(":");
        StringBuffer sb = new StringBuffer();
        for (String p : split) {
            sb.append(p);
            sb.append(",");
        }
        return sb.substring(0, sb.length() - 1);
    }

    private String makeBatchNo(String fileName, String startDate) {
        String batchNo = null;
        batchNo = CoderUtils.getFileNameWithoutType(fileName);
        batchNo = StringUtils.isNullOrEmpty((String)startDate) ? batchNo + new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()) : batchNo + new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
        return batchNo;
    }

    private void dealDataAll(FmortDataResult fmortDataResult, String tenantOtherName) {
        log.info("dataTargetRealList Size\u3010{}\u3011,dataInfoList Size\u3010{}\u3011,dataErrorList Size\u3010{}\u3011\uff0ctenantAlias\u3010{}\u3011", (Object)fmortDataResult.getDataRealList().size(), (Object)tenantOtherName);
        if (fmortDataResult.getDataRealList().size() > 0) {
            this.writeBatchList(fmortDataResult, tenantOtherName);
        }
    }

    private void writeBatchList(FmortDataResult fmortDataResult, String tenantOtherName) {
        long s = System.currentTimeMillis();
        List<ObCenterDataTaskData> lstDataTarget = fmortDataResult.getDataRealList();
        List<ObCenterDataAcontact> lsDataAcontact = fmortDataResult.getAcontactList();
        log.error("\u6570\u636e\u5199\u5165\u5f00\u59cb,\u79df\u6237\u3010{}\u3011,\u6761\u6570\u3010{}\u3011", (Object)tenantOtherName, (Object)lstDataTarget.size());
        int onceNum = 1000;
        if (lstDataTarget.size() >= 10000 && lstDataTarget.size() < 100000) {
            onceNum = 3000;
        } else if (lstDataTarget.size() >= 100000) {
            onceNum = 5000;
        }
        int remaider = lstDataTarget.size() % onceNum;
        int number = lstDataTarget.size() / onceNum;
        for (int i = 0; i < number; ++i) {
            ArrayList<ObCenterDataTaskData> batchList = new ArrayList<ObCenterDataTaskData>();
            ArrayList<ObCenterDataAcontact> batchAconList = new ArrayList<ObCenterDataAcontact>();
            for (int y = i * onceNum; y < (i + 1) * onceNum; ++y) {
                batchList.add(lstDataTarget.get(y));
                batchAconList.add(lsDataAcontact.get(y));
            }
            try {
                this.obCenterDataTaskDataService.batchInsertTenantOtherName(batchList, tenantOtherName);
                this.obCenterDataAcontactService.batchInsert(batchAconList);
                continue;
            }
            catch (DuplicateKeyException mie) {
                log.error("\u6279\u91cf\u63d2\u5165\u6570\u636e\u5f02\u5e38,\u5f02\u5e38\u3010{}\u3011", (Object)mie.getMessage());
                log.error("\u6279\u91cf\u63d2\u5165\u6570\u636e\u5f02\u5e38,\u4e3b\u952e\u51b2\u7a81,\u8df3\u8fc7-----,data={}", batchList);
                continue;
            }
            catch (Exception e) {
                this.dealInsertFailData(batchList, tenantOtherName);
                log.error("\u6279\u91cf\u63d2\u5165\u6570\u636e\u5f02\u5e38,\u653e\u5165\u7ebf\u7a0b,\u7b49\u5f85\u518d\u6b21\u63d2\u5165,\u79df\u6237\u3010{}\u3011,\u6761\u6570\u3010{}\u3011", (Object)tenantOtherName, (Object)batchList.size());
                log.error("\u6279\u91cf\u63d2\u5165\u6570\u636e\u5f02\u5e38,\u5f02\u5e38\u3010{}\u3011", (Throwable)e);
            }
        }
        if (remaider > 0) {
            ArrayList<ObCenterDataTaskData> batchList = new ArrayList<ObCenterDataTaskData>();
            ArrayList<ObCenterDataAcontact> batchAconList = new ArrayList<ObCenterDataAcontact>();
            for (int y = number * onceNum; y < lstDataTarget.size(); ++y) {
                batchList.add(lstDataTarget.get(y));
                batchAconList.add(lsDataAcontact.get(y));
            }
            try {
                this.obCenterDataTaskDataService.batchInsertTenantOtherName(batchList, tenantOtherName);
                this.obCenterDataAcontactService.batchInsert(batchAconList);
            }
            catch (DuplicateKeyException mie) {
                log.error("\u6279\u91cf\u63d2\u5165\u6570\u636e\u5f02\u5e38,\u5f02\u5e38\u3010{}\u3011", (Object)mie.getMessage());
                log.error("\u6279\u91cf\u63d2\u5165\u6570\u636e\u5f02\u5e38,\u4e3b\u952e\u51b2\u7a81,\u8df3\u8fc7-----,data={}", batchList);
            }
            catch (Exception e) {
                this.dealInsertFailData(batchList, tenantOtherName);
                log.error("\u6279\u91cf\u63d2\u5165\u6570\u636e\u5f02\u5e38,\u653e\u5165\u7ebf\u7a0b,\u7b49\u5f85\u518d\u6b21\u63d2\u5165,\u79df\u6237\u3010{}\u3011,\u6761\u6570\u3010{}\u3011", (Object)tenantOtherName, (Object)batchList.size());
                log.error("\u6279\u91cf\u63d2\u5165\u6570\u636e\u5f02\u5e38,\u5f02\u5e38\u3010{}\u3011", (Throwable)e);
            }
        }
        long e = System.currentTimeMillis();
        double d = (double)(e - s) / 1000.0;
        log.error("\u6570\u636e\u5199\u5165\u7ed3\u675f,\u79df\u6237\u3010{}\u3011,\u6761\u6570\u3010{}\u3011,\u8017\u65f6\u3010{}\u3011\u79d2", new Object[]{tenantOtherName, lstDataTarget.size(), d});
    }

    private void batchWriteMultiChannelXj(List<ObCenterDataAcontactMultiChannel> dataList) {
        int onceNum = 3000;
        if (dataList.size() > 100000) {
            onceNum = 5000;
        }
        int number = dataList.size() / onceNum;
        int remaider = dataList.size() % onceNum;
        for (int i = 0; i < number; ++i) {
            ArrayList<ObCenterDataAcontactMultiChannel> batchListNumber = new ArrayList<ObCenterDataAcontactMultiChannel>();
            for (int y = i * onceNum; y < (i + 1) * onceNum; ++y) {
                batchListNumber.add(dataList.get(y));
            }
            try {
                this.obCenterDataAcontactMultiChannelService.batchInsert(batchListNumber);
                continue;
            }
            catch (Exception e) {
                log.error("multiChannel insert exception,{}", (Throwable)e);
                this.insertFailList.addAll(batchListNumber);
            }
        }
        if (remaider > 0) {
            ArrayList<ObCenterDataAcontactMultiChannel> batchListRemaider = new ArrayList<ObCenterDataAcontactMultiChannel>();
            for (int y = number * onceNum; y < dataList.size(); ++y) {
                batchListRemaider.add(dataList.get(y));
            }
            try {
                this.obCenterDataAcontactMultiChannelService.batchInsert(batchListRemaider);
            }
            catch (Exception e) {
                log.error("multiChannel insert exception,{}", (Throwable)e);
                this.insertFailList.addAll(batchListRemaider);
            }
        }
    }

    @Override
    public void importData0403(List<String[]> dataList, String fileName) {
        log.info("\u6587\u4ef6\u540d\u79f0\u3010{}\u3011,dataList Size\u3010{}\u3011", (Object)fileName, (Object)dataList.size());
        if (fileName.contains(".chk")) {
            return;
        }
        ObCenterDataAcontactFileLog fileLog = new ObCenterDataAcontactFileLog();
        fileLog.setFileName(fileName);
        if (fileName.contains(".txt")) {
            fileName = fileName.replaceAll(".txt", "");
        }
        fileName = fileName.trim();
        fileName = fileName.substring(fileName.length() - 48);
        String type = fileName.substring(fileName.length() - 1);
        String opChannelCoding = fileName.substring(2, 16);
        String activityCode = fileName.substring(16, fileName.length() - 1);
        String channelType = PLATFORM0403;
        log.info("\u6587\u4ef6\u540d\u79f0\u89e3\u6790\u5b57\u6bb5,H/W\u6807\u8bc6\u3010{}\u3011\uff0c\u8fd0\u8425\u7f16\u7801\u3010{}\u3011\uff0c\u8425\u9500\u6d3b\u52a8\u7f16\u53f7\u3010{}\u3011\uff0c\u5355\u6e20\u9053\u4e0e\u5e73\u53f0\u6807\u8bc6\u3010{}\u3011", new Object[]{type, opChannelCoding, activityCode, channelType});
        if (dataList.size() < 0 || dataList == null) {
            log.info("\u6587\u4ef6={}\uff0c\u6587\u4ef6\u4e3a\u7a7a", (Object)fileName);
            return;
        }
        ArrayList<ObCenterDataAcontactMultiChannel0403> multiChannelList = new ArrayList<ObCenterDataAcontactMultiChannel0403>();
        SimpleDateFormat format3 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String createdTime = format3.format(new Date());
        String gearPosition = null;
        long loopBegin = System.currentTimeMillis();
        for (String[] fields : dataList) {
            if (fields.length != 14) continue;
            String marketingActivityName = fields[6].split("_")[0];
            if (StringUtils.isNullOrEmpty(gearPosition)) {
                gearPosition = fields[6].contains("_") ? fields[6].split("_")[1] : fields[13];
            }
            ObCenterDataAcontactMultiChannel0403 multiChannel = new ObCenterDataAcontactMultiChannel0403();
            multiChannel.setMobile(fields[0]);
            multiChannel.setArea(fields[1]);
            multiChannel.setMarketingTaskCode(fields[2]);
            multiChannel.setClassifyActivityCode(fields[3]);
            multiChannel.setClassifyActivityName(fields[4]);
            multiChannel.setMarketingActivityCode(fields[5]);
            multiChannel.setMarketingActivityName(marketingActivityName);
            multiChannel.setActivityAttribution(fields[7]);
            multiChannel.setStartTime(fields[8]);
            multiChannel.setEndTime(fields[9]);
            multiChannel.setRecommendProduct(fields[10]);
            multiChannel.setProductName(fields[11]);
            multiChannel.setSpeechContent(fields[12]);
            multiChannel.setGearPosition(gearPosition);
            multiChannel.setCreatedTime(createdTime);
            multiChannel.setType(type);
            multiChannel.setFileName(fileName);
            multiChannelList.add(multiChannel);
        }
        long loopEnd = System.currentTimeMillis();
        double loopTime = (double)(loopEnd - loopBegin) / 1000.0;
        log.info("multiChannelXj0403List Size\u3010{}\u3011,fileName\u3010{}\u3011", (Object)multiChannelList.size(), (Object)fileName);
        long funcStartTime = System.currentTimeMillis();
        try {
            this.batchWriteMultiChannelXj0403(multiChannelList);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u5199\u5165\u63a5\u53e3\u6587\u4ef6\u6570\u636e\u5f02\u5e38,{}", (Throwable)e);
        }
        long funcEndTime = System.currentTimeMillis();
        double excTime = (double)(funcEndTime - funcStartTime) / 1000.0;
        log.info("\u5904\u7406\u5c5e\u5730\u5916\u5916\u547c\uff0c\u6587\u4ef6\u540d\u79f0\u3010{}\u3011,\u4e2d\u95f4\u8868\u63d2\u5165\u7528\u65f6\u3010{}\u3011\u79d2", (Object)fileName, (Object)excTime);
        List<ObCenterDataAcontactMultiChannel0403> multiChannels = this.obCenterDataAcontactMultiChannel0403Service.selectGroupByTenantAndTask0403(fileName, createdTime);
        log.info("multiChannels0403 Size\u3010{}\u3011,fileName\u3010{}\u3011", (Object)multiChannels.size(), (Object)fileName);
        for (ObCenterDataAcontactMultiChannel0403 multiChannel : multiChannels) {
            String tenantOtherNames = AcontactChannelTenantConfig.channelTenantMap.get(multiChannel.getArea() + POSITION_04_03);
            String taskName = NAME_HEAD + multiChannel.getMarketingActivityName() + multiChannel.getType() + tenantOtherNames;
            String taskId = this.obCenterDataTaskInfoService.selectTaskIdByTaskName(taskName);
            log.info("\u5f00\u59cb\u67e5\u8be2\u79df\u6237\u4fe1\u606f,tenantOtherName\u3010{}\u3011", (Object)tenantOtherNames);
            String tenantId = this.obCenterDataTaskDataService.selectTenantIdByotherName(tenantOtherNames);
            if (StringUtils.hasValue((String)tenantId)) {
                log.error("\u627e\u4e0d\u5230\u8be5\u79df\u6237\u4fe1\u606f\uff0c\u8bf7\u521b\u5efa\u8be5\u79df\u6237,\u6587\u4ef6\u540d\u79f0\u3010{}\u3011", (Object)fileName);
                return;
            }
            ArrayList<String[]> mulDataList = new ArrayList<String[]>();
            String channelCode = multiChannel.getArea();
            String marketingActivityName = multiChannel.getMarketingActivityName();
            String classifyActivityName = multiChannel.getClassifyActivityName();
            List<ObCenterDataAcontactMultiChannel0403> multiChannelListByTT = this.obCenterDataAcontactMultiChannel0403Service.selectTenantAndTask0403(channelCode, marketingActivityName, type, fileName, createdTime);
            log.info("multiChannelXjListByTT Size\u3010{}\u3011,fileName\u3010{}\u3011,tenantOtherName\u3010{}\u3011", new Object[]{multiChannelListByTT.size(), fileName, tenantOtherNames});
            for (ObCenterDataAcontactMultiChannel0403 multiChannel1 : multiChannelListByTT) {
                String[] s = new String[]{multiChannel1.getMobile(), multiChannel1.getArea(), multiChannel1.getMarketingTaskCode(), multiChannel1.getClassifyActivityCode(), multiChannel1.getClassifyActivityName(), multiChannel1.getMarketingActivityCode(), multiChannel1.getMarketingActivityName(), multiChannel1.getActivityAttribution(), multiChannel1.getStartTime(), multiChannel1.getEndTime(), multiChannel1.getRecommendProduct(), multiChannel1.getProductName(), multiChannel1.getSpeechContent(), multiChannel1.getGearPosition()};
                mulDataList.add(s);
            }
            log.info("mulDataList Size\u3010{}\u3011,fileName\u3010{}\u3011,tenantOtherName\u3010{}\u3011,", new Object[]{mulDataList.size(), fileName, tenantOtherNames});
            SingleChannelParam singleChannelParam = new SingleChannelParam();
            singleChannelParam.setTaskId(taskId);
            singleChannelParam.setFileName(fileName);
            singleChannelParam.setStartTime(multiChannel.getStartTime());
            singleChannelParam.setEndTime(multiChannel.getEndTime());
            singleChannelParam.setTaskName(taskName);
            singleChannelParam.setTenantId(tenantId);
            singleChannelParam.setSpeechContent(multiChannel.getSpeechContent());
            singleChannelParam.setDataList(mulDataList);
            singleChannelParam.setTenantOtherName(tenantOtherNames);
            singleChannelParam.setChannelType(channelType);
            singleChannelParam.setActivityCode(activityCode);
            singleChannelParam.setType(type);
            singleChannelParam.setOpChannelCoding(opChannelCoding);
            singleChannelParam.setChannelCode(channelCode);
            singleChannelParam.setGearPosition(gearPosition);
            singleChannelParam.setClassificationActivityName(classifyActivityName);
            String newTaskId = this.dealSingleChannelData(singleChannelParam);
            fileLog.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            fileLog.setDataNum(dataList.size());
            fileLog.setTaskId(newTaskId);
            fileLog.setTenantAlias(tenantOtherNames);
            this.obCenterDataAcontactFileLogService.insert(fileLog);
        }
        this.obCenterDataAcontactMultiChannel0403Service.truncateTable0403();
    }

    private void batchWriteMultiChannelXj0403(List<ObCenterDataAcontactMultiChannel0403> dataList) {
        int onceNum = 3000;
        if (dataList.size() > 100000) {
            onceNum = 5000;
        }
        int number = dataList.size() / onceNum;
        int remaider = dataList.size() % onceNum;
        for (int i = 0; i < number; ++i) {
            ArrayList<ObCenterDataAcontactMultiChannel0403> batchListNumber = new ArrayList<ObCenterDataAcontactMultiChannel0403>();
            for (int y = i * onceNum; y < (i + 1) * onceNum; ++y) {
                batchListNumber.add(dataList.get(y));
            }
            this.obCenterDataAcontactMultiChannel0403Service.batchInsert(batchListNumber);
        }
        if (remaider > 0) {
            ArrayList<ObCenterDataAcontactMultiChannel0403> batchListRemaider = new ArrayList<ObCenterDataAcontactMultiChannel0403>();
            for (int y = number * onceNum; y < dataList.size(); ++y) {
                batchListRemaider.add(dataList.get(y));
            }
            this.obCenterDataAcontactMultiChannel0403Service.batchInsert(batchListRemaider);
        }
    }

    private void dealInsertFailData(List<ObCenterDataTaskData> dataList, String tenantOtherName) {
        SingleChannelParam singleChannelParam = new SingleChannelParam();
        singleChannelParam.setTenantOtherName(tenantOtherName);
        singleChannelParam.setTaskDataList(dataList);
        this.singleChannelDealing(singleChannelParam);
    }

    private List<String> getSpecialPhoneList(String tenantId) {
        return this.obCenterDataTaskDataService.selectSpecialPhoneNoList();
    }

    public static String getuuid() {
        String uuid = UUID.randomUUID().toString();
        return uuid.replaceAll("-", "");
    }
}

