/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.data.acontact.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.data.acontact.config.AcontactPropertiesHolder;
import com.tydic.nicc.data.acontact.exceptions.DataCenterException;
import com.tydic.nicc.data.acontact.service.AcontactDealDataService;
import com.tydic.nicc.data.acontact.service.AcontactDealFileService;
import com.tydic.nicc.data.acontact.util.Sftp;
import com.tydic.nicc.data.acontact.util.SftpUtil;
import com.tydic.nicc.data.acontact.util.TXTFileReadUtil;
import java.io.File;
import java.io.FileInputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AcontactDealFileServiceImpl
implements AcontactDealFileService {
    private static final Logger log = LoggerFactory.getLogger(AcontactDealFileServiceImpl.class);
    @Resource
    private AcontactPropertiesHolder holder;
    @Resource
    AcontactDealDataService acontactDealDataService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void importData() {
        try {
            String[] namelist = this.getFileNameList();
            if (namelist == null) {
                log.info("\u6ca1\u6709\u9700\u8981\u4e0b\u8f7d\u7684\u6587\u4ef6");
                return;
            }
            List<String> lstDownloadAllpath = this.download(namelist);
            if (lstDownloadAllpath == null || lstDownloadAllpath.size() == 0) {
                log.info("\u6ca1\u53d1\u73b0\u4e0b\u8f7d\u6587\u4ef6");
                return;
            }
            log.info("\u4e0b\u8f7d\u6587\u4ef6\u6210\u529f\uff0c\u5f00\u59cb\u5904\u7406\u6587\u4ef6\u5185\u5bb9,\u6587\u4ef6\u6570:={}", (Object)lstDownloadAllpath.size());
            for (int i = 0; i < lstDownloadAllpath.size(); ++i) {
                long readBegin = System.currentTimeMillis();
                String downloadFileAllPathName = lstDownloadAllpath.get(i);
                List<String[]> dataList = TXTFileReadUtil.toArrayByInputStreamReader(downloadFileAllPathName);
                ArrayList<String> newLstDownLoadAllPath = new ArrayList<String>();
                newLstDownLoadAllPath.add(downloadFileAllPathName);
                long readEnd = System.currentTimeMillis();
                String[] remoteFile = new String[1];
                String dealTime = String.valueOf((double)(readEnd - readBegin) / 1000.0);
                try {
                    float excTime;
                    long funcEndTime;
                    String fileName;
                    boolean canDeal = true;
                    remoteFile[0] = fileName = namelist[i];
                    if (fileName.length() > 48) {
                        String dsr = fileName.substring(16, 24);
                        String nowDate = new SimpleDateFormat("yyyyMMdd").format(new Date());
                        if (!nowDate.equals(dsr)) {
                            canDeal = false;
                        }
                    }
                    if (!canDeal) continue;
                    if (downloadFileAllPathName.contains("POSITION_04_03")) {
                        long funcStartTime = System.currentTimeMillis();
                        this.acontactDealDataService.importData0403(dataList, downloadFileAllPathName);
                        funcEndTime = System.currentTimeMillis();
                        excTime = (float)(funcEndTime - funcStartTime) / 1000.0f;
                        log.info("\u5904\u7406\u5c5e\u5730\u5916\u5916\u547c\uff0c\u6587\u4ef6\u540d\u79f0={},\u5355\u4e2a\u6587\u4ef6\u7528\u65f6={}\u79d2", (Object)downloadFileAllPathName, (Object)Float.valueOf(excTime));
                        continue;
                    }
                    long funcStartTime = System.currentTimeMillis();
                    this.acontactDealDataService.importData(dataList, downloadFileAllPathName);
                    funcEndTime = System.currentTimeMillis();
                    excTime = (float)(funcEndTime - funcStartTime) / 1000.0f;
                    log.info("\u5904\u7406\u5c5e\u5730\u5916\u5916\u547c\uff0c\u6587\u4ef6\u540d\u79f0={},\u5355\u4e2a\u6587\u4ef6\u7528\u65f6={}\u79d2", (Object)downloadFileAllPathName, (Object)Float.valueOf(excTime));
                    continue;
                }
                catch (Exception e) {
                    log.error("\u6587\u4ef6\u5185\u5bb9\u5904\u7406\u5f02\u5e38,\u6587\u4ef6\u540d\u79f0={},\u5f02\u5e38={}", (Object)downloadFileAllPathName, (Object)e);
                    continue;
                }
                finally {
                    this.moveFileByOne(remoteFile, newLstDownLoadAllPath);
                }
            }
        }
        catch (Exception e) {
            log.error("importData exception", (Throwable)e);
        }
    }

    private String[] getFileNameList() throws DataCenterException {
        String[] fileNameList = null;
        Sftp sftpClient = null;
        log.info("\u5f00\u59cb\u83b7\u53d6\u6587\u4ef6\u540d\u79f0\u5217\u8868:" + this.holder.getSftp().getSftpPath().getFilePath());
        try {
            String ip = this.holder.getSftp().getHost();
            int port = this.holder.getSftp().getPort();
            String userName = this.holder.getSftp().getUsername();
            String password = this.holder.getSftp().getPassword();
            String dir = this.holder.getSftp().getSftpPath().getFilePath();
            sftpClient = SftpUtil.getSFTPClient(ip, password, userName, port);
            if (dir != null && !"".equals(dir)) {
                sftpClient.changeDir(dir);
            }
            fileNameList = sftpClient.lsFiles(dir);
            log.info("\u83b7\u53d6\u6587\u4ef6\u5217\u8868\u6210\u529f!");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DataCenterException("\u8fde\u63a5SFTP\u5931\u8d25.", e);
        }
        finally {
            try {
                if (sftpClient != null) {
                    sftpClient.logout();
                }
                sftpClient = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return fileNameList;
    }

    public List<String> download(String[] fileNameList) throws DataCenterException {
        ArrayList<String> lstDownloadAllPath = new ArrayList<String>();
        String downloadAllPath = null;
        Sftp sftpClient = null;
        log.info("\u5f00\u59cb\u8bfb\u53d6\u7edd\u5bf9\u8def\u5f84" + this.holder.getSftp().getSftpPath().getFilePath() + "\u6587\u4ef6!");
        String localPath = this.holder.getSftp().getSftpPath().getLocalPath();
        try {
            String ip = this.holder.getSftp().getHost();
            int port = this.holder.getSftp().getPort();
            String userName = this.holder.getSftp().getUsername();
            String password = this.holder.getSftp().getPassword();
            String dir = this.holder.getSftp().getSftpPath().getFilePath();
            sftpClient = SftpUtil.getSFTPClient(ip, password, userName, port);
            if (dir != null && !"".equals(dir)) {
                sftpClient.changeDir(dir);
            }
            if (fileNameList == null || fileNameList.length == 0) {
                List<String> list = null;
                return list;
            }
            for (String fileName : fileNameList) {
                try {
                    log.info("\u521b\u5efa\u4fdd\u5b58\u672c\u5730\u6587\u4ef6\u6587\u4ef6\u5939={}", (Object)localPath);
                    FileUtils.forceMkdir((File)new File(localPath));
                    downloadAllPath = localPath + fileName;
                    log.info("\u672c\u5730\u4fdd\u5b58\u6587\u4ef6\u5168\u8def\u5f84={}", (Object)downloadAllPath);
                    log.info("\u5f00\u59cb\u4eceSFTP\u4e0b\u8f7d\u6587\u4ef6,SFTP\u670d\u52a1\u5668\u76ee\u5f55={},\u670d\u52a1\u5668\u4e0a\u9700\u8981\u4e0b\u8f7d\u7684\u6587\u4ef6\u540d={},\u672c\u5730\u4fdd\u5b58\u8def\u5f84={}", new Object[]{dir, fileName, localPath});
                    sftpClient.downloadFile(dir, fileName, localPath);
                    log.info("\u4e0b\u8f7d\u6210\u529f!\u6587\u4ef6\u540d\u79f0={}", (Object)fileName);
                    lstDownloadAllPath.add(downloadAllPath);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.info(downloadAllPath + "\u4e0b\u8f7d\u5931\u8d25,\u8df3\u8fc7\u4e0b\u8f7d!");
                }
            }
            sftpClient.logout();
            ArrayList<String> arrayList = lstDownloadAllPath;
            return arrayList;
        }
        catch (Exception e) {
            log.info("\u8fde\u63a5SFTP\u5931\u8d25", (Throwable)e);
            throw new DataCenterException("\u8fde\u63a5SFTP\u5931\u8d25.", e);
        }
        finally {
            try {
                if (sftpClient != null) {
                    sftpClient.logout();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveFileByOne(String[] nameList, List<String> lstDownloadAllpath) {
        Sftp sftpClient = null;
        try {
            String ip = this.holder.getSftp().getHost();
            int port = this.holder.getSftp().getPort();
            String userName = this.holder.getSftp().getUsername();
            String password = this.holder.getSftp().getPassword();
            String dir = this.holder.getSftp().getSftpPath().getFilePath();
            sftpClient = SftpUtil.getSFTPClient(ip, password, userName, port);
            if (nameList != null) {
                log.info("\u5f00\u59cb\u79fb\u52a8\u6587\u4ef6\u5939\u81f3bak={},\u6587\u4ef6\u4e0b\u8f7d\u6839\u76ee\u5f55={}", (Object)JSONObject.toJSONString((Object)nameList), (Object)dir);
                for (String fileName : nameList) {
                    String toPath = dir + "bak";
                    this.moveFtpFile(sftpClient, dir, toPath, fileName);
                    log.info("\u6210\u529f\u79fb\u52a8\u6587\u4ef6\u81f3bak\u6587\u4ef6\u5939={}", (Object)(dir + fileName));
                }
            }
            for (String localPathFile : lstDownloadAllpath) {
                File file = new File(localPathFile);
                file.delete();
            }
            log.info("\u6210\u529f\u5220\u9664\u672c\u5730\u6587\u4ef6={}", (Object)JSONObject.toJSONString(lstDownloadAllpath));
            this.logoutSftp(sftpClient);
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
        finally {
            this.logoutSftp(sftpClient);
        }
    }

    private void moveFtpFile(Sftp sftpClient, String fromPath, String toPath, String fileName) {
        String localPath = this.holder.getSftp().getSftpPath().getLocalPath();
        log.info("\u5f00\u59cb\u79fb\u52a8FTP\u6587\u4ef6\uff0ctoPath={},fileName={},localPath={}", new Object[]{toPath, fileName, localPath + fileName});
        try {
            log.info("\u4e0a\u4f20\u6587\u4ef6\u81f3bak\u76ee\u5f55\uff0ctoPath={},fileName={},localPath={}", new Object[]{toPath, fileName, localPath + fileName});
            sftpClient.uploadFile(toPath, fileName, new FileInputStream(localPath + fileName));
            log.info("FTP\u5220\u9664\u539f\u6587\u4ef6={}", (Object)(fromPath + fileName));
            sftpClient.delFile(fromPath + fileName);
        }
        catch (Exception e) {
            log.info("\u79fb\u52a8FTP\u6587\u4ef6\u81f3bak\u6587\u4ef6\u5939\u5f02\u5e38", (Throwable)e);
        }
    }

    private void logoutSftp(Sftp sftpClient) {
        try {
            if (sftpClient != null) {
                sftpClient.logout();
            }
        }
        catch (Exception e) {
            log.info("\u5173\u95edFTP\u5ba2\u6237\u7aef\u5f02\u5e38", (Throwable)e);
        }
    }
}

