/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.data.acontact.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.tydic.nicc.data.acontact.config.AcontactPropertiesHolder;
import com.tydic.nicc.data.acontact.entity.DataInfo;
import com.tydic.nicc.data.acontact.entity.FeedBackResult;
import com.tydic.nicc.data.acontact.mapper.po.ObCenterDataAcontact;
import com.tydic.nicc.data.acontact.service.AcontactFeedBackService;
import com.tydic.nicc.data.acontact.service.ObCenterDataAcontactService;
import com.tydic.nicc.data.acontact.util.Sftp;
import com.tydic.nicc.data.acontact.util.TXTFileReadUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AcontactFeedBackServiceImpl
implements AcontactFeedBackService {
    private static final Logger log = LoggerFactory.getLogger(AcontactFeedBackServiceImpl.class);
    @Resource
    private AcontactPropertiesHolder holder;
    private static final String SINGLE = "single";
    private static final String PLATFORM = "platform";
    private static final String PLATFORM0403 = "platform0403";
    @Resource
    ObCenterDataAcontactService obCenterDataAcontactService;

    @Override
    public void feedBack(String feedBackType) {
        if (feedBackType.equals(SINGLE)) {
            String[] singleList;
            String singles = "POSITION_01_04,POSITION_01_05,POSITION_01_06";
            for (String single : singleList = singles.split(",")) {
                String channelCodeByFile = "01";
                List<ObCenterDataAcontact> list = this.obCenterDataAcontactService.selectAllCallOutDate(single);
                List<FeedBackResult> fbrList = this.structureFeedbackDataByOneDay(list);
                this.generateFeedbackFiles(fbrList, channelCodeByFile, single, feedBackType);
            }
        } else if (feedBackType.equals(PLATFORM0403)) {
            String channelCodeByFile = "04";
            String operationCode = "POSITION_04_03";
            List<ObCenterDataAcontact> list = this.obCenterDataAcontactService.selectAllCallOutDate(operationCode);
            List<FeedBackResult> fbrList = this.structureFeedbackDataByOneDay(list);
            this.generateFeedbackFiles(fbrList, channelCodeByFile, operationCode, feedBackType);
        } else {
            String channelCodeByFile = "01";
            String operationCode = "POSITION_01_08";
            List<ObCenterDataAcontact> list = this.obCenterDataAcontactService.selectAllCallOutDate(operationCode);
            List<FeedBackResult> fbrList = this.structureFeedbackDataByOneDay(list);
            this.generateFeedbackFiles(fbrList, channelCodeByFile, operationCode, feedBackType);
        }
    }

    private List<FeedBackResult> structureFeedbackDataByOneDay(List<ObCenterDataAcontact> list) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat dateFormat1 = new SimpleDateFormat("yyyyMMddHHmmss");
        SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<FeedBackResult> resultList = new ArrayList<FeedBackResult>();
        if (list == null || list.size() == 0) {
            return null;
        }
        for (ObCenterDataAcontact oneRecord : list) {
            ArrayList dataInfoArrayList = (ArrayList)JSON.parseObject((String)oneRecord.getDataJson(), (TypeReference)new TypeReference<ArrayList<DataInfo>>(){}, (Feature[])new Feature[0]);
            FeedBackResult feedBackResult = new FeedBackResult();
            feedBackResult.setUserNum(oneRecord.getMobileNo());
            feedBackResult.setActivityId(((DataInfo)dataInfoArrayList.get(5)).getValue());
            feedBackResult.setActivityName(((DataInfo)dataInfoArrayList.get(6)).getValue());
            feedBackResult.setChannelCode(oneRecord.getChannelCode());
            feedBackResult.setOperationCode(oneRecord.getSystemCode());
            feedBackResult.setContactFlag(StringUtils.isEmpty((CharSequence)oneRecord.getIsConn()) ? "" : oneRecord.getIsConn());
            String contactTime = "";
            try {
                Date parse = dateFormat.parse(oneRecord.getCallTime());
                contactTime = dateFormat1.format(parse);
            }
            catch (ParseException e) {
                log.info("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38!");
            }
            feedBackResult.setContactTime(contactTime);
            if (!StringUtils.isEmpty((CharSequence)oneRecord.getHandleResult()) && "agree".equals(oneRecord.getHandleResult())) {
                oneRecord.setHandleResult("1001");
            }
            String activityResult = StringUtils.isEmpty((CharSequence)oneRecord.getHandleResult()) ? "" : oneRecord.getHandleResult();
            String handleResult = "";
            if ("".equals(activityResult)) {
                activityResult = "1002";
                handleResult = "\u65e0\u6cd5\u63a5\u901a";
            }
            feedBackResult.setActivityResult(activityResult);
            String remark = StringUtils.isEmpty((CharSequence)oneRecord.getFcoBak1()) ? "" : oneRecord.getFcoBak1();
            String newRemark = this.replaceBlank(remark);
            feedBackResult.setActivityOpinion(newRemark);
            String newHandleResult = this.replaceBlank(handleResult);
            feedBackResult.setHandleResult(newHandleResult);
            feedBackResult.setRemark("");
            String agentNumber = oneRecord.getHandleUser();
            feedBackResult.setHandlerUser(agentNumber);
            feedBackResult.setBssNum(null);
            feedBackResult.setCbssNum(null);
            feedBackResult.setCreateDate(dateFormat2.format(new Date()));
            resultList.add(feedBackResult);
        }
        return resultList;
    }

    public String replaceBlank(String str) {
        String dest = "";
        String pattern = "\\s*|\t|\r|\n";
        if (str != null) {
            Pattern p = Pattern.compile(pattern);
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }

    private void generateFeedbackFiles(List<FeedBackResult> fbrList, String channelCodeByFile, String operationCode, String feedbackType) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String beforeDay = sdf.format(new Date());
        String txtFileName = channelCodeByFile + operationCode + beforeDay + ".txt";
        String chkFileName = channelCodeByFile + operationCode + beforeDay + ".chk";
        try {
            String localPath = "";
            String feedBackPath = "";
            if (feedbackType.equals(SINGLE)) {
                localPath = this.holder.getSftp().getSftpPath().getLocalFeedbackSinglePath();
                feedBackPath = this.holder.getSftp().getSftpPath().getFeedbackSinglePath();
            } else {
                localPath = this.holder.getSftp().getSftpPath().getLocalFeedbackPath();
                feedBackPath = this.holder.getSftp().getSftpPath().getFeedbackPath();
            }
            TXTFileReadUtil.writeToDisk(localPath, txtFileName, fbrList);
            TXTFileReadUtil.writeToDisk(localPath, chkFileName, new ArrayList());
            this.uploadFile(localPath, feedBackPath, txtFileName, chkFileName, feedbackType);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadFile(String localPath, String feedBackPath, String txtFileName, String chkFileName, String feedbackType) {
        Sftp sftp = this.getSFTP();
        sftp.login();
        String localFilePathTxt = localPath + txtFileName;
        String localFilePathChk = localPath + chkFileName;
        log.info("\u4e0a\u4f20\u6e20\u9053\u53cd\u9988\u6587\u4ef6\uff0cpathName={},txtFileName={},chkFileName={},localFilePathTxt={}", new Object[]{feedBackPath, txtFileName, chkFileName, localFilePathTxt});
        try {
            sftp.uploadFile(feedBackPath, txtFileName, new FileInputStream(localFilePathTxt));
            sftp.uploadFile(feedBackPath, chkFileName, new FileInputStream(localFilePathChk));
            File fileTxt = new File(localFilePathTxt);
            fileTxt.delete();
            File fileChk = new File(localFilePathChk);
            fileChk.delete();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            try {
                sftp.logout();
            }
            catch (Exception e) {
                log.info("\u5173\u95edFTP\u5ba2\u6237\u7aef\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private Sftp getSFTP() {
        int timeout = 60000;
        String host = this.holder.getSftp().getHost();
        int port = this.holder.getSftp().getPort();
        String username = this.holder.getSftp().getUsername();
        String password = this.holder.getSftp().getPassword();
        return new Sftp(host, port, timeout, username, password);
    }
}

