/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.data.acontact.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class CoderUtils {
    private static String[][] FilterCharsRemove = new String[][]{{"<", ""}, {">", ""}, {" ", ""}, {"\"", ""}, {"&", ""}, {"/", ""}, {"\\", ""}, {"\n", ""}, {"%", ""}, {"_", ""}, {"'", ""}};
    private static String[][] FilterChars = new String[][]{{"<", "&lt;"}, {">", "&gt;"}, {" ", "&nbsp;"}, {"\"", "&quot;"}, {"&", "&amp;"}, {"/", "&#47;"}, {"\\", "&#92;"}, {"\n", "<br>"}};
    private static String[][] FilterScriptChars = new String[][]{{"\n", "'+'\\n'+'"}, {"\r", " "}, {"\\", "'+'\\\\'+'"}, {"'", "'+'\\''+'"}};

    public static char ascii2Char(int ASCII) {
        return (char)ASCII;
    }

    public static int char2ASCII(char c) {
        return c;
    }

    public static String ascii2String(int[] ASCIIs) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ASCIIs.length; ++i) {
            sb.append(CoderUtils.ascii2Char(ASCIIs[i]));
        }
        return sb.toString();
    }

    public static String ascii2String(String ASCIIs) {
        String[] ASCIIss = ASCIIs.split(",");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ASCIIss.length; ++i) {
            sb.append(CoderUtils.ascii2Char(Integer.parseInt(ASCIIss[i])));
        }
        return sb.toString();
    }

    public static int[] string2ASCII(String s) {
        if (s == null || "".equals(s)) {
            return null;
        }
        char[] chars = s.toCharArray();
        int[] asciiArray = new int[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            asciiArray[i] = CoderUtils.char2ASCII(chars[i]);
        }
        return asciiArray;
    }

    public static String getIntArrayString(int[] intArray) {
        return CoderUtils.getIntArrayString(intArray, ",");
    }

    public static String getIntArrayString(int[] intArray, String delimiter) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < intArray.length; ++i) {
            sb.append(intArray[i]).append(delimiter);
        }
        return sb.toString();
    }

    public static String getASCII(int begin, int end) {
        StringBuffer sb = new StringBuffer();
        for (int i = begin; i < end; ++i) {
            sb.append(i).append(":").append((char)i).append("/t");
            if (i % 10 != 0) continue;
            sb.append("/n");
        }
        return sb.toString();
    }

    public static String getCHASCII(int begin, int end) {
        return CoderUtils.getASCII(19968, 40869);
    }

    public static void showASCII(int begin, int end) {
        for (int i = begin; i < end; ++i) {
            System.out.print((char)i + "/t");
            if (i % 10 != 0) continue;
            System.out.println();
        }
    }

    public static void showCHASCII() {
        CoderUtils.showASCII(19968, 40869);
    }

    public static void showIntArray(int[] intArray) {
        CoderUtils.showIntArray(intArray, ",");
    }

    public static void showIntArray(int[] intArray, String delimiter) {
        for (int i = 0; i < intArray.length; ++i) {
            System.out.print(intArray[i] + delimiter);
        }
    }

    public static void createFile(String filePathAndName, String fileContent) throws IOException {
        String filePath = filePathAndName;
        File myFilePath = new File(filePath = filePath.toString());
        if (!myFilePath.exists()) {
            myFilePath.createNewFile();
        }
        FileWriter resultFile = new FileWriter(myFilePath);
        PrintWriter myFile = new PrintWriter(resultFile);
        String strContent = fileContent;
        myFile.println(strContent);
        myFile.close();
        resultFile.close();
    }

    public static String stringFilter(String str) {
        String[] str_arr = CoderUtils.stringSpilit(str, "");
        for (int i = 0; i < str_arr.length; ++i) {
            for (int j = 0; j < FilterChars.length; ++j) {
                if (!FilterChars[j][0].equals(str_arr[i])) continue;
                str_arr[i] = FilterChars[j][1];
            }
        }
        return CoderUtils.stringConnect(str_arr, "").trim();
    }

    public static String stringFilterRemove(String str) {
        String[] str_arr = CoderUtils.stringSpilit(str, "");
        for (int i = 0; i < str_arr.length; ++i) {
            for (int j = 0; j < FilterCharsRemove.length; ++j) {
                if (!FilterCharsRemove[j][0].equals(str_arr[i])) continue;
                str_arr[i] = FilterCharsRemove[j][1];
            }
        }
        return CoderUtils.stringConnect(str_arr, "").trim();
    }

    public static String stringFilterScriptChar(String str) {
        String[] str_arr = CoderUtils.stringSpilit(str, "");
        for (int i = 0; i < str_arr.length; ++i) {
            for (int j = 0; j < FilterScriptChars.length; ++j) {
                if (!FilterScriptChars[j][0].equals(str_arr[i])) continue;
                str_arr[i] = FilterScriptChars[j][1];
            }
        }
        return CoderUtils.stringConnect(str_arr, "").trim();
    }

    public static String stringConnect(String[] strings, String spilit_sign) {
        String str = "";
        for (int i = 0; i < strings.length; ++i) {
            str = str + strings[i] + spilit_sign;
        }
        return str;
    }

    public static String[] stringSpilit(String str, String spilit_sign) {
        String[] spilit_string = str.split(spilit_sign);
        if (spilit_string[0].equals("")) {
            String[] new_string = new String[spilit_string.length - 1];
            for (int i = 1; i < spilit_string.length; ++i) {
                new_string[i - 1] = spilit_string[i];
            }
            return new_string;
        }
        return spilit_string;
    }

    public static String getFileNameWithoutType(String fileName) {
        String fileNameWithoutType = "";
        if (fileName == null || "".equals(fileName)) {
            return "";
        }
        if (fileName.lastIndexOf(".") == -1) {
            return CoderUtils.stringFilterRemove(fileName);
        }
        fileNameWithoutType = fileName.substring(0, fileName.lastIndexOf("."));
        return CoderUtils.stringFilterRemove(fileNameWithoutType);
    }

    public static String getFileNameWithoutTypeByFullPath(String fileName) {
        String fileNameWithoutType = "";
        if (fileName == null || "".equals(fileName)) {
            return "";
        }
        if (fileName.lastIndexOf(".") == -1) {
            return CoderUtils.stringFilterRemove(fileName);
        }
        File tempFile = new File(fileName.trim());
        fileName = tempFile.getName();
        fileNameWithoutType = fileName.substring(0, fileName.lastIndexOf("."));
        return CoderUtils.stringFilterRemove(fileNameWithoutType);
    }

    public static void main(String[] args) throws IOException {
        String s = "\u597d\u597d\u5b66\u4e60\uff01\u5929\u5929\u5411\u4e0a\uff01\u2014\u2014\u2014\u2014\u7b11\u7684\u81ea\u7136 2009\u5e743\u670811\u65e5";
        CoderUtils.showIntArray(CoderUtils.string2ASCII(s), " ");
        System.out.println();
        System.out.println(CoderUtils.ascii2String(CoderUtils.string2ASCII(s)));
        char splitChar = CoderUtils.ascii2Char(Integer.parseInt("44"));
        System.out.println(String.valueOf(splitChar));
        String fileName = null;
        String fileNameWithoutType = CoderUtils.getFileNameWithoutType(fileName);
        System.out.println(fileNameWithoutType);
    }
}

