/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.data.acontact.util;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sftp {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Session session = null;
    private ChannelSftp channel = null;
    private String host;
    private int port;
    private int timeout;
    private String username;
    private String password;

    public Sftp(String host, int port, int timeout, String username, String password) {
        this.host = host;
        this.port = port;
        this.timeout = timeout;
        this.username = username;
        this.password = password;
    }

    public boolean login() {
        try {
            JSch jsch = new JSch();
            this.session = jsch.getSession(this.username, this.host, this.port);
            if (this.password != null) {
                this.session.setPassword(this.password);
            }
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            this.session.setConfig(config);
            this.session.setTimeout(this.timeout);
            this.session.connect();
            this.logger.debug("sftp session connected");
            this.logger.debug("opening channel");
            this.channel = (ChannelSftp)this.session.openChannel("sftp");
            this.channel.connect();
            this.logger.debug("connected successfully");
            return true;
        }
        catch (JSchException e) {
            this.logger.error("sftp login failed", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadFile(String pathName, String fileName, InputStream input) {
        this.logger.info("\u5f00\u59cb\u4e0a\u4f20\u6587\u4ef6\u5230FTP\u670d\u52a1\u5668\uff0cSFTP\u670d\u52a1\u5668\u76ee\u5f55\u3010{}\u3011,\u670d\u52a1\u5668\u4e0a\u4fdd\u5b58\u7684\u6587\u4ef6\u540d\u3010{}\u3011", (Object)pathName, (Object)fileName);
        String currentDir = this.currentDir();
        if (!this.changeDir(pathName)) {
            return false;
        }
        try {
            this.channel.put(input, fileName, 0);
            if (!this.existFile(fileName)) {
                this.logger.debug("upload failed");
                boolean bl = false;
                return bl;
            }
            this.logger.debug("upload successful");
            this.logger.info("\u4e0a\u4f20\u6587\u4ef6\u5230FTP\u670d\u52a1\u5668\u6210\u529f\uff01\uff01\uff01SFTP\u670d\u52a1\u5668\u76ee\u5f55\u3010{}\u3011,\u670d\u52a1\u5668\u4e0a\u4fdd\u5b58\u7684\u6587\u4ef6\u540d\u3010{}\u3011", (Object)pathName, (Object)fileName);
            boolean bl = true;
            return bl;
        }
        catch (SftpException e) {
            this.logger.error("upload failed", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.changeDir(currentDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadFile(String pathName, String fileName, String localFile) {
        String currentDir = this.currentDir();
        if (!this.changeDir(pathName)) {
            return false;
        }
        try {
            this.channel.put(localFile, fileName, 0);
            if (!this.existFile(fileName)) {
                this.logger.debug("upload failed");
                boolean bl = false;
                return bl;
            }
            this.logger.debug("upload successful");
            boolean bl = true;
            return bl;
        }
        catch (SftpException e) {
            this.logger.error("upload failed", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.changeDir(currentDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadFile(String remotePath, String fileName, String localPath) {
        String currentDir = this.currentDir();
        if (!this.changeDir(remotePath)) {
            return false;
        }
        try {
            String localFilePath = localPath + fileName;
            this.channel.get(fileName, localFilePath);
            File localFile = new File(localFilePath);
            if (!localFile.exists()) {
                this.logger.info("\u6587\u4ef6\u4e0b\u8f7d\uff0c\u672c\u5730\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u672c\u5730\u8def\u5f84\u3010{}\u3011", (Object)localFilePath);
                boolean bl = false;
                return bl;
            }
            if (localFile.length() == 0L) {
                localFile.deleteOnExit();
                this.logger.info("download file was has 0kb");
                boolean bl = true;
                return bl;
            }
            this.logger.info("SFTP\u6587\u4ef6\u4e0b\u8f7d\u6210\u529f\uff0c\u672c\u5730\u6587\u4ef6\u8def\u5f84\u3010{}\u3011", (Object)localFilePath);
            boolean bl = true;
            return bl;
        }
        catch (SftpException e) {
            this.logger.info("SFTP\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u5f02\u5e38\u3010{}\u3011", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.changeDir(currentDir);
        }
    }

    public boolean changeDir(String pathName) {
        if (pathName == null || pathName.trim().equals("")) {
            this.logger.debug("invalid pathName");
            return false;
        }
        try {
            this.channel.cd(pathName.replaceAll("\\\\", "/"));
            this.logger.debug("directory successfully changed,current dir=" + this.channel.pwd());
            return true;
        }
        catch (SftpException e) {
            this.logger.error("failed to change directory", (Throwable)e);
            return false;
        }
    }

    public boolean changeToParentDir() {
        return this.changeDir("..");
    }

    public boolean changeToHomeDir() {
        String homeDir = null;
        try {
            homeDir = this.channel.getHome();
        }
        catch (SftpException e) {
            this.logger.error("can not get home directory", (Throwable)e);
            return false;
        }
        return this.changeDir(homeDir);
    }

    public boolean makeDir(String dirName) {
        try {
            this.channel.mkdir(dirName);
            this.logger.debug("directory successfully created,dir=" + dirName);
            return true;
        }
        catch (SftpException e) {
            this.logger.error("failed to create directory", (Throwable)e);
            return false;
        }
    }

    public boolean delDir(String dirName) {
        if (!this.changeDir(dirName)) {
            return false;
        }
        Vector list = null;
        try {
            list = this.channel.ls(this.channel.pwd());
        }
        catch (SftpException e) {
            this.logger.error("can not list directory", (Throwable)e);
            return false;
        }
        for (ChannelSftp.LsEntry entry : list) {
            String fileName = entry.getFilename();
            if (fileName.equals(".") || fileName.equals("..")) continue;
            if (entry.getAttrs().isDir()) {
                this.delDir(fileName);
                continue;
            }
            this.delFile(fileName);
        }
        if (!this.changeToParentDir()) {
            return false;
        }
        try {
            this.channel.rmdir(dirName);
            this.logger.debug("directory " + dirName + " successfully deleted");
            return true;
        }
        catch (SftpException e) {
            this.logger.error("failed to delete directory " + dirName, (Throwable)e);
            return false;
        }
    }

    public boolean delFile(String fileName) {
        if (fileName == null || fileName.trim().equals("")) {
            this.logger.debug("invalid filename");
            return false;
        }
        try {
            this.channel.rm(fileName);
            this.logger.debug("file " + fileName + " successfully deleted");
            return true;
        }
        catch (SftpException e) {
            this.logger.error("failed to delete file " + fileName, (Throwable)e);
            return false;
        }
    }

    public String[] ls() {
        return this.list(Filter.ALL);
    }

    public String[] ls(String pathName) {
        String currentDir = this.currentDir();
        if (!this.changeDir(pathName)) {
            return new String[0];
        }
        String[] result = this.list(Filter.ALL);
        if (!this.changeDir(currentDir)) {
            return new String[0];
        }
        return result;
    }

    public String[] lsFiles() {
        return this.list(Filter.FILE);
    }

    public String[] lsFiles(String pathName) {
        String currentDir = this.currentDir();
        if (!this.changeDir(pathName)) {
            return new String[0];
        }
        String[] result = this.list(Filter.FILE);
        if (!this.changeDir(currentDir)) {
            return new String[0];
        }
        return result;
    }

    public String[] lsDirs() {
        return this.list(Filter.DIR);
    }

    public String[] lsDirs(String pathName) {
        String currentDir = this.currentDir();
        if (!this.changeDir(pathName)) {
            return new String[0];
        }
        String[] result = this.list(Filter.DIR);
        if (!this.changeDir(currentDir)) {
            return new String[0];
        }
        return result;
    }

    public boolean exist(String name) {
        return this.exist(this.ls(), name);
    }

    public boolean exist(String path, String name) {
        return this.exist(this.ls(path), name);
    }

    public boolean existFile(String name) {
        return this.exist(this.lsFiles(), name);
    }

    public boolean existFile(String path, String name) {
        return this.exist(this.lsFiles(path), name);
    }

    public boolean existDir(String name) {
        return this.exist(this.lsDirs(), name);
    }

    public boolean existDir(String path, String name) {
        return this.exist(this.lsDirs(path), name);
    }

    public String currentDir() {
        try {
            return this.channel.pwd();
        }
        catch (SftpException e) {
            this.logger.error("failed to get current dir", (Throwable)e);
            return this.homeDir();
        }
    }

    public void logout() {
        if (this.channel != null) {
            this.channel.quit();
            this.channel.disconnect();
        }
        if (this.session != null) {
            this.session.disconnect();
        }
        this.logger.debug("logout successfully");
    }

    private String[] list(Filter filter) {
        Vector list = null;
        try {
            list = this.channel.ls(this.channel.pwd());
        }
        catch (SftpException e) {
            this.logger.error("can not list directory", (Throwable)e);
            return new String[0];
        }
        ArrayList<String> resultList = new ArrayList<String>();
        for (ChannelSftp.LsEntry entry : list) {
            if (!this.filter(entry, filter)) continue;
            resultList.add(entry.getFilename());
        }
        return resultList.toArray(new String[0]);
    }

    public String[] listFileNames(String regex) {
        ArrayList<String> resultList = new ArrayList<String>();
        try {
            String[] list = this.list(Filter.ALL);
            Pattern pattern = Pattern.compile(regex);
            for (String fileName : list) {
                Matcher m = pattern.matcher(fileName);
                if (!m.matches()) continue;
                resultList.add(fileName);
            }
        }
        catch (Exception e) {
            this.logger.error("can not list directory", (Throwable)e);
            return resultList.toArray(new String[0]);
        }
        return resultList.toArray(new String[0]);
    }

    private boolean filter(ChannelSftp.LsEntry entry, Filter f) {
        if (f.equals((Object)Filter.ALL)) {
            return !entry.getFilename().equals(".") && !entry.getFilename().equals("..");
        }
        if (f.equals((Object)Filter.FILE)) {
            return !entry.getFilename().equals(".") && !entry.getFilename().equals("..") && !entry.getAttrs().isDir();
        }
        if (f.equals((Object)Filter.DIR)) {
            return !entry.getFilename().equals(".") && !entry.getFilename().equals("..") && entry.getAttrs().isDir();
        }
        return false;
    }

    private String homeDir() {
        try {
            return this.channel.getHome();
        }
        catch (SftpException e) {
            return "/";
        }
    }

    private boolean exist(String[] strArr, String str) {
        if (strArr == null || strArr.length == 0) {
            return false;
        }
        if (str == null || str.trim().equals("")) {
            return false;
        }
        for (String s : strArr) {
            if (!s.equalsIgnoreCase(str)) continue;
            return true;
        }
        return false;
    }

    private static enum Filter {
        ALL,
        FILE,
        DIR;

    }
}

