/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.data.acust.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.oss.common.utils.StringUtils;
import com.tydic.nicc.data.acust.config.AcustPropertiesHolder;
import com.tydic.nicc.data.acust.mapper.ObCenterDataAcustMapper;
import com.tydic.nicc.data.acust.mapper.ObCenterDataAcustTaskBatchMapper;
import com.tydic.nicc.data.acust.mapper.po.ObCenterDataAcust;
import com.tydic.nicc.data.acust.mapper.po.ObCenterDataAcustLog;
import com.tydic.nicc.data.acust.mapper.po.ObCenterDataAcustTaskBatch;
import com.tydic.nicc.data.acust.service.ObCenterDataAcustLogService;
import com.tydic.nicc.data.acust.util.AcustUtil;
import com.tydic.nicc.data.acust.util.DateUtil;
import com.tydic.nicc.data.acust.util.OkHttpUtil;
import com.tydic.nicc.data.mapper.po.ObCenterDataCallBackRecord;
import com.tydic.nicc.data.service.acust.AcustCallResultInfoReturnService;
import com.tydic.nicc.data.service.callback.ObCenterDataCallBackRecordService;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DubboService
public class AcustCallResultInfoReturnServiceImpl
implements AcustCallResultInfoReturnService {
    private static final Logger log = LoggerFactory.getLogger(AcustCallResultInfoReturnServiceImpl.class);
    @Resource
    ObCenterDataAcustTaskBatchMapper obCenterDataAcustTaskBatchMapper;
    @Resource
    ObCenterDataAcustMapper obCenterDataAcustMapper;
    @Resource
    ObCenterDataAcustLogService obCenterDataAcustLogService;
    @Resource
    ObCenterDataCallBackRecordService obCenterDataCallBackRecordService;
    @Resource
    AcustPropertiesHolder holder;

    public void callBackSchedule() {
        List ocdcbrs = this.obCenterDataCallBackRecordService.selectAll();
        if (ocdcbrs == null || ocdcbrs.size() < 1) {
            log.info("\u6ca1\u6709\u9700\u8981\u53cd\u9988\u7684\u6570\u636e");
            return;
        }
        for (ObCenterDataCallBackRecord cbr : ocdcbrs) {
            this.callBack(cbr);
        }
    }

    public Rsp callBack(ObCenterDataCallBackRecord callBackRecord) {
        if (callBackRecord == null) {
            return BaseRspUtils.createErrorRsp((String)"\u65e0\u8bf7\u6c42\u53c2\u6570\uff0c\u56de\u8c03\u5931\u8d25");
        }
        if (StringUtils.isNullOrEmpty((String)callBackRecord.getRecordId())) {
            return BaseRspUtils.createErrorRsp((String)"\u8bb0\u5f55ID\u4e3a\u7a7a\uff0c\u56de\u8c03\u5931\u8d25");
        }
        ObCenterDataAcustTaskBatch batchInfo = this.obCenterDataAcustTaskBatchMapper.selectByTaskId(callBackRecord.getTaskId());
        if (batchInfo == null) {
            return BaseRspUtils.createErrorRsp((String)"\u4efb\u52a1\u4e0e\u5168\u5ba2\u6279\u6b21\u65e0\u6cd5\u5339\u914d");
        }
        ObCenterDataAcust obCenterDataAcust = this.obCenterDataAcustMapper.selectById(callBackRecord.getDataId());
        if (obCenterDataAcust == null) {
            return BaseRspUtils.createErrorRsp((String)"\u65e0\u6cd5\u67e5\u5230\u6570\u636e");
        }
        Map<String, String> attributes = this.getAttribute(obCenterDataAcust.getDataJson());
        JSONObject returnObj = new JSONObject();
        JSONObject requParam = new JSONObject();
        HashMap<String, Object> map_return = new HashMap<String, Object>();
        try {
            JSONObject req;
            JSONObject paramObj = new JSONObject();
            paramObj.put("SYSTEM", (Object)obCenterDataAcust.getSystemCode());
            paramObj.put("CHANNEL_CODE", (Object)obCenterDataAcust.getChannelCode());
            paramObj.put("CALL_LOG_ONLY", (Object)callBackRecord.getRecordId());
            paramObj.put("BATCH_ID", (Object)(attributes.get("BATCH_ID") == null ? "" : attributes.get("BATCH_ID")));
            paramObj.put("JOB_ID", (Object)(attributes.get("JOB_ID") == null ? "" : attributes.get("JOB_ID")));
            paramObj.put("TRADE_ID", (Object)AcustUtil.getTradeId());
            paramObj.put("EPARCHY_CODE", (Object)(attributes.get("EPARCHY_CODE") == null ? "" : attributes.get("EPARCHY_CODE")));
            paramObj.put("DISPLAYNUM", (Object)callBackRecord.getRealCaller());
            paramObj.put("SERIAL_NUMBER", (Object)callBackRecord.getMobileNo());
            paramObj.put("CALL_STAFF_ID", (Object)callBackRecord.getUserCode());
            paramObj.put("CALL_STAFF_NAME", (Object)callBackRecord.getUserCode());
            paramObj.put("CALL_TEAM_ID", (Object)callBackRecord.getTenantId());
            paramObj.put("CALL_BEGIN_TIME", (Object)callBackRecord.getRingTime());
            paramObj.put("CALL_CONN_TIME", (Object)callBackRecord.getAnswerTime());
            paramObj.put("CALL_HOLD_TIME", (Object)callBackRecord.getContactLengthSecond());
            paramObj.put("CALL_CLEAR_TIME", (Object)callBackRecord.getEndTime());
            if ("1".equals(callBackRecord.getIsConn())) {
                paramObj.put("CALL_RESULT", (Object)"0");
                paramObj.put("ASR_RESULT", (Object)"190000");
            } else {
                paramObj.put("CALL_RESULT", (Object)"1");
                paramObj.put("ASR_RESULT", (Object)"190020");
            }
            String recordFile = callBackRecord.getRecordFile();
            if (StringUtils.isNullOrEmpty((String)recordFile)) {
                paramObj.put("FILE_NAME", (Object)recordFile.substring(recordFile.lastIndexOf("/") + 1));
                paramObj.put("FILE_PATH", (Object)recordFile.substring(0, recordFile.lastIndexOf("/") + 1));
            } else {
                paramObj.put("FILE_NAME", (Object)"");
                paramObj.put("FILE_PATH", (Object)"");
            }
            paramObj.put("PLAY_IVR", (Object)"");
            paramObj.put("CALL_ORDER_CONFIRM", (Object)"2");
            paramObj.put("CALL_CHECK_TIME", (Object)"");
            paramObj.put("PROVINCE_CODE", (Object)"89");
            paramObj.put("TOUCH_RESULT", (Object)"");
            OkHttpUtil okHttpUtil = new OkHttpUtil();
            requParam = this.putParam(paramObj);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("url", this.holder.getUrl().getCallUrl());
            paramMap.put("request", requParam.toString());
            String responseStr = okHttpUtil.getResponse(paramMap);
            returnObj = JSONObject.parseObject((String)responseStr);
            log.info("callRecordResultInfoPush\u56de\u53c2\u6253\u5370\uff1a" + returnObj);
            JSONObject body = (JSONObject)returnObj.get((Object)"UNI_BSS_BODY");
            if (body.size() != 0 && (req = (JSONObject)body.get((Object)"CALL_LOG_REAL_TIME_SYN_RSP")).size() != 0) {
                map_return.put("RESP_CODE", req.get((Object)"RESP_CODE"));
                map_return.put("RESP_DESC", req.get((Object)"RESP_DESC"));
            }
            JSONObject jsonObject1 = new JSONObject(map_return);
            ObCenterDataAcustLog logSave = new ObCenterDataAcustLog();
            logSave.setParamsObject(paramObj.toString());
            logSave.setResultObject(returnObj.toString());
            logSave.setLogId(UUID.randomUUID().toString().replace("-", ""));
            logSave.setUserCode("\u8425\u9500\u5e73\u53f0--\u300b\u80fd\u529b\u5e73\u53f0");
            logSave.setInterfaceType("CallResultInfoReturnService");
            logSave.setOperTime(DateUtil.getNowDate());
            this.obCenterDataAcustLogService.insert(logSave);
            this.updateAcust(obCenterDataAcust, callBackRecord);
            return BaseRspUtils.createSuccessRsp((Object)jsonObject1, (String)"");
        }
        catch (Exception e) {
            e.printStackTrace();
            String result = JSON.toJSONString((Object)callBackRecord);
            ObCenterDataAcustLog logSave = new ObCenterDataAcustLog();
            logSave.setParamsObject(result);
            logSave.setResultObject("\u56de\u5355\u62a5\u9519" + e.getMessage());
            logSave.setLogId(UUID.randomUUID().toString().replace("-", ""));
            logSave.setUserCode("\u8425\u9500\u5e73\u53f0--\u300b\u80fd\u529b\u5e73\u53f0");
            logSave.setInterfaceType("CallResultInfoReturnService");
            logSave.setOperTime(DateUtil.getNowDate());
            this.obCenterDataAcustLogService.insert(logSave);
            BaseRspUtils.createErrorRsp((String)("\u56de\u5355\u62a5\u9519" + e.getMessage()));
            return BaseRspUtils.createSuccessRsp((Object)"");
        }
    }

    public Map<String, String> getAttribute(String dataJson) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        JSONArray objects = JSONObject.parseArray((String)dataJson);
        for (int i = 0; i < objects.size(); ++i) {
            JSONObject obj = (JSONObject)objects.get(i);
            if ("\u6279\u6b21\u7f16\u7801".equals(obj.get((Object)"name"))) {
                attributes.put("BATCH_ID", (String)obj.get((Object)"value"));
            }
            if ("\u4efb\u52a1\u7f16\u7801".equals(obj.get((Object)"name"))) {
                attributes.put("JOB_ID", (String)obj.get((Object)"value"));
            }
            if (!"\u5730\u5e02\u7f16\u7801".equals(obj.get((Object)"name"))) continue;
            attributes.put("EPARCHY_CODE", (String)obj.get((Object)"value"));
        }
        return attributes;
    }

    public JSONObject putParam(JSONObject param) {
        String appId = this.holder.getAppId();
        String appSecret = this.holder.getAppSecret();
        JSONObject returnObj = new JSONObject();
        JSONObject header = new JSONObject();
        JSONArray reservice = new JSONArray();
        JSONObject service = new JSONObject();
        service.put("RESERVED_ID", (Object)"dopuJA0G0p2O");
        service.put("RESERVED_VALUE", (Object)"hvtvgjiG5O8qOeymces");
        reservice.add((Object)service);
        header.put("RESERVED", (Object)reservice);
        try {
            Map<String, String> map = AcustUtil.getToken(appId, appSecret);
            header.put("TRANS_ID", (Object)map.get("TRANS_ID"));
            header.put("TIMESTAMP", (Object)map.get("TIMESTAMP"));
            header.put("TOKEN", (Object)map.get("token"));
            header.put("APP_ID", (Object)appId);
        }
        catch (Exception e) {
            log.error("\u62fc\u63a5\u4f20\u53c2\u62a5\u6587\u51fa\u9519:", (Throwable)e);
        }
        JSONObject body = new JSONObject();
        body.put("CALL_LOG_REAL_TIME_SYN_REQ", (Object)param);
        JSONObject attar = new JSONObject();
        attar.put("MEDIA_INFO", (Object)"");
        returnObj.put("UNI_BSS_HEAD", (Object)header);
        returnObj.put("UNI_BSS_ATTACHED", (Object)attar);
        returnObj.put("UNI_BSS_BODY", (Object)body);
        return returnObj;
    }

    public void updateAcust(ObCenterDataAcust obCenterDataAcust, ObCenterDataCallBackRecord callBackRecord) {
        obCenterDataAcust.setAnswerTime(StringUtils.isNullOrEmpty((String)callBackRecord.getAnswerTime()) ? "" : callBackRecord.getAnswerTime());
        obCenterDataAcust.setCallTime(StringUtils.isNullOrEmpty((String)callBackRecord.getRingTime()) ? "" : callBackRecord.getRingTime());
        obCenterDataAcust.setIsConn(StringUtils.isNullOrEmpty((String)callBackRecord.getIsConn()) ? "0" : callBackRecord.getIsConn());
        obCenterDataAcust.setHangUpTime(StringUtils.isNullOrEmpty((String)callBackRecord.getEndTime()) ? "" : callBackRecord.getEndTime());
        obCenterDataAcust.setHandleResult(StringUtils.isNullOrEmpty((String)callBackRecord.getCallResult()) ? "" : callBackRecord.getCallResult());
        obCenterDataAcust.setHandleUser(StringUtils.isNullOrEmpty((String)callBackRecord.getUserCode()) ? "" : callBackRecord.getUserCode());
        obCenterDataAcust.setAcoBak1("1");
        this.obCenterDataAcustMapper.updateByPrimaryKey(obCenterDataAcust);
    }
}

