/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.data.acust.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.oss.common.utils.StringUtils;
import com.tydic.nicc.data.acust.config.AcustPropertiesHolder;
import com.tydic.nicc.data.acust.entity.AcustEntity;
import com.tydic.nicc.data.acust.mapper.po.ObCenterDataAcustBatch;
import com.tydic.nicc.data.acust.mapper.po.ObCenterDataAcustLog;
import com.tydic.nicc.data.acust.mapper.po.ObCenterDataAcustTaskBatch;
import com.tydic.nicc.data.acust.service.AcustBaseService;
import com.tydic.nicc.data.acust.service.ObCenterDataAcustBatchService;
import com.tydic.nicc.data.acust.service.ObCenterDataAcustLogService;
import com.tydic.nicc.data.acust.service.ObCenterDataAcustTaskBatchService;
import com.tydic.nicc.data.acust.util.AcustUtil;
import com.tydic.nicc.data.acust.util.DateUtil;
import com.tydic.nicc.data.acust.util.OkHttpUtil;
import com.tydic.nicc.data.service.acust.AcustOrderInformationService;
import com.tydic.nicc.data.service.task.ObCenterDataTaskDataService;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.tomcat.util.security.MD5Encoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DubboService
public class AcustOrderInformationPushServiceImpl
implements AcustBaseService,
AcustOrderInformationService {
    private static final Logger log = LoggerFactory.getLogger(AcustOrderInformationPushServiceImpl.class);
    @Resource
    private AcustPropertiesHolder holder;
    @Resource
    private ObCenterDataAcustBatchService obCenterDataAcustBatchService;
    @Resource
    private ObCenterDataTaskDataService obCenterDataTaskDataService;
    @Resource
    private ObCenterDataAcustTaskBatchService obCenterDataAcustTaskBatchService;
    @Resource
    private ObCenterDataAcustLogService obCenterDataAcustLogService;

    @Override
    public void excuete(AcustEntity acustEntity) {
        Rsp rsp = this.orderInfoPush(acustEntity.getRequestMap());
        acustEntity.setRsp(rsp);
    }

    @Override
    public void excuete() {
    }

    public Rsp orderInfoPush(Map<String, Object> param) {
        HashMap<String, Object> map_return = new HashMap<String, Object>();
        JSONObject requParam = new JSONObject();
        JSONObject returnObj = new JSONObject();
        if (param.size() == 0) {
            log.info("\u53c2\u6570\u5f02\u5e38\uff0c\u53c2\u6570\u4e3a\u7a7a!");
            map_return.put("RESP_CODE", "9999");
            map_return.put("RESP_DESC", "\u53c2\u6570\u5f02\u5e38\uff0c\u53c2\u6570\u4e3a\u7a7a!");
            return BaseRspUtils.createErrorRsp((String)((Object)map_return).toString());
        }
        try {
            JSONObject req;
            ObCenterDataAcustTaskBatch obCenterDataAcustTaskBatch;
            String tradeId = AcustUtil.getTradeId();
            String taskId = param.get("taskId").toString();
            String dataId = param.get("dataId").toString();
            String productId = String.valueOf(param.get("productId"));
            String callLogOnly = String.valueOf(param.get("recordId"));
            String jobId = dataId;
            String callStaffId = String.valueOf(param.get("userCode"));
            String userId = String.valueOf(param.get("userId"));
            String tenantId = String.valueOf(param.get("tenantId"));
            String tenantOtherName = this.obCenterDataTaskDataService.selectTenantOtherNameByTenantId(tenantId);
            String mobileNo = String.valueOf(param.get("mobileNo"));
            if (StringUtils.isNullOrEmpty((String)mobileNo)) {
                mobileNo = this.obCenterDataTaskDataService.selectByTenantOtherNameAndDataId(tenantOtherName, dataId).getMobileNo();
            }
            if ((obCenterDataAcustTaskBatch = this.obCenterDataAcustTaskBatchService.selectByTaskId(taskId)) == null) {
                log.error("\u6ca1\u6709\u4ea7\u54c1\u548c\u6ce2\u6b21\u4fe1\u606f\u4e0d\u80fd\u8ba2\u8d2d\uff01");
                map_return.put("RESP_CODE", "9999");
                map_return.put("RESP_DESC", "\u6ca1\u6709\u4ea7\u54c1\u548c\u6ce2\u6b21\u4fe1\u606f\u4e0d\u80fd\u8ba2\u8d2d\uff01");
                return BaseRspUtils.createErrorRsp((String)((Object)map_return).toString());
            }
            String batchId = String.valueOf(obCenterDataAcustTaskBatch.getBatchId());
            if (StringUtils.isNullOrEmpty((String)productId)) {
                productId = String.valueOf(obCenterDataAcustTaskBatch.getProductId());
            }
            ObCenterDataAcustBatch obCenterDataAcustBatch = this.obCenterDataAcustBatchService.selectByBatchId(batchId);
            JSONObject paramObj = new JSONObject();
            paramObj.put("TRADE_ID", (Object)tradeId);
            paramObj.put("SYSTEM", (Object)obCenterDataAcustBatch.getFileName().split("_")[1]);
            paramObj.put("CHANNEL_CODE", (Object)obCenterDataAcustBatch.getChannelCode());
            paramObj.put("CALL_LOG_ONLY", (Object)callLogOnly);
            paramObj.put("BATCH_ID", (Object)batchId);
            paramObj.put("JOB_ID", (Object)jobId);
            paramObj.put("PRODUCTID", (Object)productId);
            paramObj.put("SERIAL_NUMBER", (Object)mobileNo);
            paramObj.put("CALL_STAFF_ID", (Object)callStaffId);
            paramObj.put("CALL_TEAM_ID", (Object)tenantId);
            OkHttpUtil okHttpUtil = new OkHttpUtil();
            requParam = this.putParam(paramObj);
            log.info("orderInfoPush\u8bf7\u6c42\u62a5\u6587\uff1a" + requParam.toString());
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("url", this.holder.getUrl().getOrderUrl());
            paramMap.put("request", requParam.toString());
            String responseStr = okHttpUtil.getResponse(paramMap);
            returnObj = JSONObject.parseObject((String)responseStr);
            log.info("orderInfoPush\u56de\u53c2\u6253\u5370\uff1a" + returnObj);
            JSONObject body = (JSONObject)returnObj.get((Object)"UNI_BSS_BODY");
            if (body.size() != 0 && (req = (JSONObject)body.get((Object)"CALL_CHECK_RSP")).size() != 0) {
                map_return.put("RESP_CODE", req.get((Object)"RESP_CODE"));
                map_return.put("RESP_DESC", req.get((Object)"RESP_DESC"));
            }
            ObCenterDataAcustLog logSave = new ObCenterDataAcustLog();
            logSave.setParamsObject(requParam.toString());
            logSave.setResultObject(returnObj.toString());
            logSave.setLogId(UUID.randomUUID().toString().replace("-", ""));
            logSave.setUserCode("\u8425\u9500\u5e73\u53f0--\u300b\u80fd\u529b\u5e73\u53f0");
            logSave.setInterfaceType("OrderInformationPushService");
            logSave.setOperTime(DateUtil.getNowDate());
            this.obCenterDataAcustLogService.insert(logSave);
            return BaseRspUtils.createSuccessRsp(map_return);
        }
        catch (Exception e) {
            ObCenterDataAcustLog logSave = new ObCenterDataAcustLog();
            logSave.setParamsObject(JSONObject.toJSONString(param));
            logSave.setResultObject("\u5f02\u5e38" + e.getMessage());
            logSave.setLogId(MD5Encoder.encode((byte[])UUID.randomUUID().toString().getBytes()));
            logSave.setUserCode("\u8425\u9500\u5e73\u53f0--\u300b\u80fd\u529b\u5e73\u53f0");
            logSave.setInterfaceType("OrderInformationPushService");
            this.obCenterDataAcustLogService.insert(logSave);
            return BaseRspUtils.createSuccessRsp((Object)"");
        }
    }

    public JSONObject putParam(JSONObject param) {
        String appId = this.holder.getAppId();
        String appSecret = this.holder.getAppSecret();
        JSONObject returnObj = new JSONObject();
        JSONObject header = new JSONObject();
        JSONArray reservice = new JSONArray();
        JSONObject service = new JSONObject();
        service.put("RESERVED_ID", (Object)"dopuJA0G0p2O");
        service.put("RESERVED_VALUE", (Object)"hvtvgjiG5O8qOeymces");
        reservice.add((Object)service);
        header.put("RESERVED", (Object)reservice);
        try {
            Map<String, String> map = AcustUtil.getToken(appId, appSecret);
            header.put("TRANS_ID", (Object)map.get("TRANS_ID"));
            header.put("TIMESTAMP", (Object)map.get("TIMESTAMP"));
            header.put("TOKEN", (Object)map.get("token"));
            header.put("APP_ID", (Object)appId);
        }
        catch (Exception e) {
            log.error("\u62fc\u63a5\u4f20\u53c2\u62a5\u6587\u51fa\u9519:", (Throwable)e);
        }
        JSONObject body = new JSONObject();
        body.put("CALL_CHECK_REQ", (Object)param);
        JSONObject attar = new JSONObject();
        attar.put("MEDIA_INFO", (Object)"");
        returnObj.put("UNI_BSS_HEAD", (Object)header);
        returnObj.put("UNI_BSS_ATTACHED", (Object)attar);
        returnObj.put("UNI_BSS_BODY", (Object)body);
        return returnObj;
    }
}

