/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.data.acust.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.data.acust.config.AcustPropertiesHolder;
import com.tydic.nicc.data.acust.entity.AcustEntity;
import com.tydic.nicc.data.acust.mapper.po.ObCenterDataAcust;
import com.tydic.nicc.data.acust.mapper.po.ObCenterDataAcustBatch;
import com.tydic.nicc.data.acust.mapper.po.ObCenterDataAcustCloseMobile;
import com.tydic.nicc.data.acust.service.AcustBaseService;
import com.tydic.nicc.data.acust.service.ObCenterDataAcustBatchService;
import com.tydic.nicc.data.acust.service.ObCenterDataAcustCloseMobileService;
import com.tydic.nicc.data.acust.service.ObCenterDataAcustService;
import com.tydic.nicc.data.acust.util.AcustUtil;
import com.tydic.nicc.data.acust.util.OkHttpUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AcustProductCommonCloseServiceImpl
implements AcustBaseService {
    private static final Logger log = LoggerFactory.getLogger(AcustProductCommonCloseServiceImpl.class);
    @Resource
    AcustPropertiesHolder holder;
    @Resource
    ObCenterDataAcustBatchService obCenterDataAcustBatchService;
    @Resource
    ObCenterDataAcustService obCenterDataAcustService;
    @Resource
    ObCenterDataAcustCloseMobileService obCenterDataAcustCloseMobileService;

    @Override
    public void excuete(AcustEntity acustEntity) {
    }

    @Override
    public void excuete() {
        this.delDataDataTaskByAcust();
    }

    public void delDataDataTaskByAcust() {
        this.obCenterDataAcustCloseMobileService.truncateTable();
        ArrayList<ObCenterDataAcustCloseMobile> obCenterDataAcustCloseMobileList = new ArrayList<ObCenterDataAcustCloseMobile>();
        try {
            List<String> taskIds = this.obCenterDataAcustService.selectAllTaskId();
            for (String taskId : taskIds) {
                List<ObCenterDataAcust> obCenterDataAcustList = this.obCenterDataAcustService.selectListByTaskId(taskId);
                ObCenterDataAcustBatch obCenterDataAcustBatch = this.obCenterDataAcustBatchService.selectByTaskId(taskId);
                for (ObCenterDataAcust ocda : obCenterDataAcustList) {
                    List response;
                    String mobileNo = ocda.getMobileNo();
                    String channelCode = obCenterDataAcustBatch.getChannelCode();
                    String STRATEGY_ID = obCenterDataAcustBatch.getMaitainId();
                    HashMap<String, Object> paramReq = new HashMap<String, Object>();
                    paramReq.put("channelCode", channelCode);
                    paramReq.put("mobileNo", mobileNo);
                    Map<String, Object> mapReturn = this.productRecommend(paramReq);
                    int isContainsStrategy = 0;
                    if ("0000".equals(mapReturn.get("RESP_CODE")) && (response = (List)mapReturn.get("COMM_INFO")) != null && response.size() > 0) {
                        for (Map map : response) {
                            if (!map.containsValue(STRATEGY_ID)) continue;
                            ++isContainsStrategy;
                        }
                    }
                    if (isContainsStrategy >= true) continue;
                    ObCenterDataAcustCloseMobile ocdac = new ObCenterDataAcustCloseMobile();
                    ocdac.setBatchId(obCenterDataAcustBatch.getBatchId());
                    ocdac.setCloseId(UUID.randomUUID().toString().replace("-", ""));
                    ocdac.setDataId(ocda.getDataId());
                    ocdac.setMobileNo(ocda.getMobileNo());
                    ocdac.setTaskId(ocda.getTaskId());
                    obCenterDataAcustCloseMobileList.add(ocdac);
                    ocda.setAcoBak1("1");
                    this.obCenterDataAcustService.updateByPrimaryKey(ocda);
                }
            }
            if (obCenterDataAcustCloseMobileList.size() > 0) {
                this.obCenterDataAcustCloseMobileService.batchInsert(obCenterDataAcustCloseMobileList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Map<String, Object> productRecommend(Map<String, Object> param) throws Exception {
        Map<Object, Object> mapReturn = new HashMap();
        JSONObject requParam = new JSONObject();
        JSONObject returnObj = new JSONObject();
        String tradeId = AcustUtil.getTradeId();
        JSONObject paramObj = new JSONObject();
        paramObj.put("TRADE_ID", (Object)tradeId);
        String channelCodes = (String)param.get("channelCode");
        paramObj.put("CHANNEL_CODE", (Object)channelCodes);
        String mobileNo = (String)param.get("mobileNo");
        paramObj.put("SERIAL_NUMBER", (Object)mobileNo);
        paramObj.put("QUERY_TYPE", (Object)"1");
        HashMap<String, String> mapP = new HashMap<String, String>();
        mapP.put("PARA_ID", "");
        mapP.put("PARA_VALUE", "");
        ArrayList<HashMap<String, String>> paras = new ArrayList<HashMap<String, String>>();
        paras.add(mapP);
        paramObj.put("PARA", paras);
        OkHttpUtil okHttpUtil = new OkHttpUtil();
        requParam = this.putParam(paramObj);
        log.info("delDataDataTaskByUop\u8bf7\u6c42\u62a5\u6587\uff1a" + requParam.toString());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("url", this.holder.getUrl().getProductRecommendUrl());
        paramMap.put("request", requParam.toString());
        String responseStr = okHttpUtil.getResponse(paramMap);
        returnObj = JSONObject.parseObject((String)responseStr);
        log.info("delDataDataTaskByUop\u56de\u53c2\u6253\u5370\uff1a" + returnObj);
        mapReturn = this.getResultMap(returnObj);
        mapReturn.put("returnObj", returnObj);
        return mapReturn;
    }

    public JSONObject putParam(JSONObject param) {
        String appId = this.holder.getAppId();
        String appSecret = this.holder.getAppSecret();
        JSONObject returnObj = new JSONObject();
        JSONObject header = new JSONObject();
        JSONArray reservice = new JSONArray();
        JSONObject service = new JSONObject();
        service.put("RESERVED_ID", (Object)"dopuJA0G0p2O");
        service.put("RESERVED_VALUE", (Object)"hvtvgjiG5O8qOeymces");
        reservice.add((Object)service);
        header.put("RESERVED", (Object)reservice);
        try {
            Map<String, String> map = AcustUtil.getToken(appId, appSecret);
            header.put("TRANS_ID", (Object)map.get("TRANS_ID"));
            header.put("TIMESTAMP", (Object)map.get("TIMESTAMP"));
            header.put("TOKEN", (Object)map.get("token"));
            header.put("APP_ID", (Object)appId);
        }
        catch (Exception e) {
            log.error("\u62fc\u63a5\u4f20\u53c2\u62a5\u6587\u51fa\u9519:", (Throwable)e);
        }
        JSONObject body = new JSONObject();
        body.put("PRODUCT_RECOMMEND_REQ", (Object)param);
        JSONObject attar = new JSONObject();
        attar.put("MEDIA_INFO", (Object)"");
        returnObj.put("UNI_BSS_HEAD", (Object)header);
        returnObj.put("UNI_BSS_ATTACHED", (Object)attar);
        returnObj.put("UNI_BSS_BODY", (Object)body);
        return returnObj;
    }

    public Map<String, Object> getResultMap(JSONObject returnObj) {
        HashMap<String, Object> map_return = new HashMap<String, Object>();
        try {
            JSONObject head = (JSONObject)returnObj.get((Object)"UNI_BSS_HEAD");
            String code = String.valueOf(head.get((Object)"RESP_CODE"));
            if (!code.equals("00000")) {
                log.info("\u4ea7\u54c1\u63a8\u8350\u8c03\u7528\u4e0d\u6210\u529f\uff1a" + String.valueOf(head.get((Object)"RESP_DESC")));
                map_return.put("RESP_CODE", "9999");
                map_return.put("RESP_DESC", head.get((Object)"RESP_DESC"));
                return map_return;
            }
            JSONObject body = (JSONObject)returnObj.get((Object)"UNI_BSS_BODY");
            if (body != null) {
                JSONObject req = (JSONObject)body.get((Object)"PRODUCT_RECOMMEND_RSP");
                if (req != null) {
                    map_return.put("RESP_CODE", req.get((Object)"RESP_CODE"));
                    map_return.put("RESP_DESC", req.get((Object)"RESP_DESC"));
                    if ("0000".equals(req.get((Object)"RESP_CODE"))) {
                        map_return.put("COMM_INFO", req.getJSONObject("RESP_DATA").getJSONArray("COMM_INFO"));
                    }
                } else {
                    log.info("getResultMap\u65b9\u6cd5\uff1aPRODUCT_RECOMMEND_RSP\u89e3\u6790\u4e0d\u5b58\u5728\uff01");
                    map_return.put("RESP_CODE", "9999");
                    map_return.put("RESP_DESC", "PRODUCT_RECOMMEND_RSP\u89e3\u6790\u4e0d\u5b58\u5728");
                }
            }
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u8fd4\u56de\u62a5\u6587\u51fa\u9519:", (Throwable)e);
        }
        return map_return;
    }
}

