/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.data.acust.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.data.acust.config.AcustPropertiesHolder;
import com.tydic.nicc.data.acust.config.AcustScheduleUrl;
import com.tydic.nicc.data.acust.entity.AcustEntity;
import com.tydic.nicc.data.acust.mapper.po.ObCenterDataAcustBatch;
import com.tydic.nicc.data.acust.mapper.po.ObCenterDataAcustLog;
import com.tydic.nicc.data.acust.service.AcustBaseService;
import com.tydic.nicc.data.acust.service.ObCenterDataAcustBatchService;
import com.tydic.nicc.data.acust.service.ObCenterDataAcustLogService;
import com.tydic.nicc.data.acust.service.ObCenterDataAcustTaskBatchService;
import com.tydic.nicc.data.acust.util.AcustUtil;
import com.tydic.nicc.data.acust.util.DateUtil;
import com.tydic.nicc.data.acust.util.OkHttpUtil;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AcustProductUpDownInfoServiceImpl
implements AcustBaseService {
    private static final Logger log = LoggerFactory.getLogger(AcustProductUpDownInfoServiceImpl.class);
    @Resource
    private AcustPropertiesHolder holder;
    @Resource
    AcustScheduleUrl urlAll;
    @Resource
    private ObCenterDataAcustBatchService obCenterDataAcustBatchService;
    @Resource
    private ObCenterDataAcustTaskBatchService obCenterDataAcustTaskBatchService;
    @Resource
    private ObCenterDataAcustLogService obCenterDataAcustLogService;

    @Override
    public void excuete(AcustEntity acustEntity) {
        Rsp rsp = this.getProductUpDownInfo(acustEntity.getRequestMap());
        acustEntity.setRsp(rsp);
    }

    @Override
    public void excuete() {
    }

    public Rsp getProductUpDownInfo(Map<String, Object> param) {
        log.info("getProductUpDownInfo\u5165\u53c2\u6253\u5370\uff1a" + param);
        Map<String, Object> map_return = new HashMap<String, String>();
        JSONObject requParam = new JSONObject();
        JSONObject returnObj = new JSONObject();
        try {
            if (param.size() == 0) {
                log.info("\u53c2\u6570\u5f02\u5e38\uff0c\u53c2\u6570\u4e3a\u7a7a!");
                map_return.put("RESP_CODE", "9999");
                map_return.put("RESP_DESC", "\u53c2\u6570\u5f02\u5e38\uff0c\u53c2\u6570\u4e3a\u7a7a!");
                return BaseRspUtils.createErrorRsp((String)((Object)map_return).toString());
            }
            String tradeId = AcustUtil.getTradeId();
            String taskId = String.valueOf(param.get("taskId"));
            ObCenterDataAcustBatch obCenterDataAcustBatch = this.obCenterDataAcustBatchService.selectByTaskId(taskId);
            JSONObject paramObj = new JSONObject();
            paramObj.put("TRADE_ID", (Object)tradeId);
            paramObj.put("SYSTEM", (Object)obCenterDataAcustBatch.getFileName().split("_")[1]);
            paramObj.put("CHANNEL_CODE", (Object)obCenterDataAcustBatch.getChannelCode());
            paramObj.put("BATCH_ID", (Object)String.valueOf(obCenterDataAcustBatch.getBatchId()));
            paramObj.put("PRODUCT_ID", (Object)String.valueOf(obCenterDataAcustBatch.getCallProductid()));
            paramObj.put("POLICY_ID", (Object)String.valueOf(obCenterDataAcustBatch.getPolicyId()));
            OkHttpUtil acustOkHttpUtil = new OkHttpUtil();
            requParam = this.putParam(paramObj);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("url", this.urlAll.getProUpDownUrl());
            paramMap.put("request", requParam.toString());
            String responseStr = acustOkHttpUtil.getResponse(paramMap);
            returnObj = JSONObject.parseObject((String)responseStr);
            log.info("getProductUpDownInfo\u56de\u53c2\u6253\u5370\uff1a" + returnObj);
            map_return = this.getResultMap(returnObj, String.valueOf(obCenterDataAcustBatch.getCallProductid()));
            ObCenterDataAcustLog logSave = new ObCenterDataAcustLog();
            logSave.setParamsObject(requParam.toString());
            logSave.setResultObject(returnObj.toString());
            logSave.setLogId(UUID.randomUUID().toString().replace("-", ""));
            logSave.setUserCode("\u8425\u9500\u5e73\u53f0--\u300b\u80fd\u529b\u5e73\u53f0");
            logSave.setInterfaceType("ProductUpDownInfoService");
            logSave.setOperTime(DateUtil.getNowDate());
            this.obCenterDataAcustLogService.insert(logSave);
            return BaseRspUtils.createSuccessRsp(map_return);
        }
        catch (Exception e) {
            e.printStackTrace();
            ObCenterDataAcustLog logSave = new ObCenterDataAcustLog();
            logSave.setParamsObject(JSONObject.toJSONString(param));
            logSave.setResultObject("\u5f02\u5e38" + e.getMessage());
            logSave.setLogId(UUID.randomUUID().toString().replace("-", ""));
            logSave.setUserCode("\u8425\u9500\u5e73\u53f0--\u300b\u80fd\u529b\u5e73\u53f0");
            logSave.setInterfaceType("ProductUpDownInfoService");
            logSave.setOperTime(DateUtil.getNowDate());
            this.obCenterDataAcustLogService.insert(logSave);
            log.error("\u63a5\u53e3getProductUpDownInfo\u8c03\u7528\u5f02\u5e38", (Throwable)e);
            map_return.put("RESP_CODE", "9999");
            map_return.put("RESP_DESC", "\u4ea7\u54c1\u4e0a\u4e0b\u7ffb\u6863\u8c03\u7528\u62a5\u9519:" + e.getMessage());
            return BaseRspUtils.createErrorRsp((String)((Object)map_return).toString());
        }
    }

    public JSONObject putParam(JSONObject param) {
        String appId = this.holder.getAppId();
        String appSecret = this.holder.getAppSecret();
        JSONObject returnObj = new JSONObject();
        JSONObject header = new JSONObject();
        JSONArray reservice = new JSONArray();
        JSONObject service = new JSONObject();
        service.put("RESERVED_ID", (Object)"dopuJA0G0p2O");
        service.put("RESERVED_VALUE", (Object)"hvtvgjiG5O8qOeymces");
        reservice.add((Object)service);
        header.put("RESERVED", (Object)reservice);
        try {
            Map<String, String> map = AcustUtil.getToken(appId, appSecret);
            header.put("TRANS_ID", (Object)map.get("TRANS_ID"));
            header.put("TIMESTAMP", (Object)map.get("TIMESTAMP"));
            header.put("TOKEN", (Object)map.get("token"));
            header.put("APP_ID", (Object)appId);
        }
        catch (Exception e) {
            log.error("\u62fc\u63a5\u4f20\u53c2\u62a5\u6587\u51fa\u9519:", (Throwable)e);
        }
        JSONObject body = new JSONObject();
        body.put("CALL_TASK_PRODUCT_UP_DOWN_REQ", (Object)param);
        JSONObject attar = new JSONObject();
        attar.put("MEDIA_INFO", (Object)"");
        returnObj.put("UNI_BSS_HEAD", (Object)header);
        returnObj.put("UNI_BSS_ATTACHED", (Object)attar);
        returnObj.put("UNI_BSS_BODY", (Object)body);
        return returnObj;
    }

    public Map<String, Object> getResultMap(JSONObject returnObj, String productId) {
        HashMap<String, Object> map_return = new HashMap<String, Object>();
        try {
            JSONObject head = (JSONObject)returnObj.get((Object)"UNI_BSS_HEAD");
            String code = String.valueOf(head.get((Object)"RESP_CODE"));
            if (!code.equals("00000")) {
                log.info("\u4ea7\u54c1\u4e0a\u4e0b\u7ffb\u6863\u63a5\u53e3\u8c03\u7528\u4e0d\u6210\u529f\uff1a" + String.valueOf(head.get((Object)"RESP_DESC")));
                map_return.put("RESP_CODE", "9999");
                map_return.put("RESP_DESC", head.get((Object)"RESP_DESC"));
                return map_return;
            }
            JSONObject body = (JSONObject)returnObj.get((Object)"UNI_BSS_BODY");
            if (body != null) {
                JSONObject req = (JSONObject)body.get((Object)"CALL_TASK_PRODUCT_UP_DOWN_RSP");
                if (req != null) {
                    map_return.put("RESP_CODE", req.get((Object)"RESP_CODE"));
                    map_return.put("RESP_DESC", req.get((Object)"RESP_DESC"));
                    map_return.put("PRODUCT_LIST", req.getJSONArray("PRODUCT_LIST"));
                    map_return.put("productId", productId);
                } else {
                    log.info("getResultMap\u65b9\u6cd5\uff1aCALL_TASK_PRODUCT_UP_DOWN_RSP\u89e3\u6790\u4e0d\u5b58\u5728\uff01");
                    map_return.put("RESP_CODE", "9999");
                    map_return.put("RESP_DESC", "CALL_TASK_PRODUCT_UP_DOWN_RSP\u89e3\u6790\u4e0d\u5b58\u5728");
                }
            }
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u8fd4\u56de\u62a5\u6587\u51fa\u9519:", (Throwable)e);
        }
        return map_return;
    }
}

