/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.data.acust.service.impl;

import com.aliyun.oss.common.utils.StringUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tydic.nicc.data.acust.config.AcustPropertiesHolder;
import com.tydic.nicc.data.acust.entity.AcustEntity;
import com.tydic.nicc.data.acust.mapper.po.ObCenterDataAcust;
import com.tydic.nicc.data.acust.mapper.po.ObCenterDataAcustBatch;
import com.tydic.nicc.data.acust.mapper.po.ObCenterDataAcustFileData;
import com.tydic.nicc.data.acust.mapper.po.ObCenterDataAcustTaskBatch;
import com.tydic.nicc.data.acust.service.AcustBaseService;
import com.tydic.nicc.data.acust.service.ObCenterDataAcustBatchService;
import com.tydic.nicc.data.acust.service.ObCenterDataAcustFileDataService;
import com.tydic.nicc.data.acust.service.ObCenterDataAcustService;
import com.tydic.nicc.data.acust.service.ObCenterDataAcustTaskBatchService;
import com.tydic.nicc.data.acust.util.AcustUtil;
import com.tydic.nicc.data.acust.util.DateUtil;
import com.tydic.nicc.data.acust.util.Sftp;
import com.tydic.nicc.data.acust.util.SftpUtil;
import com.tydic.nicc.data.mapper.po.ObCenterDataTaskData;
import com.tydic.nicc.data.mapper.po.ObCenterDataTaskInfo;
import com.tydic.nicc.data.service.task.ObCenterDataTaskDataService;
import com.tydic.nicc.data.service.task.ObCenterDataTaskInfoService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AcustTaskFileDealServiceImpl
implements AcustBaseService {
    private static final Logger log = LoggerFactory.getLogger(AcustTaskFileDealServiceImpl.class);
    @Resource
    AcustPropertiesHolder holder;
    @Resource
    ObCenterDataAcustFileDataService obCenterDataAcustFileDataService;
    @Resource
    ObCenterDataAcustBatchService obCenterDataAcustBatchService;
    @Resource
    ObCenterDataTaskInfoService obCenterDataTaskInfoService;
    @Resource
    ObCenterDataTaskDataService obCenterDataTaskDataService;
    @Resource
    ObCenterDataAcustService obCenterDataAcustService;
    @Resource
    ObCenterDataAcustTaskBatchService obCenterDataAcustTaskBatchService;
    private static final String splitReg = "\\|";

    @Override
    public void excuete(AcustEntity uopEntity) {
    }

    @Override
    public void excuete() {
        this.deal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deal() {
        log.info("\u8f6e\u8be2\u5904\u7406\u6279\u6b21\u4efb\u52a1\u6570\u636e");
        List<ObCenterDataAcustBatch> batchList = this.obCenterDataAcustBatchService.selectListWithFinishStatus();
        if (batchList == null || batchList.size() == 0) {
            log.info("\u6ca1\u6709\u67e5\u8be2\u5230\u672a\u5904\u7406\u72b6\u6001\u7684\u63a5\u53e3\u6279\u6b21\u4fe1\u606f\uff01");
            return;
        }
        ObCenterDataAcustBatch ocdb = batchList.get(0);
        ocdb.setUpdateTime(DateUtil.getNowDate());
        ocdb.setFinishsStatus("1");
        this.obCenterDataAcustBatchService.updateByPrimaryKey(ocdb);
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("policyName", ocdb.getPolicyName());
            map.put("maitainName", ocdb.getMaitainName());
            if ("1".equals(ocdb.getCallsmsRingoff())) {
                map.put("callsmsRingoff", "1");
            } else if ("0".equals(ocdb.getCallsmsRingoff())) {
                map.put("callsmsRingoff", "0");
            } else {
                map.put("callsmsRingoff", "0");
            }
            map.put("callsmsRingoffContent", ocdb.getCallsmsRingoffContent());
            map.put("callProductIdName", ocdb.getCallProductidName());
            map.put("templateContent", ocdb.getSpeechTemplate());
            if ("".equals(ocdb.getServerIp())) {
                ocdb.setServerIp(this.holder.getSftp().getHost());
            }
            if ("".equals(ocdb.getServerPassword())) {
                ocdb.setServerPassword(this.holder.getSftp().getPassword());
            }
            if ("".equals(ocdb.getServerPort())) {
                ocdb.setServerPort(this.holder.getSftp().getPort() + "");
            }
            if ("".equals(ocdb.getServerUsername())) {
                ocdb.setServerUsername(this.holder.getSftp().getUsername());
            }
            boolean isContinue = false;
            Sftp sftp = null;
            try {
                sftp = this.connectSFTP(ocdb.getServerIp(), ocdb.getServerUsername(), ocdb.getServerPassword(), Integer.parseInt(ocdb.getServerPort()));
                if (sftp.downloadFile(ocdb.getFilePath(), ocdb.getFileName(), this.holder.getLocalPath())) {
                    this.parseFile(new File(this.holder.getLocalPath() + ocdb.getFileName()), map);
                    isContinue = true;
                } else {
                    log.info("\u672a\u80fd\u4e0b\u8f7d\u5230\u6307\u5b9a\u7684\u6587\u4ef6");
                    ocdb.setUpdateTime(DateUtil.getNowDate());
                    ocdb.setFinishsStatus("3");
                    ocdb.setMsg("\u672a\u80fd\u4e0b\u8f7d\u5230\u6307\u5b9a\u7684\u6587\u4ef6");
                    this.obCenterDataAcustBatchService.updateByPrimaryKey(ocdb);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                ocdb.setUpdateTime(DateUtil.getNowDate());
                ocdb.setFinishsStatus("3");
                ocdb.setMsg("\u6587\u4ef6\u4e0b\u8f7d\u9519\u8bef" + e.getMessage());
                this.obCenterDataAcustBatchService.updateByPrimaryKey(ocdb);
                this.obCenterDataAcustFileDataService.clearAllData();
            }
            finally {
                if (sftp != null) {
                    sftp.logout();
                }
            }
            if (!isContinue) {
                log.info("\u8fde\u63a5sftp\u5f02\u5e38\u6216sftp\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38\u6216\u63d2\u5165\u6570\u636e\u5230\u4e2d\u95f4\u8868\u5f02\u5e38!");
                return;
            }
            List<String> tenantIdList = this.obCenterDataAcustFileDataService.selectTenantOfFileData();
            if (tenantIdList == null || tenantIdList.size() == 0) {
                ocdb.setUpdateTime(DateUtil.getNowDate());
                ocdb.setFinishsStatus("3");
                ocdb.setMsg("\u65e0\u4efb\u4f55\u5339\u914d\u79df\u6237\uff0c\u65e0\u6cd5\u63d2\u5165\u4efb\u52a1\u548c\u6570\u636e!");
                this.obCenterDataAcustBatchService.updateByPrimaryKey(ocdb);
                return;
            }
            this.createTaskAndTaskDataAndCustomer(tenantIdList, ocdb);
            ocdb.setUpdateTime(DateUtil.getNowDate());
            ocdb.setFinishsStatus("2");
            ocdb.setMsg("\u6267\u884c\u6210\u529f");
            this.obCenterDataAcustBatchService.updateByPrimaryKey(ocdb);
            this.obCenterDataAcustFileDataService.clearAllData();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u63a5\u53e3handle\u8c03\u7528\u5f02\u5e38", (Throwable)e);
            this.obCenterDataAcustFileDataService.clearAllData();
            ocdb.setUpdateTime(DateUtil.getNowDate());
            ocdb.setFinishsStatus("3");
            ocdb.setMsg("\u6587\u4ef6\u4e0b\u8f7d\u9519\u8bef" + e.getMessage());
            this.obCenterDataAcustBatchService.updateByPrimaryKey(ocdb);
        }
    }

    private void parseFile(File file, Map<String, String> map) throws IOException {
        String line;
        String filePath = file.getPath();
        log.info("\u5f00\u59cb\u8bfb\u53d6\u89e3\u6790ftp\u6587\u4ef6: " + filePath);
        FileInputStream fis = null;
        ArrayList<String[]> dataList = new ArrayList<String[]>();
        fis = new FileInputStream(filePath);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, "utf-8");
        BufferedReader br = new BufferedReader(isr);
        String[] columnNames = null;
        String header = br.readLine();
        if (header != null) {
            columnNames = header.split(splitReg);
        }
        while ((line = br.readLine()) != null) {
            if (!StringUtils.isNullOrEmpty((String)line)) {
                String[] arrStr = line.split(splitReg);
                dataList.add(arrStr);
            }
            if (dataList.size() < 3000) continue;
            this.insertDataList(dataList, map, columnNames);
            dataList.clear();
        }
        if (dataList.size() > 0) {
            this.insertDataList(dataList, map, columnNames);
            dataList.clear();
        }
        isr.close();
        fis.close();
    }

    public void createTaskAndTaskDataAndCustomer(List<String> tenantList, ObCenterDataAcustBatch ocdb) {
        try {
            if ("2".equals(ocdb.getCallsmsAgo()) && "0".equals(ocdb.getCallsmsAgoContent())) {
                this.obCenterDataAcustService.deleteByStrategyId(ocdb.getMaitainId());
            }
            ArrayList<ObCenterDataAcustTaskBatch> taskBatchList = new ArrayList<ObCenterDataAcustTaskBatch>();
            for (String tenantId : tenantList) {
                taskBatchList.addAll(this.createTaskAndBindDataAndCustomer(tenantId, ocdb));
            }
            try {
                this.obCenterDataAcustTaskBatchService.batchInsert(taskBatchList);
            }
            catch (Exception e) {
                log.error("\u6279\u91cf\u63d2\u5165\u51fa\u9519\uff01", (Throwable)e);
            }
        }
        catch (Exception e) {
            ocdb.setUpdateTime(DateUtil.getNowDate());
            ocdb.setFinishsStatus("3");
            ocdb.setMsg("\u521b\u5efa\u4efb\u52a1\uff0c\u5e76\u521b\u5efa\u7ed1\u5b9a\u6570\u636e\u548c\u521b\u5efa\u5ba2\u6237\u753b\u50cf\u5f02\u5e38!" + e.getMessage());
            this.obCenterDataAcustBatchService.updateByPrimaryKey(ocdb);
        }
    }

    public List<ObCenterDataAcustTaskBatch> createTaskAndBindDataAndCustomer(String tenantId, ObCenterDataAcustBatch ocdb) {
        Map<String, String> map;
        String taskId;
        List<ObCenterDataAcustFileData> dataList = this.obCenterDataAcustFileDataService.selectAllDataByTenantId(tenantId);
        ArrayList<ObCenterDataAcustFileData> wyList = new ArrayList<ObCenterDataAcustFileData>();
        ArrayList<ObCenterDataAcustFileData> haList = new ArrayList<ObCenterDataAcustFileData>();
        ArrayList<ObCenterDataAcustFileData> otherList = new ArrayList<ObCenterDataAcustFileData>();
        ArrayList<ObCenterDataAcustTaskBatch> taskBatchList = new ArrayList<ObCenterDataAcustTaskBatch>();
        for (ObCenterDataAcustFileData dafd : dataList) {
            if ("14".equals(dafd.getLanguage())) {
                wyList.add(dafd);
                continue;
            }
            if ("27".equals(dafd.getLanguage())) {
                haList.add(dafd);
                continue;
            }
            otherList.add(dafd);
        }
        if (haList.size() > 0 && !StringUtils.isNullOrEmpty((String)(taskId = (map = this.createTask(tenantId, ocdb, "HA")).get("taskId")))) {
            this.createTaskData(haList, ocdb, tenantId, taskId);
            if ("1".equals(map.get("newTask"))) {
                taskBatchList.add(this.taskBatch(ocdb, taskId, tenantId, "HA"));
            }
        }
        if (wyList.size() > 0 && !StringUtils.isNullOrEmpty((String)(taskId = (map = this.createTask(tenantId, ocdb, "W")).get("taskId")))) {
            this.createTaskData(wyList, ocdb, tenantId, taskId);
            if ("1".equals(map.get("newTask"))) {
                taskBatchList.add(this.taskBatch(ocdb, taskId, tenantId, "W"));
            }
        }
        if (otherList.size() > 0 && !StringUtils.isNullOrEmpty((String)(taskId = (map = this.createTask(tenantId, ocdb, "H")).get("taskId")))) {
            this.createTaskData(otherList, ocdb, tenantId, taskId);
            if ("1".equals(map.get("newTask"))) {
                taskBatchList.add(this.taskBatch(ocdb, taskId, tenantId, "H"));
            }
        }
        return taskBatchList;
    }

    public Map<String, String> createTask(String tenantId, ObCenterDataAcustBatch ocdb, String language) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        String taskId = this.obCenterDataAcustTaskBatchService.selectTaskIdByMaitainIdAndTenantIdAndLanguage(ocdb.getMaitainId(), tenantId, language);
        String tenantOtherName = this.obCenterDataTaskDataService.selectTenantOtherNameByTenantId(tenantId);
        if (!StringUtils.isNullOrEmpty((String)taskId)) {
            log.info("\u8001\u4efb\u52a1 taskId={}\uff0c\u79df\u6237={}", (Object)taskId, (Object)tenantOtherName);
            returnMap.put("newTask", "0");
            returnMap.put("taskId", taskId);
            return returnMap;
        }
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMdd");
        String newTaskId = "Acu" + UUID.randomUUID().toString().replaceAll("-", "");
        ObCenterDataTaskInfo obTaskInfo = new ObCenterDataTaskInfo();
        String areaName = "";
        if (!StringUtils.isNullOrEmpty((String)ocdb.getEparchyCode())) {
            String area = ocdb.getEparchyCode();
            areaName = "all".equals(area) ? "\u7701\u4e2d\u5fc3" : AcustUtil.areaMap().get(area);
        }
        if (StringUtils.isNullOrEmpty((String)tenantOtherName)) {
            log.info("\u65e0\u6cd5\u6839\u636etenantId\u627e\u5230\u79df\u6237\u522b\u540d");
            return null;
        }
        String taskName = "XJAC" + sf.format(new Date()) + areaName + "-" + ocdb.getMaitainName() + "-" + language + tenantOtherName;
        obTaskInfo.setTaskId(newTaskId);
        obTaskInfo.setTaskStatus("0");
        obTaskInfo.setTaskName(taskName);
        if (ocdb.getMaitainName().contains("\u62a2\u5355")) {
            obTaskInfo.setTaskType("1");
        } else {
            obTaskInfo.setTaskType("0");
        }
        obTaskInfo.setStartTime(ocdb.getTaskStatTime());
        obTaskInfo.setEndTime(ocdb.getTaskEndTime());
        obTaskInfo.setHandleResults("");
        obTaskInfo.setIsUse("0");
        obTaskInfo.setTenantId(tenantId);
        obTaskInfo.setTaskSource("acust");
        obTaskInfo.setSourceFileName(ocdb.getFileName());
        obTaskInfo.setCallType("0");
        obTaskInfo.setCreateTime(DateUtil.getNowDate());
        obTaskInfo.setTaskBak1(ocdb.getCallProductid() + "|" + ocdb.getCallProductidName());
        obTaskInfo.setTaskBak2(tenantOtherName);
        obTaskInfo.setTaskBak3(ocdb.getSpeechTemplate());
        this.obCenterDataTaskInfoService.insert(obTaskInfo);
        returnMap.put("taskId", newTaskId);
        returnMap.put("newTask", "1");
        return returnMap;
    }

    public void createTaskData(List<ObCenterDataAcustFileData> dataList, ObCenterDataAcustBatch ocdb, String tenantId, String taskId) {
        try {
            ArrayList<ObCenterDataTaskData> dataRealList = new ArrayList<ObCenterDataTaskData>();
            HashSet phoneNos = new HashSet();
            List<String> lstSpecialPhone = this.getSpecialPhoneList(tenantId);
            if (lstSpecialPhone == null) {
                lstSpecialPhone = new ArrayList<String>();
            }
            ArrayList finalListAntiPhone = new ArrayList();
            ArrayList<ObCenterDataAcust> daList = new ArrayList<ObCenterDataAcust>();
            for (ObCenterDataAcustFileData afd : dataList) {
                String mobileNo = afd.getSerialNumber();
                if (StringUtils.isNullOrEmpty((String)mobileNo) || lstSpecialPhone.contains(mobileNo) || finalListAntiPhone.contains(mobileNo)) continue;
                ObCenterDataTaskData obCenterDataTaskData = new ObCenterDataTaskData();
                String dataId = "acu" + afd.getJobId();
                obCenterDataTaskData.setDataId(dataId);
                obCenterDataTaskData.setTaskId(taskId);
                obCenterDataTaskData.setMobileNo(mobileNo);
                obCenterDataTaskData.setSpeechTemplate(ocdb.getSpeechTemplate());
                obCenterDataTaskData.setProductId(ocdb.getCallProductid());
                obCenterDataTaskData.setProductName(ocdb.getCallProductidName());
                obCenterDataTaskData.setCallsmsRingoff(ocdb.getCallsmsRingoff());
                obCenterDataTaskData.setCallsmsRingoffContent(ocdb.getCallsmsRingoffContent());
                obCenterDataTaskData.setDataStartTime(ocdb.getTaskStatTime());
                obCenterDataTaskData.setDataEndTime(ocdb.getTaskEndTime());
                String now = DateUtil.getNowDate();
                obCenterDataTaskData.setImportTime(now);
                obCenterDataTaskData.setArea(afd.getEparchyCode());
                obCenterDataTaskData.setBak1("");
                obCenterDataTaskData.setBak2("");
                obCenterDataTaskData.setBak3("");
                dataRealList.add(obCenterDataTaskData);
                ObCenterDataAcust acust = new ObCenterDataAcust();
                acust.setDataId(dataId);
                acust.setTaskId(taskId);
                acust.setTenantId(tenantId);
                acust.setMobileNo(mobileNo);
                acust.setStrategyId(ocdb.getMaitainId());
                acust.setStrategyName(ocdb.getMaitainName());
                acust.setSpeechTemplate(ocdb.getSpeechTemplate());
                acust.setProductId(ocdb.getCallProductid());
                acust.setProductName(ocdb.getCallProductidName());
                acust.setCallsmsRingoff(ocdb.getCallsmsRingoff());
                acust.setCallsmsRingoffContent(ocdb.getCallsmsRingoffContent());
                acust.setChannelCode(ocdb.getChannelCode());
                acust.setSystemCode(ocdb.getFileName().split("_")[1]);
                acust.setDataFileName(ocdb.getFileName());
                acust.setImportTime(now);
                acust.setDataJson(afd.getJsonInfo());
                daList.add(acust);
            }
            String tenantOtherName = this.obCenterDataTaskDataService.selectTenantOtherNameByTenantId(tenantId);
            this.obCenterDataTaskDataService.batchInsertTenantOtherName(dataRealList, tenantOtherName);
            this.obCenterDataAcustService.batchInsert(daList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<String> getSpecialPhoneList(String tenantId) {
        return this.obCenterDataTaskDataService.selectSpecialPhoneNoList();
    }

    public ObCenterDataAcustTaskBatch taskBatch(ObCenterDataAcustBatch ocdb, String taskId, String tenantId, String language) {
        ObCenterDataAcustTaskBatch atb = new ObCenterDataAcustTaskBatch();
        atb.setTbId(UUID.randomUUID().toString().replace("-", ""));
        atb.setBatchId(ocdb.getBatchId());
        atb.setCreateTime(DateUtil.getNowDate());
        atb.setTaskId(taskId);
        atb.setPolicyId(ocdb.getPolicyId());
        atb.setProductId(ocdb.getCallProductid());
        atb.setJobId(language);
        atb.setTenantId(tenantId);
        atb.setMaitainId(ocdb.getMaitainId());
        return atb;
    }

    public void insertDataList(List<String[]> dataList, Map<String, String> map, String[] columnNames) {
        HashMap<String, Integer> parseRule = new HashMap<String, Integer>();
        ArrayList<ObCenterDataAcustFileData> list = new ArrayList<ObCenterDataAcustFileData>();
        parseRule.put("BATCH_ID", 0);
        parseRule.put("JOB_ID", 1);
        parseRule.put("EPARCHY_CODE", 2);
        parseRule.put("SERIAL_NUMBER", 3);
        parseRule.put("CONTACT_NUMBER", 4);
        parseRule.put("CUST_NAME", 5);
        parseRule.put("TEAM_ID", 6);
        parseRule.put("LANGUAGE", 11);
        for (String[] arr : dataList) {
            ObCenterDataAcustFileData afd = new ObCenterDataAcustFileData();
            afd.setBatchId(arr[(Integer)parseRule.get("BATCH_ID")]);
            afd.setJobId(arr[(Integer)parseRule.get("JOB_ID")]);
            afd.setDataId(arr[(Integer)parseRule.get("JOB_ID")]);
            afd.setEparchyCode(arr[(Integer)parseRule.get("EPARCHY_CODE")]);
            afd.setSerialNumber(arr[(Integer)parseRule.get("SERIAL_NUMBER")]);
            afd.setContactNumber(StringUtils.isNullOrEmpty((String)arr[(Integer)parseRule.get("CONTACT_NUMBER")]) ? "" : arr[(Integer)parseRule.get("CONTACT_NUMBER")]);
            afd.setCustName(StringUtils.isNullOrEmpty((String)arr[(Integer)parseRule.get("CUST_NAME")]) ? "" : arr[(Integer)parseRule.get("CUST_NAME")]);
            afd.setTeamId(arr[(Integer)parseRule.get("TEAM_ID")]);
            afd.setGrade("");
            afd.setCreateTime(DateUtil.getNowDate());
            if (arr.length > 10) {
                afd.setLanguage(StringUtils.isNullOrEmpty((String)arr[(Integer)parseRule.get("LANGUAGE")]) ? "" : arr[(Integer)parseRule.get("LANGUAGE")]);
            } else {
                afd.setLanguage("");
            }
            JsonArray jsonArray = new JsonArray();
            JsonObject jsonObject1 = new JsonObject();
            jsonObject1.addProperty("name", "\u7528\u6237\u53f7\u7801");
            jsonObject1.addProperty("value", arr[(Integer)parseRule.get("SERIAL_NUMBER")]);
            jsonObject1.addProperty("field", "customerAttribute1");
            JsonObject jsonObject2 = new JsonObject();
            jsonObject2.addProperty("name", "\u8054\u7cfb\u53f7\u7801");
            jsonObject2.addProperty("value", StringUtils.isNullOrEmpty((String)arr[(Integer)parseRule.get("CONTACT_NUMBER")]) ? "" : arr[(Integer)parseRule.get("CONTACT_NUMBER")]);
            jsonObject2.addProperty("field", "customerAttribute2");
            JsonObject jsonObject3 = new JsonObject();
            jsonObject3.addProperty("name", "\u5ba2\u6237\u59d3\u540d");
            jsonObject3.addProperty("value", StringUtils.isNullOrEmpty((String)arr[(Integer)parseRule.get("CUST_NAME")]) ? "" : arr[(Integer)parseRule.get("CUST_NAME")]);
            jsonObject3.addProperty("field", "customerAttribute3");
            JsonObject jsonObject4 = new JsonObject();
            jsonObject4.addProperty("name", "\u653f\u7b56\u540d\u79f0");
            jsonObject4.addProperty("value", map.get("policyName"));
            jsonObject4.addProperty("field", "customerAttribute4");
            JsonObject jsonObject5 = new JsonObject();
            jsonObject5.addProperty("name", "\u7b56\u7565\u540d\u79f0");
            jsonObject5.addProperty("value", map.get("maitainName"));
            jsonObject5.addProperty("field", "customerAttribute5");
            JsonObject jsonObject6 = new JsonObject();
            jsonObject6.addProperty("name", "\u662f\u5426\u6302\u673a\u77ed\u4fe1");
            jsonObject6.addProperty("value", map.get("callsmsRingoff"));
            jsonObject6.addProperty("field", "customerAttribute6");
            JsonObject jsonObject7 = new JsonObject();
            jsonObject7.addProperty("name", "\u6302\u673a\u77ed\u4fe1\u6a21\u677f");
            jsonObject7.addProperty("value", map.get("callsmsRingoffContent"));
            jsonObject7.addProperty("field", "customerAttribute7");
            JsonObject jsonObject8 = new JsonObject();
            jsonObject8.addProperty("name", "\u4ea7\u54c1\u540d\u79f0");
            jsonObject8.addProperty("value", map.get("callProductIdName"));
            jsonObject8.addProperty("field", "customerAttribute8");
            JsonObject jsonObject9 = new JsonObject();
            jsonObject9.addProperty("name", "\u6279\u6b21\u7f16\u7801");
            jsonObject9.addProperty("value", arr[(Integer)parseRule.get("BATCH_ID")]);
            jsonObject9.addProperty("field", "customerAttribute9");
            JsonObject jsonObject10 = new JsonObject();
            jsonObject10.addProperty("name", "\u4efb\u52a1\u7f16\u7801");
            jsonObject10.addProperty("value", arr[(Integer)parseRule.get("JOB_ID")]);
            jsonObject10.addProperty("field", "customerAttribute10");
            JsonObject jsonObject11 = new JsonObject();
            jsonObject11.addProperty("name", "\u5730\u5e02\u7f16\u7801");
            jsonObject11.addProperty("value", arr[(Integer)parseRule.get("EPARCHY_CODE")]);
            jsonObject11.addProperty("field", "customerAttribute11");
            JsonObject jsonObject12 = new JsonObject();
            jsonObject12.addProperty("name", "\u8425\u9500\u8bdd\u672f");
            jsonObject12.addProperty("value", map.get("templateContent"));
            jsonObject12.addProperty("field", "customerAttribute12");
            jsonArray.add((JsonElement)jsonObject1);
            jsonArray.add((JsonElement)jsonObject2);
            jsonArray.add((JsonElement)jsonObject3);
            jsonArray.add((JsonElement)jsonObject4);
            jsonArray.add((JsonElement)jsonObject5);
            jsonArray.add((JsonElement)jsonObject6);
            jsonArray.add((JsonElement)jsonObject7);
            jsonArray.add((JsonElement)jsonObject8);
            jsonArray.add((JsonElement)jsonObject9);
            jsonArray.add((JsonElement)jsonObject10);
            jsonArray.add((JsonElement)jsonObject11);
            jsonArray.add((JsonElement)jsonObject12);
            if (arr.length > 7) {
                for (int i = 7; i < arr.length; ++i) {
                    JsonObject jsonobj = new JsonObject();
                    jsonobj.addProperty("name", columnNames[i]);
                    jsonobj.addProperty("value", arr[i]);
                    jsonobj.addProperty("field", "customerAttribute" + (i + 5));
                    jsonArray.add((JsonElement)jsonobj);
                }
            }
            afd.setJsonInfo(jsonArray.toString());
            list.add(afd);
        }
        this.obCenterDataAcustFileDataService.batchInsert(list);
    }

    public Sftp connectSFTP(String ip, String userName, String password, int port) throws Exception {
        log.info("ip\u3010{}\u3011, password\u3010{}\u3011, userName\u3010{}\u3011, port\u3010{}\u3011", new Object[]{ip, password, userName, port});
        return SftpUtil.getSFTPClient(ip, password, userName, port);
    }
}

