/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.data.acust.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.data.acust.entity.AcustEntity;
import com.tydic.nicc.data.acust.mapper.po.ObCenterDataAcustLog;
import com.tydic.nicc.data.acust.service.AcustBaseService;
import com.tydic.nicc.data.acust.service.ObCenterDataAcustLogService;
import com.tydic.nicc.data.acust.service.ObCenterDataAcustTaskBatchService;
import com.tydic.nicc.data.acust.util.DateUtil;
import com.tydic.nicc.data.service.task.ObCenterDataTaskInfoService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.dubbo.common.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AcustTaskStatusChanageServiceImpl
implements AcustBaseService {
    private static final Logger log = LoggerFactory.getLogger(AcustTaskStatusChanageServiceImpl.class);
    @Resource
    ObCenterDataAcustTaskBatchService obCenterDataAcustTaskBatchService;
    @Resource
    ObCenterDataTaskInfoService obCenterDataTaskInfoService;
    @Resource
    private ObCenterDataAcustLogService obCenterDataAcustLogService;

    @Override
    public void excuete(AcustEntity uopEntity) {
        Map<String, Object> returnMap = this.taskStatusChange(uopEntity.getRequestParams());
        JSONObject jsonObject = new JSONObject(returnMap);
        uopEntity.setResponseParams(jsonObject.toString());
        System.out.println("****************returnjsonObject Start****************");
        System.out.println(jsonObject);
        System.out.println("****************returnjsonObject End****************");
    }

    @Override
    public void excuete() {
    }

    public Map<String, Object> taskStatusChange(String param) {
        log.info("taskStatusChange\u5165\u53c2\u6253\u5370\uff1a" + param);
        HashMap<String, Object> map_return = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)param)) {
            log.info("\u53c2\u6570\u5f02\u5e38\uff0c\u53c2\u6570\u4e3a\u7a7a!");
            map_return.put("RESP_CODE", "9999");
            map_return.put("RESP_DESC", "\u53c2\u6570\u5f02\u5e38\uff0c\u53c2\u6570\u4e3a\u7a7a!");
            return map_return;
        }
        try {
            if (StringUtils.isEmpty((String)param)) {
                log.info("\u53c2\u6570\u5f02\u5e38\uff0c\u53c2\u6570\u4e3a\u7a7a!");
                map_return.put("RESP_CODE", "9999");
                map_return.put("RESP_DESC", "\u53c2\u6570\u5f02\u5e38\uff0c\u53c2\u6570\u4e3a\u7a7a!");
                return map_return;
            }
            JSONObject obj = JSONObject.parseObject((String)param);
            String tradeId = (String)obj.get((Object)"TRADE_ID");
            String channelCode = (String)obj.get((Object)"CHANNEL_CODE");
            String taskType = (String)obj.get((Object)"TASK_TYPE");
            String taskStatus = (String)obj.get((Object)"TASK_STATUS");
            String pushTime = (String)obj.get((Object)"PUSH_TIME");
            JSONObject taskJobList = (JSONObject)obj.get((Object)"TASK_JOB_LIST");
            String taskJobId = (String)taskJobList.get((Object)"TASK_JOB_ID");
            String teamId = "";
            if ("2".equals(taskType)) {
                teamId = (String)taskJobList.get((Object)"TEAM_ID");
            }
            map_return.put("TRADE_ID", tradeId);
            if (StringUtils.isNotEmpty((String)teamId)) {
                List<String> taskIds = this.obCenterDataAcustTaskBatchService.selectTaskIdByBatchIdAndTenantId(taskJobId, teamId);
                if (taskIds != null && taskIds.size() > 0) {
                    taskIds.forEach(taskId -> this.obCenterDataTaskInfoService.updateByTaskId(taskId));
                }
            } else {
                List<String> taskIdList = this.obCenterDataAcustTaskBatchService.selectTaskIdListByBatchId(taskJobId);
                if (taskIdList.size() > 0) {
                    for (String taskId2 : taskIdList) {
                        this.obCenterDataTaskInfoService.updateByTaskId(taskId2);
                    }
                }
            }
            map_return.put("RESP_CODE", "0000");
            map_return.put("RESP_DESC", "\u63a5\u53e3\u8c03\u7528\u6210\u529f");
            ObCenterDataAcustLog logSave = new ObCenterDataAcustLog();
            logSave.setParamsObject(obj.toString());
            logSave.setResultObject(((Object)map_return).toString());
            logSave.setLogId(UUID.randomUUID().toString().replace("-", ""));
            logSave.setUserCode("\u80fd\u529b\u5e73\u53f0--\u300b\u8425\u9500\u5e73\u53f0");
            logSave.setInterfaceType("TaskStatusChange");
            logSave.setOperTime(DateUtil.getNowDate());
            this.obCenterDataAcustLogService.insert(logSave);
        }
        catch (Exception e) {
            log.error("\u63a5\u53e3\u65b9\u6cd5taskStatusChange\u8c03\u7528\u5f02\u5e38", (Throwable)e);
            e.printStackTrace();
            map_return.put("RESP_CODE", "9999");
            map_return.put("RESP_DESC", "\u63a5\u53e3\u8c03\u7528\u62a5\u9519:" + e.getMessage());
            return map_return;
        }
        return map_return;
    }
}

