/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.data.acust.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.data.acust.config.AcustPropertiesHolder;
import com.tydic.nicc.data.acust.mapper.po.ObCenterDataAcust;
import com.tydic.nicc.data.acust.mapper.po.ObCenterDataAcustBatch;
import com.tydic.nicc.data.acust.service.ObCenterDataAcustBatchService;
import com.tydic.nicc.data.acust.service.ObCenterDataAcustService;
import com.tydic.nicc.data.acust.service.ProductSubService;
import com.tydic.nicc.data.acust.util.AcustUtil;
import com.tydic.nicc.data.acust.util.OkHttpUtil;
import com.tydic.nicc.data.acust.util.Sftp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.ocs.bo.DCQProductSubReqBO;
import com.tydic.nicc.ocs.bo.DCQProductSubRspBO;
import com.tydic.nicc.ocs.service.DcProductSubService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ProductSubServiceImpl
implements ProductSubService {
    private static final Logger log = LoggerFactory.getLogger(ProductSubServiceImpl.class);
    @DubboReference
    private DcProductSubService dcProductSubService;
    @Resource
    private ObCenterDataAcustBatchService obCenterDataAcustBatchService;
    @Resource
    private ObCenterDataAcustService obCenterDataAcustService;
    @Resource
    AcustPropertiesHolder holder;
    private static final String splitChar = "|";

    @Override
    public void uploadBD(String filNameFlag) {
        DCQProductSubReqBO reqBO = new DCQProductSubReqBO();
        reqBO.setQualityStatus(Integer.valueOf(0));
        reqBO.setSubscribeChannel(Integer.valueOf(0));
        RspList rspList = this.dcProductSubService.selectProductSubscribe(reqBO);
        if (!"0000".equals(rspList.getRspDesc())) {
            log.info("\u6682\u65e0\u9700\u8981\u53d1\u9001\u7684\u6570\u636e");
            return;
        }
        List dcList = rspList.getRows();
        ArrayList<String> dataList = new ArrayList<String>();
        String fileName = AcustUtil.getDay(0) + "_HJZHCP_" + filNameFlag + ".txt";
        for (DCQProductSubRspBO rspBo : dcList) {
            dataList.add(this.change(rspBo));
        }
        this.uploadLocal(fileName, dataList);
        Sftp sftp = this.getSftp();
        sftp.login();
        String localFilePathTxt = this.holder.getOrder().getOrderLocalPath() + fileName;
        try {
            sftp.uploadFile(this.holder.getOrder().getSftpUpload(), fileName, new FileInputStream(localFilePathTxt));
        }
        catch (FileNotFoundException e) {
            log.info("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u6587\u4ef6\u540d\u79f0\u3010{}\u3011,\u5f02\u5e38\u3010{}\u3011", (Object)fileName, (Object)e);
            e.printStackTrace();
        }
        File fileTxt = new File(localFilePathTxt);
        fileTxt.delete();
        sftp.logout();
    }

    @Override
    public void downloadBD(String filNameFlag) {
        String fileName = AcustUtil.getDay(0) + "_HJZHCP_HC_" + filNameFlag + ".txt";
        Sftp sftp = this.getSftp();
        sftp.login();
        if (sftp.downloadFile(this.holder.getOrder().getSftpUpload(), fileName, this.holder.getOrder().getOrderLocalPath())) {
            File file = new File(this.holder.getOrder().getOrderLocalPath() + fileName);
            String filePath = file.getPath();
            log.info("\u5f00\u59cb\u8bfb\u53d6\u89e3\u6790sftp\u6587\u4ef6: " + filePath);
            try {
                String line;
                FileInputStream fis = null;
                ArrayList dataList = new ArrayList();
                fis = new FileInputStream(filePath);
                InputStreamReader isr = new InputStreamReader((InputStream)fis, "utf-8");
                BufferedReader br = new BufferedReader(isr);
                while ((line = br.readLine()) != null) {
                    String[] arrStr = line.split(splitChar);
                    String recordId = arrStr[0].toString();
                    String taskId = arrStr[1].toString();
                    String tenantId = arrStr[2].toString();
                    String called = arrStr[3].toString();
                    String productId = arrStr[4].toString();
                    String cbssFlow = arrStr[5].toString();
                    String orderTime = arrStr[6].toString();
                    String orderStatus = arrStr[7].toString();
                    if (!"0".equals(orderStatus)) continue;
                    String EPARCHY_CODE = "";
                    DCQProductSubReqBO reqBo = new DCQProductSubReqBO();
                    reqBo.setTenantId(tenantId);
                    reqBo.setUcId(recordId);
                    reqBo.setCalled(called);
                    reqBo.setTaskId(taskId);
                    DCQProductSubRspBO rspBo = this.dcProductSubService.selectByCalled(reqBo);
                    if (rspBo != null) {
                        ObCenterDataAcust ob = this.obCenterDataAcustService.selectById(rspBo.getDataId());
                        Map<String, String> attributes = this.getAttribute(ob.getDataJson());
                        EPARCHY_CODE = attributes.get("EPARCHY_CODE");
                        Map<String, String> resultMap = this.orderResultCallBack(called, EPARCHY_CODE, taskId, rspBo.getTaskId(), productId, cbssFlow, orderTime, orderStatus);
                        DCQProductSubReqBO reqBO = new DCQProductSubReqBO();
                        reqBO.setId(rspBo.getId());
                        reqBO.setSubscribeStatus(Integer.valueOf(0));
                        reqBO.setReceiptStatus(Integer.valueOf(0));
                        reqBO.setCbssOrderTime(orderTime);
                        this.dcProductSubService.updateById(reqBO);
                        continue;
                    }
                    log.info("\u672a\u83b7\u53d6\u5230\u8ba2\u5355\u8d28\u68c0\u4fe1\u606f {}", (Object)JSON.toJSONString((Object)reqBo).toString());
                    return;
                }
            }
            catch (Exception e) {
                log.info("\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\u3010{}\u3011", (Object)fileName);
            }
        } else {
            log.info("sftp\u670d\u52a1\u5668\u672a\u4e0b\u8f7d\u5230\u6307\u5b9a\u6587\u4ef6\u3010{}\u3011", (Object)fileName);
        }
        sftp.logout();
    }

    public Map<String, String> getAttribute(String dataJson) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        JSONArray objects = JSONObject.parseArray((String)dataJson);
        for (int i = 0; i < objects.size(); ++i) {
            JSONObject obj = (JSONObject)objects.get(i);
            if (!"\u5730\u5e02\u7f16\u7801".equals(obj.get((Object)"name"))) continue;
            attributes.put("EPARCHY_CODE", (String)obj.get((Object)"value"));
        }
        return attributes;
    }

    public String change(DCQProductSubRspBO rspBo) {
        ArrayList<String> strList = new ArrayList<String>();
        strList.add(rspBo.getUcId());
        strList.add(rspBo.getTaskId());
        strList.add(rspBo.getTenantId());
        strList.add(rspBo.getCalled());
        strList.add(this.getCommCode(rspBo.getTaskId(), rspBo.getCalled(), rspBo.getProductId()));
        return StringUtils.join((Object[])strList.toArray(), (String)splitChar);
    }

    public void uploadLocal(String fileName, List<String> dataList) {
        try {
            File file = new File(this.holder.getOrder().getOrderLocalPath() + fileName);
            FileOutputStream fos = new FileOutputStream(file);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            for (String line : dataList) {
                out.write(line);
                out.write("\r\n");
            }
            log.info("\u8ba2\u5355\u4e0a\u4f20\u5927\u6570\u636e\u5199\u5165" + dataList.size() + "\u6761");
            ((Writer)out).flush();
            ((Writer)out).close();
            fos.close();
            fos.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getCommCode(String taskId, String called, String productId) {
        String commCode = "";
        try {
            List response;
            ObCenterDataAcustBatch batch = this.obCenterDataAcustBatchService.selectByTaskId(taskId);
            if (batch == null) {
                return "9999";
            }
            String channelCode = batch.getChannelCode();
            String STRATEGY_ID = batch.getMaitainId();
            HashMap<String, Object> paramReq = new HashMap<String, Object>();
            paramReq.put("channelCode", channelCode);
            paramReq.put("mobileNo", called);
            Map<String, Object> mapReturn = this.productRecommend(paramReq);
            if ("0000".equals(mapReturn.get("RESP_CODE")) && (response = (List)mapReturn.get("COMM_INFO")) != null && response.size() > 0) {
                for (Map map : response) {
                    if (!productId.equals(map.get("COMM_ID"))) continue;
                    commCode = map.get("COMM_CODE").toString();
                }
            }
        }
        catch (Exception e) {
            log.info("\u8bf7\u6c42\u4ea7\u54c1\u63a8\u8350\u63a5\u53e3\u5f02\u5e38\uff01 {}", (Object)e.getMessage());
            e.printStackTrace();
            return "9999";
        }
        return commCode;
    }

    public Map<String, Object> productRecommend(Map<String, Object> param) throws Exception {
        Map<Object, Object> mapReturn = new HashMap();
        JSONObject requParam = new JSONObject();
        JSONObject returnObj = new JSONObject();
        String tradeId = AcustUtil.getTradeId();
        JSONObject paramObj = new JSONObject();
        paramObj.put("TRADE_ID", (Object)tradeId);
        String channelCodes = (String)param.get("channelCode");
        paramObj.put("CHANNEL_CODE", (Object)channelCodes);
        String mobileNo = (String)param.get("mobileNo");
        paramObj.put("SERIAL_NUMBER", (Object)mobileNo);
        paramObj.put("QUERY_TYPE", (Object)"1");
        HashMap<String, String> mapP = new HashMap<String, String>();
        mapP.put("PARA_ID", "");
        mapP.put("PARA_VALUE", "");
        ArrayList<HashMap<String, String>> paras = new ArrayList<HashMap<String, String>>();
        paras.add(mapP);
        paramObj.put("PARA", paras);
        OkHttpUtil okHttpUtil = new OkHttpUtil();
        requParam = this.putParam(paramObj);
        log.info("delDataDataTaskByUop\u8bf7\u6c42\u62a5\u6587\uff1a" + requParam.toString());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("url", this.holder.getUrl().getProductRecommendUrl());
        paramMap.put("request", requParam.toString());
        String responseStr = okHttpUtil.getResponse(paramMap);
        returnObj = JSONObject.parseObject((String)responseStr);
        log.info("delDataDataTaskByUop\u56de\u53c2\u6253\u5370\uff1a" + returnObj);
        mapReturn = this.getResultMap(returnObj);
        mapReturn.put("returnObj", returnObj);
        return mapReturn;
    }

    public JSONObject putParam(JSONObject param) {
        String appId = this.holder.getAppId();
        String appSecret = this.holder.getAppSecret();
        JSONObject returnObj = new JSONObject();
        JSONObject header = new JSONObject();
        JSONArray reservice = new JSONArray();
        JSONObject service = new JSONObject();
        service.put("RESERVED_ID", (Object)"dopuJA0G0p2O");
        service.put("RESERVED_VALUE", (Object)"hvtvgjiG5O8qOeymces");
        reservice.add((Object)service);
        header.put("RESERVED", (Object)reservice);
        try {
            Map<String, String> map = AcustUtil.getToken(appId, appSecret);
            header.put("TRANS_ID", (Object)map.get("TRANS_ID"));
            header.put("TIMESTAMP", (Object)map.get("TIMESTAMP"));
            header.put("TOKEN", (Object)map.get("token"));
            header.put("APP_ID", (Object)appId);
        }
        catch (Exception e) {
            log.error("\u62fc\u63a5\u4f20\u53c2\u62a5\u6587\u51fa\u9519:", (Throwable)e);
        }
        JSONObject body = new JSONObject();
        body.put("PRODUCT_RECOMMEND_REQ", (Object)param);
        JSONObject attar = new JSONObject();
        attar.put("MEDIA_INFO", (Object)"");
        returnObj.put("UNI_BSS_HEAD", (Object)header);
        returnObj.put("UNI_BSS_ATTACHED", (Object)attar);
        returnObj.put("UNI_BSS_BODY", (Object)body);
        return returnObj;
    }

    public Map<String, Object> getResultMap(JSONObject returnObj) {
        HashMap<String, Object> map_return = new HashMap<String, Object>();
        try {
            JSONObject head = (JSONObject)returnObj.get((Object)"UNI_BSS_HEAD");
            String code = String.valueOf(head.get((Object)"RESP_CODE"));
            if (!code.equals("00000")) {
                log.info("\u4ea7\u54c1\u63a8\u8350\u8c03\u7528\u4e0d\u6210\u529f\uff1a" + String.valueOf(head.get((Object)"RESP_DESC")));
                map_return.put("RESP_CODE", "9999");
                map_return.put("RESP_DESC", head.get((Object)"RESP_DESC"));
                return map_return;
            }
            JSONObject body = (JSONObject)returnObj.get((Object)"UNI_BSS_BODY");
            if (body != null) {
                JSONObject req = (JSONObject)body.get((Object)"PRODUCT_RECOMMEND_RSP");
                if (req != null) {
                    map_return.put("RESP_CODE", req.get((Object)"RESP_CODE"));
                    map_return.put("RESP_DESC", req.get((Object)"RESP_DESC"));
                    if ("0000".equals(req.get((Object)"RESP_CODE"))) {
                        map_return.put("COMM_INFO", req.getJSONObject("RESP_DATA").getJSONArray("COMM_INFO"));
                    }
                } else {
                    log.info("getResultMap\u65b9\u6cd5\uff1aPRODUCT_RECOMMEND_RSP\u89e3\u6790\u4e0d\u5b58\u5728\uff01");
                    map_return.put("RESP_CODE", "9999");
                    map_return.put("RESP_DESC", "PRODUCT_RECOMMEND_RSP\u89e3\u6790\u4e0d\u5b58\u5728");
                }
            }
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u8fd4\u56de\u62a5\u6587\u51fa\u9519:", (Throwable)e);
        }
        return map_return;
    }

    public Map<String, String> orderResultCallBack(String called, String EPARCHY_CODE, String taskId, String userId, String productId, String cbssFlow, String orderTime, String orderStatus) {
        HashMap<String, String> map_return = new HashMap<String, String>();
        JSONObject requParam = new JSONObject();
        JSONObject returnObj = new JSONObject();
        String tradeId = AcustUtil.getTradeId();
        JSONObject paramObj = new JSONObject();
        paramObj.put("EPARCHY_CODE", (Object)EPARCHY_CODE);
        paramObj.put("STAFF_ID", (Object)userId);
        ObCenterDataAcustBatch batch = this.obCenterDataAcustBatchService.selectByTaskId(taskId);
        paramObj.put("CHANNEL_CODE", (Object)batch.getChannelCode());
        paramObj.put("PROVINCE_CODE", (Object)batch.getProvinceCode());
        paramObj.put("STRATEGY_ID", (Object)batch.getMaitainId());
        paramObj.put("COMM_ID", (Object)productId);
        paramObj.put("SERIAL_NUMBER", (Object)called);
        paramObj.put("CHANNEL_TYPE", (Object)"HJJY");
        paramObj.put("CHANNEL_ID", (Object)"HJJY");
        paramObj.put("ORDER_STATUS", (Object)orderStatus);
        paramObj.put("RESP_CODE", (Object)"0000");
        paramObj.put("TRADE_ID", (Object)tradeId);
        paramObj.put("IS_EXP", (Object)"n");
        paramObj.put("ORDER_TYPE", (Object)"2113");
        paramObj.put("IS_RETURN", (Object)"n");
        paramObj.put("ORDER_ID", (Object)cbssFlow);
        paramObj.put("ORDER_RESULT", (Object)"0000");
        paramObj.put("CANCEL_TAG", (Object)"0");
        paramObj.put("ORDER_TIME", (Object)orderTime);
        OkHttpUtil uopOkHttpUtil = new OkHttpUtil();
        requParam = this.putParamOrderCallBack(paramObj);
        log.info("\u8bf7\u6c42\u62a5\u6587\uff1a" + requParam.toString());
        try {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("url", this.holder.getUrl().getOrderCallBackUrl());
            paramMap.put("request", requParam.toString());
            String responseStr = uopOkHttpUtil.getResponse(paramMap);
            returnObj = JSONObject.parseObject((String)responseStr);
            log.info("\u56de\u53c2\u6253\u5370\uff1a" + responseStr);
            map_return.put("RESP_CODE", "0000");
            map_return.put("RESP_DESC", "\u63a5\u53e3\u8c03\u7528\u6210\u529f");
        }
        catch (Exception e) {
            map_return.put("RESP_CODE", "9999");
            map_return.put("RESP_DESC", "\u63a5\u53e3\u8c03\u7528\u62a5\u9519:" + e.getMessage());
            return map_return;
        }
        return map_return;
    }

    public JSONObject putParamOrderCallBack(JSONObject param) {
        JSONObject returnObj = new JSONObject();
        JSONObject header = new JSONObject();
        JSONArray reservice = new JSONArray();
        JSONObject service = new JSONObject();
        service.put("RESERVED_ID", (Object)"dopuJA0G0p2O");
        service.put("RESERVED_VALUE", (Object)"hvtvgjiG5O8qOeymces");
        reservice.add((Object)service);
        header.put("RESERVED", (Object)reservice);
        try {
            Map<String, String> map = AcustUtil.getToken(this.holder.getAppId(), this.holder.getAppSecret());
            header.put("TRANS_ID", (Object)map.get("TRANS_ID"));
            header.put("TIMESTAMP", (Object)map.get("TIMESTAMP"));
            header.put("TOKEN", (Object)map.get("token"));
            header.put("APP_ID", (Object)this.holder.getAppId());
        }
        catch (Exception e) {
            log.error("\u62fc\u63a5\u4f20\u53c2\u62a5\u6587\u51fa\u9519:", (Throwable)e);
        }
        JSONObject body = new JSONObject();
        body.put("ORDER_RESULT_CALLBACK_REQ", (Object)param);
        JSONObject attar = new JSONObject();
        attar.put("MEDIA_INFO", (Object)"");
        returnObj.put("UNI_BSS_HEAD", (Object)header);
        returnObj.put("UNI_BSS_ATTACHED", (Object)attar);
        returnObj.put("UNI_BSS_BODY", (Object)body);
        return returnObj;
    }

    private Sftp getSftp() {
        int timeout = 60000;
        Sftp sftp = new Sftp(this.holder.getOrder().getSftpIp(), this.holder.getOrder().getSftpPort(), timeout, this.holder.getOrder().getSftpUser(), this.holder.getOrder().getSftpPasswd());
        return sftp;
    }
}

