/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.data.acust.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.springframework.util.DigestUtils;

public class DateUtil {
    private static final SimpleDateFormat sdfYear = new SimpleDateFormat("yyyy");
    private static final SimpleDateFormat sdfDay = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat sdfDays = new SimpleDateFormat("yyyyMMdd");
    private static final SimpleDateFormat sdfTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static String getYear() {
        return sdfYear.format(new Date());
    }

    public static String getDay() {
        return sdfDay.format(new Date());
    }

    public static String getDays() {
        return sdfDays.format(new Date());
    }

    public static String getNowDate() {
        return sdfTime.format(new Date());
    }

    public static boolean compareDate(String s, String e) {
        if (DateUtil.fomatDate(s) == null || DateUtil.fomatDate(e) == null) {
            return false;
        }
        return DateUtil.fomatDate(s).getTime() >= DateUtil.fomatDate(e).getTime();
    }

    public static Date fomatDate(String date) {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return fmt.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isValidDate(String s) {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
        try {
            fmt.parse(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int getDiffYear(String startTime, String endTime) {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
        try {
            int years = (int)((fmt.parse(endTime).getTime() - fmt.parse(startTime).getTime()) / 86400000L / 365L);
            return years;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static long getDaySub(String beginDateStr, String endDateStr) {
        long day = 0L;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date beginDate = null;
        Date endDate = null;
        try {
            beginDate = format.parse(beginDateStr);
            endDate = format.parse(endDateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        day = (endDate.getTime() - beginDate.getTime()) / 86400000L;
        return day;
    }

    public static String getAfterDayDate(String days) {
        int daysInt = Integer.parseInt(days);
        Calendar canlendar = Calendar.getInstance();
        canlendar.add(5, daysInt);
        Date date = canlendar.getTime();
        SimpleDateFormat sdfd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateStr = sdfd.format(date);
        return dateStr;
    }

    public static String getAfterDayWeek(String days) {
        int daysInt = Integer.parseInt(days);
        Calendar canlendar = Calendar.getInstance();
        canlendar.add(5, daysInt);
        Date date = canlendar.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("E");
        String dateStr = sdf.format(date);
        return dateStr;
    }

    public static String getAfterMonthDate(String month) throws Exception {
        int daysInt = Integer.parseInt(month);
        Calendar canlendar = Calendar.getInstance();
        canlendar.add(2, daysInt);
        Date date = canlendar.getTime();
        SimpleDateFormat sdfd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateStr = sdfd.format(date);
        return dateStr;
    }

    public static Date getAfterMonthBao(Date sj, int daysInt) throws Exception {
        Calendar canlendar = Calendar.getInstance();
        canlendar.setTime(sj);
        canlendar.add(2, daysInt);
        Date date = canlendar.getTime();
        return date;
    }

    public static String getAfterDay(String days) {
        int daysInt = Integer.parseInt(days);
        Calendar canlendar = Calendar.getInstance();
        canlendar.add(5, daysInt);
        Date date = canlendar.getTime();
        SimpleDateFormat sdfd = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = sdfd.format(date);
        return dateStr;
    }

    public static String getPlanNumber() {
        SimpleDateFormat sdfd = new SimpleDateFormat("yyyyMMddHHmmss");
        String dateStr = sdfd.format(new Date());
        String rs = dateStr.substring(2, dateStr.length() - 6);
        return rs;
    }

    public static String getDateWo(Date date) {
        return sdfDay.format(date);
    }

    public static int getAfterDayInt(String days) {
        int daysInt = Integer.parseInt(days);
        Calendar canlendar = Calendar.getInstance();
        canlendar.add(5, daysInt);
        Date date = canlendar.getTime();
        SimpleDateFormat sdfd = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = sdfd.format(date);
        return (int)(DateUtil.fomatDate(dateStr).getTime() / 1000L);
    }

    public static int getToDayLong() {
        return (int)(new Date().getTime() / 1000L);
    }

    public static int getAddTimeInt(long t) {
        try {
            Date date = new Date(t * 1000L);
            String now = sdfDay.format(date);
            return (int)(sdfDay.parse(now).getTime() / 1000L);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static Date fomatDateLong(String date) {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        try {
            return fmt.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getHour() {
        Calendar cal = Calendar.getInstance();
        int hour = cal.get(11);
        return hour;
    }

    public static String getAfterMonthDay(String month) throws Exception {
        int daysInt = Integer.parseInt(month);
        Calendar canlendar = Calendar.getInstance();
        canlendar.add(2, daysInt);
        Date date = canlendar.getTime();
        String dateStr = sdfDay.format(date);
        return dateStr;
    }

    public static Date getNow() {
        return DateUtil.fomatDate(DateUtil.getDateWo(new Date()));
    }

    public static String getDateStr(long time) {
        Date date = new Date(time);
        SimpleDateFormat sdfDay = new SimpleDateFormat("yyyy\u5e74MM\u6708dd");
        return sdfDay.format(date);
    }

    public static Date getBeforeDayDate(int days) throws Exception {
        int daysInt = days;
        Calendar canlendar = Calendar.getInstance();
        canlendar.add(5, daysInt);
        Date date = canlendar.getTime();
        SimpleDateFormat sdfd = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = sdfd.format(date);
        Date dateNow = sdfDay.parse(dateStr);
        return dateNow;
    }

    public static int getDateToDayOneInt() {
        String str = DateUtil.getDay();
        Date dat = DateUtil.fomatDate(str);
        return (int)(dat.getTime() / 1000L);
    }

    public static int StrDateToInt(String date) {
        try {
            return (int)(sdfDay.parse(date).getTime() / 1000L);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static Date getAfterMonthDay(int month, int day) throws Exception {
        Calendar canlendar = Calendar.getInstance();
        canlendar.add(5, day);
        canlendar.add(2, month);
        Date date = canlendar.getTime();
        return DateUtil.fomatDate(sdfDay.format(date));
    }

    public static Date getAfterMonthDay(Date datePlan, int month, int day) throws Exception {
        Calendar canlendar = Calendar.getInstance();
        canlendar.setTime(datePlan);
        canlendar.add(5, day);
        canlendar.add(2, month);
        Date date = canlendar.getTime();
        return DateUtil.fomatDate(sdfDay.format(date));
    }

    public static String int2LongDate(long sec) {
        Date date = new Date(sec * 1000L);
        return sdfTime.format(date);
    }

    public static String getTheMonthFirstDay() {
        Calendar c = Calendar.getInstance();
        c.add(2, 0);
        c.set(5, 1);
        String first = sdfDay.format(c.getTime());
        System.out.println("===============first:" + first);
        return first;
    }

    public static String getTheMonthLastDay() {
        Calendar ca = Calendar.getInstance();
        ca.set(5, ca.getActualMaximum(5));
        String last = sdfDay.format(ca.getTime());
        System.out.println("===============last:" + last);
        return last;
    }

    public static String toDayAddOneMonth() throws Exception {
        return sdfDay.format(DateUtil.getAfterMonthBao(DateUtil.fomatDate(DateUtil.getTheMonthFirstDay()), 1));
    }

    public static int planDateAndDayTime(Date planDate, Date time) throws Exception {
        String plan = sdfTime.format(planDate);
        String day = sdfTime.format(time);
        String start = plan.substring(0, day.indexOf(" "));
        String end = day.substring(day.indexOf(" ") + 1);
        int ms = (int)(sdfTime.parse(start + " " + end).getTime() / 1000L);
        return ms;
    }

    public static String sheHourTime(int hour) {
        Calendar c = Calendar.getInstance();
        c.set(11, hour);
        c.set(12, 0);
        c.set(13, 0);
        String first = sdfTime.format(c.getTime());
        return first;
    }

    public static int getDaySubInt(long start, long end) {
        String str_begin = sdfDay.format(new Date(start * 1000L));
        String str_end = sdfDay.format(new Date(end * 1000L));
        return (int)DateUtil.getDaySub(str_begin, str_end);
    }

    public static String Date2Str(Date date) {
        return sdfDay.format(date);
    }

    public static boolean isCurrentDay(Date date) {
        try {
            String dateStr = sdfDay.format(date);
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Date d = format.parse(dateStr);
            return DateUtil.getNow().compareTo(d) == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getDateStr(String dateTime) {
        String toDay = "";
        SimpleDateFormat geshi = new SimpleDateFormat("yyyy\u5e74MM\u6708dd");
        try {
            toDay = geshi.format(sdfDay.parse(dateTime));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return toDay;
    }

    public static String getDateStrMo() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd HH:mm");
        return sdf.format(new Date());
    }

    public static int addYear(int daysInt) {
        Calendar canlendar = Calendar.getInstance();
        canlendar.add(1, daysInt);
        Date date = canlendar.getTime();
        SimpleDateFormat sdfd = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = sdfd.format(date);
        return DateUtil.StrDateToInt(dateStr);
    }

    public static int getAfterMonthDayInt(Date datePlan, int month, int day) throws Exception {
        Calendar canlendar = Calendar.getInstance();
        canlendar.setTime(datePlan);
        canlendar.add(5, day);
        canlendar.add(2, month);
        Date date = canlendar.getTime();
        return (int)(date.getTime() / 1000L);
    }

    public static void main(String[] args) throws Exception {
        System.out.println(DigestUtils.md5DigestAsHex((byte[])"hahaha".getBytes()));
    }

    public static String dateToLLPayFormat(String s) {
        SimpleDateFormat dataFormat = new SimpleDateFormat("yyyyMMddHHmmss", Locale.getDefault());
        if (s.length() == 10) {
            return dataFormat.format(new Date(Long.valueOf(s + "000")));
        }
        return dataFormat.format(new Date(Long.valueOf(s + "000")));
    }

    public static String changeTimeZone(long time, String format) {
        Date date = new Date(time);
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT+08"));
        String dateStrTmp = dateFormat.format(date);
        return dateStrTmp;
    }

    public static boolean judgeIsSetBiddingTime(String startTime, String endTime) {
        SimpleDateFormat df = new SimpleDateFormat("HH:mm");
        Date now = null;
        Date beginTime = null;
        Date endTimes = null;
        try {
            now = df.parse(df.format(new Date()));
            beginTime = df.parse(startTime);
            endTimes = df.parse(endTime);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Calendar date = Calendar.getInstance();
        date.setTime(now);
        Calendar begin = Calendar.getInstance();
        begin.setTime(beginTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTimes);
        return date.after(begin) && date.before(end);
    }
}

