/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.ocs.bo.GeneralCodeBO;
import com.tydic.nicc.ocs.bo.MouldUrlReqBO;
import com.tydic.nicc.ocs.bo.MouldUrlRspBO;
import com.tydic.nicc.ocs.mapper.DcGeneralCodeDAO;
import com.tydic.nicc.ocs.mapper.po.DcGeneralCodePO;
import com.tydic.nicc.ocs.service.CodeService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;

@DubboService
public class CodeServiceImp
implements CodeService {
    private static final Logger log = LoggerFactory.getLogger(CodeServiceImp.class);
    @Resource
    private DcGeneralCodeDAO dcGeneralCodeDAO;

    public Rsp getCodeValue(MouldUrlReqBO reqBO) {
        log.info("\u67e5\u8be2\u4e0b\u8f7d\u6a21\u677f\u8def\u5f84\u5165\u53c2={}", (Object)JSON.toJSONString((Object)reqBO));
        MouldUrlRspBO rspBO = new MouldUrlRspBO();
        if (StringUtils.isEmpty((Object)reqBO.getCodeType())) {
            log.info("\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            return BaseRspUtils.createErrorRsp((String)"\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getCodeName())) {
            log.info("\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            return BaseRspUtils.createErrorRsp((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DcGeneralCodePO generalCodePO = new DcGeneralCodePO();
        generalCodePO.setCodeName(reqBO.getCodeName());
        generalCodePO.setCodeStatus("1");
        generalCodePO.setCodeType(reqBO.getCodeType());
        log.info("\u67e5\u8be2\u4e0b\u8f7d\u6a21\u677fmapper\u5c42\u5165\u53c2={}", (Object)JSON.toJSONString((Object)generalCodePO));
        DcGeneralCodePO codePO = this.dcGeneralCodeDAO.selectByActivity(generalCodePO);
        log.info("\u67e5\u8be2\u4e0b\u8f7d\u6a21\u677fmapper\u5c42\u51fa\u53c2={}", (Object)JSON.toJSONString((Object)codePO));
        if (codePO != null) {
            rspBO.setCodeName(codePO.getCodeName());
            rspBO.setCodeType(codePO.getCodeType());
            rspBO.setDownLoadUrl(codePO.getCodeValue());
        }
        return BaseRspUtils.createSuccessRsp((Object)rspBO);
    }

    public List<GeneralCodeBO> getGeneral(String codeType) {
        log.info("\u8fdb\u5165\u83b7\u53d6\u5b57\u5178\u6570\u636e\u63a5\u53e3\uff0ccodeType\uff1a{}", (Object)codeType);
        ArrayList<GeneralCodeBO> generalCodeBOS = new ArrayList<GeneralCodeBO>();
        if (StringUtils.isEmpty((Object)codeType)) {
            log.error("codeType\u4e3a\u7a7a");
            return generalCodeBOS;
        }
        List dcGeneralCodePOS = this.dcGeneralCodeDAO.qryGeneralCode(codeType);
        if (dcGeneralCodePOS != null && dcGeneralCodePOS.size() > 0) {
            for (DcGeneralCodePO generalCodePO : dcGeneralCodePOS) {
                GeneralCodeBO codeBO = new GeneralCodeBO();
                BeanUtils.copyProperties((Object)generalCodePO, (Object)codeBO);
                generalCodeBOS.add(codeBO);
            }
        }
        return generalCodeBOS;
    }
}

