/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.bo.skillGroup.DcSkillGroupInfoBO;
import com.tydic.nicc.dc.skillGroup.inter.SkillGroupInterService;
import com.tydic.nicc.ocs.bo.AdjustTaskBO;
import com.tydic.nicc.ocs.bo.BaseBO;
import com.tydic.nicc.ocs.bo.CallRateConfigBO;
import com.tydic.nicc.ocs.bo.CallerBO;
import com.tydic.nicc.ocs.bo.ChildTaskBO;
import com.tydic.nicc.ocs.bo.CreateIsvTaskResultBO;
import com.tydic.nicc.ocs.bo.CreatePreTaskBO;
import com.tydic.nicc.ocs.bo.EndTaskBO;
import com.tydic.nicc.ocs.bo.ImportBO;
import com.tydic.nicc.ocs.bo.ListData;
import com.tydic.nicc.ocs.bo.ListInfoFormatBO;
import com.tydic.nicc.ocs.bo.MonitorTaskBO;
import com.tydic.nicc.ocs.bo.MonitorTaskReqBO;
import com.tydic.nicc.ocs.bo.PeriodBO;
import com.tydic.nicc.ocs.bo.PeriodInfoBO;
import com.tydic.nicc.ocs.bo.PrefixInfoBO;
import com.tydic.nicc.ocs.bo.QueryPeriodBO;
import com.tydic.nicc.ocs.bo.QueryPeriodResultBO;
import com.tydic.nicc.ocs.bo.QueryTaskVoiceRspBO;
import com.tydic.nicc.ocs.bo.StartTaskBO;
import com.tydic.nicc.ocs.bo.StopTaskBO;
import com.tydic.nicc.ocs.bo.TaskInfoBO;
import com.tydic.nicc.ocs.bo.TaskTacticsBO;
import com.tydic.nicc.ocs.bo.TaskType;
import com.tydic.nicc.ocs.bo.TestCallBO;
import com.tydic.nicc.ocs.bo.UpdatePeriodBO;
import com.tydic.nicc.ocs.bo.UpdateTaskBO;
import com.tydic.nicc.ocs.busi.TaskBusiService;
import com.tydic.nicc.ocs.config.CodeConfig;
import com.tydic.nicc.ocs.exception.OcsException;
import com.tydic.nicc.ocs.isv.ListService;
import com.tydic.nicc.ocs.isv.PredictiveTaskService;
import com.tydic.nicc.ocs.isv.bo.ListInfoBO;
import com.tydic.nicc.ocs.mapper.PortraitNewDAO;
import com.tydic.nicc.ocs.mapper.po.PortraitNewPO;
import com.tydic.nicc.ocs.service.CallRateConfigService;
import com.tydic.nicc.ocs.service.IsvTaskProxyService;
import com.tydic.nicc.ocs.service.TaskConfigRelationService;
import com.tydic.nicc.ocs.service.TaskInfoService;
import com.tydic.nicc.ocs.service.TaskTacticsService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class IsvTaskProxyServiceImpl
implements IsvTaskProxyService {
    private static final Logger log = LoggerFactory.getLogger(IsvTaskProxyServiceImpl.class);
    @Value(value="${isv.default.isOut:true}")
    private boolean isOut;
    @Autowired
    private PortraitNewDAO portraitNewDAO;
    @Resource
    private CodeConfig codeConfig;
    @Resource
    private TaskBusiService taskBusiService;
    @Resource
    private TaskTacticsService taskTacticsService;
    @Resource
    private PredictiveTaskService predictiveTaskService;
    @Resource
    private ListService listService;
    @Resource
    private TaskInfoService taskInfoService;
    @Resource
    private TaskConfigRelationService taskConfigRelationService;
    @Resource
    private CallRateConfigService callRateConfigService;
    @DubboReference
    private SkillGroupInterService skillGroupInterService;
    private String[] WEEK = new String[]{"\u5468\u65e5", "\u5468\u4e00", "\u5468\u4e8c", "\u5468\u4e09", "\u5468\u56db", "\u5468\u4e94", "\u5468\u516d"};
    private String dateFormat = "yyyy-MM-dd HH:mm:ss";
    private String ymdDateFormat = "yyyy-MM-dd";
    @Value(value="${isv.default.connectRate:50}")
    private Integer connectRate;
    @Value(value="${isv.default.maxQueue:0}")
    private Integer maxQueue;
    @Value(value="${isv.default.transferRate:50}")
    private Integer transferRate;
    @Value(value="${isv.default.maxCallCount:1000}")
    private Integer maxCallCount;
    @Value(value="${isv.default.agentWorkTime:0}")
    private Integer agentWorkTime;
    @Value(value="${isv.default.callProcessTime:0}")
    private Integer callProcessTime;
    @Value(value="${isv.default.callTimeout:0}")
    private Integer callTimeout;
    @Value(value="${isv.default.failPolicy:NEXT}")
    private String failPolicy;
    @Value(value="${isv.default.nextInterval:30}")
    private Integer nextInterval;
    @Value(value="${isv.default.retryCount:0}")
    private Integer retryCount;
    @Value(value="${isv.default.retryInterval:3600}")
    private Integer retryInterval;
    @Value(value="${isv.default.exportType:HTTP}")
    private String exportType;
    @Value(value="${isv.default.exportPlan:TIME}")
    private String exportPlan;
    @Value(value="${isv.default.exportInterval:1}")
    private Integer exportInterval;
    @Value(value="${isv.default.cleanFile:1}")
    private Integer cleanFile;
    @Value(value="${isv.default.cleanHistory:10}")
    private Integer cleanHistory;
    @Value(value="${isv.default.autoAni:N}")
    private String autoAni;
    @Value(value="${isv.default.cleanHistory:1,2,3}")
    private String statusPlan;
    @Value(value="${isv.default.exceptionPlan:N}")
    private String exceptionPlan;
    @Value(value="${isv.default.callResultBack:http://192.168.10.184:8862/e1R5MV2JIQ2IThZM/gainResults?}")
    private String callResultBack;
    @Value(value="${isv.default.callStatusBack:}")
    private String callStatusBack;
    @Value(value="${isv.default.exceptionUrl:}")
    private String exceptionUrl;

    public CreateIsvTaskResultBO createIsvTask(String taskID, String tenantID) {
        TaskInfoBO taskInfo = this.getTaskInfo(taskID, tenantID);
        if ("1".equals(taskInfo.getCallType())) {
            log.info("=====\u9884\u89c8\u5f0f\u4efb\u52a1\u4e0d\u9700\u8981\u4e0b\u53d1ISV\u5916\u547c\u4efb\u52a1=====");
            return null;
        }
        if (!StringUtils.isEmpty((Object)taskInfo.getIvrTaskId()) && !StringUtils.isEmpty((Object)taskInfo.getIvrListId())) {
            log.info("=====IVR \u5916\u547c\u4efb\u52a1\u5df2\u7ecf\u521b\u5efatakID:{}=====", (Object)taskID);
            this.modifyIsvTask(taskID, tenantID, taskInfo);
            return null;
        }
        this.commonCheak(taskID, tenantID, taskInfo);
        CreatePreTaskBO createPreTask = new CreatePreTaskBO();
        createPreTask.setTenantId("1");
        createPreTask.setTaskName(taskInfo.getTaskName());
        if (taskInfo.getCallType() == null) {
            createPreTask.setTaskType(TaskType.P);
        } else if ("0".equals(taskInfo.getCallType())) {
            createPreTask.setTaskType(TaskType.P);
            createPreTask.setConnectRate(this.connectRate);
        } else if ("2".equals(taskInfo.getCallType())) {
            createPreTask.setTaskType(TaskType.A);
        }
        if (TaskType.P.equals((Object)createPreTask.getTaskType())) {
            Rsp rsp = this.skillGroupInterService.getSkillGroupInfo(taskInfo.getSkillId(), taskInfo.getTenantId());
            if (rsp.isSuccess()) {
                DcSkillGroupInfoBO skillGroup = (DcSkillGroupInfoBO)rsp.getData();
                createPreTask.setSkillCode(skillGroup.getSkillGroupCode());
                createPreTask.setAcdDn(skillGroup.getAcdDn());
            }
            createPreTask.setMaxCallCount(Integer.valueOf(500));
        } else if (TaskType.A.equals((Object)createPreTask.getTaskType())) {
            createPreTask.setHuntGroupDn(this.codeConfig.getCodeStrValue(CodeConfig.CODE_BUSI.SYS_PARAM, CodeConfig.CODE_NAME.HUNT_GROUP_DN));
            createPreTask.setMaxCallCount(Integer.valueOf(2));
        }
        createPreTask.setAutoAni(this.autoAni);
        ArrayList<TaskTacticsBO> tacticss = this.taskTacticsService.qryTacticsByTaskID(taskID, tenantID);
        CallRateConfigBO callRateBO = this.callRateConfigService.getCallRateBO(tenantID);
        if (null != callRateBO) {
            tacticss = new ArrayList<TaskTacticsBO>();
            TaskTacticsBO bo = new TaskTacticsBO();
            bo.setMaxQueue(callRateBO.getMaxQueue());
            bo.setPredictionDivisor(callRateBO.getMicroParam());
            bo.setNextInterval(null == callRateBO.getNextNumberTime() ? null : Integer.valueOf(callRateBO.getNextNumberTime().intValue()));
            tacticss.add(bo);
        }
        if (tacticss != null && !tacticss.isEmpty()) {
            TaskTacticsBO tacticsBO = (TaskTacticsBO)tacticss.get(0);
            int localMaxQueue = null == tacticsBO.getMinStartSeats() || tacticsBO.getMinStartSeats() <= 0 ? (null == tacticsBO.getMaxQueue() || tacticsBO.getMaxQueue() <= 0 ? this.maxQueue : tacticsBO.getMaxQueue()) : tacticsBO.getMinStartSeats();
            int localNextInterval = null == tacticsBO.getNextInterval() || tacticsBO.getNextInterval() <= 0 ? (this.nextInterval <= 0 ? null : this.nextInterval) : tacticsBO.getNextInterval();
            createPreTask.setTuneParam(tacticsBO.getPredictionDivisor());
            createPreTask.setMaxQueue(Integer.valueOf(localMaxQueue));
            createPreTask.setNextInterval(Integer.valueOf(localNextInterval));
        }
        createPreTask.setTransferRate(this.transferRate <= 0 ? null : this.transferRate);
        createPreTask.setAgentWorkTime(this.agentWorkTime <= 0 ? null : this.agentWorkTime);
        createPreTask.setCallProcessTime(this.callProcessTime <= 0 ? null : this.callProcessTime);
        createPreTask.setCallTimeout(this.callTimeout <= 0 ? null : this.callTimeout);
        createPreTask.setRetryInterval(this.retryInterval < 0 ? null : this.retryInterval);
        createPreTask.setExportType(this.exportType);
        createPreTask.setFailPolicy(this.failPolicy);
        createPreTask.setExportPlan(this.exportPlan);
        createPreTask.setRetryCount(this.retryCount);
        createPreTask.setExportInterval(this.exportInterval);
        createPreTask.setCleanFile(this.cleanFile);
        createPreTask.setCleanHistory(this.cleanHistory);
        createPreTask.setPrefixInfo(this.createPrefixInfo(taskInfo));
        createPreTask.setCallAni(taskInfo.getCalling());
        createPreTask.setPeriodInfo(this.createPeriodInfo(taskInfo, tacticss, false));
        if ("HTTP".equals(this.exportType)) {
            createPreTask.setFileFormat("JSON");
            createPreTask.setExportUrl(this.getResultBack(taskInfo));
        } else if ("FILE".equals(this.exportType)) {
            createPreTask.setFileFormat("TXT");
        }
        if ("Y".equals(this.exceptionPlan)) {
            createPreTask.setStatusPlan(this.statusPlan);
            createPreTask.setExceptionPlan(this.exceptionPlan);
            createPreTask.setStatusUrl(this.getStatusUrl(taskInfo));
        }
        createPreTask.setExceptionUrl(this.getExceptionUrl(taskInfo));
        createPreTask.setListInfo(this.getListFormat());
        createPreTask.setExportContent("call_id,task_id,list_id,batch_id,record_id,tenant_id,origin_id,cust_id,contact_id,ucid,scid,ani,dnis,start_time,talk_time,end_time,duration,call_duration,end_type,record_url,record_duration,agent_id,agent_dn,agent_lock_time,agent_ring_time,agent_talk_time,agent_end_time,agent_reason_desc,ivr_dn,ivr_ring_time,ivr_talk_time,ivr_end_time,trunk_dn,trunk_ring_time,trunk_talk_time,trunk_queue_time,trunk_end_time,trunk_reason_desc,hangup_type,create_time,update_time,call_seq,extend_field1,extend_field2,extend_field3,extend_field4,extend_field5,extend_field6,extend_field7,extend_field8,extend_field9,extend_field10,business_data,prefix_desc,last_call,record_state,call_totalcount,ivr_data,platform_id,area_code,tone_detect_type,tone_detect_result");
        CreateIsvTaskResultBO resultBO = this.predictiveTaskService.createTask(createPreTask);
        if (null == resultBO) {
            log.error("========\u521b\u5efaisv\u4efb\u52a1\u5931\u8d25========");
        }
        if (0 != resultBO.getStatus()) {
            throw new RuntimeException(resultBO.getMessage());
        }
        resultBO.setCreateParam(JSONObject.toJSONString((Object)createPreTask));
        ChildTaskBO childTaskBO = new ChildTaskBO();
        childTaskBO.setIvrTaskId(resultBO.getTaskId());
        childTaskBO.setIvrListId(resultBO.getListId());
        childTaskBO.setTenantCode(tenantID);
        childTaskBO.setTaskId(taskID);
        childTaskBO.setCreateParam(resultBO.getCreateParam());
        this.taskInfoService.addChildTask(childTaskBO);
        return resultBO;
    }

    public void modifyIsvTask(String taskID, String tenantID) {
        this.modifyIsvTask(taskID, tenantID, null);
    }

    public void updateIsvTask(String taskID, String tenantID) {
        this.updateTask(taskID, tenantID, null);
    }

    public void modifyPredictive(String taskID, String tenantID) {
        TaskInfoBO taskInfoBO = this.getTaskInfo(taskID, tenantID);
        if (null == taskInfoBO) {
            log.info("============\u672a\u77e5\u7684\u4efb\u52a1:taskID:{},tenantID", (Object)taskID, (Object)tenantID);
            return;
        }
        if ("1".equals(taskInfoBO.getCallType())) {
            log.info("=====\u9884\u89c8\u5f0f\u4efb\u52a1\u4e0d\u9700\u8981\u53d8\u66f4ISV\u5916\u547c\u4efb\u52a1=====");
            return;
        }
        this.commonCheak(taskID, tenantID, taskInfoBO);
        if (StringUtils.isEmpty((Object)taskInfoBO.getIvrListId())) {
            this.createIsvTask(taskID, tenantID);
            return;
        }
        ArrayList<TaskTacticsBO> tacticss = null;
        CallRateConfigBO callRateBO = this.callRateConfigService.getCallRateBO(tenantID);
        if (null != callRateBO) {
            tacticss = new ArrayList();
            TaskTacticsBO bo = new TaskTacticsBO();
            bo.setMaxQueue(callRateBO.getMaxQueue());
            bo.setPredictionDivisor(callRateBO.getMicroParam());
            bo.setNextInterval(null == callRateBO.getNextNumberTime() ? null : Integer.valueOf(callRateBO.getNextNumberTime().intValue()));
            tacticss.add(bo);
        } else {
            tacticss = this.taskTacticsService.qryTacticsByTaskID(taskID, tenantID);
        }
        this.modifyPredictive(taskInfoBO, tacticss);
    }

    public void modifyIsvTask(String taskID, String tenantID, TaskInfoBO taskInfo) {
        TaskInfoBO taskInfoBO = taskInfo;
        if (null == taskInfoBO) {
            taskInfoBO = this.getTaskInfo(taskID, tenantID);
        }
        if ("1".equals(taskInfoBO.getCallType())) {
            log.info("=====\u9884\u89c8\u5f0f\u4efb\u52a1\u4e0d\u9700\u8981\u53d8\u66f4ISV\u5916\u547c\u4efb\u52a1=====");
        }
        this.commonCheak(taskID, tenantID, taskInfoBO);
        if (StringUtils.isEmpty((Object)taskInfoBO.getIvrListId())) {
            this.createIsvTask(taskID, tenantID);
            return;
        }
        List tacticss = this.taskTacticsService.qryTacticsByTaskID(taskID, tenantID);
        this.modifyPeriod(taskInfoBO, tacticss);
        CallRateConfigBO callRateBO = this.callRateConfigService.getCallRateBO(tenantID);
        if (null == callRateBO) {
            this.modifyPredictive(taskInfoBO, tacticss);
        }
        this.updateTask(taskID, tenantID, taskInfoBO);
    }

    private void updateTask(String taskID, String tenantID, TaskInfoBO taskInfoBO) {
        TaskInfoBO taskInfo = taskInfoBO;
        if (null == taskInfo) {
            taskInfo = this.getTaskInfo(taskID, tenantID);
        }
        UpdateTaskBO updateTask = new UpdateTaskBO();
        updateTask.setTaskId(taskInfo.getIvrTaskId());
        if (null == taskInfo.getCallType() || "0".equals(taskInfo.getCallType())) {
            Rsp rsp = this.skillGroupInterService.getSkillGroupInfo(taskInfo.getSkillId(), taskInfo.getTenantId());
            if (rsp.isSuccess()) {
                DcSkillGroupInfoBO skillGroup = (DcSkillGroupInfoBO)rsp.getData();
                updateTask.setSkillCode(skillGroup.getSkillGroupCode());
                updateTask.setAcdDn(skillGroup.getAcdDn());
            }
        } else if ("2".equals(taskInfo.getCallType())) {
            updateTask.setHuntGroupDn(this.codeConfig.getCodeStrValue(CodeConfig.CODE_BUSI.SYS_PARAM, CodeConfig.CODE_NAME.HUNT_GROUP_DN));
        }
        updateTask.setCallAni(taskInfo.getCalling());
        BaseBO base = this.predictiveTaskService.updateTask(updateTask);
        if (null == base && 0 != base.getStatus()) {
            log.warn("{}\u66f4\u65b0\u5916\u547c\u4efb\u52a1\u5931\u8d25:{},\u7ed3\u679c\uff1a{}", new Object[]{taskID, JSONObject.toJSONString((Object)updateTask), JSONObject.toJSONString((Object)base)});
            throw new RuntimeException(base.getMessage());
        }
        log.info("{}\u66f4\u65b0\u5916\u547c\u4efb\u52a1\u6210\u529f:{}", (Object)taskID, (Object)JSONObject.toJSONString((Object)updateTask));
    }

    private void modifyPredictive(TaskInfoBO taskInfoBO, List<TaskTacticsBO> tacticss) {
        if (null == tacticss && tacticss.isEmpty()) {
            return;
        }
        TaskTacticsBO tacticsBO = tacticss.get(0);
        if (null == tacticsBO) {
            return;
        }
        AdjustTaskBO adjustTaskBO = new AdjustTaskBO();
        adjustTaskBO.setMaxCallCount(tacticsBO.getMaxCallCount());
        adjustTaskBO.setMaxQueue(null == tacticsBO.getMinStartSeats() || tacticsBO.getMinStartSeats() <= 0 ? (null == tacticsBO.getMaxQueue() || tacticsBO.getMaxQueue() <= 0 ? this.maxQueue : tacticsBO.getMaxQueue()) : tacticsBO.getMinStartSeats());
        adjustTaskBO.setTuneParam(tacticsBO.getPredictionDivisor());
        adjustTaskBO.setNextInterval(tacticsBO.getNextInterval());
        adjustTaskBO.setRetryCount(tacticsBO.getRetryCount());
        adjustTaskBO.setRetryInterval(tacticsBO.getRetryInterval());
        adjustTaskBO.setTaskId(taskInfoBO.getIvrTaskId());
        BaseBO rspBO = this.predictiveTaskService.adjustTask(adjustTaskBO);
        if (rspBO != null && 0 != rspBO.getStatus()) {
            log.warn("{}\u66f4\u65b0\u5916\u547c\u4efb\u52a1\u9884\u6d4b\u56e0\u5b50\u5931\u8d25:{},\u7ed3\u679c\uff1a{}", new Object[]{taskInfoBO.getTaskId(), JSONObject.toJSONString((Object)adjustTaskBO), JSONObject.toJSONString((Object)rspBO)});
            throw new RuntimeException(rspBO.getMessage());
        }
    }

    private void modifyPeriod(TaskInfoBO taskInfo, List<TaskTacticsBO> tacticss) {
        PeriodInfoBO periodInfo = this.createPeriodInfo(taskInfo, tacticss, false);
        UpdatePeriodBO updatePeriod = new UpdatePeriodBO();
        updatePeriod.setPeriodList(periodInfo.getPeriodList());
        updatePeriod.setTaskId(taskInfo.getIvrTaskId());
        BaseBO rspBO = this.predictiveTaskService.updatePeriod(updatePeriod);
        if (rspBO != null && 0 == rspBO.getStatus()) {
            return;
        }
        if (rspBO != null) {
            log.warn("{}\u66f4\u65b0\u5916\u547c\u4efb\u52a1\u65f6\u6bb5\u5931\u8d25:{},\u7ed3\u679c\uff1a{}", new Object[]{taskInfo.getTaskId(), JSONObject.toJSONString((Object)taskInfo), JSONObject.toJSONString((Object)rspBO)});
            throw new RuntimeException(rspBO.getMessage());
        }
    }

    private void modifyPeriodByStart(TaskInfoBO taskInfo, List<TaskTacticsBO> tacticss) {
        PeriodInfoBO periodInfo = this.createPeriodInfo(taskInfo, tacticss, true);
        UpdatePeriodBO updatePeriod = new UpdatePeriodBO();
        updatePeriod.setPeriodList(periodInfo.getPeriodList());
        updatePeriod.setTaskId(taskInfo.getIvrTaskId());
        BaseBO rspBO = this.predictiveTaskService.updatePeriod(updatePeriod);
        if (rspBO != null && 0 == rspBO.getStatus()) {
            return;
        }
        if (rspBO != null) {
            log.warn("{}\u66f4\u65b0\u5916\u547c\u4efb\u52a1\u65f6\u6bb5\u5931\u8d25:{},\u7ed3\u679c\uff1a{}", new Object[]{taskInfo.getTaskId(), JSONObject.toJSONString((Object)taskInfo), JSONObject.toJSONString((Object)rspBO)});
            throw new RuntimeException(rspBO.getMessage());
        }
    }

    public void startIsvTask(String taskID, String tenantID) {
        this.startIsvTask(taskID, tenantID, false);
    }

    private void startIsvTask(String taskID, String tenantID, boolean isTest) {
        TaskInfoBO taskInfo = this.getTaskInfo(taskID, tenantID);
        if ("1".equals(taskInfo.getCallType())) {
            log.info("=====\u9884\u89c8\u5f0f\u4efb\u52a1\u4e0d\u9700\u8981\u542f\u52a8ISV\u5916\u547c\u4efb\u52a1=====");
            return;
        }
        this.commonCheak(taskID, tenantID, taskInfo);
        if (StringUtils.isEmpty((Object)taskInfo.getIvrTaskId())) {
            this.createIsvTask(taskID, tenantID);
            taskInfo = this.getTaskInfo(taskID, tenantID);
            if (StringUtils.isEmpty((Object)taskInfo.getIvrTaskId())) {
                throw new RuntimeException("\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
        }
        if (taskInfo.getCallType().equals("2")) {
            List tacticss = this.taskTacticsService.qryTacticsByTaskID(taskID, tenantID);
            if (isTest) {
                this.modifyPeriod(taskInfo, tacticss);
            } else {
                this.modifyPeriodByStart(taskInfo, tacticss);
            }
        }
        StartTaskBO startTask = new StartTaskBO();
        startTask.setTaskId(taskInfo.getIvrTaskId());
        BaseBO rsp = this.predictiveTaskService.startTask(startTask);
        if (null != rsp && 0 == rsp.getStatus()) {
            return;
        }
        if (206 == rsp.getStatus()) {
            log.info("\u4efb\u52a1\u5df2\u8fd0\u884c\uff1a{}", (Object)rsp.getMessage());
            return;
        }
        if (0 != rsp.getStatus()) {
            throw new RuntimeException(rsp.getMessage());
        }
    }

    public void endIsvTask(String taskID, String tenantID) {
        TaskInfoBO taskInfo = this.getTaskInfo(taskID, tenantID);
        if ("1".equals(taskInfo.getCallType())) {
            log.info("=====\u9884\u89c8\u5f0f\u4efb\u52a1\u4e0d\u9700\u8981\u7ed3\u675fISV\u5916\u547c\u4efb\u52a1=====");
            return;
        }
        this.commonCheak(taskID, tenantID, taskInfo);
        if (StringUtils.isEmpty((Object)taskInfo.getIvrTaskId())) {
            throw new RuntimeException("\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        EndTaskBO endTaskBO = new EndTaskBO();
        endTaskBO.setTaskId(taskInfo.getIvrTaskId());
        BaseBO rsp = this.predictiveTaskService.endTask(endTaskBO);
        if (0 != rsp.getStatus()) {
            throw new RuntimeException(rsp.getMessage());
        }
    }

    public void stopIsvTask(String taskID, String tenantID) {
        TaskInfoBO taskInfo = this.getTaskInfo(taskID, tenantID);
        if ("1".equals(taskInfo.getCallType())) {
            log.info("=====\u9884\u89c8\u5f0f\u4efb\u52a1\u4e0d\u9700\u8981\u505c======");
            return;
        }
        this.commonCheak(taskID, tenantID, taskInfo);
        if (StringUtils.isEmpty((Object)taskInfo.getIvrTaskId())) {
            throw new OcsException("\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        StopTaskBO stopTaskBO = new StopTaskBO();
        stopTaskBO.setTaskId(taskInfo.getIvrTaskId());
        BaseBO rsp = this.predictiveTaskService.stopTask(stopTaskBO);
        if (0 != rsp.getStatus()) {
            throw new OcsException(rsp.getMessage());
        }
    }

    public void testCall(String taskID, String tenantID, String called, TaskInfoBO taskInfo) throws InterruptedException {
        try {
            BaseBO rsp;
            if (null == taskInfo) {
                taskInfo = this.getTaskInfo(taskID, tenantID);
            }
            if ("1".equals(taskInfo.getCallType())) {
                log.info("======\u9884\u6d4b\u5f0f\u4efb\u52a1\u65e0\u6cd5\u8bd5\u547c======");
                return;
            }
            this.commonCheak(taskID, tenantID, taskInfo);
            if (StringUtils.isEmpty((Object)taskInfo.getIvrTaskId())) {
                CreateIsvTaskResultBO resultBO = this.createIsvTask(taskID, tenantID);
                if (null != resultBO) {
                    taskInfo.setIvrTaskId(resultBO.getTaskId());
                    taskInfo.setIvrListId(resultBO.getListId());
                }
                if (StringUtils.isEmpty((Object)taskInfo.getIvrTaskId()) || StringUtils.isEmpty((Object)taskInfo.getIvrListId())) {
                    throw new OcsException("\u8bd5\u547c\u5931\u8d25\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                }
            }
            if (!"running".equals(taskInfo.getTaskStatus())) {
                this.barredCall(taskInfo);
                this.startIsvTask(taskID, tenantID, true);
            }
            ImportBO importBO = new ImportBO();
            importBO.setType("json");
            importBO.setTaskId(taskInfo.getIvrTaskId());
            importBO.setListId(taskInfo.getIvrListId());
            ListData listData = new ListData();
            ArrayList<ListInfoBO> datas = new ArrayList<ListInfoBO>();
            ListInfoBO listInfo = new ListInfoBO();
            String custID = UUID.randomUUID().toString();
            listInfo.setOriginId(custID);
            listInfo.setPhoneNumber1(called);
            listInfo.setBusinessData(this.getVoiceFileByTaskID(taskInfo));
            listInfo.setCustId(custID);
            listInfo.setExtendField1("Test");
            listInfo.setExtendField10(this.getExtendField10(called));
            datas.add(listInfo);
            listData.setData(datas);
            importBO.setListData(listData);
            ImportBO importResult = this.listService.importListJSON(importBO);
            String batchID = null;
            if (null != importResult) {
                batchID = importResult.getBatchId();
            }
            if (!StringUtils.isEmpty(batchID)) {
                TestCallBO testCallBO = new TestCallBO();
                testCallBO.setBatchId(batchID);
                testCallBO.setTaskId(taskInfo.getIvrTaskId());
                testCallBO.setCustId(custID);
                rsp = this.predictiveTaskService.testCall(testCallBO);
                if (rsp != null && 0 != rsp.getStatus()) {
                    for (int i = 0; i < 3; ++i) {
                        Thread.sleep(3000L);
                        rsp = this.predictiveTaskService.testCall(testCallBO);
                        if (rsp != null && 0 == rsp.getStatus()) break;
                    }
                }
            } else {
                throw new OcsException("\u5bfc\u5165\u5f85\u547c\u6570\u636e\u5931\u8d25");
            }
            log.info("\u8bd5\u547cresult :{}", (Object)JSONObject.toJSONString((Object)rsp));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            if (e instanceof OcsException) {
                throw e;
            }
            throw new OcsException("\u8bd5\u547c\u5931\u8d25");
        }
    }

    public MonitorTaskBO monitorTask(String tenantId, String taskId) {
        if (StringUtils.isEmpty((Object)tenantId) || StringUtils.isEmpty((Object)taskId)) {
            return null;
        }
        TaskInfoBO taskInfo = this.getTaskInfo(taskId, tenantId);
        this.commonCheak(taskId, tenantId, taskInfo);
        MonitorTaskReqBO request = new MonitorTaskReqBO();
        request.setTaskId(taskInfo.getIvrTaskId());
        BaseBO rsp = this.predictiveTaskService.monitorTask(request);
        if (null == rsp) {
            return null;
        }
        if (0 != rsp.getStatus()) {
            return null;
        }
        return (MonitorTaskBO)rsp.getResult();
    }

    private void barredCall(TaskInfoBO taskInfo) {
        QueryPeriodBO queryPeriodBO = new QueryPeriodBO();
        queryPeriodBO.setTaskId(taskInfo.getIvrTaskId());
        QueryPeriodResultBO periodResultBO = this.predictiveTaskService.queryPeriod(queryPeriodBO);
        if (0 != periodResultBO.getStatus()) {
            this.modifyPeriod(taskInfo, null);
            return;
        }
        List periods = periodResultBO.getRows();
        if (null == periods || periods.isEmpty()) {
            this.modifyPeriod(taskInfo, null);
            return;
        }
        boolean isAllDayBarred = false;
        for (PeriodBO periodBO : periods) {
            if (!"N".equals(periodBO.getPeriodType()) || !"00:00:00".equals(periodBO.getStartTime()) || !"23:59:59".equals(periodBO.getEndTime())) continue;
            isAllDayBarred = true;
            break;
        }
        if (!isAllDayBarred) {
            this.modifyPeriod(taskInfo, null);
        }
    }

    public void delIsvTask(String taskID, String tenantID) {
        TaskInfoBO taskInfo = this.getTaskInfo(taskID, tenantID);
        if ("1".equals(taskInfo.getCallType())) {
            log.info("=====\u9884\u89c8\u5f0f\u4efb\u52a1\u4e0d\u9700\u8981\u5220\u9664ISV\u5916\u547c\u4efb\u52a1======");
            return;
        }
        this.commonCheak(taskID, tenantID, taskInfo);
        if (StringUtils.isEmpty((Object)taskInfo.getIvrTaskId())) {
            throw new OcsException("\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        StopTaskBO stopTaskBO = new StopTaskBO();
        stopTaskBO.setTaskId(taskInfo.getIvrTaskId());
        BaseBO rsp = this.predictiveTaskService.stopTask(stopTaskBO);
        if (0 != rsp.getStatus()) {
            throw new OcsException(rsp.getMessage());
        }
    }

    TaskInfoBO getTaskInfo(String taskID, String tenantID) {
        TaskInfoBO taskInfo = new TaskInfoBO();
        taskInfo.setTaskId(taskID);
        taskInfo.setTenantId(tenantID);
        return this.taskBusiService.qryTask(taskInfo);
    }

    void commonCheak(String taskID, String tenantID, TaskInfoBO taskInfoBO) {
        if (StringUtils.isEmpty((Object)taskID) || StringUtils.isEmpty((Object)tenantID)) {
            throw new OcsException("Unknown taskID or tenantID");
        }
        if (null == taskInfoBO) {
            throw new OcsException("Unknown task");
        }
    }

    private PeriodInfoBO createPeriodInfo(TaskInfoBO taskInfo, List<TaskTacticsBO> tacticss, boolean isStart) {
        PeriodInfoBO periodInfo = new PeriodInfoBO();
        ArrayList<PeriodBO> periodList = new ArrayList<PeriodBO>();
        periodInfo.setPeriodList(periodList);
        try {
            if (!StringUtils.isEmpty((Object)taskInfo.getIvrTaskId())) {
                periodInfo.setPeriodId(taskInfo.getIvrTaskId());
            }
            if ("2".equals(taskInfo.getCallType()) && !isStart) {
                PeriodBO periodBO = new PeriodBO();
                periodBO.setPeriodType("N");
                periodBO.setStartTime("00:00:00");
                periodBO.setEndTime("23:59:59");
                periodList.add(periodBO);
                return periodInfo;
            }
            if (tacticss == null || tacticss.isEmpty()) {
                PeriodBO periodBO = new PeriodBO();
                periodBO.setPeriodType("Y");
                periodBO.setStartTime("10:00:00");
                periodBO.setEndTime("21:00:00");
                periodList.add(periodBO);
                return periodInfo;
            }
            String startTimeStr = taskInfo.getStartTime();
            String endTimeStr = taskInfo.getEndTime();
            SimpleDateFormat format = new SimpleDateFormat(this.dateFormat);
            SimpleDateFormat format1 = new SimpleDateFormat(this.ymdDateFormat);
            Date startDay = format1.parse(startTimeStr);
            Date endDay = format1.parse(endTimeStr);
            String endDayStr = format1.format(endDay);
            String currentStr = format.format(new Date());
            Calendar cal = Calendar.getInstance();
            cal.set(10, 0);
            cal.set(13, 0);
            cal.set(12, 0);
            cal.set(14, 0);
            if (startDay.before(cal.getTime())) {
                startDay = cal.getTime();
            }
            cal.setTime(startDay);
            int differentDays = this.differentDaysByMillisecond(startDay, endDay);
            for (int index = 0; index <= differentDays; ++index) {
                log.debug("current time :{}", (Object)cal.getTime());
                for (TaskTacticsBO tacticsBO : tacticss) {
                    int dayOfWeek = cal.get(7) - 1;
                    String week = this.WEEK[dayOfWeek];
                    if (!week.equals(tacticsBO.getWeek())) continue;
                    PeriodBO periodBO = new PeriodBO();
                    String strformat = format1.format(cal.getTime());
                    String star = strformat + " " + tacticsBO.getStartTime();
                    String end = strformat + " " + tacticsBO.getEndTime();
                    if (currentStr.compareTo(end) > 0) continue;
                    if (star.compareTo(startTimeStr) < 0) {
                        star = startTimeStr;
                    }
                    if (end.compareTo(endTimeStr) > 0 && strformat.equals(endDayStr)) {
                        end = endTimeStr;
                    }
                    periodBO.setPeriodType("Y");
                    periodBO.setStartTime(star);
                    periodBO.setEndTime(end);
                    periodList.add(periodBO);
                }
                cal.add(5, 1);
            }
        }
        catch (Exception e) {
            log.info(e.getMessage(), (Throwable)e);
        }
        return periodInfo;
    }

    private int differentDaysByMillisecond(Date startDay, Date endDay) {
        return (int)((endDay.getTime() - startDay.getTime()) / 86400000L);
    }

    private boolean isCanUploadRollcall(List<TaskTacticsBO> tacticss) {
        if (tacticss.isEmpty()) {
            return true;
        }
        Calendar cal = Calendar.getInstance();
        int dayOfWeek = cal.get(7) - 1;
        String week = this.WEEK[dayOfWeek];
        for (TaskTacticsBO tacticsBO : tacticss) {
            if (!week.equals(tacticsBO.getWeek())) continue;
            return true;
        }
        return false;
    }

    private PrefixInfoBO createPrefixInfo(TaskInfoBO taskInfo) {
        PrefixInfoBO prefixInfo = new PrefixInfoBO();
        prefixInfo.setOutPrefix(this.codeConfig.getCodeStrValue(CodeConfig.CODE_BUSI.SYS_PARAM, CodeConfig.CODE_NAME.OUT_PREFIX));
        ArrayList<CallerBO> callers = new ArrayList<CallerBO>();
        CallerBO caller = new CallerBO();
        caller.setCallerNo(taskInfo.getCalling());
        callers.add(caller);
        prefixInfo.setCallerList(callers);
        return prefixInfo;
    }

    private ListInfoFormatBO getListFormat() {
        ListInfoFormatBO format = new ListInfoFormatBO();
        format.setBusinessData("businessData");
        format.setCustId("custId");
        format.setPhoneNumber1("phoneNumber1");
        format.setAppointBegin("appointBegin");
        format.setAppointEnd("appointEnd");
        format.setExtendField1("extendField1");
        format.setExtendField9("extendField9");
        format.setExtendField10("extendField10");
        return format;
    }

    private String getStatusUrl(TaskInfoBO toCallTask) {
        StringBuffer statusUrl = new StringBuffer(this.callStatusBack);
        if (!this.callStatusBack.endsWith("?")) {
            statusUrl.append("?");
        }
        statusUrl.append("callType=").append(toCallTask.getCallType()).append("&");
        statusUrl.append("tenantId=").append(toCallTask.getTenantId()).append("&");
        statusUrl.append("taskId=").append(toCallTask.getTaskId());
        return statusUrl.toString();
    }

    private String getResultBack(TaskInfoBO toCallTask) {
        StringBuffer back = new StringBuffer(this.callResultBack);
        if (!this.callResultBack.endsWith("?")) {
            back.append("?");
        }
        back.append("callType=").append(toCallTask.getCallType()).append("&");
        back.append("tenantCode=").append(toCallTask.getTenantId()).append("&");
        back.append("taskId=").append(toCallTask.getTaskId()).append("&");
        back.append("taskType=").append(toCallTask.getTaskType());
        return back.toString();
    }

    private String getExceptionUrl(TaskInfoBO toCallTask) {
        StringBuffer exception = new StringBuffer(this.exceptionUrl);
        if (!this.exceptionUrl.endsWith("?")) {
            exception.append("?");
        }
        exception.append("callType=").append(toCallTask.getCallType()).append("&");
        exception.append("tenantId=").append(toCallTask.getTenantId()).append("&");
        exception.append("taskId=").append(toCallTask.getTaskId());
        return exception.toString();
    }

    private String getVoiceFileByTaskID(TaskInfoBO taskInfoBO) {
        if (!"2".equals(taskInfoBO.getCallType())) {
            return null;
        }
        if (!StringUtils.isEmpty((Object)taskInfoBO.getVoiceUrl())) {
            return taskInfoBO.getVoiceUrl();
        }
        QueryTaskVoiceRspBO taskVoiceRspBO = this.taskConfigRelationService.queryTaskVoice(taskInfoBO.getTaskId());
        if (null == taskVoiceRspBO) {
            return null;
        }
        return taskVoiceRspBO.getVoiceUrl();
    }

    private String getExtendField10(String mobileNo) {
        if (this.isOut) {
            return null;
        }
        String areaCode = "0991";
        String explicitNum = this.getExplicitNum(mobileNo);
        return areaCode + "@@" + explicitNum;
    }

    private String getExplicitNum(String mobileNo) {
        PortraitNewPO portraitNewPO = this.portraitNewDAO.selectByPrimaryKey(mobileNo);
        if (null != portraitNewPO && !StringUtils.isEmpty((Object)portraitNewPO.getExpNumber())) {
            return portraitNewPO.getExpNumber();
        }
        return "10016";
    }
}

