/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.busi.impl;

import com.alibaba.fastjson.JSON;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.ftp.FtpConfigBean;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.ocs.bo.OcsDownLoadReqBO;
import com.tydic.nicc.ocs.bo.OcsDownLoadRspBO;
import com.tydic.nicc.ocs.bo.OcsUploadReqBO;
import com.tydic.nicc.ocs.bo.OcsUploadRspBO;
import com.tydic.nicc.ocs.service.OCSFileService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OcsFileServiceImp
implements OCSFileService {
    private static final Logger log = LoggerFactory.getLogger(OcsFileServiceImp.class);
    @Value(value="${file.path.ftUrl}")
    private String ftpUrl;
    @Value(value="${file.downLoad.saveUrl}")
    private String downLoadSaveUrl;
    @Resource
    private FtpConfigBean ftpConfigBean;
    public static final String SEP_STR = "/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rsp ocsDownLoad(OcsDownLoadReqBO reqBO) {
        OcsDownLoadRspBO downLoadRspBO = new OcsDownLoadRspBO();
        String directory = reqBO.getDirectory();
        if (StringUtils.isEmpty((CharSequence)directory)) {
            log.info("\u4e0b\u8f7d\u8def\u5f84\u4e3a\u7a7a\uff01,\u542f\u7528\u9ed8\u8ba4\u8def\u5f84");
            directory = this.ftpConfigBean.getHomeDir();
        }
        String downloadFile = reqBO.getDownloadFile();
        String saveFile = reqBO.getSaveFile();
        File path = new File(this.downLoadSaveUrl);
        if (!path.exists()) {
            log.info("\u6587\u4ef6\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c\u65b0\u5efa\u76ee\u5f55");
            path.mkdirs();
        }
        saveFile = this.downLoadSaveUrl + downloadFile;
        Session session = null;
        Channel channel = null;
        FileOutputStream outputStream = null;
        try {
            JSch jSch = new JSch();
            session = jSch.getSession(this.ftpConfigBean.getUsername(), this.ftpConfigBean.getHost(), this.ftpConfigBean.getPort().intValue());
            Properties sshConfig = new Properties();
            sshConfig.put("StrictHostKeyChecking", "no");
            session.setConfig(sshConfig);
            session.setPassword(this.ftpConfigBean.getPassword());
            session.connect();
            channel = session.openChannel("sftp");
            channel.connect();
            ChannelSftp sftp = (ChannelSftp)channel;
            sftp.cd(directory);
            File file = null;
            try {
                file = new File(saveFile);
            }
            catch (Exception e) {
                log.info("\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u65b0\u5efa\u6587\u4ef6");
                file.mkdir();
                e.printStackTrace();
            }
            outputStream = new FileOutputStream(file);
            sftp.get(downloadFile, (OutputStream)outputStream);
            outputStream.flush();
            downLoadRspBO.setRespCode("0000");
            downLoadRspBO.setFileName(downloadFile);
            downLoadRspBO.setFilePath(saveFile);
            System.out.println("downLoad is success,session is closed");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (session != null) {
                session.disconnect();
            }
            if (channel != null) {
                channel.disconnect();
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return BaseRspUtils.createSuccessRsp((Object)downLoadRspBO, (String)"\u4e0b\u8f7d\u6210\u529f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OcsUploadRspBO ocsUpload(OcsUploadReqBO reqBO) {
        OcsUploadRspBO uploadRspBO = new OcsUploadRspBO();
        log.info("\u4e0a\u4f20\u6587\u4ef6\u5165\u53c2={}", (Object)JSON.toJSONString((Object)reqBO));
        String uploadFileName = reqBO.getUploadFileName();
        String uploadPath = reqBO.getUploadPath();
        if (StringUtils.isEmpty((CharSequence)uploadFileName)) {
            log.info("\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            uploadRspBO.setRespDesc("\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            uploadRspBO.setMessage("\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            uploadRspBO.setCode("8888");
            uploadRspBO.setRespCode("8888");
            return uploadRspBO;
        }
        if (StringUtils.isEmpty((CharSequence)uploadPath)) {
            log.info("\u4e0a\u4f20\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
            uploadRspBO.setRespDesc("\u4e0a\u4f20\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
            uploadRspBO.setMessage("\u4e0a\u4f20\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
            uploadRspBO.setCode("8888");
            uploadRspBO.setRespCode("8888");
            return uploadRspBO;
        }
        File file = new File(uploadPath);
        FileInputStream inputStream = null;
        log.info("\u5f00\u59cb\u4e0a\u4f20\u6587\u4ef6\u5230\u6587\u4ef6\u670d\u52a1\u5668");
        try {
            inputStream = new FileInputStream(file);
            JSch jsch = new JSch();
            Session sshSession = jsch.getSession(this.ftpConfigBean.getUsername(), this.ftpConfigBean.getHost(), this.ftpConfigBean.getPort().intValue());
            Properties sshConfig = new Properties();
            sshConfig.put("StrictHostKeyChecking", "no");
            sshSession.setConfig(sshConfig);
            sshSession.setPassword(this.ftpConfigBean.getPassword());
            sshSession.connect();
            Channel channel = sshSession.openChannel("sftp");
            channel.connect();
            ChannelSftp sftp = (ChannelSftp)channel;
            try {
                sftp.cd(this.ftpConfigBean.getHomeDir());
                log.info("uploadFilePath = {}", (Object)this.ftpConfigBean.getHomeDir());
            }
            catch (SftpException e) {
                log.warn("directory is not exist");
                sftp.mkdir(this.ftpConfigBean.getHomeDir());
                sftp.cd(this.ftpConfigBean.getHomeDir());
            }
            sftp.put((InputStream)inputStream, uploadFileName);
            log.info("\u4e0a\u4f20\u76ee\u5f55\u4e0b\u6587\u4ef6\u540d");
            if (sftp.isConnected()) {
                sftp.disconnect();
            }
            if (sftp.getSession().isConnected()) {
                sftp.getSession().disconnect();
            }
            log.info("file:{" + uploadFileName + "} is upload successful");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        uploadRspBO.setFilePath(OcsFileServiceImp.concatFilePath(this.ftpUrl, uploadFileName));
        uploadRspBO.setFileName(uploadFileName);
        uploadRspBO.setFileOriginalName(uploadFileName);
        uploadRspBO.setCode("0000");
        uploadRspBO.setSuccess(Boolean.valueOf(true));
        uploadRspBO.setRespCode("0000");
        uploadRspBO.setMessage("\u4e0a\u4f20\u6210\u529f");
        uploadRspBO.setRespDesc("\u4e0a\u4f20\u6210\u529f");
        return uploadRspBO;
    }

    public static String concatFilePath(String path1, String path2) {
        if (path1.endsWith(SEP_STR) && path2.startsWith(SEP_STR)) {
            return path1 + path2.substring(1, path2.length());
        }
        if (!path1.endsWith(SEP_STR) && !path2.startsWith(SEP_STR)) {
            return path1 + SEP_STR + path2;
        }
        return path1 + path2;
    }
}

