/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.tydic.nicc.dc.base.bo.Req;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.bladetenant.inter.BladeTenantInterService;
import com.tydic.nicc.dc.bo.bladetenant.BladeTenantBO;
import com.tydic.nicc.dc.bo.bladetenant.GetBladeTenantInfoReqBO;
import com.tydic.nicc.dc.bo.bladetenant.GetBladeTenantInfoRspBO;
import com.tydic.nicc.dc.bo.bladetenant.GetBladeTenantListReqBO;
import com.tydic.nicc.dc.bo.bladetenant.GetBladeTenantListRspBO;
import com.tydic.nicc.dc.bo.jobNumber.QueryJobNumberRecordInfoBO;
import com.tydic.nicc.dc.bo.script.QryConfigScriptRspBO;
import com.tydic.nicc.dc.bo.user.BladeUserBO;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.jobNumber.inter.DcJobNumberInterService;
import com.tydic.nicc.dc.script.inter.ScriptInterService;
import com.tydic.nicc.dc.user.inter.BladeUserInterService;
import com.tydic.nicc.ocs.bo.CalculationFormulaReqBO;
import com.tydic.nicc.ocs.bo.CalculationReqBO;
import com.tydic.nicc.ocs.bo.EvaluateTenantInfoBO;
import com.tydic.nicc.ocs.bo.ExportRspBO;
import com.tydic.nicc.ocs.bo.GrabTaskStatisticsReqBO;
import com.tydic.nicc.ocs.bo.MarketingTimedTaskReq;
import com.tydic.nicc.ocs.bo.NumberAttributeReq;
import com.tydic.nicc.ocs.bo.OcsUploadReqBO;
import com.tydic.nicc.ocs.bo.OcsUploadRspBO;
import com.tydic.nicc.ocs.bo.QryNumberAttributeReqBO;
import com.tydic.nicc.ocs.bo.QryNumberAttributeRspBO;
import com.tydic.nicc.ocs.bo.QryScriptStatisticReqBO;
import com.tydic.nicc.ocs.bo.QryScriptStatisticsRspBO;
import com.tydic.nicc.ocs.bo.QryTenantActNationCustReqBO;
import com.tydic.nicc.ocs.bo.QryTenantActNationCustRspBO;
import com.tydic.nicc.ocs.bo.QryTenantEvaluateReqBO;
import com.tydic.nicc.ocs.bo.QueryAttributeDataReqBO;
import com.tydic.nicc.ocs.bo.QueryAttributeDataRspBO;
import com.tydic.nicc.ocs.bo.QueryGrabStatisticsReqBO;
import com.tydic.nicc.ocs.bo.QueryGrabStatisticsRspBO;
import com.tydic.nicc.ocs.bo.QueryMarketingTaskReqBO;
import com.tydic.nicc.ocs.bo.QueryMarketingTaskRspBO;
import com.tydic.nicc.ocs.bo.QuerySubScribeRecordReqBO;
import com.tydic.nicc.ocs.bo.QuerySubscribeRecordRspBO;
import com.tydic.nicc.ocs.bo.QueryTenantDataReqBO;
import com.tydic.nicc.ocs.bo.QueryTenantDataRspBO;
import com.tydic.nicc.ocs.bo.QueryTenantEvaluateRspBO;
import com.tydic.nicc.ocs.bo.QueryTenantStatisticsDataReqBO;
import com.tydic.nicc.ocs.bo.QueryTenantStatisticsDataRspBO;
import com.tydic.nicc.ocs.bo.TenantComplainInfoBO;
import com.tydic.nicc.ocs.bo.TenantDataReqBO;
import com.tydic.nicc.ocs.bo.TenantEvaluateTaskReqBO;
import com.tydic.nicc.ocs.cache.AreaCache;
import com.tydic.nicc.ocs.mapper.DcGeneralCodeDAO;
import com.tydic.nicc.ocs.mapper.ObAreaDAO;
import com.tydic.nicc.ocs.mapper.ObCallRecordAnswerMapper;
import com.tydic.nicc.ocs.mapper.ObCallRecordDAO;
import com.tydic.nicc.ocs.mapper.ObCustServeRecordDAO;
import com.tydic.nicc.ocs.mapper.ObDataTargetDAO;
import com.tydic.nicc.ocs.mapper.ObGrabStatisticsMapper;
import com.tydic.nicc.ocs.mapper.ObMarketingTaskStatisticsMapper;
import com.tydic.nicc.ocs.mapper.ObNumberAttributionStatisticsMapper;
import com.tydic.nicc.ocs.mapper.ObProductSubscribeDAO;
import com.tydic.nicc.ocs.mapper.ObScriptRecordStatisticsMapper;
import com.tydic.nicc.ocs.mapper.ObSubscribeRecordMapper;
import com.tydic.nicc.ocs.mapper.ObTaskInfoDAO;
import com.tydic.nicc.ocs.mapper.ObTaskScriptDAO;
import com.tydic.nicc.ocs.mapper.ObTaskTenantDAO;
import com.tydic.nicc.ocs.mapper.ObTenantEvaluateStatisticsMapper;
import com.tydic.nicc.ocs.mapper.ObTenantScoreMapper;
import com.tydic.nicc.ocs.mapper.ObTenantStatisticsMapper;
import com.tydic.nicc.ocs.mapper.po.AttributeDataInfoPO;
import com.tydic.nicc.ocs.mapper.po.DcGeneralCodePO;
import com.tydic.nicc.ocs.mapper.po.ObAreaPO;
import com.tydic.nicc.ocs.mapper.po.ObCallRecordAnswer;
import com.tydic.nicc.ocs.mapper.po.ObCallRecordPO;
import com.tydic.nicc.ocs.mapper.po.ObDataTargetPO;
import com.tydic.nicc.ocs.mapper.po.ObGrabStatistics;
import com.tydic.nicc.ocs.mapper.po.ObMarketingTaskStatistics;
import com.tydic.nicc.ocs.mapper.po.ObNumberAttributionStatistics;
import com.tydic.nicc.ocs.mapper.po.ObScriptRecordStatistics;
import com.tydic.nicc.ocs.mapper.po.ObSubscribeRecord;
import com.tydic.nicc.ocs.mapper.po.ObTaskInfoPO;
import com.tydic.nicc.ocs.mapper.po.ObTaskScriptPO;
import com.tydic.nicc.ocs.mapper.po.ObTaskTenantPO;
import com.tydic.nicc.ocs.mapper.po.ObTenantEvaluateStatistics;
import com.tydic.nicc.ocs.mapper.po.ObTenantScore;
import com.tydic.nicc.ocs.mapper.po.ObTenantStatistics;
import com.tydic.nicc.ocs.mapper.po.TenantDataInfoPO;
import com.tydic.nicc.ocs.service.OCSFileService;
import com.tydic.nicc.ocs.service.TimedTasks;
import com.tydic.nicc.ocs.statistics.excelbo.ExcelActSeatBO;
import com.tydic.nicc.ocs.statistics.excelbo.ExcelAttributeDataBO;
import com.tydic.nicc.ocs.statistics.excelbo.ExcelGrabStatisticsBO;
import com.tydic.nicc.ocs.statistics.excelbo.ExcelMarketingTaskBO;
import com.tydic.nicc.ocs.statistics.excelbo.ExcelNumberAttributeBO;
import com.tydic.nicc.ocs.statistics.excelbo.ExcelSubscribeRecordBO;
import com.tydic.nicc.ocs.statistics.excelbo.ExcelTenantDataBO;
import com.tydic.nicc.ocs.statistics.excelbo.ExcelTenantEvaluateBO;
import com.tydic.nicc.ocs.utils.DateUtil;
import com.tydic.nicc.ocs.utils.ExcelHelper;
import com.tydic.nicc.ocs.utils.RegularUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@DubboService
public class TimedTasksImp
implements TimedTasks {
    private static final Logger log = LoggerFactory.getLogger(TimedTasksImp.class);
    @DubboReference
    private BladeTenantInterService bladeTenantInterService;
    @DubboReference
    private ScriptInterService scriptInterService;
    @DubboReference
    private BladeUserInterService bladeUserInterService;
    @DubboReference
    private DcJobNumberInterService dcJobNumberInterService;
    @Autowired
    private ObCallRecordDAO obCallRecordDAO;
    @Autowired
    private ObTaskInfoDAO obTaskInfoDAO;
    @Autowired
    private ObCustServeRecordDAO obCustServeRecordDAO;
    @Autowired
    private ObDataTargetDAO obDataTargetDAO;
    @Autowired
    private ObMarketingTaskStatisticsMapper obMarketingTaskStatisticsMapper;
    @Resource
    private ExcelHelper excelHelper;
    @Autowired
    private ObSubscribeRecordMapper obSubscribeRecordMapper;
    @Autowired
    private ObNumberAttributionStatisticsMapper obNumberAttributionStatisticsMapper;
    @Autowired
    private ObTenantStatisticsMapper obTenantStatisticsMapper;
    @Autowired
    private ObCallRecordAnswerMapper obCallRecordAnswerMapper;
    @Autowired
    private ObScriptRecordStatisticsMapper obScriptRecordStatisticsMapper;
    @Autowired
    private ObTaskScriptDAO obTaskScriptDAO;
    @Resource
    private OCSFileService ocsFileService;
    @Autowired
    private ObTenantScoreMapper obTenantScoreMapper;
    @Autowired
    private ObTenantEvaluateStatisticsMapper obTenantEvaluateStatisticsMapper;
    @Autowired
    private ObGrabStatisticsMapper obGrabStatisticsMapper;
    @Autowired
    private DcGeneralCodeDAO dcGeneralCodeDAO;
    @Autowired
    private ObTaskTenantDAO obTaskTenantDAO;
    @Autowired
    private ObProductSubscribeDAO obProductSubscribeDAO;
    @Resource
    private ObAreaDAO obAreaDAO;
    public static final String PARENT_ID = "1";
    private static final String tenantEvaluateCode = "TENANT_EVALUATE";
    @Value(value="${file.path.ftUrl:http://192.168.10.112:8088/upload/}")
    private String path;

    @Transactional(rollbackFor={Exception.class})
    public void marketingTask(MarketingTimedTaskReq req) {
        log.info("\u8425\u9500\u4efb\u52a1\u7edf\u8ba1\u8bf7\u6c42\u5165\u53c2={}", (Object)JSON.toJSONString((Object)req));
        try {
            GetBladeTenantListRspBO tenantList = this.bladeTenantInterService.getBladeTenantList(new GetBladeTenantListReqBO());
            if (!tenantList.getRspCode().equals("0000")) {
                log.error("\u8425\u9500\u4efb\u52a1\u7edf\u8ba1\uff0c\u67e5\u8be2\u79df\u6237\u5217\u8868\u5931\u8d25");
                return;
            }
            List rows = tenantList.getRows();
            for (BladeTenantBO po : rows) {
                req.setTenantCode(po.getTenantId());
                req.setTenantOtherName(po.getTenantOtherName());
                try {
                    this.singleTenantMarketingStatistics(req);
                }
                catch (Exception e) {
                    log.error("\u8425\u9500\u4efb\u52a1\u7edf\u8ba1-\u79df\u6237{}\u51fa\u9519", (Object)req.getTenantCode());
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            log.error("\u5177\u4f53\u6267\u884c\u8425\u9500\u4efb\u52a1\u7edf\u8ba1\u5f02\u5e38 {}", (Throwable)e);
        }
    }

    public RspList<QueryMarketingTaskRspBO> queryMarketingTask(QueryMarketingTaskReqBO reqBO) {
        log.info("\u67e5\u8be2\u8425\u9500\u4efb\u52a1\u5165\u53c2={}", (Object)JSON.toJSONString((Object)reqBO));
        String startTimeStr = null;
        String endTimeStr = null;
        ArrayList tenantIds = new ArrayList();
        if (null != reqBO.getTenantIds()) {
            tenantIds.addAll(reqBO.getTenantIds());
        }
        Map<String, String> id_name = null;
        Req req = new Req();
        req.setTenantCode(reqBO.getTenantCode());
        req.setIn_tenantCode(reqBO.getIn_tenantCode());
        req.setRoleSet(reqBO.getRoleSet());
        req.setReqData(tenantIds);
        List bladeTenants = this.bladeTenantInterService.getBalseTenantList(req);
        if (bladeTenants != null && !bladeTenants.isEmpty()) {
            id_name = bladeTenants.stream().collect(Collectors.toMap(BladeTenantBO::getTenantId, BladeTenantBO::getTenantName));
        }
        if (tenantIds.isEmpty() && null != id_name) {
            tenantIds.addAll(id_name.keySet());
        }
        if (StringUtils.isEmpty((Object)reqBO.getStartTime()) || StringUtils.isEmpty((Object)reqBO.getEndTime())) {
            Date yesterday = DateUtil.getYesterday();
            startTimeStr = DateUtil.getDayStartTimeStr(yesterday);
            endTimeStr = DateUtil.getDayEndTimeStr(yesterday);
        } else {
            startTimeStr = reqBO.getStartTime();
            endTimeStr = reqBO.getEndTime();
        }
        log.info("\u67e5\u8be2\u8425\u9500\u4efb\u52a1\u7edf\u8ba1mapper\u5c42\u5165\u53c2\uff0cstartTimeStr={},endTimeStr={},tenantIds={}", new Object[]{startTimeStr, endTimeStr, tenantIds});
        PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
        List statisticsList = this.obMarketingTaskStatisticsMapper.selectByTimeAndTenant(startTimeStr, endTimeStr, tenantIds, reqBO.getTaskName());
        PageInfo pageInfo = new PageInfo(statisticsList);
        long total = 0L;
        ArrayList<QueryMarketingTaskRspBO> boList = new ArrayList<QueryMarketingTaskRspBO>();
        if (statisticsList != null && statisticsList.size() > 0) {
            total = pageInfo.getTotal();
            for (ObMarketingTaskStatistics po : statisticsList) {
                QueryMarketingTaskRspBO bo = new QueryMarketingTaskRspBO();
                BeanUtils.copyProperties((Object)po, (Object)bo);
                bo.setId(po.getId().toString());
                String data = po.getData().substring(0, po.getData().indexOf(" "));
                bo.setDate(data);
                if (null != id_name) {
                    bo.setTenantName(id_name.get(po.getTenantCode()));
                }
                if (StringUtils.isEmpty((Object)bo.getTenantName())) {
                    BladeTenantBO tenantInfo = this.getTenantInfo(po.getTenantCode());
                    bo.setTenantName(tenantInfo.getTenantName());
                }
                boList.add(bo);
            }
        }
        return BaseRspUtils.createSuccessRspList(boList, (long)total);
    }

    public Rsp exportMarketingTask(QueryMarketingTaskReqBO reqBO) {
        log.info("\u5bfc\u51fa\u8425\u9500\u4efb\u52a1\u7edf\u8ba1\u62a5\u8868\u5165\u53c2={}", (Object)JSON.toJSONString((Object)reqBO));
        String tenantId = StringUtils.isEmpty((Object)reqBO.getTenantCode()) ? reqBO.getIn_tenantCode() : reqBO.getTenantCode();
        int limit = reqBO.getLimit();
        reqBO.setLimit(1);
        RspList<QueryMarketingTaskRspBO> rspList = this.queryMarketingTask(reqBO);
        if (!rspList.getRspCode().equals("0000")) {
            log.error("\u67e5\u8be2\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)rspList.getRspDesc());
            return BaseRspUtils.createErrorRsp((String)"\u5bfc\u51fa\u5931\u8d25\uff01");
        }
        int pageCount = (int)rspList.getCount();
        if (pageCount == 0) {
            return BaseRspUtils.createSuccessRsp((Object)"", (String)"\u672a\u83b7\u53d6\u5230\u8425\u9500\u8bb0\u5f55");
        }
        int pageNumber = (pageCount - 1) / limit + 1;
        reqBO.setLimit(limit);
        ArrayList<ExcelMarketingTaskBO> excelBOS = new ArrayList<ExcelMarketingTaskBO>();
        Integer index = 1;
        for (int i = 1; i <= pageNumber; ++i) {
            List rows;
            reqBO.setPage(i);
            RspList<QueryMarketingTaskRspBO> rsp = this.queryMarketingTask(reqBO);
            if (!rsp.getRspCode().equals("0000") || (rows = rsp.getRows()) == null || rows.size() <= 0) continue;
            for (QueryMarketingTaskRspBO mt : rows) {
                ExcelMarketingTaskBO exmt = new ExcelMarketingTaskBO();
                BeanUtils.copyProperties((Object)mt, (Object)exmt);
                excelBOS.add(exmt);
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
            }
        }
        log.info("excelBOS\uff1a{}", (Object)JSONObject.toJSONString(excelBOS));
        String filePath = null;
        try {
            String fileName = "\u8425\u9500\u4efb\u52a1\u7edf\u8ba1\u62a5\u8868_" + tenantId + "_" + System.currentTimeMillis();
            filePath = this.excelHelper.writeExcel(excelBOS, ExcelMarketingTaskBO.class, fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            return BaseRspUtils.createErrorRsp((String)"\u5bfc\u51fa\u5931\u8d25\uff01");
        }
        filePath = this.path + filePath.substring(filePath.lastIndexOf("/") + 1);
        log.info("filePath:{}", (Object)filePath);
        ExportRspBO rspBO = new ExportRspBO();
        rspBO.setFilePath(filePath);
        rspBO.setFileName(filePath.substring(filePath.lastIndexOf("/") + 1));
        return BaseRspUtils.createSuccessRsp((Object)rspBO);
    }

    public RspList<QuerySubscribeRecordRspBO> querySubscribeRecord(QuerySubScribeRecordReqBO reqBO) {
        log.info("\u67e5\u8be2\u9884\u7ea6\u8bb0\u5f55\u5165\u53c2={}", (Object)JSON.toJSONString((Object)reqBO));
        String tenantCodeIn = reqBO.getTenantCode();
        if (StringUtils.isEmpty((Object)tenantCodeIn) && !StringUtils.isEmpty((Object)reqBO.getTenantId())) {
            tenantCodeIn = reqBO.getTenantId();
        }
        log.info("\u67e5\u8be2\u9884\u7ea6\u8bb0\u5f55mapper\u5c42\u5165\u53c2\uff0ctenantCodeIn={}\uff0cstartTime={}\uff0cendTime={},phone={}", new Object[]{tenantCodeIn, reqBO.getStartTime(), reqBO.getEndTime(), reqBO.getPhone()});
        PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
        List subscribeRecordList = this.obSubscribeRecordMapper.selectCommon(tenantCodeIn, reqBO.getStartTime(), reqBO.getEndTime(), reqBO.getPhone());
        PageInfo pageInfo = new PageInfo(subscribeRecordList);
        long total = 0L;
        ArrayList<QuerySubscribeRecordRspBO> boList = new ArrayList<QuerySubscribeRecordRspBO>();
        if (null != subscribeRecordList && subscribeRecordList.size() > 0) {
            total = pageInfo.getTotal();
            for (ObSubscribeRecord recordPo : subscribeRecordList) {
                ObTaskInfoPO taskInfoPO;
                QuerySubscribeRecordRspBO bo = new QuerySubscribeRecordRspBO();
                BladeTenantBO tenantInfo = this.getTenantInfo(recordPo.getTenantCode());
                if (StringUtils.isEmpty((Object)reqBO.getTaskName())) {
                    taskInfoPO = this.obTaskInfoDAO.selectByPrimaryKey(recordPo.getTaskId());
                    if (taskInfoPO == null) continue;
                    bo.setCalled(recordPo.getSubscribePhone());
                    bo.setCustName(recordPo.getSubscribeCreateUserName());
                    bo.setRemark(recordPo.getRemark());
                    bo.setSubscribePhone(recordPo.getSubscribePhone());
                    bo.setSubscribeTime(recordPo.getSubscribeTime());
                    bo.setTaskName(taskInfoPO.getTaskName());
                    if (tenantInfo != null) {
                        bo.setTenantName(tenantInfo.getTenantName());
                    }
                    boList.add(bo);
                    continue;
                }
                taskInfoPO = new ObTaskInfoPO();
                taskInfoPO.setTaskId(recordPo.getTaskId());
                taskInfoPO.setTaskName(reqBO.getTaskName());
                ObTaskInfoPO queryByName = this.obTaskInfoDAO.fuzzyQueryByName(taskInfoPO);
                if (queryByName == null) continue;
                bo.setCalled(recordPo.getSubscribePhone());
                bo.setCustName(recordPo.getSubscribeCreateUserName());
                bo.setRemark(recordPo.getRemark());
                bo.setSubscribePhone(recordPo.getSubscribePhone());
                bo.setSubscribeTime(recordPo.getSubscribeTime());
                bo.setTaskName(queryByName.getTaskName());
                if (tenantInfo != null) {
                    bo.setTenantName(tenantInfo.getTenantName());
                }
                boList.add(bo);
            }
        }
        return BaseRspUtils.createSuccessRspList(boList, (long)total);
    }

    public Rsp exportSubscribeRecord(QuerySubScribeRecordReqBO reqBO) {
        log.info("\u5bfc\u51fa\u9884\u7ea6\u8bb0\u5f55\u62a5\u8868\u5165\u53c2={}", (Object)JSON.toJSONString((Object)reqBO));
        int limit = reqBO.getLimit();
        reqBO.setLimit(1);
        String tenantId = StringUtils.isEmpty((Object)reqBO.getTenantCode()) ? reqBO.getIn_tenantCode() : reqBO.getTenantCode();
        RspList<QuerySubscribeRecordRspBO> rspList = this.querySubscribeRecord(reqBO);
        if (!rspList.getRspCode().equals("0000")) {
            log.error("\u67e5\u8be2\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)rspList.getRspDesc());
            return BaseRspUtils.createErrorRsp((String)"\u5bfc\u51fa\u5931\u8d25\uff01");
        }
        int pageCount = (int)rspList.getCount();
        if (pageCount == 0) {
            return BaseRspUtils.createSuccessRsp((Object)"", (String)"\u672a\u83b7\u53d6\u5230\u9884\u7ea6\u8bb0\u5f55");
        }
        int pageNumber = (pageCount - 1) / limit + 1;
        reqBO.setLimit(limit);
        ArrayList<ExcelSubscribeRecordBO> excelBOS = new ArrayList<ExcelSubscribeRecordBO>();
        Integer index = 1;
        for (int i = 1; i <= pageNumber; ++i) {
            List rows;
            reqBO.setPage(i);
            RspList<QuerySubscribeRecordRspBO> rsp = this.querySubscribeRecord(reqBO);
            if (!rsp.getRspCode().equals("0000") || (rows = rsp.getRows()) == null || rows.size() <= 0) continue;
            for (QuerySubscribeRecordRspBO mt : rows) {
                ExcelSubscribeRecordBO exmt = new ExcelSubscribeRecordBO();
                BeanUtils.copyProperties((Object)mt, (Object)exmt);
                exmt.setStartTime(reqBO.getStartTime());
                exmt.setEndTime(reqBO.getEndTime());
                excelBOS.add(exmt);
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
            }
        }
        log.info("excelBOS\uff1a{}", (Object)JSONObject.toJSONString(excelBOS));
        String filePath = null;
        try {
            String fileName = "\u9884\u7ea6\u8bb0\u5f55\u7edf\u8ba1\u62a5\u8868_" + tenantId + "_" + System.currentTimeMillis();
            filePath = this.excelHelper.writeExcel(excelBOS, ExcelSubscribeRecordBO.class, fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            return BaseRspUtils.createErrorRsp((String)"\u5bfc\u51fa\u5931\u8d25\uff01");
        }
        filePath = this.path + filePath.substring(filePath.lastIndexOf("/") + 1);
        log.info("filePath:{}", (Object)filePath);
        ExportRspBO rspBO = new ExportRspBO();
        rspBO.setFilePath(filePath);
        rspBO.setFileName(filePath.substring(filePath.lastIndexOf("/") + 1));
        return BaseRspUtils.createSuccessRsp((Object)rspBO);
    }

    @Transactional(rollbackFor={Exception.class})
    public void numberAttributeTask(NumberAttributeReq reqBO) {
        log.info("\u53f7\u7801\u5f52\u5c5e\u5730\u7edf\u8ba1\u5165\u53c2={}", (Object)JSON.toJSONString((Object)reqBO));
        try {
            GetBladeTenantListRspBO tenantList = this.bladeTenantInterService.getBladeTenantList(new GetBladeTenantListReqBO());
            if (!tenantList.getRspCode().equals("0000")) {
                log.error("\u53f7\u7801\u5f52\u5c5e\u5730\u4efb\u52a1\u7edf\u8ba1\uff0c\u67e5\u8be2\u79df\u6237\u5217\u8868\u5931\u8d25");
                return;
            }
            List rows = tenantList.getRows();
            for (BladeTenantBO row : rows) {
                reqBO.setTenantCode(row.getTenantId());
                reqBO.setTenantOtherName(row.getTenantOtherName());
                try {
                    this.singleTenantNumberAttribute(reqBO);
                }
                catch (Exception e) {
                    log.error("\u53f7\u7801\u5f52\u5c5e\u5730\u7edf\u8ba1-\u79df\u6237{}\u51fa\u9519,\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)reqBO.getTenantCode(), (Object)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            log.error("\u5177\u4f53\u6267\u884c\u53f7\u7801\u5f52\u5c5e\u5730\u4efb\u52a1\u7edf\u8ba1\u5f02\u5e38 {}", (Throwable)e);
        }
    }

    public RspList<QryNumberAttributeRspBO> queryNumberAttribute(QryNumberAttributeReqBO reqBO) {
        log.info("\u67e5\u8be2\u53f7\u7801\u5f52\u5c5e\u5730\u7edf\u8ba1\u6570\u636e\u5165\u53c2={}", (Object)JSON.toJSONString((Object)reqBO));
        String startTimeStr = null;
        String endTimeStr = null;
        ArrayList tenantIds = new ArrayList();
        if (reqBO.getTenantIds() != null && reqBO.getTenantIds().size() > 0) {
            tenantIds.addAll(reqBO.getTenantIds());
        }
        Map<String, String> id_name = null;
        Req req = new Req();
        req.setTenantCode(reqBO.getTenantCode());
        req.setIn_tenantCode(reqBO.getIn_tenantCode());
        req.setRoleSet(reqBO.getRoleSet());
        req.setReqData(tenantIds);
        List bladeTenants = this.bladeTenantInterService.getBalseTenantList(req);
        if (bladeTenants != null && !bladeTenants.isEmpty()) {
            id_name = bladeTenants.stream().collect(Collectors.toMap(BladeTenantBO::getTenantId, BladeTenantBO::getTenantName));
        }
        if (tenantIds.isEmpty() && null != id_name) {
            tenantIds.addAll(id_name.keySet());
        }
        if (StringUtils.isEmpty((Object)reqBO.getStartTime()) || StringUtils.isEmpty((Object)reqBO.getEndTime())) {
            Date yesterday = DateUtil.getYesterday();
            startTimeStr = DateUtil.getDayStartTimeStr(yesterday);
            endTimeStr = DateUtil.getDayEndTimeStr(yesterday);
        } else {
            startTimeStr = reqBO.getStartTime();
            endTimeStr = reqBO.getEndTime();
        }
        log.info("\u67e5\u8be2\u53f7\u7801\u5f52\u5c5e\u5730\u7edf\u8ba1\u6570\u636emapper\u5c42\u5165\u53c2\uff0cstartTimeStr={}\uff0cendTimeStr={},tenantIds={},taskName={},numberAttribute={}", new Object[]{startTimeStr, endTimeStr, tenantIds, reqBO.getTaskName(), reqBO.getNumberAttribute()});
        PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
        List qryDataList = this.obNumberAttributionStatisticsMapper.selectByCommon(startTimeStr, endTimeStr, tenantIds, reqBO.getTaskName(), reqBO.getNumberAttribute());
        PageInfo pageInfo = new PageInfo(qryDataList);
        long total = 0L;
        ArrayList<QryNumberAttributeRspBO> boList = new ArrayList<QryNumberAttributeRspBO>();
        if (null != qryDataList && qryDataList.size() > 0) {
            total = pageInfo.getTotal();
            for (ObNumberAttributionStatistics po : qryDataList) {
                BladeTenantBO tenantInfo;
                QryNumberAttributeRspBO bo = new QryNumberAttributeRspBO();
                BeanUtils.copyProperties((Object)po, (Object)bo);
                bo.setTaskName(po.getTaskNme());
                bo.setId(po.getId().toString());
                String data = po.getDate().substring(0, po.getDate().indexOf(" "));
                bo.setDate(data);
                if (null != id_name) {
                    bo.setTenantName(id_name.get(po.getTenantCode()));
                }
                if (StringUtils.isEmpty((Object)po.getTenantCode()) && (tenantInfo = this.getTenantInfo(po.getTenantCode())) != null) {
                    bo.setTenantName(tenantInfo.getTenantName());
                }
                bo.setNumberAttribute(StringUtils.isEmpty((Object)AreaCache.getArea(po.getNumberAttribute())) ? po.getNumberAttribute() : AreaCache.getArea(po.getNumberAttribute()));
                boList.add(bo);
            }
        }
        return BaseRspUtils.createSuccessRspList(boList, (long)total);
    }

    public Rsp exportNumberAttribute(QryNumberAttributeReqBO reqBO) {
        log.info("\u5bfc\u51fa\u53f7\u7801\u5f52\u5c5e\u5730\u7edf\u8ba1\u62a5\u8868\u5165\u53c2={}", (Object)JSON.toJSONString((Object)reqBO));
        String tenantId = StringUtils.isEmpty((Object)reqBO.getTenantCode()) ? reqBO.getIn_tenantCode() : reqBO.getTenantCode();
        int limit = reqBO.getLimit();
        reqBO.setLimit(1);
        RspList<QryNumberAttributeRspBO> rspList = this.queryNumberAttribute(reqBO);
        if (!rspList.getRspCode().equals("0000")) {
            log.error("\u67e5\u8be2\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)rspList.getRspDesc());
            return BaseRspUtils.createErrorRsp((String)"\u5bfc\u51fa\u5931\u8d25\uff01");
        }
        int count = (int)rspList.getCount();
        if (count == 0) {
            return BaseRspUtils.createSuccessRsp((Object)"", (String)"\u672a\u83b7\u53d6\u5230\u53f7\u7801\u5f52\u5c5e\u5730\u7edf\u8ba1\u6570\u636e");
        }
        int pageNumber = (count - 1) / limit + 1;
        reqBO.setLimit(limit);
        ArrayList<ExcelNumberAttributeBO> excelBOS = new ArrayList<ExcelNumberAttributeBO>();
        Integer index = 1;
        for (int i = 1; i <= pageNumber; ++i) {
            List rows;
            reqBO.setPage(i);
            RspList<QryNumberAttributeRspBO> rsp = this.queryNumberAttribute(reqBO);
            if (!rsp.getRspCode().equals("0000") || (rows = rsp.getRows()) == null || rows.size() <= 0) continue;
            for (QryNumberAttributeRspBO mt : rows) {
                ExcelNumberAttributeBO exmt = new ExcelNumberAttributeBO();
                BeanUtils.copyProperties((Object)mt, (Object)exmt);
                exmt.setStartTime(reqBO.getStartTime());
                exmt.setEndTime(reqBO.getEndTime());
                excelBOS.add(exmt);
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
            }
        }
        log.info("excelBOS\uff1a{}", (Object)JSONObject.toJSONString(excelBOS));
        String filePath = null;
        try {
            String fileName = "\u53f7\u7801\u5f52\u5c5e\u5730\u7edf\u8ba1\u62a5\u8868_" + tenantId + "_" + System.currentTimeMillis();
            filePath = this.excelHelper.writeExcel(excelBOS, ExcelNumberAttributeBO.class, fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            return BaseRspUtils.createErrorRsp((String)"\u5bfc\u51fa\u5931\u8d25\uff01");
        }
        filePath = this.path + filePath.substring(filePath.lastIndexOf("/") + 1);
        log.info("filePath:{}", (Object)filePath);
        ExportRspBO rspBO = new ExportRspBO();
        rspBO.setFilePath(filePath);
        rspBO.setFileName(filePath.substring(filePath.lastIndexOf("/") + 1));
        return BaseRspUtils.createSuccessRsp((Object)rspBO);
    }

    public RspList<QueryAttributeDataRspBO> queryAttributeData(QueryAttributeDataReqBO reqBO) {
        log.info("\u67e5\u8be2\u5f52\u5c5e\u5730\u6570\u636e\u5165\u53c2={}", (Object)JSON.toJSONString((Object)reqBO));
        String startTimeStr = null;
        String endTimeStr = null;
        if (StringUtils.isEmpty((Object)reqBO.getStartTime()) || StringUtils.isEmpty((Object)reqBO.getEndTime())) {
            Date yesterday = DateUtil.getYesterday();
            startTimeStr = DateUtil.getDayStartTimeStr(yesterday);
            endTimeStr = DateUtil.getDayEndTimeStr(yesterday);
        } else {
            startTimeStr = reqBO.getStartTime();
            endTimeStr = reqBO.getEndTime();
        }
        log.info("\u67e5\u8be2\u5f52\u5c5e\u5730\u6570\u636emapper\u5c42\u5165\u53c2\uff0cstartTimeStr={}\uff0cendTimeStr={}\uff0cnumberAttribute={}", new Object[]{startTimeStr, endTimeStr, reqBO.getNumberAttribute()});
        PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
        List infoPOList = this.obNumberAttributionStatisticsMapper.selectAttributeData(startTimeStr, endTimeStr, reqBO.getNumberAttribute());
        PageInfo pageInfo = new PageInfo(infoPOList);
        long total = 0L;
        ArrayList<QueryAttributeDataRspBO> boList = new ArrayList<QueryAttributeDataRspBO>();
        if (infoPOList != null && infoPOList.size() > 0) {
            total = pageInfo.getTotal();
            for (AttributeDataInfoPO po : infoPOList) {
                QueryAttributeDataRspBO bo = new QueryAttributeDataRspBO();
                String data = po.getDateTime().substring(0, po.getDateTime().indexOf(" "));
                bo.setDate(data);
                bo.setNumberAttribute(po.getNumberAttribute());
                bo.setCallNumber(po.getCallNumber());
                bo.setConnectNumber(po.getConnectNumber());
                bo.setSuccessNumber(po.getSuccessNumber());
                String connectRate = this.percent(bo.getConnectNumber(), bo.getCallNumber());
                bo.setConnectionRate(connectRate);
                String successRate = this.percent(bo.getSuccessNumber(), bo.getConnectNumber());
                bo.setSuccessRate(successRate);
                bo.setNumberAttribute(StringUtils.isEmpty((Object)AreaCache.getArea(po.getNumberAttribute())) ? po.getNumberAttribute() : AreaCache.getArea(po.getNumberAttribute()));
                boList.add(bo);
            }
        }
        return BaseRspUtils.createSuccessRspList(boList, (long)total);
    }

    public Rsp exportAttributeData(QueryAttributeDataReqBO reqBO) {
        log.info("\u5bfc\u51fa\u5f52\u5c5e\u5730\u6570\u636e\u7edf\u8ba1\u62a5\u8868\u5165\u53c2={}", (Object)JSON.toJSONString((Object)reqBO));
        String tenantId = StringUtils.isEmpty((Object)reqBO.getTenantCode()) ? reqBO.getIn_tenantCode() : reqBO.getTenantCode();
        int limit = reqBO.getLimit();
        reqBO.setLimit(1);
        RspList<QueryAttributeDataRspBO> rspList = this.queryAttributeData(reqBO);
        if (rspList.getRspCode().equals("8888")) {
            log.info("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0={}", (Object)rspList.getRspDesc());
            return BaseRspUtils.createErrorRsp((String)"\u5bfc\u51fa\u5931\u8d25\uff01");
        }
        int count = (int)rspList.getCount();
        if (count == 0) {
            log.info("\u67e5\u8be2\u6570\u636e\u6761\u6570\u4e3a0");
            return BaseRspUtils.createSuccessRsp((Object)"", (String)"\u672a\u67e5\u8be2\u5230\u5f52\u5c5e\u5730\u6570\u636e");
        }
        int pageNumber = (count - 1) / limit + 1;
        reqBO.setLimit(limit);
        ArrayList<ExcelAttributeDataBO> excelBOS = new ArrayList<ExcelAttributeDataBO>();
        Integer index = 1;
        for (int i = 1; i <= pageNumber; ++i) {
            List rows;
            reqBO.setPage(i);
            RspList<QueryAttributeDataRspBO> rsp = this.queryAttributeData(reqBO);
            if (!rsp.getRspCode().equals("0000") || (rows = rsp.getRows()) == null || rows.size() <= 0) continue;
            for (QueryAttributeDataRspBO mt : rows) {
                ExcelAttributeDataBO exmt = new ExcelAttributeDataBO();
                BeanUtils.copyProperties((Object)mt, (Object)exmt);
                exmt.setStartTime(reqBO.getStartTime());
                exmt.setEndTime(reqBO.getEndTime());
                excelBOS.add(exmt);
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
            }
        }
        log.info("excelBOS\uff1a{}", (Object)JSONObject.toJSONString(excelBOS));
        String filePath = null;
        try {
            Integer intDate = DateUtil.getIntDate(new Date());
            String fileName = "\u5f52\u5c5e\u5730\u6570\u636e\u7edf\u8ba1\u62a5\u8868_" + tenantId + "_" + System.currentTimeMillis();
            filePath = this.excelHelper.writeExcel(excelBOS, ExcelAttributeDataBO.class, fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            return BaseRspUtils.createErrorRsp((String)"\u5bfc\u51fa\u5931\u8d25\uff01");
        }
        filePath = this.path + filePath.substring(filePath.lastIndexOf("/") + 1);
        log.info("filePath:{}", (Object)filePath);
        ExportRspBO rspBO = new ExportRspBO();
        rspBO.setFilePath(filePath);
        rspBO.setFileName(filePath.substring(filePath.lastIndexOf("/") + 1));
        return BaseRspUtils.createSuccessRsp((Object)rspBO);
    }

    public RspList<QueryTenantStatisticsDataRspBO> queryTenantData(QueryTenantStatisticsDataReqBO reqBO) {
        log.info("\u67e5\u8be2\u79df\u6237\u7edf\u8ba1\u6570\u636e\u5165\u53c2={}", (Object)JSON.toJSONString((Object)reqBO));
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String startTimeStr = null;
        String endTimeStr = null;
        if (StringUtils.isEmpty((Object)reqBO.getStartTime()) || StringUtils.isEmpty((Object)reqBO.getEndTime())) {
            Date yesterday = DateUtil.getYesterday();
            startTimeStr = DateUtil.getDayStartTimeStr(yesterday);
            endTimeStr = DateUtil.getDayEndTimeStr(yesterday);
        } else {
            startTimeStr = reqBO.getStartTime();
            endTimeStr = reqBO.getEndTime();
        }
        ArrayList<String> tenantIds = new ArrayList<String>();
        List bladeTenants = null;
        List roleNames = this.bladeUserInterService.getUserRoleInfo(reqBO.getLoginInfo().getUserId());
        Set roleSet = reqBO.getRoleSet();
        if (reqBO.getTenantIds() != null && reqBO.getTenantIds().size() > 0) {
            tenantIds.addAll(reqBO.getTenantIds());
        } else {
            tenantIds.add(reqBO.getTenantCode());
            for (String role : roleNames) {
                if (null == roleSet || StringUtils.isEmpty((Object)role) || !role.equals("system:admin") && !role.equals("system:administrator")) continue;
                Req req = new Req();
                req.setTenantCode(reqBO.getTenantCode());
                req.setIn_tenantCode(reqBO.getIn_tenantCode());
                req.setRoleSet(reqBO.getRoleSet());
                bladeTenants = this.bladeTenantInterService.getBalseTenantList(req);
                if (null == bladeTenants) break;
                tenantIds.addAll(bladeTenants.stream().map(x -> x.getTenantId()).collect(Collectors.toList()));
                break;
            }
        }
        if (null != tenantIds && !tenantIds.isEmpty() && (null == bladeTenants || bladeTenants.isEmpty())) {
            Req req = new Req();
            req.setIn_tenantCode(req.getIn_tenantCode());
            req.setRoleSet(roleSet);
            req.setReqData(tenantIds);
            bladeTenants = this.bladeTenantInterService.getBalseTenantList(req);
        }
        log.info("\u67e5\u8be2\u79df\u6237\u7edf\u8ba1\u6570\u636emapper\u5c42\u5165\u53c2\uff0cstartTimeStr={}\uff0cendTimeStr={}\uff0ctenants={}", new Object[]{startTimeStr, endTimeStr, tenantIds});
        PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
        List tenantData = this.obMarketingTaskStatisticsMapper.selectTenantData(startTimeStr, endTimeStr, tenantIds);
        PageInfo pageInfo = new PageInfo(tenantData);
        long total = 0L;
        ArrayList<QueryTenantStatisticsDataRspBO> boList = new ArrayList<QueryTenantStatisticsDataRspBO>();
        if (tenantData != null && tenantData.size() > 0) {
            total = pageInfo.getTotal();
            for (TenantDataInfoPO po : tenantData) {
                QueryTenantStatisticsDataRspBO bo = new QueryTenantStatisticsDataRspBO();
                BeanUtils.copyProperties((Object)po, (Object)bo);
                String date = po.getDateTime().substring(0, po.getDateTime().indexOf(" "));
                bo.setDate(date);
                BladeTenantBO tenantInfo = this.getTenantInfo(po.getTenantCode());
                if (tenantInfo != null) {
                    bo.setTenantName(tenantInfo.getTenantName());
                }
                List recordPOS = this.obCallRecordDAO.selectTenantData(startTimeStr, endTimeStr, tenantInfo.getTenantId(), tenantInfo.getTenantOtherName());
                List jobNumberBindRecord = this.dcJobNumberInterService.getJobNumberBindRecord(startTimeStr, endTimeStr, tenantInfo.getTenantId());
                Integer custNum = 0;
                if (null != recordPOS && recordPOS.size() > 0) {
                    Map<String, List<ObCallRecordPO>> listMap = recordPOS.stream().collect(Collectors.groupingBy(ObCallRecordPO::getJobNumber));
                    for (String key : listMap.keySet()) {
                        List<ObCallRecordPO> pos = listMap.get(key);
                        String startTalkTime = pos.get(0).getTalkTime();
                        String endTalkTime = pos.get(pos.size() - 1).getTalkTime();
                        log.info("\u5f53\u524d\u5de5\u53f7\uff1a{}\uff0c \u7b2c\u4e00\u6b21\u5916\u547c\u65f6\u95f4\uff1a{}\uff0c \u6700\u540e\u4e00\u6b21\u5916\u547c\u65f6\u95f4\uff1a{}", new Object[]{key, startTalkTime, endTalkTime});
                        if (StringUtils.isEmpty((Object)endTalkTime) || StringUtils.isEmpty((Object)key)) continue;
                        Long num1 = jobNumberBindRecord.stream().filter(bindRecord -> key.equals(bindRecord.getJobNumber()) && null == bindRecord.getUnBindTime() && endTalkTime.compareTo(bindRecord.getBindTime()) > 0).count();
                        Long num2 = jobNumberBindRecord.stream().filter(bindRecord -> key.equals(bindRecord.getJobNumber()) && null != bindRecord.getUnBindTime() && endTalkTime.compareTo(bindRecord.getUnBindTime()) < 0).count();
                        custNum = num1.intValue() + num2.intValue();
                    }
                }
                bo.setCustNumber(custNum);
                String connectRate = this.percent(bo.getConnectNumber(), bo.getCallNumber());
                bo.setConnectionRate(connectRate);
                String successRate = this.percent(bo.getSuccessNumber(), bo.getConnectNumber());
                bo.setSuccessRate(successRate);
                boList.add(bo);
            }
        }
        return BaseRspUtils.createSuccessRspList(boList, (long)total);
    }

    public Rsp exportTenantData(QueryTenantStatisticsDataReqBO reqBO) {
        log.info("\u5bfc\u51fa\u4efb\u52a1\u6570\u636e\u7edf\u8ba1\u62a5\u8868\u5165\u53c2={}", (Object)JSON.toJSONString((Object)reqBO));
        String tenantId = StringUtils.isEmpty((Object)reqBO.getTenantCode()) ? reqBO.getIn_tenantCode() : reqBO.getTenantCode();
        int limit = reqBO.getLimit();
        reqBO.setLimit(1);
        RspList<QueryTenantStatisticsDataRspBO> rspList = this.queryTenantData(reqBO);
        if (rspList.getRspCode().equals("8888")) {
            log.info("\u67e5\u8be2\u79df\u6237\u7edf\u8ba1\u6570\u636e\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0={}", (Object)rspList.getRspDesc());
            return BaseRspUtils.createErrorRsp((String)"\u5bfc\u51fa\u5931\u8d25");
        }
        int count = (int)rspList.getCount();
        if (count == 0) {
            log.info("\u67e5\u8be2\u6570\u636e\u6761\u6570\u4e3a0");
            return BaseRspUtils.createSuccessRsp((Object)"", (String)"\u672a\u67e5\u8be2\u5230\u5f52\u5c5e\u5730\u6570\u636e");
        }
        int pageNumber = (count - 1) / limit + 1;
        reqBO.setLimit(limit);
        ArrayList<ExcelTenantDataBO> excelBOS = new ArrayList<ExcelTenantDataBO>();
        Integer index = 1;
        for (int i = 1; i <= pageNumber; ++i) {
            List rows;
            reqBO.setPage(i);
            RspList<QueryTenantStatisticsDataRspBO> rsp = this.queryTenantData(reqBO);
            if (!rsp.getRspCode().equals("0000") || (rows = rsp.getRows()) == null || rows.size() <= 0) continue;
            for (QueryTenantStatisticsDataRspBO mt : rows) {
                ExcelTenantDataBO exmt = new ExcelTenantDataBO();
                BeanUtils.copyProperties((Object)mt, (Object)exmt);
                exmt.setStartTime(reqBO.getStartTime());
                exmt.setEndTime(reqBO.getEndTime());
                excelBOS.add(exmt);
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
            }
        }
        log.info("excelBOS\uff1a{}", (Object)JSONObject.toJSONString(excelBOS));
        String filePath = null;
        try {
            String fileName = "\u79df\u6237\u6570\u636e\u7edf\u8ba1\u62a5\u8868_" + tenantId + "_" + System.currentTimeMillis();
            filePath = this.excelHelper.writeExcel(excelBOS, ExcelTenantDataBO.class, fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            return BaseRspUtils.createErrorRsp((String)"\u5bfc\u51fa\u5931\u8d25\uff01");
        }
        filePath = this.path + filePath.substring(filePath.lastIndexOf("/") + 1);
        log.info("filePath:{}", (Object)filePath);
        ExportRspBO rspBO = new ExportRspBO();
        rspBO.setFilePath(filePath);
        rspBO.setFileName(filePath.substring(filePath.lastIndexOf("/") + 1));
        return BaseRspUtils.createSuccessRsp((Object)rspBO);
    }

    public void tenantDataTask(TenantDataReqBO reqBO) {
        log.info("\u7edf\u8ba1\u79df\u6237\u6570\u636e\u5165\u53c2={}", (Object)JSONObject.toJSONString((Object)reqBO));
        try {
            GetBladeTenantListRspBO tenantList = this.bladeTenantInterService.getBladeTenantList(new GetBladeTenantListReqBO());
            if (!tenantList.getRspCode().equals("0000")) {
                log.error("\u79df\u6237\u6570\u636e\u7edf\u8ba1\uff0c\u67e5\u8be2\u79df\u6237\u5217\u8868\u5931\u8d25");
                return;
            }
            List rows = tenantList.getRows();
            for (BladeTenantBO po : rows) {
                reqBO.setTenantCode(po.getTenantId());
                reqBO.setTenantOtherName(po.getTenantOtherName());
                try {
                    this.singleTenantData(reqBO);
                }
                catch (Exception e) {
                    log.error("\u79df\u6237\u6570\u636e\u7edf\u8ba1-\u79df\u6237{}\u51fa\u9519", (Object)reqBO.getTenantCode());
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            log.error("\u5177\u4f53\u6267\u884c\u79df\u6237\u6570\u636e\u7edf\u8ba1\u5f02\u5e38 {}", (Throwable)e);
        }
    }

    public RspList<QueryTenantDataRspBO> qryTenantData(QueryTenantDataReqBO reqBO) {
        log.info("\u67e5\u8be2\u79df\u6237\u6570\u636e\u5165\u53c2={}", (Object)JSONObject.toJSONString((Object)reqBO));
        String startTimeStr = null;
        String endTimeStr = null;
        if (StringUtils.isEmpty((Object)reqBO.getStartTime()) || StringUtils.isEmpty((Object)reqBO.getEndTime())) {
            Date yesterday = DateUtil.getYesterday();
            startTimeStr = DateUtil.getDayStartTimeStr(yesterday);
            endTimeStr = DateUtil.getDayEndTimeStr(yesterday);
        } else {
            startTimeStr = reqBO.getStartTime();
            endTimeStr = reqBO.getEndTime();
        }
        List tenantIds = reqBO.getTenantIds();
        ArrayList<QueryTenantDataRspBO> boList = new ArrayList<QueryTenantDataRspBO>();
        long total = 0L;
        PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
        List dataList = this.obTenantStatisticsMapper.selectActive(startTimeStr, endTimeStr, tenantIds);
        PageInfo pageInfo = new PageInfo(dataList);
        if (null != dataList && dataList.size() > 0) {
            total = pageInfo.getTotal();
            for (ObTenantStatistics tt : dataList) {
                QueryTenantDataRspBO bo = new QueryTenantDataRspBO();
                bo.setCallNumber(tt.getCallNumber());
                bo.setConnectNumber(tt.getConnectNumber());
                bo.setCustNumber(tt.getCustNumber());
                bo.setSuccessNumber(tt.getSuccessNumber());
                String oldDate = tt.getOldDate();
                String data = oldDate.substring(0, oldDate.indexOf(" "));
                bo.setDate(data);
                BladeTenantBO tenantInfo = this.getTenantInfo(tt.getTenantId());
                if (null != tenantInfo) {
                    bo.setTenantName(tenantInfo.getTenantName());
                }
                boList.add(bo);
            }
        }
        return BaseRspUtils.createSuccessRspList(boList, (long)total);
    }

    public void scriptRecordTask(TenantDataReqBO reqBO) {
        log.info("\u95ee\u5377\u8bb0\u5f55\u5b9a\u65f6\u4efb\u52a1\u5165\u53c2={}", (Object)JSONObject.toJSONString((Object)reqBO));
        SimpleDateFormat stf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String nowTime = stf.format(new Date());
        List allRecord = this.obCallRecordAnswerMapper.selectByTime(reqBO.getStartTime(), reqBO.getEndTime());
        log.info("\u67e5\u8be2\u5f53\u5929\u95ee\u5377\u8bb0\u5f55={}", (Object)JSONObject.toJSONString((Object)allRecord));
        if (null != allRecord) {
            Map<String, List<ObCallRecordAnswer>> callIdList = allRecord.stream().collect(Collectors.groupingBy(ObCallRecordAnswer::getCallId));
            for (Map.Entry<String, List<ObCallRecordAnswer>> next : callIdList.entrySet()) {
                ObScriptRecordStatistics po = new ObScriptRecordStatistics();
                po.setOldTime(reqBO.getStartTime());
                po.setCreateTime(nowTime);
                List<ObCallRecordAnswer> answerList = next.getValue();
                if (null == answerList || answerList.size() <= 0) continue;
                ObCallRecordAnswer callRecordAnswer = answerList.get(0);
                String hanStr = stf.format(callRecordAnswer.getHandleTime());
                po.setHandleTime(hanStr);
                po.setHandleUserId(callRecordAnswer.getHandleUserId());
                log.info("\u7528\u6237id={}", (Object)callRecordAnswer.getHandleUserId());
                BladeUserBO bladeUserBO = this.bladeUserInterService.queryUserInfo(callRecordAnswer.getHandleUserId());
                log.info("\u5904\u7406\u4eba\u7528\u6237\u4fe1\u606f={}", (Object)JSONObject.toJSONString((Object)bladeUserBO));
                po.setHandleUserName(bladeUserBO.getRealName());
                String tenantCode = callRecordAnswer.getTenantId();
                String content = "";
                for (ObCallRecordAnswer answer : answerList) {
                    String question = answer.getQuestion();
                    String anss = answer.getAnswer();
                    content = content + question + ":" + anss + "/";
                }
                po.setContent(content);
                BladeTenantBO tenantInfo = this.getTenantInfo(tenantCode);
                ObCallRecordPO obCallRecordPO = new ObCallRecordPO();
                obCallRecordPO.setUcId(next.getKey());
                obCallRecordPO.setTenantOtherName(tenantInfo.getTenantOtherName());
                obCallRecordPO.setTenantId(tenantCode);
                log.info("\u67e5\u8be2\u5916\u547c\u8bb0\u5f55={}", (Object)JSONObject.toJSONString((Object)obCallRecordPO));
                ObCallRecordPO callRecordPO = this.obCallRecordDAO.selectByUcId(obCallRecordPO);
                log.info("\u67e5\u8be2\u5916\u547c\u8bb0\u5f55\u51fa\u53c2={}", (Object)JSONObject.toJSONString((Object)callRecordPO));
                po.setCalled(callRecordPO.getCalled());
                ObTaskInfoPO taskInfoPO = this.obTaskInfoDAO.selectByPrimaryKey(callRecordPO.getTaskId());
                po.setTaskId(callRecordPO.getTaskId());
                po.setTaskName(taskInfoPO.getTaskName());
                ObTaskScriptPO taskScriptPO = this.obTaskScriptDAO.selectByTaskId(callRecordPO.getTaskId());
                QryConfigScriptRspBO rspBO = this.scriptInterService.queryConfigScript(taskScriptPO.getScriptId());
                po.setScriptName(rspBO.getScriptName());
                po.setTenantId(tenantCode);
                po.setExtra1(obCallRecordPO.getUcId());
                this.obScriptRecordStatisticsMapper.insertSelective(po);
            }
        }
    }

    public RspList<QryScriptStatisticsRspBO> qryScriptRecord(QryScriptStatisticReqBO reqBO) {
        log.info("\u67e5\u8be2\u95ee\u5377\u8bb0\u5f55\u62a5\u8868\u5165\u53c2={}", (Object)JSONObject.toJSONString((Object)reqBO));
        if (StringUtils.isEmpty((Object)reqBO.getTenantCode())) {
            log.info("tenantId\u4e0d\u80fd\u4e3a\u7a7a");
            return BaseRspUtils.createErrorRspList((String)"tenantId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String startTimeStr = null;
        String endTimeStr = null;
        if (StringUtils.isEmpty((Object)reqBO.getStartTime()) || StringUtils.isEmpty((Object)reqBO.getEndTime())) {
            Date yesterday = DateUtil.getYesterday();
            startTimeStr = DateUtil.getDayStartTimeStr(yesterday);
            endTimeStr = DateUtil.getDayEndTimeStr(yesterday);
        } else {
            startTimeStr = reqBO.getStartTime();
            endTimeStr = reqBO.getEndTime();
        }
        ArrayList<QryScriptStatisticsRspBO> boList = new ArrayList<QryScriptStatisticsRspBO>();
        ObScriptRecordStatistics po = new ObScriptRecordStatistics();
        po.setHandleUserName(reqBO.getCustName());
        po.setTenantId(reqBO.getTenantCode());
        po.setTaskName(reqBO.getTaskName());
        po.setCreateTime(startTimeStr);
        po.setHandleTime(endTimeStr);
        po.setScriptName(reqBO.getScriptName());
        PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
        log.info("\u67e5\u8be2\u95ee\u5377\u8bb0\u5f55\u62a5\u8868mapper\u5c42\u5165\u53c2={}", (Object)JSONObject.toJSONString((Object)po));
        List statisticsList = this.obScriptRecordStatisticsMapper.selectByActiv(po);
        log.info("\u67e5\u8be2\u95ee\u5377\u8bb0\u5f55\u62a5\u8868mapper\u5c42\u51fa\u53c2={}", (Object)JSONObject.toJSONString((Object)statisticsList));
        PageInfo pageInfo = new PageInfo(statisticsList);
        long total = 0L;
        if (null != statisticsList && statisticsList.size() > 0) {
            total = pageInfo.getTotal();
            for (ObScriptRecordStatistics tt : statisticsList) {
                QryScriptStatisticsRspBO bo = new QryScriptStatisticsRspBO();
                bo.setCalled(tt.getCalled());
                bo.setCustName(tt.getHandleUserName());
                bo.setHandleTime(tt.getHandleTime());
                bo.setScriptName(tt.getScriptName());
                bo.setTaskName(tt.getTaskName());
                bo.setUcId(tt.getExtra1());
                String[] split = tt.getContent().split("/");
                List<String> asList = Arrays.asList(split);
                bo.setAnswerList(asList);
                boList.add(bo);
            }
        }
        return BaseRspUtils.createSuccessRspList(boList, (long)total);
    }

    public Rsp exportScriptDetails(QryScriptStatisticReqBO reqBO) {
        log.info("\u5bfc\u51fa\u95ee\u5377\u8be6\u60c5\u5165\u53c2={}", (Object)JSONObject.toJSONString((Object)reqBO));
        String tenantId = StringUtils.isEmpty((Object)reqBO.getTenantCode()) ? reqBO.getIn_tenantCode() : reqBO.getTenantCode();
        int limit = reqBO.getLimit();
        reqBO.setLimit(1);
        RspList<QryScriptStatisticsRspBO> rspList = this.qryScriptRecord(reqBO);
        if (rspList.getRspCode().equals("8888")) {
            log.info("\u67e5\u8be2\u95ee\u5377\u8bb0\u5f55\u62a5\u8868\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0={}", (Object)rspList.getRspDesc());
            return BaseRspUtils.createErrorRsp((String)"\u5bfc\u51fa\u5931\u8d25");
        }
        int count = (int)rspList.getCount();
        if (count == 0) {
            log.info("\u67e5\u8be2\u6570\u636e\u6761\u6570\u4e3a0");
            return BaseRspUtils.createSuccessRsp((Object)"", (String)"\u672a\u67e5\u8be2\u5230\u95ee\u5377\u8bb0\u5f55\u62a5\u8868");
        }
        int pageNumber = (count - 1) / limit + 1;
        reqBO.setLimit(limit);
        ArrayList<QryScriptStatisticsRspBO> excelBOS = new ArrayList<QryScriptStatisticsRspBO>();
        Integer index = 1;
        for (int i = 1; i <= pageNumber; ++i) {
            List rows;
            reqBO.setPage(i);
            RspList<QryScriptStatisticsRspBO> rsp = this.qryScriptRecord(reqBO);
            if (!rsp.getRspCode().equals("0000") || (rows = rsp.getRows()) == null || rows.size() <= 0) continue;
            for (QryScriptStatisticsRspBO mt : rows) {
                QryScriptStatisticsRspBO exmt = new QryScriptStatisticsRspBO();
                BeanUtils.copyProperties((Object)mt, (Object)exmt);
                excelBOS.add(exmt);
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
            }
        }
        String tempPath = TimedTasksImp.ex(excelBOS, tenantId);
        String fileName = tempPath.substring(tempPath.lastIndexOf("/") + 1);
        OcsUploadReqBO ft = new OcsUploadReqBO();
        ft.setUploadFileName(fileName);
        ft.setUploadPath(tempPath);
        OcsUploadRspBO ocsUploadRspBO = this.ocsFileService.ocsUpload(ft);
        log.info("\u4e0a\u4f20\u4fe1\u606f={}", (Object)JSONObject.toJSONString((Object)ocsUploadRspBO));
        String ff = null;
        String fp = null;
        if (null != ocsUploadRspBO) {
            ff = ocsUploadRspBO.getFileName();
            String p = ocsUploadRspBO.getFilePath();
            fp = this.path + p.substring(p.lastIndexOf("/") + 1);
            log.info("fp={}", (Object)fp);
        }
        ExportRspBO rspBO = new ExportRspBO();
        rspBO.setFilePath(fp);
        rspBO.setFileName(ff);
        return BaseRspUtils.createSuccessRsp((Object)rspBO);
    }

    public Rsp calculationFormula(CalculationFormulaReqBO req) {
        log.info("\u8ba1\u7b97\u6e05\u5355\u56e0\u5b50\u5165\u53c2={}", (Object)JSONObject.toJSONString((Object)req));
        if (null == req.getComplainInfos()) {
            log.info("ComplainInfos\u53c2\u6570\u7f3a\u5931");
            return BaseRspUtils.createErrorRsp((String)"ComplainInfos\u53c2\u6570\u7f3a\u5931");
        }
        SimpleDateFormat stf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String firstDay = null;
        String lastDay = null;
        int beforeMonthDay = 0;
        if (StringUtils.isEmpty((Object)req.getMouth())) {
            firstDay = DateUtil.getBeforeMonthFirstDay();
            lastDay = DateUtil.getBeforeMonthLastDay();
            beforeMonthDay = DateUtil.getBeforeMonthDay();
            log.info("\u4e0a\u4e2a\u6708\u7b2c\u4e00\u5929\uff1a{}", (Object)firstDay);
            log.info("\u4e0a\u4e2a\u6708\u6700\u540e\u4e00\u5929\uff1a{}", (Object)lastDay);
            log.info("\u4e0a\u4e2a\u6708\u5929\u6570\uff1a{}", (Object)beforeMonthDay);
        } else {
            boolean timeForm = RegularUtils.timeForm(req.getMouth());
            if (!timeForm) {
                log.info("\u6708\u4efd\u683c\u5f0f\u4e0d\u6b63\u786e");
                return BaseRspUtils.createErrorRsp((String)"\u6708\u4efd\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            Date minDateMonth = DateUtil.getMinDateMonth(req.getMouth());
            Date maxDateMonth = DateUtil.getMaxDateMonth(req.getMouth());
            int dayOfMonth = DateUtil.getDayOfMonth(req.getMouth());
            firstDay = stf.format(minDateMonth);
            lastDay = stf.format(maxDateMonth);
            beforeMonthDay = dayOfMonth;
            log.info("\u6307\u5b9a\u6708\u7b2c\u4e00\u5929\uff1a{}", (Object)firstDay);
            log.info("\u6307\u5b9a\u6708\u6700\u540e\u4e00\u5929\uff1a{}", (Object)lastDay);
            log.info("\u6307\u5b9a\u6708\u4efd\u5929\u6570:{}", (Object)beforeMonthDay);
        }
        GetBladeTenantListRspBO tenantList = this.bladeTenantInterService.getBladeTenantList(new GetBladeTenantListReqBO());
        if (!tenantList.getRspCode().equals("0000")) {
            log.error("\u8ba1\u7b97\u79df\u6237\u62a2\u5355\u56e0\u5b50\uff0c\u67e5\u8be2\u79df\u6237\u5217\u8868\u5931\u8d25");
            return BaseRspUtils.createErrorRsp((String)"\u8ba1\u7b97\u79df\u6237\u62a2\u5355\u56e0\u5b50\uff0c\u67e5\u8be2\u79df\u6237\u5217\u8868\u5931\u8d25");
        }
        List rows = tenantList.getRows();
        for (BladeTenantBO po : rows) {
            TenantComplainInfoBO next;
            CalculationReqBO reqBO = new CalculationReqBO();
            List complainInfos = req.getComplainInfos();
            Set boSet = complainInfos.stream().filter(e -> po.getTenantId().equals(e.getTenantId())).collect(Collectors.toSet());
            if (null != boSet && boSet.size() > 0 && null != (next = (TenantComplainInfoBO)boSet.iterator().next())) {
                reqBO.setComplain(next.getComplaintCount());
                reqBO.setSuccessBuyCount(next.getSuccessBuyCount());
            }
            reqBO.setStartTime(firstDay);
            reqBO.setEndTime(lastDay);
            reqBO.setTenantCode(po.getTenantId());
            reqBO.setTenantOtherName(po.getTenantOtherName());
            reqBO.setDayCount(Integer.valueOf(beforeMonthDay));
            try {
                this.singleTenantScore(reqBO);
            }
            catch (Exception e2) {
                log.info("\u8ba1\u7b97\u62a2\u5355\u56e0\u5b50-\u79df\u6237{}\u51fa\u9519,\u51fa\u9519\u4fe1\u606f{}", (Object)reqBO.getTenantCode(), (Object)e2.getMessage());
            }
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    public RspList queryActCust(QryTenantActNationCustReqBO reqBO) {
        log.info("\u67e5\u8be2\u79df\u6237\u6d3b\u8dc3\u5750\u5e2d\u5165\u53c2={}", (Object)JSONObject.toJSONString((Object)reqBO));
        ArrayList<QryTenantActNationCustRspBO> boList = new ArrayList<QryTenantActNationCustRspBO>();
        String startTimeStr = null;
        String endTimeStr = null;
        if (StringUtils.isEmpty((Object)reqBO.getStartTime()) || StringUtils.isEmpty((Object)reqBO.getEndTime())) {
            Date yesterday = DateUtil.getYesterday();
            startTimeStr = DateUtil.getDayStartTimeStr(yesterday);
            endTimeStr = DateUtil.getDayEndTimeStr(yesterday);
        } else {
            startTimeStr = reqBO.getStartTime();
            endTimeStr = reqBO.getEndTime();
        }
        boolean sixMonth = DateUtil.sixMonth(startTimeStr, endTimeStr, 6);
        if (!sixMonth) {
            return BaseRspUtils.createErrorRspList((String)"\u67e5\u8be2\u533a\u95f4\u5728\u516d\u4e2a\u6708\u5185");
        }
        DcGeneralCodePO codePO = new DcGeneralCodePO();
        codePO.setCodeType(tenantEvaluateCode);
        codePO.setCodeName(tenantEvaluateCode);
        codePO.setCodeStatus(PARENT_ID);
        DcGeneralCodePO generalCodePO = this.dcGeneralCodeDAO.selectByActivity(codePO);
        if (null == generalCodePO) {
            log.info("\u672a\u67e5\u8be2\u5230\u8bc4\u4ef7\u7edf\u8ba1\u79df\u6237");
            return BaseRspUtils.createErrorRspList((String)"\u672a\u67e5\u8be2\u5230\u8bc4\u4ef7\u7edf\u8ba1\u79df\u6237");
        }
        String str = generalCodePO.getCodeValue();
        log.info("\u8bc4\u4ef7\u79df\u6237\u5217\u8868={}", (Object)generalCodePO.getCodeValue());
        List<String> list = Arrays.asList(str.split(","));
        ArrayList<String> tenantIds = new ArrayList<String>();
        if (null != reqBO.getTenantIds() && reqBO.getTenantIds().size() > 0) {
            for (String tenantId : reqBO.getTenantIds()) {
                boolean contains = list.contains(tenantId);
                if (contains) continue;
                log.info("\u79df\u6237{}\u4e0d\u5728\u7edf\u8ba1\u8303\u56f4\u4e4b\u5185", (Object)tenantId);
                return BaseRspUtils.createErrorRspList((String)("\u79df\u6237" + tenantId + "\u4e0d\u5728\u7edf\u8ba1\u8303\u56f4\u4e4b\u5185"));
            }
        }
        tenantIds.addAll(reqBO.getTenantIds());
        if (null == tenantIds || tenantIds.size() == 0) {
            tenantIds.addAll(list);
        }
        int actSeatTotal = 0;
        int actHSeatTotal = 0;
        int actWSeatTotal = 0;
        for (String s : tenantIds) {
            QryTenantActNationCustRspBO bo = new QryTenantActNationCustRspBO();
            BladeTenantBO tenantInfo1 = this.getTenantInfo(s);
            if (null != tenantInfo1) {
                bo.setTenantName(tenantInfo1.getTenantName());
            }
            String stDate = startTimeStr.substring(0, startTimeStr.indexOf(" "));
            String endDate = endTimeStr.substring(0, endTimeStr.indexOf(" "));
            String data = null;
            data = endDate.equals(stDate) ? stDate : stDate + "~" + endDate;
            bo.setDate(data);
            int actHSeat = 0;
            int actWSeat = 0;
            BladeTenantBO tenantInfo = this.getTenantInfo(s);
            if (null == tenantInfo) {
                log.info("\u672a\u67e5\u8be2\u5230\u79df\u6237{}\u4fe1\u606f", (Object)s);
                continue;
            }
            log.info("\u67e5\u8be2\u6d3b\u8dc3\u5750\u5e2d\u5916\u547c\u8bb0\u5f55\u8868mapper\u5c42\u5165\u53c2\uff0cstartTimeStr={}\uff0cendTimeStr={}\uff0ctenantId={}\uff0ctenantOtherName={}", new Object[]{startTimeStr, endTimeStr, s, tenantInfo.getTenantOtherName()});
            List callRecordPOList = this.obCallRecordDAO.selectActSeat(startTimeStr, endTimeStr, s, tenantInfo.getTenantOtherName());
            if (null == callRecordPOList || callRecordPOList.size() <= 0) continue;
            actSeatTotal += callRecordPOList.size();
            for (ObCallRecordPO callRecordPO : callRecordPOList) {
                String userId = callRecordPO.getUserId();
                BladeUserBO bladeUserBO = this.bladeUserInterService.queryUserInfo(userId);
                if (null == bladeUserBO || StringUtils.isEmpty((Object)bladeUserBO.getNation())) continue;
                if ("\u6c49\u65cf".equals(bladeUserBO.getNation())) {
                    ++actHSeatTotal;
                    ++actHSeat;
                }
                if (!"\u7ef4\u543e\u5c14\u65cf".equals(bladeUserBO.getNation())) continue;
                ++actWSeatTotal;
                ++actWSeat;
            }
            bo.setCustOfH(String.valueOf(actHSeat));
            bo.setCustOfW(String.valueOf(actWSeat));
            bo.setCustTotal(String.valueOf(callRecordPOList.size()));
            boList.add(bo);
        }
        if (null != boList && boList.size() > 0) {
            for (QryTenantActNationCustRspBO bo : boList) {
                String hRate = this.percent(Integer.valueOf(bo.getCustOfH()), actHSeatTotal);
                bo.setCustOfHRate(hRate);
                String wRate = this.percent(Integer.valueOf(bo.getCustOfW()), actWSeatTotal);
                bo.setCustOfWRate(wRate);
                String sumRate = this.percent(Integer.valueOf(bo.getCustTotal()), actSeatTotal);
                bo.setCustTotalRate(sumRate);
            }
        }
        return BaseRspUtils.createSuccessRspList(boList);
    }

    public Rsp exportActSeat(QryTenantActNationCustReqBO reqBO) {
        log.info("\u5bfc\u51fa\u5916\u547c\u516c\u53f8\u6d3b\u8dc3\u5750\u5e2d\u5165\u53c2={}", (Object)JSONObject.toJSONString((Object)reqBO));
        String tenantId = StringUtils.isEmpty((Object)reqBO.getTenantCode()) ? reqBO.getIn_tenantCode() : reqBO.getTenantCode();
        int limit = reqBO.getLimit();
        reqBO.setLimit(1);
        RspList rspList = this.queryActCust(reqBO);
        if (rspList.getRspCode().equals("8888")) {
            log.info("\u67e5\u8be2\u79df\u6237\u7edf\u8ba1\u6570\u636e\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0={}", (Object)rspList.getRspDesc());
            return BaseRspUtils.createErrorRsp((String)"\u5bfc\u51fa\u5931\u8d25");
        }
        int count = (int)rspList.getCount();
        if (count == 0) {
            log.info("\u67e5\u8be2\u6570\u636e\u6761\u6570\u4e3a0");
            return BaseRspUtils.createSuccessRsp((Object)"", (String)"\u672a\u67e5\u8be2\u5230\u5f52\u5c5e\u5730\u6570\u636e");
        }
        int pageNumber = (count - 1) / limit + 1;
        reqBO.setLimit(limit);
        ArrayList<ExcelActSeatBO> excelBOS = new ArrayList<ExcelActSeatBO>();
        Integer index = 1;
        for (int i = 1; i <= pageNumber; ++i) {
            List rows;
            reqBO.setPage(i);
            RspList rsp = this.queryActCust(reqBO);
            if (!rsp.getRspCode().equals("0000") || (rows = rsp.getRows()) == null || rows.size() <= 0) continue;
            for (QryTenantActNationCustRspBO mt : rows) {
                ExcelActSeatBO exmt = new ExcelActSeatBO();
                BeanUtils.copyProperties((Object)mt, (Object)exmt);
                excelBOS.add(exmt);
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
            }
        }
        log.info("excelBOS\uff1a{}", (Object)JSONObject.toJSONString(excelBOS));
        String filePath = null;
        try {
            String fileName = "\u5916\u547c\u516c\u53f8\u6d3b\u8dc3\u5750\u5e2d\u62a5\u8868_" + tenantId + "_" + System.currentTimeMillis();
            filePath = this.excelHelper.writeExcel(excelBOS, ExcelActSeatBO.class, fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            return BaseRspUtils.createErrorRsp((String)"\u5bfc\u51fa\u5931\u8d25\uff01");
        }
        filePath = this.path + filePath.substring(filePath.lastIndexOf("/") + 1);
        log.info("filePath:{}", (Object)filePath);
        ExportRspBO rspBO = new ExportRspBO();
        rspBO.setFilePath(filePath);
        rspBO.setFileName(filePath.substring(filePath.lastIndexOf("/") + 1));
        return BaseRspUtils.createSuccessRsp((Object)rspBO);
    }

    public Rsp tenantEvaluateTask(TenantEvaluateTaskReqBO reqBO) {
        log.info("\u7edf\u8ba1\u5916\u547c\u516c\u53f8\u8bc4\u4ef7\u5165\u53c2={}", (Object)JSONObject.toJSONString((Object)reqBO));
        String startTime = null;
        String endTime = null;
        boolean flag = false;
        SimpleDateFormat stf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (StringUtils.isEmpty((Object)reqBO.getMouth())) {
            startTime = DateUtil.getBeforeMonthFirstDay();
            endTime = DateUtil.getBeforeMonthLastDay();
        } else {
            boolean form = RegularUtils.timeForm(reqBO.getMouth());
            if (!form) {
                return BaseRspUtils.createErrorRsp((String)"\u6708\u4efd\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
            }
            Date minDateMonth = DateUtil.getMinDateMonth(reqBO.getMouth());
            Date maxDateMonth = DateUtil.getMaxDateMonth(reqBO.getMouth());
            startTime = stf.format(minDateMonth);
            endTime = stf.format(maxDateMonth);
            flag = true;
        }
        DcGeneralCodePO codePO = new DcGeneralCodePO();
        codePO.setCodeType(tenantEvaluateCode);
        codePO.setCodeName(tenantEvaluateCode);
        codePO.setCodeStatus(PARENT_ID);
        DcGeneralCodePO generalCodePO = this.dcGeneralCodeDAO.selectByActivity(codePO);
        if (null == generalCodePO) {
            log.info("\u672a\u67e5\u8be2\u5230\u8bc4\u4ef7\u7edf\u8ba1\u79df\u6237");
            return BaseRspUtils.createErrorRsp((String)"\u672a\u67e5\u8be2\u5230\u8bc4\u4ef7\u7edf\u8ba1\u79df\u6237");
        }
        String str = generalCodePO.getCodeValue();
        log.info("\u8bc4\u4ef7\u79df\u6237\u5217\u8868={}", (Object)generalCodePO.getCodeValue());
        List<String> list = Arrays.asList(str.split(","));
        for (String s : list) {
            BladeTenantBO tenantInfo = this.getTenantInfo(s);
            TenantEvaluateTaskReqBO re = new TenantEvaluateTaskReqBO();
            re.setStartTime(startTime);
            re.setEndTime(endTime);
            re.setTenantCode(s);
            re.setTenantOtherName(tenantInfo.getTenantOtherName());
            try {
                this.singleTenantEvaluate(re, flag);
            }
            catch (Exception e) {
                log.error("\u79df\u6237\u6570\u636e\u7edf\u8ba1-\u79df\u6237{}\u51fa\u9519,\u9519\u8bef\u4fe1\u606f{}", (Object)reqBO.getTenantCode(), (Object)e.getMessage());
            }
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6210\u529f");
    }

    public RspList queryTenantEvaluate(QryTenantEvaluateReqBO reqBO) {
        log.info("\u67e5\u8be2\u5916\u547c\u516c\u53f8\u8bc4\u4ef7\u5165\u53c2={}", (Object)JSONObject.toJSONString((Object)reqBO));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List months = reqBO.getMonths();
        List tenantIds = reqBO.getTenantIds();
        String startTime = null;
        String endTime = null;
        ArrayList<QueryTenantEvaluateRspBO> boList = new ArrayList<QueryTenantEvaluateRspBO>();
        if (null != months && months.size() > 0) {
            boolean b = RegularUtils.timeForm((String)months.get(0));
            if (!b) {
                log.info("\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e{}", months.get(0));
                return BaseRspUtils.createErrorRspList((String)"\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            Date minDateMonth = DateUtil.getMinDateMonth((String)months.get(0));
            String s = (String)months.get(months.size() - 1);
            boolean b1 = RegularUtils.timeForm(s);
            if (!b1) {
                log.info("\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e{}", (Object)s);
                return BaseRspUtils.createErrorRspList((String)"\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            Date maxDateMonth = DateUtil.getMaxDateMonth(s);
            startTime = sdf.format(minDateMonth);
            endTime = sdf.format(maxDateMonth);
        } else {
            startTime = DateUtil.getBeforeMonthFirstDay();
            endTime = DateUtil.getBeforeMonthLastDay();
        }
        PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
        log.info("\u67e5\u8be2\u5916\u547c\u516c\u53f8\u8bc4\u4ef7mapper\u5c42\u5165\u53c2,startTime={},endTime={},tenantIds={}", new Object[]{startTime, endTime, tenantIds});
        List statisticsList = this.obTenantEvaluateStatisticsMapper.selectByTenants(startTime, endTime, tenantIds);
        PageInfo pageInfo = new PageInfo(statisticsList);
        long total = 0L;
        if (null != statisticsList && statisticsList.size() > 0) {
            total = pageInfo.getTotal();
            for (ObTenantEvaluateStatistics statistics : statisticsList) {
                QueryTenantEvaluateRspBO bo = new QueryTenantEvaluateRspBO();
                BeanUtils.copyProperties((Object)statistics, (Object)bo);
                bo.setId(statistics.getId().toString());
                bo.setTargetCount(statistics.getTargetNumber().toString());
                bo.setCallCount(statistics.getCallNumber().toString());
                bo.setSuccessCount(statistics.getSuccessNumber().toString());
                BladeTenantBO tenantInfo = this.getTenantInfo(statistics.getTenantId());
                bo.setTenantName(tenantInfo.getTenantName());
                bo.setRate(statistics.getDaBiaoRate());
                bo.setChangeRate(statistics.getSwitchRate());
                String date = null;
                try {
                    date = DateUtil.getYyyyMmDate(sdf.parse(statistics.getOldTime()));
                }
                catch (ParseException e) {
                    log.error("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38");
                    e.printStackTrace();
                }
                bo.setDate(date);
                boList.add(bo);
            }
        }
        return BaseRspUtils.createSuccessRspList(boList, (long)total);
    }

    public Rsp exportTenantEvaluate(QryTenantEvaluateReqBO reqBO) {
        log.info("\u5bfc\u51fa\u79df\u6237\u8bc4\u4ef7\u62a5\u8868\u5165\u53c2={}", (Object)JSONObject.toJSONString((Object)reqBO));
        String tenantId = StringUtils.isEmpty((Object)reqBO.getTenantCode()) ? reqBO.getIn_tenantCode() : reqBO.getTenantCode();
        int limit = reqBO.getLimit();
        reqBO.setLimit(1);
        RspList rspList = this.queryTenantEvaluate(reqBO);
        if (rspList.getRspCode().equals("8888")) {
            log.info("\u67e5\u8be2\u79df\u6237\u7edf\u8ba1\u6570\u636e\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0={}", (Object)rspList.getRspDesc());
            return BaseRspUtils.createErrorRsp((String)"\u5bfc\u51fa\u5931\u8d25");
        }
        int count = (int)rspList.getCount();
        if (count == 0) {
            log.info("\u67e5\u8be2\u6570\u636e\u6761\u6570\u4e3a0");
            return BaseRspUtils.createSuccessRsp((Object)"", (String)"\u672a\u67e5\u8be2\u5230\u5f52\u5c5e\u5730\u6570\u636e");
        }
        int pageNumber = (count - 1) / limit + 1;
        reqBO.setLimit(limit);
        ArrayList<ExcelTenantEvaluateBO> excelBOS = new ArrayList<ExcelTenantEvaluateBO>();
        Integer index = 1;
        for (int i = 1; i <= pageNumber; ++i) {
            List rows;
            reqBO.setPage(i);
            RspList rsp = this.queryTenantEvaluate(reqBO);
            if (!rsp.getRspCode().equals("0000") || (rows = rsp.getRows()) == null || rows.size() <= 0) continue;
            for (QueryTenantEvaluateRspBO mt : rows) {
                ExcelTenantEvaluateBO exmt = new ExcelTenantEvaluateBO();
                BeanUtils.copyProperties((Object)mt, (Object)exmt);
                excelBOS.add(exmt);
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
            }
        }
        log.info("excelBOS\uff1a{}", (Object)JSONObject.toJSONString(excelBOS));
        String filePath = null;
        try {
            String fileName = "\u5916\u547c\u516c\u53f8\u8bc4\u4ef7\u62a5\u8868_" + tenantId + "_" + System.currentTimeMillis();
            filePath = this.excelHelper.writeExcel(excelBOS, ExcelTenantEvaluateBO.class, fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            return BaseRspUtils.createErrorRsp((String)"\u5bfc\u51fa\u5931\u8d25\uff01");
        }
        filePath = this.path + filePath.substring(filePath.lastIndexOf("/") + 1);
        log.info("filePath:{}", (Object)filePath);
        ExportRspBO rspBO = new ExportRspBO();
        rspBO.setFilePath(filePath);
        rspBO.setFileName(filePath.substring(filePath.lastIndexOf("/") + 1));
        return BaseRspUtils.createSuccessRsp((Object)rspBO);
    }

    public RspList grabTask(GrabTaskStatisticsReqBO reqBO) {
        log.info("\u62a2\u5355grabTask\u7edf\u8ba1\u5165\u53c2={}", (Object)JSONObject.toJSONString((Object)reqBO));
        String startTimeStr = null;
        String endTimeStr = null;
        SimpleDateFormat stf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (StringUtils.isEmpty((Object)reqBO.getStartTime()) || StringUtils.isEmpty((Object)reqBO.getEndTime())) {
            Date yesterday = DateUtil.getYesterday();
            startTimeStr = DateUtil.getDayStartTimeStr(yesterday);
            endTimeStr = DateUtil.getDayEndTimeStr(yesterday);
        } else {
            startTimeStr = reqBO.getStartTime();
            endTimeStr = reqBO.getEndTime();
        }
        ArrayList<ObGrabStatistics> boList = new ArrayList<ObGrabStatistics>();
        List infoPOList = this.obTaskInfoDAO.selectGrab(startTimeStr, endTimeStr);
        if (null != infoPOList && infoPOList.size() > 0) {
            for (ObTaskInfoPO taskInfoPO : infoPOList) {
                List grabTaskTenants;
                ArrayList<ObGrabStatistics> poList = new ArrayList<ObGrabStatistics>();
                int totalCount = 0;
                Long dialCount = 0L;
                Long waitCallCount = 0L;
                Long isConnCount = 0L;
                Long isNotConnCount = 0L;
                Long callLoseCount = 0L;
                BladeTenantBO selfInfo = this.getTenantInfo(taskInfoPO.getTenantId());
                ObCallRecordPO selfRecord = new ObCallRecordPO();
                selfRecord.setTenantId(taskInfoPO.getTenantId());
                selfRecord.setTaskId(taskInfoPO.getTaskId());
                selfRecord.setTenantOtherName(selfInfo.getTenantOtherName());
                List selfList = this.obCallRecordDAO.selectByTaskId(selfRecord);
                if (null != selfList && selfList.size() > 0) {
                    dialCount = dialCount + (long)selfList.size();
                }
                ObDataTargetPO targetPO = new ObDataTargetPO();
                targetPO.setTenantId(selfInfo.getTenantId());
                targetPO.setTaskId(taskInfoPO.getTaskId());
                targetPO.setTenantOtherName(selfInfo.getTenantOtherName());
                List targetPOList = this.obDataTargetDAO.selectByTaskId(targetPO);
                if (null != targetPOList && targetPOList.size() > 0) {
                    totalCount = targetPOList.size();
                }
                if (null == (grabTaskTenants = this.obTaskTenantDAO.selectByTaskId(taskInfoPO.getTaskId())) || grabTaskTenants.size() <= 0) continue;
                for (ObTaskTenantPO taskTenant : grabTaskTenants) {
                    int custNum = 0;
                    int avgSeatCall = 0;
                    List rows = this.dcJobNumberInterService.getJobNumberBindRecord(startTimeStr, endTimeStr, taskTenant.getTenantId());
                    ObGrabStatistics po = new ObGrabStatistics();
                    po.setTaskId(taskInfoPO.getTaskId());
                    po.setTenantId(taskTenant.getTenantId());
                    po.setTaskName(taskInfoPO.getTaskName());
                    po.setProductName(taskInfoPO.getProductName());
                    BladeTenantBO tenantInfo1 = this.getTenantInfo(taskTenant.getTenantId());
                    if (null == tenantInfo1) {
                        log.info("\u4e3a\u67e5\u8be2\u5230\u79df\u6237\u4fe1\u606f\uff1b{}", (Object)taskInfoPO.getTenantId());
                        continue;
                    }
                    ObCallRecordPO callRecordPO = new ObCallRecordPO();
                    callRecordPO.setTenantId(taskTenant.getTenantId());
                    callRecordPO.setTaskId(taskInfoPO.getTaskId());
                    callRecordPO.setTenantOtherName(tenantInfo1.getTenantOtherName());
                    callRecordPO.setQryStartTime(startTimeStr);
                    callRecordPO.setQryEndTime(endTimeStr);
                    List obCallRecordPOS = this.obCallRecordDAO.selectByTaskId(callRecordPO);
                    List dgCount = this.obProductSubscribeDAO.selectByTaskAndTenant(taskInfoPO.getTaskId(), taskTenant.getTenantId());
                    if (null != dgCount && dgCount.size() > 0) {
                        po.setBuySuccessNumber(Integer.valueOf(dgCount.size()));
                    }
                    if (null == obCallRecordPOS || obCallRecordPOS.size() <= 0) continue;
                    Long conn = obCallRecordPOS.stream().filter(callRecord -> callRecord.getIsConn().equals(PARENT_ID) && callRecord.getObsIsConn().equals(PARENT_ID)).count();
                    po.setConnectNumber(Integer.valueOf(conn.intValue()));
                    Long notConn = obCallRecordPOS.stream().filter(callRecord -> callRecord.getIsConn().equals("0") && callRecord.getObsIsConn().equals("0")).count();
                    Long callLose = obCallRecordPOS.stream().filter(callRecord -> callRecord.getObsIsConn().equals(PARENT_ID) && callRecord.getIsConn().equals("0")).count();
                    isConnCount = isConnCount + conn;
                    isNotConnCount = isNotConnCount + notConn;
                    callLoseCount = callLoseCount + callLose;
                    Map<String, List<ObCallRecordPO>> listMap = obCallRecordPOS.stream().collect(Collectors.groupingBy(ObCallRecordPO::getJobNumber));
                    for (String key : listMap.keySet()) {
                        List<ObCallRecordPO> pos = listMap.get(key);
                        String startTalkTime = pos.get(0).getTalkTime();
                        String endTalkTime = pos.get(pos.size() - 1).getTalkTime();
                        log.info("\u5f53\u524d\u5de5\u53f7\uff1a{}\uff0c \u7b2c\u4e00\u6b21\u5916\u547c\u65f6\u95f4\uff1a{}\uff0c \u6700\u540e\u4e00\u6b21\u5916\u547c\u65f6\u95f4\uff1a{}", new Object[]{key, startTalkTime, endTalkTime});
                        Long num1 = rows.stream().filter(bindRecord -> key.equals(bindRecord.getJobNumber()) && null == bindRecord.getUnBindTime() && endTalkTime.compareTo(bindRecord.getBindTime()) > 0).count();
                        List bos = rows.stream().filter(bindRecord -> key.equals(bindRecord.getJobNumber()) && null == bindRecord.getUnBindTime() && endTalkTime.compareTo(bindRecord.getBindTime()) > 0).collect(Collectors.toList());
                        log.info("bos:{}", (Object)JSONObject.toJSONString(bos));
                        Long num2 = rows.stream().filter(bindRecord -> key.equals(bindRecord.getJobNumber()) && null != bindRecord.getUnBindTime() && endTalkTime.compareTo(bindRecord.getUnBindTime()) < 0).count();
                        List bos1 = rows.stream().filter(bindRecord -> key.equals(bindRecord.getJobNumber()) && null != bindRecord.getUnBindTime() && endTalkTime.compareTo(bindRecord.getUnBindTime()) < 0).collect(Collectors.toList());
                        log.info("bos1:{}", (Object)JSONObject.toJSONString(bos1));
                        custNum += num1.intValue() + num2.intValue();
                        log.info("num1:{},num2{}", (Object)num1, (Object)num2);
                    }
                    po.setActSeatNumber(Integer.valueOf(custNum));
                    String s = this.percent2((double)conn.longValue(), custNum);
                    Double aDouble = Double.valueOf(s);
                    double floor = Math.floor(aDouble);
                    avgSeatCall = new Double(floor).intValue();
                    po.setAvgSeatCallNumber(Integer.valueOf(avgSeatCall));
                    poList.add(po);
                }
                waitCallCount = (long)totalCount - (dialCount = Long.valueOf(dialCount + (isConnCount + isNotConnCount + callLoseCount)));
                if (waitCallCount < 0L) {
                    waitCallCount = 0L;
                }
                if (null == poList || poList.size() <= 0) continue;
                for (ObGrabStatistics ss : poList) {
                    ss.setTargetNumber(Integer.valueOf(totalCount));
                    ss.setCallNumber(Integer.valueOf(dialCount.intValue()));
                    ss.setWaitingNumber(Integer.valueOf(waitCallCount.intValue()));
                    ss.setOldTime(startTimeStr);
                    ss.setCreateTime(stf.format(new Date()));
                    boList.add(ss);
                }
            }
        }
        return BaseRspUtils.createSuccessRspList(boList);
    }

    public Rsp grabTimeTask(GrabTaskStatisticsReqBO reqBO) {
        List rows;
        log.info("\u62a2\u5355\u5b9a\u65f6\u4efb\u52a1\u5165\u53c2={}", (Object)JSONObject.toJSONString((Object)reqBO));
        RspList rspList = this.grabTask(reqBO);
        if (null != rspList && "0000".equals(rspList.getRspCode()) && null != (rows = rspList.getRows()) && rows.size() > 0) {
            for (ObGrabStatistics row : rows) {
                this.obGrabStatisticsMapper.insertSelective(row);
            }
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6267\u884c\u62a2\u5355\u5b9a\u65f6\u4efb\u52a1\u6210\u529f");
    }

    public RspList queryGrabStatistics(QueryGrabStatisticsReqBO reqBO) {
        boolean flage = false;
        log.info("\u67e5\u8be2\u62a2\u5355\u62a5\u8868\u5165\u53c2={}", (Object)JSONObject.toJSONString((Object)reqBO));
        List tenantIds = reqBO.getTenantIds();
        String taskName = reqBO.getTaskName();
        String productName = reqBO.getProductName();
        ArrayList<Object> boList = new ArrayList<Object>();
        String startTimeStr = null;
        String endTimeStr = null;
        if (StringUtils.isEmpty((Object)reqBO.getStartTime()) || StringUtils.isEmpty((Object)reqBO.getEndTime())) {
            Date yesterday = DateUtil.getYesterday();
            startTimeStr = DateUtil.getDayStartTimeStr(yesterday);
            endTimeStr = DateUtil.getDayEndTimeStr(yesterday);
        } else {
            startTimeStr = reqBO.getStartTime();
            endTimeStr = reqBO.getEndTime();
            flage = DateUtil.nowTimeIsInsideTargetTime(startTimeStr, endTimeStr);
        }
        boolean sixMonth = DateUtil.sixMonth(startTimeStr, endTimeStr, 6);
        if (!sixMonth) {
            return BaseRspUtils.createErrorRspList((String)"\u67e5\u8be2\u533a\u95f4\u5728\u516d\u4e2a\u6708\u5185");
        }
        log.info("\u67e5\u8be2\u62a2\u5355\u62a5\u8868mapper\u5c42\u5165\u53c2\uff0cstartTimeStr={}\uff0cendTimeStr={}\uff0ctaskName={}\uff0ctenantIds={},productName={}", new Object[]{startTimeStr, endTimeStr, taskName, tenantIds, productName});
        List grabStatistics = this.obGrabStatisticsMapper.selectActive(startTimeStr, endTimeStr, taskName, tenantIds, productName);
        if (null != grabStatistics && grabStatistics.size() > 0) {
            for (ObGrabStatistics statistic : grabStatistics) {
                QueryGrabStatisticsRspBO bo = new QueryGrabStatisticsRspBO();
                bo.setActSeatCount(statistic.getActSeatNumber().toString());
                bo.setAvgSeatCallCount(statistic.getAvgSeatCallNumber().toString());
                bo.setBuySuccessCount(statistic.getBuySuccessNumber() == null ? "0" : statistic.getBuySuccessNumber().toString());
                bo.setCallCount(statistic.getCallNumber().toString());
                bo.setTargetCount(statistic.getTargetNumber().toString());
                bo.setWaitCallCount(statistic.getWaitingNumber().toString());
                bo.setProductName(statistic.getProductName());
                bo.setConnectionCount(statistic.getConnectNumber().toString());
                BladeTenantBO tenantInfo = this.getTenantInfo(statistic.getTenantId());
                bo.setTenantName(tenantInfo.getTenantName());
                String data = statistic.getOldTime().substring(0, statistic.getOldTime().indexOf(" "));
                bo.setDate(data);
                bo.setTaskName(statistic.getTaskName());
                boList.add(bo);
            }
        }
        if (flage) {
            List rows;
            GrabTaskStatisticsReqBO re = new GrabTaskStatisticsReqBO();
            String dayStartTimeStr = DateUtil.getDayStartTimeStr(new Date());
            String dayEndTimeStr = DateUtil.getDayEndTimeStr(new Date());
            re.setStartTime(dayStartTimeStr);
            re.setEndTime(dayEndTimeStr);
            RspList rspList = this.grabTask(re);
            if (null != rspList && "0000".equals(rspList.getRspCode()) && null != (rows = rspList.getRows()) && rows.size() > 0) {
                String data;
                BladeTenantBO tenantInfo;
                Object bo;
                List collect;
                String data2;
                BladeTenantBO tenantInfo2;
                QueryGrabStatisticsRspBO bo2;
                List collect2;
                Iterator tenantId2;
                boolean tenantFlag = false;
                boolean taskFlag = false;
                boolean productFlag = false;
                if (!StringUtils.isEmpty((Object)reqBO.getProductName())) {
                    productFlag = true;
                }
                if (!StringUtils.isEmpty((Object)reqBO.getTaskName())) {
                    taskFlag = true;
                }
                if (null != reqBO.getTenantIds() && reqBO.getTenantIds().size() > 0) {
                    tenantFlag = true;
                }
                if (!(tenantFlag || taskFlag || productFlag)) {
                    for (ObGrabStatistics row : rows) {
                        QueryGrabStatisticsRspBO bo3 = new QueryGrabStatisticsRspBO();
                        bo3.setConnectionCount(row.getConnectNumber().toString());
                        bo3.setProductName(row.getProductName());
                        bo3.setTaskName(row.getTaskName());
                        bo3.setWaitCallCount(row.getWaitingNumber().toString());
                        bo3.setTargetCount(row.getTargetNumber().toString());
                        bo3.setCallCount(row.getCallNumber().toString());
                        bo3.setBuySuccessCount(row.getBuySuccessNumber() == null ? "0" : row.getBuySuccessNumber().toString());
                        bo3.setAvgSeatCallCount(row.getAvgSeatCallNumber().toString());
                        bo3.setActSeatCount(row.getActSeatNumber().toString());
                        BladeTenantBO tenantInfo3 = this.getTenantInfo(row.getTenantId());
                        if (null != tenantInfo3) {
                            bo3.setTenantName(tenantInfo3.getTenantName());
                        }
                        String data3 = row.getOldTime().substring(0, row.getOldTime().indexOf(" "));
                        bo3.setDate(data3);
                        boList.add(bo3);
                    }
                }
                if (tenantFlag && !taskFlag && !productFlag) {
                    for (Iterator tenantId2 : reqBO.getTenantIds()) {
                        collect2 = rows.stream().filter(arg_0 -> TimedTasksImp.lambda$queryGrabStatistics$11((String)((Object)tenantId2), arg_0)).collect(Collectors.toList());
                        if (null == collect2 || collect2.size() <= 0) continue;
                        for (ObGrabStatistics row : collect2) {
                            bo2 = new QueryGrabStatisticsRspBO();
                            bo2.setConnectionCount(row.getConnectNumber().toString());
                            bo2.setProductName(row.getProductName());
                            bo2.setTaskName(row.getTaskName());
                            bo2.setWaitCallCount(row.getWaitingNumber().toString());
                            bo2.setTargetCount(row.getTargetNumber().toString());
                            bo2.setCallCount(row.getCallNumber().toString());
                            bo2.setBuySuccessCount(row.getBuySuccessNumber() == null ? "0" : row.getBuySuccessNumber().toString());
                            bo2.setAvgSeatCallCount(row.getAvgSeatCallNumber().toString());
                            bo2.setActSeatCount(row.getActSeatNumber().toString());
                            tenantInfo2 = this.getTenantInfo(row.getTenantId());
                            if (null != tenantInfo2) {
                                bo2.setTenantName(tenantInfo2.getTenantName());
                            }
                            data2 = row.getOldTime().substring(0, row.getOldTime().indexOf(" "));
                            bo2.setDate(data2);
                            boList.add(bo2);
                        }
                    }
                }
                if (taskFlag && !tenantFlag && !productFlag && null != (collect = rows.stream().filter(e -> e.getTaskName().contains(reqBO.getTaskName())).collect(Collectors.toList())) && collect.size() > 0) {
                    for (ObGrabStatistics row : collect) {
                        bo = new QueryGrabStatisticsRspBO();
                        bo.setConnectionCount(row.getConnectNumber().toString());
                        bo.setProductName(row.getProductName());
                        bo.setTaskName(row.getTaskName());
                        bo.setWaitCallCount(row.getWaitingNumber().toString());
                        bo.setTargetCount(row.getTargetNumber().toString());
                        bo.setCallCount(row.getCallNumber().toString());
                        bo.setBuySuccessCount(row.getBuySuccessNumber() == null ? "0" : row.getBuySuccessNumber().toString());
                        bo.setAvgSeatCallCount(row.getAvgSeatCallNumber().toString());
                        bo.setActSeatCount(row.getActSeatNumber().toString());
                        tenantInfo = this.getTenantInfo(row.getTenantId());
                        if (null != tenantInfo) {
                            bo.setTenantName(tenantInfo.getTenantName());
                        }
                        data = row.getOldTime().substring(0, row.getOldTime().indexOf(" "));
                        bo.setDate(data);
                        boList.add(bo);
                    }
                }
                if (productFlag && !tenantFlag && !taskFlag && null != (collect = rows.stream().filter(e -> e.getProductName().contains(reqBO.getProductName())).collect(Collectors.toList())) && collect.size() > 0) {
                    for (ObGrabStatistics row : collect) {
                        bo = new QueryGrabStatisticsRspBO();
                        bo.setConnectionCount(row.getConnectNumber().toString());
                        bo.setProductName(row.getProductName());
                        bo.setTaskName(row.getTaskName());
                        bo.setWaitCallCount(row.getWaitingNumber().toString());
                        bo.setTargetCount(row.getTargetNumber().toString());
                        bo.setCallCount(row.getCallNumber().toString());
                        bo.setBuySuccessCount(row.getBuySuccessNumber() == null ? "0" : row.getBuySuccessNumber().toString());
                        bo.setAvgSeatCallCount(row.getAvgSeatCallNumber().toString());
                        bo.setActSeatCount(row.getActSeatNumber().toString());
                        tenantInfo = this.getTenantInfo(row.getTenantId());
                        if (null != tenantInfo) {
                            bo.setTenantName(tenantInfo.getTenantName());
                        }
                        data = row.getOldTime().substring(0, row.getOldTime().indexOf(" "));
                        bo.setDate(data);
                        boList.add(bo);
                    }
                }
                if (tenantFlag && taskFlag && !productFlag) {
                    collect = reqBO.getTenantIds().iterator();
                    while (collect.hasNext()) {
                        tenantId2 = (String)collect.next();
                        collect2 = rows.stream().filter(e -> tenantId2.equals(e.getTenantId()) && e.getTaskName().contains(reqBO.getTaskName())).collect(Collectors.toList());
                        if (null == collect2 || collect2.size() <= 0) continue;
                        for (ObGrabStatistics row : collect2) {
                            bo2 = new QueryGrabStatisticsRspBO();
                            bo2.setConnectionCount(row.getConnectNumber().toString());
                            bo2.setProductName(row.getProductName());
                            bo2.setTaskName(row.getTaskName());
                            bo2.setWaitCallCount(row.getWaitingNumber().toString());
                            bo2.setTargetCount(row.getTargetNumber().toString());
                            bo2.setCallCount(row.getCallNumber().toString());
                            bo2.setBuySuccessCount(row.getBuySuccessNumber() == null ? "0" : row.getBuySuccessNumber().toString());
                            bo2.setAvgSeatCallCount(row.getAvgSeatCallNumber().toString());
                            bo2.setActSeatCount(row.getActSeatNumber().toString());
                            tenantInfo2 = this.getTenantInfo(row.getTenantId());
                            if (null != tenantInfo2) {
                                bo2.setTenantName(tenantInfo2.getTenantName());
                            }
                            data2 = row.getOldTime().substring(0, row.getOldTime().indexOf(" "));
                            bo2.setDate(data2);
                            boList.add(bo2);
                        }
                    }
                }
                if (tenantFlag && productFlag && !taskFlag) {
                    collect = reqBO.getTenantIds().iterator();
                    while (collect.hasNext()) {
                        tenantId2 = (String)collect.next();
                        collect2 = rows.stream().filter(e -> tenantId2.equals(e.getTenantId()) && e.getProductName().contains(reqBO.getProductName())).collect(Collectors.toList());
                        if (null == collect2 || collect2.size() <= 0) continue;
                        for (ObGrabStatistics row : collect2) {
                            bo2 = new QueryGrabStatisticsRspBO();
                            bo2.setConnectionCount(row.getConnectNumber().toString());
                            bo2.setProductName(row.getProductName());
                            bo2.setTaskName(row.getTaskName());
                            bo2.setWaitCallCount(row.getWaitingNumber().toString());
                            bo2.setTargetCount(row.getTargetNumber().toString());
                            bo2.setCallCount(row.getCallNumber().toString());
                            bo2.setBuySuccessCount(row.getBuySuccessNumber() == null ? "0" : row.getBuySuccessNumber().toString());
                            bo2.setAvgSeatCallCount(row.getAvgSeatCallNumber().toString());
                            bo2.setActSeatCount(row.getActSeatNumber().toString());
                            tenantInfo2 = this.getTenantInfo(row.getTenantId());
                            if (null != tenantInfo2) {
                                bo2.setTenantName(tenantInfo2.getTenantName());
                            }
                            data2 = row.getOldTime().substring(0, row.getOldTime().indexOf(" "));
                            bo2.setDate(data2);
                            boList.add(bo2);
                        }
                    }
                }
                if (taskFlag && productFlag && !tenantFlag && null != (collect = rows.stream().filter(e -> e.getTaskName().contains(reqBO.getTaskName()) && e.getProductName().contains(reqBO.getProductName())).collect(Collectors.toList())) && collect.size() > 0) {
                    for (ObGrabStatistics row : collect) {
                        bo = new QueryGrabStatisticsRspBO();
                        bo.setConnectionCount(row.getConnectNumber().toString());
                        bo.setProductName(row.getProductName());
                        bo.setTaskName(row.getTaskName());
                        bo.setWaitCallCount(row.getWaitingNumber().toString());
                        bo.setTargetCount(row.getTargetNumber().toString());
                        bo.setCallCount(row.getCallNumber().toString());
                        bo.setBuySuccessCount(row.getBuySuccessNumber() == null ? "0" : row.getBuySuccessNumber().toString());
                        bo.setAvgSeatCallCount(row.getAvgSeatCallNumber().toString());
                        bo.setActSeatCount(row.getActSeatNumber().toString());
                        tenantInfo = this.getTenantInfo(row.getTenantId());
                        if (null != tenantInfo) {
                            bo.setTenantName(tenantInfo.getTenantName());
                        }
                        data = row.getOldTime().substring(0, row.getOldTime().indexOf(" "));
                        bo.setDate(data);
                        boList.add(bo);
                    }
                }
                if (tenantFlag && taskFlag && productFlag) {
                    for (Iterator tenantId2 : reqBO.getTenantIds()) {
                        collect2 = rows.stream().filter(e -> tenantId2.equals(e.getTenantId()) && e.getTaskName().contains(reqBO.getTaskName()) && e.getProductName().contains(reqBO.getProductName())).collect(Collectors.toList());
                        if (null == collect2 || collect2.size() <= 0) continue;
                        for (ObGrabStatistics row : collect2) {
                            bo2 = new QueryGrabStatisticsRspBO();
                            bo2.setConnectionCount(row.getConnectNumber().toString());
                            bo2.setProductName(row.getProductName());
                            bo2.setTaskName(row.getTaskName());
                            bo2.setWaitCallCount(row.getWaitingNumber().toString());
                            bo2.setTargetCount(row.getTargetNumber().toString());
                            bo2.setCallCount(row.getCallNumber().toString());
                            bo2.setBuySuccessCount(row.getBuySuccessNumber() == null ? "0" : row.getBuySuccessNumber().toString());
                            bo2.setAvgSeatCallCount(row.getAvgSeatCallNumber().toString());
                            bo2.setActSeatCount(row.getActSeatNumber().toString());
                            tenantInfo2 = this.getTenantInfo(row.getTenantId());
                            if (null != tenantInfo2) {
                                bo2.setTenantName(tenantInfo2.getTenantName());
                            }
                            data2 = row.getOldTime().substring(0, row.getOldTime().indexOf(" "));
                            bo2.setDate(data2);
                            boList.add(bo2);
                        }
                    }
                }
            }
        }
        List collect = boList.stream().skip(reqBO.getLimit() * (reqBO.getPage() - 1)).limit(reqBO.getLimit()).collect(Collectors.toList());
        return BaseRspUtils.createSuccessRspList(collect, (long)boList.size());
    }

    public Rsp exportGrabStatistics(QueryGrabStatisticsReqBO reqBO) {
        log.info("\u5bfc\u51fa\u62a2\u5355\u62a5\u8868\u5165\u53c2={}", (Object)JSONObject.toJSONString((Object)reqBO));
        String tenantId = StringUtils.isEmpty((Object)reqBO.getTenantCode()) ? reqBO.getIn_tenantCode() : reqBO.getTenantCode();
        int limit = reqBO.getLimit();
        reqBO.setLimit(1);
        RspList rspList = this.queryGrabStatistics(reqBO);
        if (rspList.getRspCode().equals("8888")) {
            log.info("\u67e5\u8be2\u62a2\u5355\u7edf\u8ba1\u6570\u636e\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0={}", (Object)rspList.getRspDesc());
            return BaseRspUtils.createErrorRsp((String)"\u5bfc\u51fa\u5931\u8d25");
        }
        int count = (int)rspList.getCount();
        if (count == 0) {
            log.info("\u67e5\u8be2\u6570\u636e\u6761\u6570\u4e3a0");
            return BaseRspUtils.createSuccessRsp((Object)"", (String)"\u672a\u67e5\u8be2\u5230\u62a2\u5355\u6570\u636e");
        }
        int pageNumber = (count - 1) / limit + 1;
        reqBO.setLimit(limit);
        ArrayList<ExcelGrabStatisticsBO> excelBOS = new ArrayList<ExcelGrabStatisticsBO>();
        Integer index = 1;
        for (int i = 1; i <= pageNumber; ++i) {
            List rows;
            reqBO.setPage(i);
            RspList rsp = this.queryGrabStatistics(reqBO);
            if (!rsp.getRspCode().equals("0000") || (rows = rsp.getRows()) == null || rows.size() <= 0) continue;
            for (QueryGrabStatisticsRspBO mt : rows) {
                ExcelGrabStatisticsBO exmt = new ExcelGrabStatisticsBO();
                BeanUtils.copyProperties((Object)mt, (Object)exmt);
                excelBOS.add(exmt);
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
            }
        }
        log.info("excelBOS\uff1a{}", (Object)JSONObject.toJSONString(excelBOS));
        String filePath = null;
        try {
            String fileName = "\u62a2\u5355\u62a5\u8868_" + tenantId + "_" + System.currentTimeMillis();
            filePath = this.excelHelper.writeExcel(excelBOS, ExcelGrabStatisticsBO.class, fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            return BaseRspUtils.createErrorRsp((String)"\u5bfc\u51fa\u5931\u8d25\uff01");
        }
        filePath = this.path + filePath.substring(filePath.lastIndexOf("/") + 1);
        log.info("filePath:{}", (Object)filePath);
        ExportRspBO rspBO = new ExportRspBO();
        rspBO.setFilePath(filePath);
        rspBO.setFileName(filePath.substring(filePath.lastIndexOf("/") + 1));
        return BaseRspUtils.createSuccessRsp((Object)rspBO);
    }

    public RspList evaluateTenantCode(Req req) {
        String codeValue;
        ArrayList<EvaluateTenantInfoBO> boList = new ArrayList<EvaluateTenantInfoBO>();
        DcGeneralCodePO codePO = new DcGeneralCodePO();
        codePO.setCodeType(tenantEvaluateCode);
        codePO.setCodeName(tenantEvaluateCode);
        codePO.setCodeStatus(PARENT_ID);
        DcGeneralCodePO generalCodePO = this.dcGeneralCodeDAO.selectByActivity(codePO);
        if (null != generalCodePO && null != (codeValue = generalCodePO.getCodeValue())) {
            List<String> list = Arrays.asList(codeValue.split(","));
            for (String s : list) {
                EvaluateTenantInfoBO bo = new EvaluateTenantInfoBO();
                BladeTenantBO tenantInfo = this.getTenantInfo(s);
                bo.setTenantId(s);
                if (null != tenantInfo) {
                    bo.setTenantName(tenantInfo.getTenantName());
                }
                boList.add(bo);
            }
        }
        return BaseRspUtils.createSuccessRspList(boList);
    }

    public void singleTenantEvaluate(TenantEvaluateTaskReqBO reqBO, boolean flag) {
        List tenantStatistics;
        Date minDateMonth;
        String months;
        log.info("\u5355\u4e2a\u5916\u547c\u516c\u53f8\u8bc4\u4ef7\u7edf\u8ba1\u5165\u53c2= {}", (Object)JSONObject.toJSONString((Object)reqBO));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList<String> tenantIds = new ArrayList<String>();
        tenantIds.add(reqBO.getTenantCode());
        int targetTotal = 0;
        int callTotal = 0;
        int successTotal = 0;
        String daBiaoRate = "0%";
        String switchRate = "0%";
        String scoreOne = "0";
        String scoreTwo = "0";
        double baseValue = 0.0;
        String sTime = null;
        String eTime = null;
        if (flag) {
            months = DateUtil.getLast12Months(3, reqBO.getStartTime());
            minDateMonth = DateUtil.getMinDateMonth(months);
            sTime = sdf.format(minDateMonth);
            String months1 = DateUtil.getLast12Months(1, reqBO.getStartTime());
            Date maxDateMonth = DateUtil.getMaxDateMonth(months1);
            eTime = sdf.format(maxDateMonth);
        } else {
            months = DateUtil.getLast12Months(2, reqBO.getStartTime());
            minDateMonth = DateUtil.getMinDateMonth(months);
            sTime = sdf.format(minDateMonth);
            eTime = reqBO.getEndTime();
        }
        log.info("\u67e5\u8be2\u524d\u4e09\u4e2a\u6708\u6570\u636emapper\u5c42\u5165\u53c2\uff0cstime={}\uff0cetime={}", (Object)sTime, (Object)eTime);
        List evaluateStatistics = this.obTenantEvaluateStatisticsMapper.selectByTime(sTime, eTime);
        if (null != evaluateStatistics && evaluateStatistics.size() > 0) {
            int threeMonthsSuccess = 0;
            int threeMonthsTarget = 0;
            for (ObTenantEvaluateStatistics statistic : evaluateStatistics) {
                threeMonthsSuccess += statistic.getSuccessNumber().intValue();
                threeMonthsTarget += statistic.getTargetNumber().intValue();
            }
            String percent = this.percent(threeMonthsSuccess, threeMonthsTarget);
            baseValue = Double.valueOf(percent.substring(0, percent.indexOf("%")));
            String pp = this.percent2(baseValue, 100);
            baseValue = Double.valueOf(pp);
        }
        if (null != (tenantStatistics = this.obTenantStatisticsMapper.selectActive(reqBO.getStartTime(), reqBO.getEndTime(), tenantIds)) && tenantStatistics.size() > 0) {
            for (ObTenantStatistics statistic : tenantStatistics) {
                targetTotal += statistic.getTargetNumber().intValue();
                callTotal += statistic.getCallNumber().intValue();
                successTotal += statistic.getSuccessNumber().intValue();
            }
            daBiaoRate = this.percent(callTotal, targetTotal);
            switchRate = this.percent(successTotal, targetTotal);
            Double aDouble = Double.valueOf(daBiaoRate.substring(0, daBiaoRate.indexOf("%")));
            double mulitDate1 = this.mulitDate(aDouble, 0.003);
            double mulitDate2 = this.mulitDate(20.0, 0.7 + mulitDate1);
            log.info("mulitDate1={},mulitDate2={}", (Object)mulitDate1, (Object)mulitDate2);
            scoreOne = String.valueOf(mulitDate2);
            String lastMonth = DateUtil.getLast12Months(1, reqBO.getStartTime());
            Date minDateMonth2 = DateUtil.getMinDateMonth(lastMonth);
            Date maxDateMonth = DateUtil.getMaxDateMonth(lastMonth);
            ObTenantEvaluateStatistics lastMonthData = this.obTenantEvaluateStatisticsMapper.selectLastMonth(sdf.format(minDateMonth2), sdf.format(maxDateMonth), reqBO.getTenantCode());
            if (null != lastMonthData) {
                String s = this.percent2((double)lastMonthData.getSuccessNumber().intValue(), lastMonthData.getTargetNumber());
                String s1 = this.percent2((double)Double.valueOf(s), baseValue);
                double v1 = Double.valueOf(s1) * 50.0;
                scoreTwo = String.valueOf(v1);
            }
            ObTenantEvaluateStatistics po = new ObTenantEvaluateStatistics();
            po.setBaseValue(String.valueOf(baseValue));
            po.setCallNumber(Integer.valueOf(callTotal));
            po.setCreateTime(sdf.format(new Date()));
            po.setDaBiaoRate(daBiaoRate);
            po.setOldTime(reqBO.getStartTime());
            po.setScoreOne(scoreOne);
            po.setScoreTwo(scoreTwo);
            po.setSuccessNumber(Integer.valueOf(successTotal));
            po.setSwitchRate(switchRate);
            po.setTargetNumber(Integer.valueOf(targetTotal));
            po.setTenantId(reqBO.getTenantCode());
            this.obTenantEvaluateStatisticsMapper.insertSelective(po);
        }
    }

    public void singleTenantScore(CalculationReqBO reqBO) {
        log.info("\u8ba1\u7b97\u5355\u4e2a\u79df\u6237\u62a2\u5355\u56e0\u5b50\u5165\u53c2={}", (Object)JSONObject.toJSONString((Object)reqBO));
        Integer dayCount = reqBO.getDayCount();
        Integer activSeatCount = 0;
        Integer allSeatCount = 0;
        Integer successCount = 0;
        Integer connectCount = 0;
        Integer buyCount = 0;
        Integer complaintCount = reqBO.getComplain();
        Integer successBuyCount = reqBO.getSuccessBuyCount();
        boolean flag = false;
        if (null == complaintCount) {
            complaintCount = 0;
            flag = true;
        }
        boolean flagTwo = false;
        if (null == successBuyCount) {
            successBuyCount = 0;
            buyCount = 0;
            flag = true;
        }
        ArrayList<String> tenantIds = new ArrayList<String>();
        tenantIds.add(reqBO.getTenantCode());
        List statisticsList = this.obTenantStatisticsMapper.selectActive(reqBO.getStartTime(), reqBO.getEndTime(), tenantIds);
        if (null != statisticsList && statisticsList.size() > 0) {
            for (ObTenantStatistics tenantStatistics : statisticsList) {
                if (0 != tenantStatistics.getCustNumber()) {
                    activSeatCount = activSeatCount + tenantStatistics.getCustNumber();
                    allSeatCount = allSeatCount + tenantStatistics.getAllSeatNumber();
                } else {
                    Integer n = dayCount;
                    Integer n2 = dayCount = Integer.valueOf(dayCount - 1);
                }
                successCount = successCount + tenantStatistics.getSuccessNumber();
                connectCount = connectCount + tenantStatistics.getConnectNumber();
                if (!flag) continue;
                complaintCount = complaintCount + tenantStatistics.getComplaintNumber();
            }
        }
        double parseDouble = Double.parseDouble(String.valueOf(activSeatCount));
        String seatRate = this.percent2(parseDouble, allSeatCount);
        String activSeatZhanBi = this.percent2(Double.parseDouble(seatRate), dayCount);
        double suu = Double.parseDouble(String.valueOf(successCount));
        String successRate = this.percent2(suu, connectCount);
        if (flagTwo) {
            List buyList = this.obCustServeRecordDAO.selectBuySuccess(reqBO.getStartTime(), reqBO.getEndTime(), reqBO.getTenantCode(), reqBO.getTenantOtherName());
            if (null != buyList && buyList.size() > 0) {
                buyCount = buyList.size();
            }
        } else {
            buyCount = successBuyCount;
        }
        if (null == complaintCount) {
            complaintCount = 0;
        }
        double comp = Double.parseDouble(String.valueOf(complaintCount));
        String compRate = this.percent2(comp, buyCount);
        double score = (Double.parseDouble(activSeatZhanBi) * 0.5 + Double.parseDouble(successRate) * 0.5 - Double.parseDouble(compRate) * 10.0) * 100.0;
        ObTenantScore po = new ObTenantScore();
        SimpleDateFormat stf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String format = stf.format(new Date());
        po.setTenantId(reqBO.getTenantCode());
        po.setCreateTime(format);
        po.setOldDate(reqBO.getStartTime());
        po.setActivSeatSum(activSeatCount);
        po.setAllSeats(allSeatCount);
        po.setSuccessNumber(successCount);
        po.setConnectNumber(connectCount);
        po.setComplaintNumber(complaintCount);
        po.setSuccessBuy(buyCount);
        po.setScore(String.valueOf(new Double(Math.ceil(score)).intValue()));
        BigDecimal aBig = new BigDecimal(activSeatZhanBi);
        po.setActivSeatRate(aBig);
        BigDecimal sBig = new BigDecimal(successRate);
        po.setSuccessRate(sBig);
        BigDecimal cBig = new BigDecimal(compRate);
        po.setComplaint(cBig);
        this.obTenantScoreMapper.insertSelective(po);
    }

    public void singleTenantMarketingStatistics(MarketingTimedTaskReq taskReq) {
        log.info("\u7edf\u8ba1\u5355\u4e2a\u79df\u6237\u8425\u9500\u4efb\u52a1\u5165\u53c2={}", (Object)JSON.toJSONString((Object)taskReq));
        String data = taskReq.getStartTime();
        ObMarketingTaskStatistics po = new ObMarketingTaskStatistics();
        po.setTenantCode(taskReq.getTenantCode());
        po.setData(data);
        List callRecordPOList = this.obCallRecordDAO.selectDayTaskList(taskReq.getTenantCode(), taskReq.getTenantOtherName(), taskReq.getStartTime(), taskReq.getEndTime());
        if (null != callRecordPOList && callRecordPOList.size() > 0) {
            for (ObCallRecordPO callRecordPO : callRecordPOList) {
                List obCallRecordPOS;
                if ("ACTIVE_OUT".equals(callRecordPO.getTaskId())) continue;
                po.setTaskId(callRecordPO.getTaskId());
                ObTaskInfoPO taskInfoPO = this.obTaskInfoDAO.selectByPrimaryKey(callRecordPO.getTaskId());
                if (null != taskInfoPO) {
                    po.setTaskName(taskInfoPO.getTaskName());
                }
                if (null != (obCallRecordPOS = this.obCallRecordDAO.selectTaskCallCount(taskReq.getTenantCode(), taskReq.getTenantOtherName(), taskReq.getStartTime(), taskReq.getEndTime(), taskInfoPO.getTaskId())) && obCallRecordPOS.size() > 0) {
                    po.setCallNumber(Integer.valueOf(obCallRecordPOS.size()));
                } else {
                    po.setCallNumber(Integer.valueOf(0));
                }
                List connectList = this.obCallRecordDAO.selectConnectCount(taskReq.getTenantCode(), taskReq.getTenantOtherName(), taskReq.getStartTime(), taskReq.getEndTime(), taskInfoPO.getTaskId());
                SimpleDateFormat stf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                if (null != connectList && connectList.size() > 0) {
                    po.setConnectNumber(Integer.valueOf(connectList.size()));
                    long totalTime = 0L;
                    for (ObCallRecordPO recordPO : connectList) {
                        int sumTime = (int)(totalTime += (long)Integer.parseInt(recordPO.getContactLength()));
                        po.setCallTotalTime(Integer.valueOf(sumTime));
                    }
                } else {
                    po.setConnectNumber(Integer.valueOf(0));
                    po.setCallTotalTime(Integer.valueOf(0));
                }
                List successList = this.obCustServeRecordDAO.selectSuccessCount(taskReq.getTenantCode(), taskReq.getTenantOtherName(), taskReq.getStartTime(), taskReq.getEndTime(), taskInfoPO.getTaskId());
                if (null != successList && successList.size() > 0) {
                    po.setSuccessNumber(Integer.valueOf(successList.size()));
                } else {
                    po.setSuccessNumber(Integer.valueOf(0));
                }
                List callLossList = this.obCallRecordDAO.selectCallLossCount(taskReq.getTenantCode(), taskReq.getTenantOtherName(), taskReq.getStartTime(), taskReq.getEndTime(), taskInfoPO.getTaskId());
                if (null != callLossList && callLossList.size() > 0) {
                    po.setCallLossNumber(Integer.valueOf(callLossList.size()));
                } else {
                    po.setCallLossNumber(Integer.valueOf(0));
                }
                List custList = this.obCustServeRecordDAO.selectCustCount(taskReq.getTenantCode(), taskReq.getTenantOtherName(), taskReq.getStartTime(), taskReq.getEndTime(), taskInfoPO.getTaskId());
                if (null != custList && custList.size() > 0) {
                    po.setCustNumber(Integer.valueOf(custList.size()));
                } else {
                    po.setCustNumber(Integer.valueOf(0));
                }
                ObDataTargetPO dataTargetPO = new ObDataTargetPO();
                dataTargetPO.setTaskId(taskInfoPO.getTaskId());
                dataTargetPO.setTenantId(taskReq.getTenantCode());
                dataTargetPO.setTenantOtherName(taskReq.getTenantOtherName());
                dataTargetPO.setIsBind(Integer.valueOf(0));
                List dataTargetPOList = this.obDataTargetDAO.selectAlreadyBindByTaskId(dataTargetPO);
                if (null != dataTargetPOList && dataTargetPOList.size() > 0) {
                    po.setTargetNumber(Integer.valueOf(dataTargetPOList.size()));
                } else {
                    po.setTargetNumber(Integer.valueOf(0));
                }
                String connectRate = this.percent(po.getConnectNumber(), po.getCallNumber());
                po.setConnectionRate(connectRate);
                String successRate = this.percent(po.getSuccessNumber(), po.getConnectNumber());
                po.setSuccessRate(successRate);
                po.setCreateTime(stf.format(new Date()));
                log.info("\u63d2\u5165\u8425\u9500\u4efb\u52a1\u7edf\u8ba1\u8868mapper\u5c42\u5165\u53c2={}", (Object)JSON.toJSONString((Object)po));
                int n = this.obMarketingTaskStatisticsMapper.insertSelective(po);
            }
        }
        log.info("\u8be5\u79df\u6237\u4eca\u5929\u6ca1\u6709\u4efb\u52a1");
    }

    public String percent(int a, int b) {
        if (b == 0) {
            return "0%";
        }
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        String result = numberFormat.format((float)a / (float)b * 100.0f);
        return result + "%";
    }

    public String percent2(double a, int b) {
        if (b == 0) {
            return "0.00";
        }
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        String result = numberFormat.format((float)a / (float)b);
        return result;
    }

    public String percent2(double a, double b) {
        if (b == 0.0) {
            return "0.00";
        }
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        String result = numberFormat.format((float)a / (float)b);
        return result;
    }

    public double mulitDate(double a, double b) {
        DecimalFormat df = new DecimalFormat("0.00");
        df.setRoundingMode(RoundingMode.HALF_UP);
        String format = df.format(a * b);
        return Double.valueOf(format);
    }

    public BladeTenantBO getTenantInfo(String tenantId) {
        GetBladeTenantInfoReqBO infoReqBO = new GetBladeTenantInfoReqBO();
        infoReqBO.setTenantCode(tenantId);
        GetBladeTenantInfoRspBO bladeTenantInfo = this.bladeTenantInterService.getBladeTenantInfo(infoReqBO);
        BladeTenantBO bladeTenantBO = new BladeTenantBO();
        if (bladeTenantInfo.getRspCode().equals("0000")) {
            bladeTenantBO = (BladeTenantBO)bladeTenantInfo.getData();
        }
        return bladeTenantBO;
    }

    public void singleTenantNumberAttribute(NumberAttributeReq req) {
        log.info("\u5355\u4e2a\u79df\u6237\u7edf\u8ba1\u53f7\u7801\u5f52\u5c5e\u5730\u62a5\u8868\u5165\u53c2={}", (Object)JSON.toJSONString((Object)req));
        String date = req.getStartTime();
        log.info("\u67e5\u8be2\u8be5\u79df\u6237\u524d\u4e00\u5929\u5916\u547c\u8bb0\u5f55\u5165\u53c2\uff0ctenantCode={}\uff0ctenantOtherName={}\uff0cstartTime={}\uff0cendTime={}", new Object[]{req.getTenantCode(), req.getTenantOtherName(), req.getStartTime(), req.getEndTime()});
        List recordPOList = this.obCallRecordDAO.selectDayTaskList(req.getTenantCode(), req.getTenantOtherName(), req.getStartTime(), req.getEndTime());
        log.info("\u67e5\u8be2\u8be5\u79df\u6237\u524d\u4e00\u5929\u5916\u547c\u8bb0\u5f55\u51fa\u53c2={}", (Object)JSONObject.toJSONString((Object)recordPOList));
        if (recordPOList != null && recordPOList.size() > 0) {
            for (ObCallRecordPO recordPO : recordPOList) {
                List dataTargetPOList = this.obDataTargetDAO.selectByTaskIdGroupByCity(req.getTenantCode(), req.getTenantOtherName(), recordPO.getTaskId());
                log.info("\u4efb\u52a1\u4e0b\u5f52\u5c5e\u5730\u5206\u7ec4\u7ed3\u679c={}", (Object)JSONObject.toJSONString((Object)dataTargetPOList));
                if (dataTargetPOList == null || dataTargetPOList.size() <= 0) continue;
                for (ObDataTargetPO po : dataTargetPOList) {
                    List cityDataList;
                    List attributeData = new ArrayList();
                    String activity = null;
                    if (!StringUtils.isEmpty((Object)po.getCity()) && (cityDataList = this.obDataTargetDAO.selectByTaskIdAndCity(req.getTenantCode(), req.getTenantOtherName(), recordPO.getTaskId(), po.getCity())) != null && cityDataList.size() > 0) {
                        List phoneList = cityDataList.stream().map(ObDataTargetPO::getMobileNo).collect(Collectors.toList());
                        attributeData = this.obCallRecordDAO.selectAttributeData(req.getTenantCode(), req.getTenantOtherName(), recordPO.getTaskId(), phoneList, req.getStartTime(), req.getEndTime());
                        log.info("\u5f52\u5c5e\u5730->{}-\u6570\u636e={}", (Object)po.getCity(), (Object)JSONObject.toJSONString(attributeData));
                        ObDataTargetPO targetPO = (ObDataTargetPO)cityDataList.get(0);
                        activity = targetPO.getActivityCode();
                    }
                    ObNumberAttributionStatistics numberAttPO = new ObNumberAttributionStatistics();
                    numberAttPO.setDate(date);
                    SimpleDateFormat sft = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String createTime = sft.format(new Date());
                    numberAttPO.setCreateTime(createTime);
                    numberAttPO.setNumberAttribute(po.getCity());
                    numberAttPO.setTenantCode(req.getTenantCode());
                    numberAttPO.setTaskId(recordPO.getTaskId());
                    ObTaskInfoPO taskInfo = this.obTaskInfoDAO.selectByPrimaryKey(recordPO.getTaskId());
                    if (taskInfo != null) {
                        numberAttPO.setTaskNme(taskInfo.getTaskName());
                    }
                    numberAttPO.setMarketingActivity(activity);
                    int connectNum = 0;
                    if (attributeData != null && attributeData.size() > 0) {
                        numberAttPO.setCallNumber(Integer.valueOf(attributeData.size()));
                        long totalTime = 0L;
                        for (ObCallRecordPO atPo : attributeData) {
                            log.info("\u8fdb\u5165");
                            if (!atPo.getIsConn().equals(PARENT_ID) || !atPo.getObsIsConn().equals(PARENT_ID)) continue;
                            ++connectNum;
                            String startTime = atPo.getStartTime();
                            String endTime = atPo.getEndTime();
                            try {
                                Date dateS = sft.parse(startTime);
                                Date dateE = sft.parse(endTime);
                                long l = (dateE.getTime() - dateS.getTime()) / 1000L;
                                totalTime += l;
                            }
                            catch (ParseException e2) {
                                log.error("\u65f6\u95f4\u8ba1\u7b97\u5f02\u5e38");
                            }
                        }
                        int suTime = (int)totalTime;
                        numberAttPO.setCallTotalTime(Integer.valueOf(suTime));
                    } else {
                        numberAttPO.setCallNumber(Integer.valueOf(0));
                    }
                    numberAttPO.setConnectNumber(Integer.valueOf(connectNum));
                    List ucIdList = attributeData.stream().map(ObCallRecordPO::getUcId).collect(Collectors.toList());
                    if (null != attributeData && attributeData.size() > 0) {
                        List custServeRecordPOList = this.obCustServeRecordDAO.selectAttributeCount(req.getTenantCode(), req.getTenantOtherName(), req.getStartTime(), req.getEndTime(), recordPO.getTaskId(), ucIdList);
                        if (custServeRecordPOList != null && custServeRecordPOList.size() > 0) {
                            numberAttPO.setSuccessNumber(Integer.valueOf(custServeRecordPOList.size()));
                        } else {
                            numberAttPO.setSuccessNumber(Integer.valueOf(0));
                        }
                    } else {
                        numberAttPO.setSuccessNumber(Integer.valueOf(0));
                    }
                    long callLoss = attributeData.stream().filter(e -> e.getIsConn().equals("0") && PARENT_ID.equals(e.getObsIsConn())).count();
                    int loss = (int)callLoss;
                    numberAttPO.setCallLossNumber(Integer.valueOf(loss));
                    List custList = this.obCustServeRecordDAO.selectCustCount(req.getTenantCode(), req.getTenantOtherName(), req.getStartTime(), req.getEndTime(), recordPO.getTaskId());
                    if (custList != null && custList.size() > 0) {
                        numberAttPO.setCustNumber(Integer.valueOf(custList.size()));
                    } else {
                        numberAttPO.setCustNumber(Integer.valueOf(0));
                    }
                    ObDataTargetPO dataTargetPO = new ObDataTargetPO();
                    dataTargetPO.setTaskId(recordPO.getTaskId());
                    dataTargetPO.setTenantId(req.getTenantCode());
                    dataTargetPO.setTenantOtherName(req.getTenantOtherName());
                    dataTargetPO.setIsBind(Integer.valueOf(0));
                    List targetDataList = this.obDataTargetDAO.selectAlreadyBindByTaskId(dataTargetPO);
                    if (targetDataList != null && targetDataList.size() > 0) {
                        numberAttPO.setTargetNumber(Integer.valueOf(targetDataList.size()));
                    } else {
                        numberAttPO.setTargetNumber(Integer.valueOf(0));
                    }
                    String successRate = this.percent(numberAttPO.getSuccessNumber(), numberAttPO.getConnectNumber());
                    numberAttPO.setSuccessRate(successRate);
                    String connRate = this.percent(numberAttPO.getConnectNumber(), numberAttPO.getCallNumber());
                    numberAttPO.setConnectionRate(connRate);
                    log.info("\u65b0\u589e\u53f7\u7801\u5f52\u5c5e\u5730\u7edf\u8ba1\u6570\u636emapper\u5c42\u5165\u53c2={}", (Object)JSON.toJSONString((Object)numberAttPO));
                    this.obNumberAttributionStatisticsMapper.insertSelective(numberAttPO);
                }
            }
        }
    }

    public void singleTenantData(TenantDataReqBO reqBO) {
        Map<String, List<QueryJobNumberRecordInfoBO>> listMap;
        log.info("\u7edf\u8ba1\u5355\u4e2a\u79df\u6237\u6570\u636e\u5165\u53c2={}", (Object)JSONObject.toJSONString((Object)reqBO));
        SimpleDateFormat stf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String format = stf.format(new Date());
        String endTime = reqBO.getEndTime();
        String startTime = reqBO.getStartTime();
        String tenantCode = reqBO.getTenantCode();
        String tenantOtherName = reqBO.getTenantOtherName();
        List recordPOList = this.obCallRecordDAO.selectTenantData(startTime, endTime, tenantCode, tenantOtherName);
        List tenantTargetData = this.obDataTargetDAO.selectTenantTargetData(startTime, endTime, tenantCode, tenantOtherName);
        int custNum = 0;
        int callNum = 0;
        int connectNum = 0;
        int successNum = 0;
        int allSeatNum = 0;
        int activHCustNum = 0;
        int activWCustNum = 0;
        int tenantNum = 0;
        if (null != tenantTargetData && tenantTargetData.size() > 0) {
            tenantNum = tenantTargetData.size();
        }
        ArrayList actCustList = new ArrayList();
        List rows = this.dcJobNumberInterService.getJobNumberBindRecord(startTime, endTime, tenantCode);
        if (null != rows && rows.size() > 0) {
            listMap = rows.stream().collect(Collectors.groupingBy(QueryJobNumberRecordInfoBO::getUserId));
            allSeatNum = listMap.size();
        }
        if (null != recordPOList && recordPOList.size() > 0) {
            listMap = recordPOList.stream().collect(Collectors.groupingBy(ObCallRecordPO::getJobNumber));
            callNum = recordPOList.size();
            long ss = recordPOList.stream().filter(e -> PARENT_ID.equals(e.getIsConn()) && PARENT_ID.equals(e.getObsIsConn())).count();
            connectNum = (int)ss;
            List custServeRecordPOList = this.obCustServeRecordDAO.selectSuccessCount(tenantCode, tenantOtherName, startTime, endTime, null);
            if (null != custServeRecordPOList && custServeRecordPOList.size() > 0) {
                successNum = custServeRecordPOList.size();
            }
            for (String key : listMap.keySet()) {
                List<QueryJobNumberRecordInfoBO> pos = listMap.get(key);
                String startTalkTime = ((ObCallRecordPO)pos.get(0)).getTalkTime();
                String endTalkTime = ((ObCallRecordPO)pos.get(pos.size() - 1)).getTalkTime();
                log.info("\u5f53\u524d\u5de5\u53f7\uff1a{}\uff0c \u7b2c\u4e00\u6b21\u5916\u547c\u65f6\u95f4\uff1a{}\uff0c \u6700\u540e\u4e00\u6b21\u5916\u547c\u65f6\u95f4\uff1a{}", new Object[]{key, startTalkTime, endTalkTime});
                Long num1 = rows.stream().filter(bindRecord -> key.equals(bindRecord.getJobNumber()) && null == bindRecord.getUnBindTime() && endTalkTime.compareTo(bindRecord.getBindTime()) > 0).count();
                List bos = rows.stream().filter(bindRecord -> key.equals(bindRecord.getJobNumber()) && null == bindRecord.getUnBindTime() && endTalkTime.compareTo(bindRecord.getBindTime()) > 0).collect(Collectors.toList());
                log.info("bos:{}", (Object)JSONObject.toJSONString(bos));
                Long num2 = rows.stream().filter(bindRecord -> key.equals(bindRecord.getJobNumber()) && null != bindRecord.getUnBindTime() && endTalkTime.compareTo(bindRecord.getUnBindTime()) < 0).count();
                List bos1 = rows.stream().filter(bindRecord -> key.equals(bindRecord.getJobNumber()) && null != bindRecord.getUnBindTime() && endTalkTime.compareTo(bindRecord.getUnBindTime()) < 0).collect(Collectors.toList());
                log.info("bos1:{}", (Object)JSONObject.toJSONString(bos1));
                custNum += num1.intValue() + num2.intValue();
                log.info("num1:{},num2{}", (Object)num1, (Object)num2);
                actCustList.addAll(bos);
                actCustList.addAll(bos1);
            }
            if (null != actCustList && actCustList.size() > 0) {
                for (QueryJobNumberRecordInfoBO infoBO : actCustList) {
                    BladeUserBO bladeUserBO = this.bladeUserInterService.queryUserInfo(infoBO.getUserId());
                    if (StringUtils.isEmpty((Object)bladeUserBO.getNation())) continue;
                    if ("\u6c49\u65cf".equals(bladeUserBO.getNation())) {
                        ++activHCustNum;
                    }
                    if (!"\u7ef4\u543e\u5c14\u65cf".equals(bladeUserBO.getNation())) continue;
                    ++activWCustNum;
                }
            }
        }
        ObTenantStatistics po = new ObTenantStatistics();
        po.setCallNumber(Integer.valueOf(callNum));
        po.setConnectNumber(Integer.valueOf(connectNum));
        po.setCustNumber(Integer.valueOf(custNum));
        po.setSuccessNumber(Integer.valueOf(successNum));
        po.setOldDate(reqBO.getStartTime());
        po.setCreateTime(format);
        po.setTenantId(reqBO.getTenantCode());
        po.setAllSeatNumber(Integer.valueOf(allSeatNum));
        po.setActHCustNumber(Integer.valueOf(activHCustNum));
        po.setActWCustNumber(Integer.valueOf(activWCustNum));
        po.setTargetNumber(Integer.valueOf(tenantNum));
        log.info("\u65b0\u589e\u79df\u6237\u6570\u636emapper\u5c42\u5165\u53c2={}", (Object)JSONObject.toJSONString((Object)po));
        this.obTenantStatisticsMapper.insertSelective(po);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String ex(List<QryScriptStatisticsRspBO> list, String tenantId) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet("sheet1");
        XSSFRow headRow = sheet.createRow(0);
        headRow.createCell(0).setCellValue("\u4efb\u52a1\u540d\u79f0");
        headRow.createCell(1).setCellValue("\u95ee\u5377\u811a\u672c");
        headRow.createCell(2).setCellValue("\u5ba2\u6237\u53f7\u7801");
        headRow.createCell(3).setCellValue("\u5904\u7406\u5750\u5e2d");
        headRow.createCell(4).setCellValue("\u586b\u5199\u65f6\u95f4");
        headRow.setHeightInPoints(30.0f);
        for (int i = 0; i < list.size(); ++i) {
            QryScriptStatisticsRspBO bo = list.get(i);
            XSSFRow row = sheet.createRow(i + 1);
            row.createCell(0).setCellValue(bo.getTaskName());
            row.createCell(1).setCellValue(bo.getScriptName());
            row.createCell(2).setCellValue(bo.getCalled());
            row.createCell(3).setCellValue(bo.getCustName());
            row.createCell(4).setCellValue(bo.getHandleTime());
            List answerList = bo.getAnswerList();
            for (int j = 0; j < answerList.size(); ++j) {
                int hh = j + 4 + 1;
                row.createCell(hh).setCellValue((String)answerList.get(j));
            }
        }
        FileOutputStream fos = null;
        File file = null;
        String filePath = null;
        Integer intDate = DateUtil.getIntDate(new Date());
        String fileName = "\u95ee\u5377\u811a\u672c\u5904\u7406\u8be6\u60c5_" + tenantId + "_" + System.currentTimeMillis() + ".xlsx";
        try {
            String path = System.getProperty("java.io.tmpdir") + File.separator;
            File dir = new File(path);
            if (!dir.exists()) {
                dir.mkdir();
            }
            filePath = path + fileName;
            file = new File(filePath);
            log.debug("filePath={}", (Object)filePath);
            fos = new FileOutputStream(file);
            workbook.write((OutputStream)fos);
            workbook.close();
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u6587\u4ef6\u9519\u8bef", (Throwable)e);
            e.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return filePath;
    }

    public Rsp getAreaMap(Req req) {
        HashMap<String, String> codeMap = new HashMap<String, String>();
        ObAreaPO obAreaPO = new ObAreaPO();
        obAreaPO.setParentId(Long.valueOf(Long.parseLong(PARENT_ID)));
        List areaPOList = this.obAreaDAO.selectByParentId(obAreaPO);
        log.info("\u7236ID\u4e3a[{}]\u5730\u5e02\u4fe1\u606f\uff1a{}", (Object)PARENT_ID, (Object)JSONObject.toJSONString((Object)areaPOList));
        if (null != areaPOList && areaPOList.size() > 0) {
            for (ObAreaPO po : areaPOList) {
                codeMap.put(po.getAreaCode(), po.getAreaName());
            }
        }
        return BaseRspUtils.createSuccessRsp(codeMap);
    }

    private static /* synthetic */ boolean lambda$queryGrabStatistics$11(String tenantId, ObGrabStatistics e) {
        return tenantId.equals(e.getTenantId());
    }
}

