/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.cache;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.ocs.mapper.ObAreaDAO;
import com.tydic.nicc.ocs.mapper.po.ObAreaPO;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@Order(value=3)
public class AreaCache
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(AreaCache.class);
    public static final Map<String, String> CODE_MAP = new ConcurrentHashMap<String, String>();
    public static final String PARENT_ID = "1";
    public static final String AREA_KEY = "area";
    @Resource
    private ObAreaDAO obAreaDAO;

    public void run(String ... args) throws Exception {
        this.setAreaMap();
        log.info("CODE_MAP:{}", CODE_MAP);
    }

    public void setAreaMap() {
        ObAreaPO obAreaPO = new ObAreaPO();
        obAreaPO.setParentId(Long.valueOf(Long.parseLong(PARENT_ID)));
        List areaPOList = this.obAreaDAO.selectByParentId(obAreaPO);
        log.info("\u7236ID\u4e3a[{}]\u5730\u5e02\u4fe1\u606f\uff1a{}", (Object)PARENT_ID, (Object)JSONObject.toJSONString((Object)areaPOList));
        if (null != areaPOList && areaPOList.size() > 0) {
            for (ObAreaPO po : areaPOList) {
                CODE_MAP.put(po.getAreaCode(), po.getAreaName());
            }
        }
    }

    public static String getArea(String code) {
        if (StringUtils.isEmpty((Object)code)) {
            return null;
        }
        String areaName = CODE_MAP.get(code);
        log.info("code\uff1a[{}], name:[{}]", (Object)code, (Object)areaName);
        return areaName;
    }
}

