/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.cache;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.ocs.bo.SessionBO;
import com.tydic.nicc.ocs.bo.TaskExecuteCaseRspBO;
import com.tydic.nicc.ocs.cache.CacheKey;
import com.tydic.nicc.ocs.handler.bo.TaskMonitorInfo;
import com.tydic.nicc.ocs.handler.bo.UserJoinInfoBO;
import com.tydic.nicc.ocs.isv.StatusControlService;
import com.tydic.nicc.ocs.isv.bo.ISVRequestBO;
import com.tydic.nicc.ocs.isv.bo.ISVRestResponseBO;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class WsCache {
    private static final Logger log = LoggerFactory.getLogger(WsCache.class);
    @Autowired
    RedisHelper redisHelper;
    @Autowired
    StatusControlService statusControlService;
    public static int DEFUALT_INVALID_16_H = 57600;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    public void pushAgentLastActionTime(String jobCode, Long lastActionTime) {
        try {
            this.redisHelper.set(CacheKey.agentLastActionTime(jobCode), (Object)lastActionTime);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void pushActionAgent(String jobCode) {
        try {
            this.redisHelper.lRemove(CacheKey.actionAgent(), 0L, (Object)jobCode);
            this.redisHelper.lSet(CacheKey.actionAgent(), (Object)jobCode);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public String popActionAgent() {
        try {
            Object objectSession = this.redisHelper.lLPop(CacheKey.actionAgent());
            if (null == objectSession) {
                return null;
            }
            return (String)objectSession;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public long popAgentLastActionTime(String jobCode) {
        try {
            Object objectSessionLastTime = this.redisHelper.get(CacheKey.agentLastActionTime(jobCode));
            return objectSessionLastTime == null ? 0L : (Long)objectSessionLastTime;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public void userLinked(UserJoinInfoBO userJoinInfo) {
        try {
            UserJoinInfoBO userJoinInfoBO;
            Object object;
            if (StringUtils.isEmpty((CharSequence)userJoinInfo.getJoinTaskID()) && (object = this.redisHelper.get(CacheKey.userInfo(userJoinInfo.getJobCode()))) != null && !StringUtils.isEmpty((CharSequence)(userJoinInfoBO = (UserJoinInfoBO)object).getJoinTaskID())) {
                userJoinInfo.setJoinTaskID(userJoinInfoBO.getJoinTaskID());
            }
            this.redisHelper.set(CacheKey.userInfo(userJoinInfo.getJobCode()), (Object)userJoinInfo);
            this.redisHelper.lSet(CacheKey.actionAgent(), (Object)userJoinInfo.getJobCode());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void updateUserJoinInfo(String jobCode, String taskId, String ctiSessionID) {
        try {
            Object object = this.redisHelper.get(CacheKey.userInfo(jobCode));
            if (object != null) {
                UserJoinInfoBO userJoinInfoBO = (UserJoinInfoBO)object;
                userJoinInfoBO.setCtiSessionID(ctiSessionID);
                userJoinInfoBO.setJoinTaskID(taskId);
                this.redisHelper.set(CacheKey.userInfo(jobCode), (Object)userJoinInfoBO);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public UserJoinInfoBO getUserLinkedInfo(String jobCode) {
        try {
            Object o = this.redisHelper.get(CacheKey.userInfo(jobCode));
            if (null != o) {
                return (UserJoinInfoBO)o;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public void outSession(SessionBO userJoinInfo) {
        try {
            long time = 300L;
            this.redisHelper.expire(CacheKey.userInfo(userJoinInfo.getJobCode()), time);
            this.redisHelper.expire(CacheKey.agentLastActionTime(userJoinInfo.getJobCode()), time);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void ctiAndOcsSessionBound(String ctiSessionID, String sessionId, String jobCode, String taskId) {
        try {
            if (!StringUtils.isEmpty((CharSequence)sessionId)) {
                this.redisHelper.set(CacheKey.ctiAndOcsBound(ctiSessionID), (Object)sessionId, (long)DEFUALT_INVALID_16_H);
            }
            if (!StringUtils.isEmpty((CharSequence)jobCode)) {
                this.redisHelper.set(CacheKey.ctiAndJobBound(ctiSessionID), (Object)jobCode, (long)DEFUALT_INVALID_16_H);
            }
            if (!StringUtils.isEmpty((CharSequence)taskId)) {
                this.redisHelper.set(CacheKey.ctiAndTaskBound(ctiSessionID), (Object)taskId, (long)DEFUALT_INVALID_16_H);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void ctiAndOcsSessionUnbundle(String ctiSessionID) {
        long time = 300L;
        try {
            this.redisHelper.expire(CacheKey.ctiAndOcsBound(ctiSessionID), time);
        }
        catch (Exception e) {
            log.error("ctiAndOcsBound:{}", (Object)e.getMessage(), (Object)e);
        }
        try {
            this.redisHelper.expire(CacheKey.ctiAndJobBound(ctiSessionID), time);
        }
        catch (Exception e) {
            log.error("ctiAndJobBound:{}", (Object)e.getMessage(), (Object)e);
        }
        try {
            this.redisHelper.expire(CacheKey.ctiAndTaskBound(ctiSessionID), time);
        }
        catch (Exception e) {
            log.error("ctiAndTaskBound:{}", (Object)e.getMessage(), (Object)e);
        }
    }

    public String getSessionIdByCti(String ctiSessionID) {
        try {
            return null == this.redisHelper.get(CacheKey.ctiAndOcsBound(ctiSessionID)) ? null : String.valueOf(this.redisHelper.get(CacheKey.ctiAndOcsBound(ctiSessionID)));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getJobCodeByCti(String ctiSessionID) {
        try {
            return null == this.redisHelper.get(CacheKey.ctiAndJobBound(ctiSessionID)) ? null : String.valueOf(this.redisHelper.get(CacheKey.ctiAndJobBound(ctiSessionID)));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getTaskByCti(String ctiSessionID) {
        try {
            return null == this.redisHelper.get(CacheKey.ctiAndTaskBound(ctiSessionID)) ? null : String.valueOf(this.redisHelper.get(CacheKey.ctiAndTaskBound(ctiSessionID)));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getBlacklistFailTime(String mobileNo) {
        try {
            return null == this.redisHelper.get(CacheKey.blacklistFailDay(mobileNo)) ? null : String.valueOf(this.redisHelper.get(CacheKey.blacklistFailDay(mobileNo)));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean isBalacklist(String mobileNo) {
        try {
            return null != this.redisHelper.get(CacheKey.blacklist(mobileNo));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public long changeTaskAgentNum(String taskId, String jobCode, String action) {
        String key = CacheKey.taskAgentNumKey(taskId);
        if ("ADD".equals(action)) {
            this.redisHelper.sSet(key, new Object[]{jobCode});
        } else if ("REMOVE".equals(action)) {
            this.redisHelper.setRemove(key, new Object[]{jobCode});
        }
        return this.redisHelper.sGetSetSize(key);
    }

    public void delLastActionTime(String actionJobCode) {
        try {
            this.redisHelper.del(new String[]{CacheKey.agentLastActionTime(actionJobCode)});
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public TaskMonitorInfo getTaskMonitorInfo(String localTaskId) {
        try {
            Object o = this.redisHelper.get(CacheKey.taskMonitor(localTaskId));
            if (null != o) {
                return (TaskMonitorInfo)o;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public void setTaskMonitorInfo(String localTaskId, TaskMonitorInfo taskMonitorInfo) {
        try {
            long time = 5L;
            this.redisHelper.set(CacheKey.taskMonitor(localTaskId), (Object)taskMonitorInfo, time);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void refreshIsvSession(String ctiSessionID) {
        try {
            long time = 60L;
            String key = CacheKey.refreshIsvSessinTime(ctiSessionID);
            Object o = this.redisHelper.get(key);
            if (null != o) {
                return;
            }
            ISVRequestBO request = new ISVRequestBO();
            request.setSessionId(ctiSessionID);
            ISVRestResponseBO rsp = this.statusControlService.getSessionStatus(request);
            log.info("\u5237\u65b0IVR\u4f1a\u8bdd\uff1a{},getSessionStatus body:{}", (Object)ctiSessionID, (Object)JSONObject.toJSONString((Object)rsp));
            if (null != rsp && 0 == rsp.getStatus()) {
                this.redisHelper.set(key, rsp.getData(), time);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void agentDnBandUser(String agentDn, String userId) {
        try {
            long time = 50400L;
            this.redisHelper.set(CacheKey.agentDnBandUser(agentDn), (Object)userId, time);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public String getAgentDnBandUser(String agentDn) {
        try {
            Object o = this.redisHelper.get(CacheKey.agentDnBandUser(agentDn));
            if (null != o) {
                return String.valueOf(o);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public boolean isRepeated(String mobileNo) {
        try {
            Object o = this.redisHelper.get(CacheKey.mobileNoSig(mobileNo));
            if (o == null) {
                this.redisHelper.set(CacheKey.mobileNoSig(mobileNo), (Object)"1", 72000L);
                return false;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public void setTaskMonitorByTask(String tenantId, String taskId, TaskExecuteCaseRspBO rspBO) {
        try {
            this.redisHelper.set(CacheKey.taskMonitorTaskId(tenantId, taskId), (Object)rspBO, 8L);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public TaskExecuteCaseRspBO getTaskMointorByTask(String tenantId, String taskId) {
        try {
            return (TaskExecuteCaseRspBO)this.redisHelper.get(CacheKey.taskMonitorTaskId(tenantId, taskId));
        }
        catch (Exception e) {
            return null;
        }
    }

    public String isWelcoming(String tenantId, String taskId) {
        try {
            Object o = this.redisHelper.get(CacheKey.taskIsWelcoming(tenantId, taskId));
            if (null != o) {
                return (String)o;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public void setWelcoming(String tenantId, String taskId, boolean isWel) {
        try {
            String res = isWel ? "true" : "false";
            this.redisHelper.set(CacheKey.taskIsWelcoming(tenantId, taskId), (Object)res, 60L);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isDoTaskEndCheck() {
        try {
            Object o = this.redisHelper.get("A:system:doEndCheck");
            return null == o || !"0".equals(o);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return true;
        }
    }

    public boolean isDoTaskNoDataCheck() {
        try {
            Object o = this.redisHelper.get("A:system:doNoDataCheck");
            return null == o || !"0".equals(o);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return true;
        }
    }

    public boolean isIdempotent(String sid, Long eid) {
        try {
            Boolean result = this.redisTemplate.opsForValue().setIfAbsent((Object)("im:idempotent:" + sid + ":" + eid), (Object)1, 120L, TimeUnit.SECONDS);
            if (null != result) {
                return result;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public void setNoSendNoDataMessage(String agentID, String taskId) {
        try {
            this.redisHelper.set("SEND:" + agentID + ":" + taskId, (Object)"1", 3600L);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isSendNoDataMessage(String agentID, String taskId) {
        try {
            Object o = this.redisHelper.get("SEND:" + agentID + ":" + taskId);
            return null == o;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

