/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.controller;

import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.ocs.bo.CallRecordHistoryBO;
import com.tydic.nicc.ocs.bo.GetCustomerNumHistoryReqBO;
import com.tydic.nicc.ocs.bo.GetSeatsCallHistoryReqBO;
import com.tydic.nicc.ocs.bo.PushCallRecordReqBO;
import com.tydic.nicc.ocs.bo.QjStatisticsReqBO;
import com.tydic.nicc.ocs.bo.QjStatisticsRspBO;
import com.tydic.nicc.ocs.bo.QryCallRecordReqBO;
import com.tydic.nicc.ocs.bo.QryDataPropertyReqBO;
import com.tydic.nicc.ocs.bo.QryScriptAnswerReqBO;
import com.tydic.nicc.ocs.bo.QryUpdRecordLogsReqBO;
import com.tydic.nicc.ocs.bo.QuerySeatsDayStatisticsReqBO;
import com.tydic.nicc.ocs.bo.QuerySeatsDayStatisticsRspBO;
import com.tydic.nicc.ocs.bo.QuerySeatsEtaDayStatisticsReqBO;
import com.tydic.nicc.ocs.bo.QuerySeatsEtaDayStatisticsRspBO;
import com.tydic.nicc.ocs.bo.TenantActivityTypeStatReqBO;
import com.tydic.nicc.ocs.bo.UpdateMarketingReqBO;
import com.tydic.nicc.ocs.bo.UserPurposeReqBO;
import com.tydic.nicc.ocs.service.HistoryService;
import com.tydic.nicc.ocs.service.ObCallRecordService;
import com.tydic.nicc.ocs.service.SeatsEtaStatisticsService;
import com.tydic.nicc.ocs.service.SeatsStatisticsService;
import com.tydic.nicc.ocs.service.StatisticsService;
import com.tydic.nicc.ocs.service.TenantActivityTypeService;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"record"})
public class CallRecordController {
    @DubboReference
    private HistoryService historyService;
    @DubboReference
    private SeatsStatisticsService seatsStatisticsService;
    @DubboReference
    private SeatsEtaStatisticsService seatsEtaStatisticsService;
    @DubboReference
    private ObCallRecordService obCallRecordService;
    @DubboReference
    private StatisticsService statisticsService;
    @DubboReference
    private TenantActivityTypeService tenantActivityTypeService;

    @RequestMapping(value={"getSeatsCallHistory"})
    public RspList<CallRecordHistoryBO> getSeatsCallHistory(@RequestBody GetSeatsCallHistoryReqBO reqBO) {
        return this.historyService.getSeatsCallHistoryRefactor(reqBO);
    }

    @RequestMapping(value={"getCustomerNumHistory"})
    public RspList getCustomerNumHistory(@RequestBody GetCustomerNumHistoryReqBO reqBO) {
        return this.historyService.getCustomerNumHistory(reqBO);
    }

    @RequestMapping(value={"qryCallRecord"})
    public RspList qryCallRecord(@RequestBody QryCallRecordReqBO reqBO) {
        return this.historyService.qryCallRecordRefactor(reqBO);
    }

    @RequestMapping(value={"qryDataProperty"})
    public Rsp qryDataProperty(@RequestBody QryDataPropertyReqBO reqBO) {
        return this.historyService.qryDataProperty(reqBO);
    }

    @RequestMapping(value={"qryScriptAnswer"})
    public RspList qryScriptAnswer(@RequestBody QryScriptAnswerReqBO reqBO) {
        return this.historyService.qryScriptAnswer(reqBO);
    }

    @RequestMapping(value={"updateMarketing"})
    public Rsp updateMarketing(@RequestBody UpdateMarketingReqBO reqBO) {
        return this.historyService.updateMarketing(reqBO);
    }

    @RequestMapping(value={"qryUpdRecordLogs"})
    public RspList qryUpdRecordLogs(@RequestBody QryUpdRecordLogsReqBO reqBO) {
        return this.historyService.qryUpdRecordLogs(reqBO);
    }

    @RequestMapping(value={"exportGetSeatsCallHistory"})
    public Rsp exportGetSeatsCallHistory(@RequestBody GetSeatsCallHistoryReqBO reqBO) {
        return this.historyService.exportGetSeatsCallHistory(reqBO);
    }

    @RequestMapping(value={"exportQryCallRecord"})
    public Rsp exportQryCallRecord(@RequestBody QryCallRecordReqBO reqBO) {
        return this.historyService.exportQryCallRecord(reqBO);
    }

    @RequestMapping(value={"seatsDayStatistics"})
    public Rsp seatsDayStatistics(String date) {
        return this.seatsStatisticsService.seatsDayStatistics(date);
    }

    @RequestMapping(value={"querySeatsDayStatistics"})
    public RspList<QuerySeatsDayStatisticsRspBO> querySeatsDayStatistics(@RequestBody QuerySeatsDayStatisticsReqBO reqBO) {
        return this.seatsStatisticsService.querySeatsDayStatistics(reqBO);
    }

    @RequestMapping(value={"exportSeatsDayStatistics"})
    public Rsp exportSeatsDayStatistics(@RequestBody QuerySeatsDayStatisticsReqBO reqBO) {
        return this.seatsStatisticsService.exportSeatsDayStatistics(reqBO);
    }

    @GetMapping(value={"seatsEtaDayStatistics"})
    public Rsp seatsEtaDayStatistics(String statisticsDate) {
        return this.seatsEtaStatisticsService.seatsEtaDayStatistics(statisticsDate);
    }

    @RequestMapping(value={"querySeatsEtaDayStatistics"})
    public RspList<QuerySeatsEtaDayStatisticsRspBO> querySeatsEtaDayStatistics(@RequestBody QuerySeatsEtaDayStatisticsReqBO reqBO) {
        return this.seatsEtaStatisticsService.querySeatsEtaDayStatistics(reqBO);
    }

    @RequestMapping(value={"exportSeatsEtaDayStatistics"})
    public Rsp exportSeatsEtaDayStatistics(@RequestBody QuerySeatsEtaDayStatisticsReqBO reqBO) {
        return this.seatsEtaStatisticsService.exportSeatsEtaDayStatistics(reqBO);
    }

    @RequestMapping(value={"pushCallRecord"})
    public Rsp pushCallRecord(@RequestBody PushCallRecordReqBO reqBO) {
        return this.obCallRecordService.pushCallRecord(reqBO.getHours(), reqBO.getEndTime());
    }

    @RequestMapping(value={"qjStatistics"})
    public RspList<QjStatisticsRspBO> qjStatistics(@RequestBody QjStatisticsReqBO reqBO) {
        return this.statisticsService.qjStatistics(reqBO);
    }

    @RequestMapping(value={"exportQjStatistics"})
    public Rsp exportQjStatistics(@RequestBody QjStatisticsReqBO reqBO) {
        return this.statisticsService.exportQjStatistics(reqBO);
    }

    @RequestMapping(value={"getUserPurpose"})
    public RspList getUserPurpose(@RequestBody UserPurposeReqBO reqBO) {
        return this.historyService.getUserPurpose(reqBO);
    }

    @RequestMapping(value={"qryTenantActivity"})
    public RspList queryTenantActivityTypeStat(@RequestBody TenantActivityTypeStatReqBO reqBO) {
        return this.tenantActivityTypeService.queryTenantActivityTypeStat(reqBO);
    }

    @RequestMapping(value={"qryActivity"})
    public RspList queryActivityTypeStat(@RequestBody TenantActivityTypeStatReqBO reqBO) {
        return this.tenantActivityTypeService.queryActivityTypeStat(reqBO);
    }

    @RequestMapping(value={"exportTenantActivity"})
    public Rsp exportTenantActivityTypeStat(@RequestBody TenantActivityTypeStatReqBO reqBO) {
        return this.tenantActivityTypeService.exportTenantActivityTypeStat(reqBO);
    }

    @RequestMapping(value={"exportActivity"})
    public Rsp exportActivityTypeStat(@RequestBody TenantActivityTypeStatReqBO reqBO) {
        return this.tenantActivityTypeService.exportActivityTypeStat(reqBO);
    }
}

