/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.seats;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.bo.configurable.DcTitleBO;
import com.tydic.nicc.dc.bo.configurable.GetPropertiesBO;
import com.tydic.nicc.dc.bo.configurable.ObPropertyBO;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.configurable.inter.ConfigurableInterService;
import com.tydic.nicc.ocs.bo.BigDataBO;
import com.tydic.nicc.ocs.bo.CustInfoBO;
import com.tydic.nicc.ocs.bo.CustomerBO;
import com.tydic.nicc.ocs.bo.DataInfoBO;
import com.tydic.nicc.ocs.bo.GetSeatsReqBO;
import com.tydic.nicc.ocs.bo.UserInfoBO;
import com.tydic.nicc.ocs.cache.AreaCache;
import com.tydic.nicc.ocs.service.SeatsService;
import com.tydic.nicc.ocs.unicom.bo.WorkBenchHttpRequestBo;
import com.tydic.nicc.ocs.unicom.service.WorkBenchService;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@DubboService
public class SeatsServiceImpl
implements SeatsService {
    private static final Logger log = LoggerFactory.getLogger(SeatsServiceImpl.class);
    @Autowired
    private WorkBenchService workBenchService;
    @DubboReference
    private ConfigurableInterService configurableInterService;

    public RspList getSeatsInfo(GetSeatsReqBO reqBO) {
        log.info("\u8fdb\u5165\u83b7\u53d6\u5750\u5e2d\u5de5\u4f5c\u53f0\u6a21\u5757\u4fe1\u606f\u63a5\u53e3\uff0c \u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        String tenantId = reqBO.getTenantCode();
        if (StringUtils.isEmpty((Object)tenantId)) {
            if (StringUtils.isEmpty((Object)reqBO.getIn_tenantCode())) {
                return BaseRspUtils.createErrorRspList((String)"\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            tenantId = reqBO.getIn_tenantCode();
        }
        if (StringUtils.isEmpty((Object)reqBO.getTitleEn())) {
            return BaseRspUtils.createErrorRspList((String)"TitleEn\u4e0d\u80fd\u4e3a\u7a7a");
        }
        GetPropertiesBO getPropertiesBO = new GetPropertiesBO();
        getPropertiesBO.setTitleEn(reqBO.getTitleEn());
        DcTitleBO dcTitleBO = this.configurableInterService.getTitleInfo(getPropertiesBO);
        if (StringUtils.isEmpty((Object)dcTitleBO)) {
            return BaseRspUtils.createErrorRspList((String)"\u672a\u67e5\u8be2\u5230 Title \u4fe1\u606f\uff0c \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        List properties = this.configurableInterService.getProperties(getPropertiesBO);
        if (properties == null || properties.size() == 0) {
            return BaseRspUtils.createErrorRspList((String)"\u672a\u67e5\u8be2\u5230\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        List<Map<String, Object>> mapList = this.getData(properties, dcTitleBO, reqBO.getPhone());
        if (null == mapList) {
            return BaseRspUtils.createErrorRspList((String)"\u672a\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f");
        }
        return BaseRspUtils.createSuccessRspList(mapList, (long)mapList.size());
    }

    private List<Map<String, Object>> getData(List<ObPropertyBO> properties, DcTitleBO dcTitleBO, String phone) {
        log.info("\u8fdb\u5165getData\u65b9\u6cd5\uff0cproperties\uff1a{}\uff0c titleType\uff1a{}", (Object)JSONObject.toJSONString(properties), (Object)JSONObject.toJSONString((Object)dcTitleBO));
        LinkedList<Map<String, Object>> listMap = new LinkedList<Map<String, Object>>();
        JSONObject userInfo = this.getUserInfo(phone);
        if (null == userInfo) {
            log.error("\u672a\u83b7\u53d6\u5230\u7528\u6237\u6570\u636e");
            return null;
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Object openDate = userInfo.get((Object)"openDate");
        Object contractEndTime = userInfo.get((Object)"contractEndTime");
        Object averageFlow = userInfo.get((Object)"averageFlow");
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddhhmmss");
        if (null != averageFlow) {
            BigDecimal averageFlowG = new BigDecimal(String.valueOf(averageFlow));
            averageFlowG = averageFlowG.divide(BigDecimal.valueOf(1024L), 2, 4);
            userInfo.put("averageFlow", (Object)averageFlowG.doubleValue());
        }
        try {
            if (null != openDate) {
                Date parse = format.parse(String.valueOf(openDate));
                Calendar dt1 = Calendar.getInstance();
                dt1.setTime(parse);
                Calendar dt2 = Calendar.getInstance();
                String monthNum = SeatsServiceImpl.monthDiff(dt1, dt2);
                userInfo.put("onTheNetTime", (Object)monthNum);
            }
            if (null != contractEndTime) {
                SimpleDateFormat format1 = new SimpleDateFormat("yyyyMMdd");
                Date parse = format1.parse(String.valueOf(contractEndTime));
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                userInfo.put("contractEndTime", (Object)sdf.format(parse));
            }
        }
        catch (ParseException e) {
            log.error("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
        }
        for (ObPropertyBO property : properties) {
            if (!userInfo.containsKey((Object)property.getPropertyEn())) continue;
            map = new LinkedHashMap();
            map.put("title", property.getPropertyCn());
            map.put("type", dcTitleBO.getTitleType());
            map.put("value", (String)userInfo.get(property.getPropertyEn()));
            listMap.add(map);
        }
        return listMap;
    }

    private JSONObject getUserInfo(String phone) {
        CustomerBO customerBO = new CustomerBO();
        WorkBenchHttpRequestBo bo = new WorkBenchHttpRequestBo();
        bo.setMobileNo(phone);
        Rsp rsp = this.workBenchService.customerPortrait(bo);
        log.info("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)rsp));
        if (!"0000".equals(rsp.getRspCode())) {
            log.error("\u672a\u83b7\u53d6\u5230\u7528\u6237\u753b\u50cf\u4fe1\u606f");
            return null;
        }
        Object rspData = rsp.getData();
        if (null != rspData) {
            List dataInfoBOS;
            JSONObject rspJson;
            Object dataObj;
            JSONObject userRsp = (JSONObject)JSONObject.parseObject((String)String.valueOf(rspData), JSONObject.class);
            Object bigDataObj = userRsp.get((Object)"bigData");
            if (null != bigDataObj) {
                BigDataBO bigData = (BigDataBO)JSONObject.parseObject((String)String.valueOf(bigDataObj), BigDataBO.class);
                customerBO.setCustLevel(bigData.getCustLevel());
                customerBO.setAverageOut(bigData.getAverageOut());
                customerBO.setAverageFlow(bigData.getAverageFlow());
                customerBO.setContractEndTime(bigData.getContractEndTime());
                customerBO.setIsTerminal5g(bigData.getIsTerminal5g());
            }
            Object rspObj = userRsp.get((Object)"RSP");
            log.info("rspObj:{}", rspObj);
            if (null != rspObj && null != (dataObj = (rspJson = (JSONObject)JSONObject.parseObject((String)String.valueOf(rspObj), JSONObject.class)).get((Object)"DATA")) && null != (dataInfoBOS = JSONArray.parseArray((String)String.valueOf(dataObj), DataInfoBO.class)) && dataInfoBOS.size() > 0) {
                for (DataInfoBO dataInfoBO : dataInfoBOS) {
                    UserInfoBO userInfo;
                    CustInfoBO custInfo = dataInfoBO.getCustInfo();
                    if (null != custInfo) {
                        customerBO.setCertType(custInfo.getCertType());
                        customerBO.setCertCode(custInfo.getCertCode());
                        customerBO.setCustName(custInfo.getCustName());
                    }
                    if (null == (userInfo = dataInfoBO.getUserInfo())) continue;
                    customerBO.setDevelopStaffId(userInfo.getDevelopStaffId());
                    customerBO.setProductName(userInfo.getProductName());
                    customerBO.setUserState(userInfo.getUserState());
                    customerBO.setEparchyCode(StringUtils.isEmpty((Object)AreaCache.getArea(userInfo.getEparchyCode())) ? userInfo.getEparchyCode() : AreaCache.getArea(userInfo.getEparchyCode()));
                    customerBO.setBrand(userInfo.getBrand());
                    customerBO.setOpenDate(userInfo.getOpenDate());
                }
            }
            customerBO.setSubNumber(phone);
            return (JSONObject)JSONObject.parseObject((String)JSONObject.toJSONString((Object)customerBO), JSONObject.class);
        }
        return null;
    }

    private String getDayNum(Integer seconds) {
        String parse = "";
        int day = 86400;
        if (seconds < day) {
            parse = "1\u5929";
        } else {
            int dayTime = seconds / day;
            parse = dayTime + "\u5929";
        }
        return parse;
    }

    private static String monthDiff(Calendar dt1, Calendar dt2) {
        int month1 = dt1.get(2);
        int year1 = dt1.get(1);
        int month2 = dt2.get(2);
        int year2 = dt2.get(1);
        return (year2 - year1) * 12 + (month2 - month1) + "\u6708";
    }
}

