/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.statistics;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.dc.base.bo.Req;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.bladetenant.inter.BladeTenantInterService;
import com.tydic.nicc.dc.bo.bladetenant.BladeTenantBO;
import com.tydic.nicc.dc.bo.bladetenant.GetBladeTenantInfoReqBO;
import com.tydic.nicc.dc.bo.bladetenant.GetBladeTenantInfoRspBO;
import com.tydic.nicc.dc.bo.dept.QueryDeptRspBo;
import com.tydic.nicc.dc.bo.jobNumber.JobNumberBO;
import com.tydic.nicc.dc.bo.user.BladeUserBO;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.dept.inter.BladeDeptInterService;
import com.tydic.nicc.dc.jobNumber.inter.DcJobNumberInterService;
import com.tydic.nicc.dc.user.inter.BladeUserInterService;
import com.tydic.nicc.ocs.bo.ExportRspBO;
import com.tydic.nicc.ocs.bo.QuerySeatsEtaDayStatisticsReqBO;
import com.tydic.nicc.ocs.bo.QuerySeatsEtaDayStatisticsRspBO;
import com.tydic.nicc.ocs.bo.SeatsEtaBO;
import com.tydic.nicc.ocs.mapper.ObCallRecordDAO;
import com.tydic.nicc.ocs.mapper.ObSeatsEtaStatisticsDAO;
import com.tydic.nicc.ocs.mapper.SessionChangeRecordDAO;
import com.tydic.nicc.ocs.mapper.po.ObCallRecordPO;
import com.tydic.nicc.ocs.mapper.po.ObSeatsEtaStatisticsPO;
import com.tydic.nicc.ocs.mapper.po.SessionChangeRecordPO;
import com.tydic.nicc.ocs.service.SeatsEtaStatisticsService;
import com.tydic.nicc.ocs.statistics.excelbo.ExcelSeatsEtaDayStatistics;
import com.tydic.nicc.ocs.utils.DateUtil;
import com.tydic.nicc.ocs.utils.ExcelHelper;
import com.tydic.nicc.ocs.utils.TaskInfoUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

@DubboService
public class SeatsEtaStatisticsServiceImpl
implements SeatsEtaStatisticsService {
    private static final Logger log = LoggerFactory.getLogger(SeatsEtaStatisticsServiceImpl.class);
    @Resource
    private SessionChangeRecordDAO sessionChangeRecordDAO;
    @Resource
    private ObCallRecordDAO obCallRecordDAO;
    @Resource
    private ObSeatsEtaStatisticsDAO obSeatsEtaStatisticsDAO;
    @DubboReference
    private BladeTenantInterService bladeTenantInterService;
    @DubboReference
    private DcJobNumberInterService dcJobNumberInterService;
    @DubboReference
    private BladeUserInterService bladeUserInterService;
    @DubboReference
    private BladeDeptInterService bladeDeptInterService;
    @Resource
    private ExcelHelper excelHelper;
    @Value(value="${file.path.ftUrl:http://192.168.10.112:8088/upload/}")
    private String path;

    public Rsp seatsEtaDayStatistics(String statisticsDate) {
        log.info("\u8fdb\u5165\u5750\u5e2d\u6548\u7387\u65e5\u62a5\u7edf\u8ba1\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)statisticsDate);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            if (StringUtils.isEmpty((Object)statisticsDate)) {
                statisticsDate = format.format(new Date());
            }
            Date beforeDate = DateUtil.getBeforeDate(format.parse(statisticsDate));
            Date startTime = DateUtil.getStartTime(beforeDate);
            Date endTime = DateUtil.getEndTime(beforeDate);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(beforeDate);
            Integer day = calendar.get(5);
            SessionChangeRecordPO sessionChangeRecordPO = new SessionChangeRecordPO();
            sessionChangeRecordPO.setStatisticsStartTime(startTime);
            sessionChangeRecordPO.setStatisticsEndTime(endTime);
            log.info("\u5750\u5e2d\u6548\u7387\u65e5\u62a5\u7edf\u8ba1Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)sessionChangeRecordPO));
            List sessionChangeRecordPOS = this.sessionChangeRecordDAO.selectSessionChangeRecord(sessionChangeRecordPO);
            ArrayList<ObSeatsEtaStatisticsPO> pos = new ArrayList<ObSeatsEtaStatisticsPO>();
            if (sessionChangeRecordPOS != null && sessionChangeRecordPOS.size() > 0) {
                Map<String, SeatsEtaBO> statisticsParam = this.getStatisticsParam(sessionChangeRecordPOS);
                if (null != statisticsParam) {
                    for (Map.Entry<String, SeatsEtaBO> entry : statisticsParam.entrySet()) {
                        ObSeatsEtaStatisticsPO po = new ObSeatsEtaStatisticsPO();
                        SeatsEtaBO etaBO = entry.getValue();
                        if (etaBO != null) {
                            Long signInLength = etaBO.getSignInLength() + etaBO.getBusyLength() + etaBO.getLeisureLength() + etaBO.getAfterCallBusy() + etaBO.getAgentLockedLength() + etaBO.getAgentOtherWorkLength() + etaBO.getAgentWorkingLength();
                            po.setGmtTime(format.format(new Date()));
                            po.setObDay(day.toString());
                            po.setAgentId(entry.getKey());
                            po.setSignInLength(signInLength);
                            po.setBusyLength(etaBO.getBusyLength());
                            po.setLeisureLength(etaBO.getLeisureLength());
                            po.setLeisureNum(etaBO.getLeisureNum());
                            po.setAfterCallBusy(etaBO.getAfterCallBusy());
                            po.setStatisticsTime(format.format(beforeDate));
                            JobNumberBO jobNumberBO = this.dcJobNumberInterService.queryJobNumberInfo(entry.getKey());
                            if (null == jobNumberBO) {
                                log.error("\u5f53\u524d\u5de5\u53f7\u4e3a\u3010{}\u3011\uff0c \u672a\u83b7\u53d6\u5230\u8be6\u7ec6\u4fe1\u606f\uff01", (Object)entry.getKey());
                                continue;
                            }
                            po.setAgentId(jobNumberBO.getJobNumberCode());
                            po.setCustId(jobNumberBO.getUserId());
                            BladeUserBO userBO = this.bladeUserInterService.queryUserInfo(jobNumberBO.getUserId());
                            if (null == userBO) {
                                log.error("\u5f53\u524d\u5750\u5e2dID\u4e3a\u3010{}\u3011\uff0c \u672a\u83b7\u53d6\u5230\u8be6\u7ec6\u4fe1\u606f\uff01", (Object)jobNumberBO.getUserId());
                                continue;
                            }
                            po.setTenantId(userBO.getTenantId());
                            po.setDeptId(userBO.getDeptId());
                            BladeTenantBO tenantInfo = this.getTenantInfo(userBO.getTenantId());
                            if (tenantInfo == null) {
                                log.error("\u5f53\u524d\u79df\u6237ID\u4e3a\u3010{}\u3011\uff0c \u672a\u83b7\u53d6\u5230\u8be6\u7ec6\u4fe1\u606f\uff01", (Object)userBO.getTenantId());
                                continue;
                            }
                            ObCallRecordPO obCallRecordPO = new ObCallRecordPO();
                            obCallRecordPO.setTenantId(userBO.getTenantId());
                            obCallRecordPO.setTenantOtherName(tenantInfo.getTenantOtherName());
                            obCallRecordPO.setJobNumber(entry.getKey());
                            obCallRecordPO.setStartTime(format.format(startTime));
                            obCallRecordPO.setEndTime(format.format(endTime));
                            obCallRecordPO.setUserId(jobNumberBO.getUserId());
                            log.info("\u83b7\u53d6\u5916\u547c\u4fe1\u606fMapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obCallRecordPO));
                            List callRecords = this.obCallRecordDAO.getCallRecords(obCallRecordPO);
                            po.setDuration(this.getDuration(callRecords));
                            po.setConnNum(this.getConnNum(callRecords));
                        }
                        pos.add(po);
                    }
                }
                if (pos != null && pos.size() > 0) {
                    int inserts = this.obSeatsEtaStatisticsDAO.inserts(pos);
                    log.info("\u5f53\u524d\u65f6\u95f4\u3010{}\u3011, \u7edf\u8ba1\u5165\u5e93\u3010{}\u3011\u6761\u6570\u636e", (Object)statisticsDate, (Object)inserts);
                }
            }
        }
        catch (Exception e) {
            log.error("\u7edf\u8ba1\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRsp((Object)"");
    }

    public RspList<QuerySeatsEtaDayStatisticsRspBO> querySeatsEtaDayStatistics(QuerySeatsEtaDayStatisticsReqBO reqBO) {
        log.info("\u8fdb\u5165\u5750\u5e2d\u6548\u7387\u65e5\u62a5\u67e5\u8be2\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        List<Object> rspBOS = new ArrayList<QuerySeatsEtaDayStatisticsRspBO>();
        int count = 0;
        try {
            ArrayList tenantIds = new ArrayList();
            Req req = new Req();
            req.setIn_tenantCode(reqBO.getIn_tenantCode());
            req.setRoleSet(reqBO.getRoleSet());
            req.setReqData((Object)reqBO.getTenantIds());
            List bladeTenants = this.bladeTenantInterService.getBalseTenantList(req);
            if (null != bladeTenants && !bladeTenants.isEmpty()) {
                tenantIds.addAll(bladeTenants.stream().map(x -> x.getTenantId()).collect(Collectors.toList()));
            } else {
                tenantIds.addAll(reqBO.getTenantIds());
            }
            if (StringUtils.isEmpty((Object)reqBO.getStartTime())) {
                return BaseRspUtils.createErrorRspList((String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)reqBO.getEndTime())) {
                return BaseRspUtils.createErrorRspList((String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ObSeatsEtaStatisticsPO seatsEtaStatisticsPO = new ObSeatsEtaStatisticsPO();
            seatsEtaStatisticsPO.setTenantIds(tenantIds);
            seatsEtaStatisticsPO.setStartTime(reqBO.getStartTime());
            seatsEtaStatisticsPO.setEndTime(reqBO.getEndTime());
            log.info("\u5750\u5e2d\u6548\u7387\u65e5\u62a5\u67e5\u8be2Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)seatsEtaStatisticsPO));
            List etaStatisticsPOS = this.obSeatsEtaStatisticsDAO.selectSeatsEtaDayStatistics(seatsEtaStatisticsPO);
            if (etaStatisticsPOS != null && etaStatisticsPOS.size() > 0) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (ObSeatsEtaStatisticsPO po : etaStatisticsPOS) {
                    QuerySeatsEtaDayStatisticsRspBO rspBO = this.getRspBO(po, map);
                    rspBOS.add(rspBO);
                }
            }
            if (rspBOS != null && rspBOS.size() > 0) {
                if (!StringUtils.isEmpty((Object)reqBO.getCustName())) {
                    rspBOS = this.filterList(rspBOS, reqBO.getCustName());
                }
                if (!StringUtils.isEmpty((Object)reqBO.getDeptName())) {
                    rspBOS = this.filterListByDept(rspBOS, reqBO.getDeptName());
                }
            }
            count = rspBOS.size();
            rspBOS = rspBOS.stream().skip(reqBO.getLimit() * (reqBO.getPage() - 1)).limit(reqBO.getLimit()).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            return BaseRspUtils.createErrorRspList((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRspList(rspBOS, (long)count);
    }

    public Rsp exportSeatsEtaDayStatistics(QuerySeatsEtaDayStatisticsReqBO reqBO) {
        log.info("\u8fdb\u5165\u5750\u5e2d\u6548\u7387\u65e5\u62a5\u5bfc\u51fa\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        ExportRspBO exportRspBO = new ExportRspBO();
        try {
            Integer limit = reqBO.getLimit();
            reqBO.setLimit(1);
            RspList<QuerySeatsEtaDayStatisticsRspBO> rspBO = this.querySeatsEtaDayStatistics(reqBO);
            if (!rspBO.getRspCode().equals("0000")) {
                log.error("\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)rspBO.getRspDesc());
                return BaseRspUtils.createErrorRsp((String)rspBO.getRspDesc());
            }
            int pageCount = (int)rspBO.getCount();
            if (pageCount == 0) {
                return BaseRspUtils.createSuccessRsp((Object)"", (String)"\u672a\u83b7\u53d6\u5230\u5750\u5e2d\u6548\u7387\u6570\u636e");
            }
            int pageNumber = (pageCount - 1) / limit + 1;
            reqBO.setLimit(limit.intValue());
            Integer index = 1;
            ArrayList<ExcelSeatsEtaDayStatistics> excelBOS = new ArrayList<ExcelSeatsEtaDayStatistics>();
            for (int i = 1; i <= pageNumber; ++i) {
                List rows;
                reqBO.setPage(i);
                RspList<QuerySeatsEtaDayStatisticsRspBO> rsp = this.querySeatsEtaDayStatistics(reqBO);
                if (!rsp.getRspCode().equals("0000") || (rows = rsp.getRows()) == null || rows.size() <= 0) continue;
                for (QuerySeatsEtaDayStatisticsRspBO bo : rows) {
                    ExcelSeatsEtaDayStatistics excelBO = new ExcelSeatsEtaDayStatistics();
                    BeanUtils.copyProperties((Object)bo, (Object)excelBO);
                    excelBO.setIndexCode(index);
                    Integer n = index;
                    Integer n2 = index = Integer.valueOf(index + 1);
                    excelBOS.add(excelBO);
                }
            }
            log.info("\u5750\u5e2d\u6548\u7387\u65e5\u62a5\u5bfc\u51fa\uff0cexcelBOS\uff1a{}", (Object)JSONObject.toJSONString(excelBOS));
            String filePath = null;
            try {
                String tenantId = StringUtils.isEmpty((Object)reqBO.getTenantCode()) ? reqBO.getIn_tenantCode() : reqBO.getTenantCode();
                String fileName = "\u5750\u5e2d\u6548\u7387\u65e5\u62a5_" + tenantId + "_" + System.currentTimeMillis();
                filePath = this.excelHelper.writeExcel(excelBOS, ExcelSeatsEtaDayStatistics.class, fileName);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error(e.getMessage());
                return BaseRspUtils.createErrorRsp((String)"\u5bfc\u51fa\u5931\u8d25\uff01");
            }
            filePath = this.path + filePath.substring(filePath.lastIndexOf("/") + 1);
            log.info("filePath:{}", (Object)filePath);
            exportRspBO.setFilePath(filePath);
            exportRspBO.setFileName(filePath.substring(filePath.lastIndexOf("/") + 1));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            return BaseRspUtils.createErrorRsp((String)"\u5bfc\u51fa\u5931\u8d25\uff01");
        }
        return BaseRspUtils.createSuccessRsp((Object)exportRspBO);
    }

    private List<QuerySeatsEtaDayStatisticsRspBO> filterList(List<QuerySeatsEtaDayStatisticsRspBO> rspBOS, String patternName) {
        ArrayList<QuerySeatsEtaDayStatisticsRspBO> bos = new ArrayList<QuerySeatsEtaDayStatisticsRspBO>();
        Pattern pattern = Pattern.compile(patternName);
        for (QuerySeatsEtaDayStatisticsRspBO rspBO : rspBOS) {
            Boolean aBoolean = this.getPatternName(pattern, rspBO.getCustName());
            if (!aBoolean.booleanValue()) continue;
            bos.add(rspBO);
        }
        return bos;
    }

    private List<QuerySeatsEtaDayStatisticsRspBO> filterListByDept(List<QuerySeatsEtaDayStatisticsRspBO> rspBOS, String patternName) {
        ArrayList<QuerySeatsEtaDayStatisticsRspBO> bos = new ArrayList<QuerySeatsEtaDayStatisticsRspBO>();
        Pattern pattern = Pattern.compile(patternName);
        for (QuerySeatsEtaDayStatisticsRspBO rspBO : rspBOS) {
            Boolean aBoolean = this.getPatternName(pattern, rspBO.getDeptName());
            if (!aBoolean.booleanValue()) continue;
            bos.add(rspBO);
        }
        return bos;
    }

    private Boolean getPatternName(Pattern pattern, String str) {
        if (!StringUtils.isEmpty((Object)str)) {
            Matcher matcher = pattern.matcher(str);
            return matcher.find();
        }
        return false;
    }

    private QuerySeatsEtaDayStatisticsRspBO getRspBO(ObSeatsEtaStatisticsPO po, Map<String, Object> map) {
        QuerySeatsEtaDayStatisticsRspBO rspBO = new QuerySeatsEtaDayStatisticsRspBO();
        rspBO.setId(po.getId().toString());
        rspBO.setObDay(po.getObDay());
        rspBO.setStatisticsTime(po.getStatisticsTime().substring(0, po.getStatisticsTime().lastIndexOf("-") + 3));
        rspBO.setGmtTime(po.getGmtTime());
        rspBO.setAgentId(po.getAgentId());
        rspBO.setCustId(po.getCustId());
        BladeUserBO userBO = (BladeUserBO)map.get("SITE_" + po.getCustId());
        if (null == userBO) {
            userBO = this.bladeUserInterService.queryUserInfo(po.getCustId());
            map.put("SITE_" + po.getCustId(), userBO);
        }
        if (userBO != null) {
            rspBO.setLoginName(userBO.getAccount());
            rspBO.setCustName(userBO.getName());
        } else {
            log.info("\u672a\u67e5\u8be2\u5230\u5750\u5e2d\u4fe1\u606f");
        }
        rspBO.setTenantId(po.getTenantId());
        BladeTenantBO tenantInfo = (BladeTenantBO)map.get("TENANT_");
        if (null == tenantInfo) {
            tenantInfo = this.getTenantInfo(po.getTenantId());
            map.put("TENANT_", tenantInfo);
        }
        if (tenantInfo != null) {
            rspBO.setTenantName(tenantInfo.getTenantName());
        } else {
            log.info("\u672a\u83b7\u53d6\u5230\u79df\u6237\u4fe1\u606f");
        }
        ArrayList<String> strs = new ArrayList<String>();
        if (!StringUtils.isEmpty((Object)po.getDeptId())) {
            String[] split;
            rspBO.setDeptId(po.getDeptId());
            String deptId = po.getDeptId();
            for (String str : split = deptId.split(",")) {
                QueryDeptRspBo deptInfo = (QueryDeptRspBo)map.get("DEPT_" + str);
                if (null == deptInfo) {
                    deptInfo = this.bladeDeptInterService.getDeptInfo(str);
                    map.put("DEPT_" + str, deptInfo);
                }
                if (null != deptInfo) {
                    strs.add(deptInfo.getDeptName());
                    continue;
                }
                log.info("\u672a\u83b7\u53d6\u5230\u7ec4\u7ec7\u673a\u6784\uff08\u90e8\u95e8\uff09\u4fe1\u606f");
            }
        }
        String deptName = String.join((CharSequence)",", strs);
        rspBO.setDeptName(deptName);
        rspBO.setConnNum(po.getConnNum());
        rspBO.setDuration(po.getDuration());
        rspBO.setSignInLength(po.getSignInLength());
        rspBO.setBusyLength(Long.valueOf(po.getBusyLength() + po.getAfterCallBusy()));
        rspBO.setAvgCallLength(Long.valueOf((long)po.getConnNum().intValue() == 0L ? 0L : (null == po.getDuration() ? 0L : po.getDuration() / po.getConnNum().longValue())));
        rspBO.setAvgLaborHour(Long.valueOf(null == po.getDuration() ? 0L : (po.getDuration() == 0L ? 0L : po.getSignInLength() / po.getDuration())));
        rspBO.setSeatsUtilizeRate(TaskInfoUtil.getRate(po.getAfterCallBusy().intValue(), po.getSignInLength().intValue()));
        rspBO.setBusyRate(TaskInfoUtil.getRate(po.getBusyLength().intValue(), po.getSignInLength().intValue()));
        rspBO.setLeisureLength(po.getLeisureLength());
        rspBO.setAvgLeisureLength(Long.valueOf(null == po.getLeisureNum() ? 0L : (0 == po.getLeisureNum() ? 0L : po.getLeisureLength() / po.getLeisureNum().longValue())));
        return rspBO;
    }

    private Integer getConnNum(List<ObCallRecordPO> callRecords) {
        int connNum = 0;
        if (callRecords != null && callRecords.size() > 0) {
            for (ObCallRecordPO po : callRecords) {
                if (!po.getIsConn().equals("1") || !po.getObsIsConn().equals("1")) continue;
                connNum += po.getConnNum().intValue();
            }
        }
        return connNum;
    }

    private Long getDuration(List<ObCallRecordPO> callRecords) {
        Long duration = 0L;
        if (callRecords != null && callRecords.size() > 0) {
            for (ObCallRecordPO po : callRecords) {
                if (StringUtils.isEmpty((Object)po.getContactLength())) continue;
                duration = duration + Long.parseLong(po.getContactLength());
            }
        }
        return duration;
    }

    private Map<String, SeatsEtaBO> getStatisticsParam(List<SessionChangeRecordPO> sessionChangeRecordPOS) {
        HashMap<String, SeatsEtaBO> map = new HashMap<String, SeatsEtaBO>();
        int k = 1;
        for (int i = 0; i < sessionChangeRecordPOS.size(); ++i) {
            SessionChangeRecordPO nowRecordPO = sessionChangeRecordPOS.get(i);
            if (k < sessionChangeRecordPOS.size()) {
                SessionChangeRecordPO nextRecordPO = sessionChangeRecordPOS.get(k);
                String nowPromoterId = nowRecordPO.getPromoterId();
                String nextPromoterId = nextRecordPO.getPromoterId();
                Date nowCreateTime = nowRecordPO.getCreateTime();
                Date nextCreateTime = nextRecordPO.getCreateTime();
                SeatsEtaBO seatsEta = new SeatsEtaBO();
                if (!StringUtils.isEmpty((Object)nowPromoterId) && !StringUtils.isEmpty((Object)nextPromoterId)) {
                    SeatsEtaBO seatsEtaBo;
                    if (i == 0) {
                        if (nowRecordPO.getEndTime() != null) {
                            seatsEta = this.getSeatsEta(nowRecordPO.getEndTime(), nowCreateTime, nowRecordPO.getCtiSessionStatus(), new SeatsEtaBO());
                        }
                        map.put(nowRecordPO.getPromoterId(), seatsEta);
                    }
                    if (!nowPromoterId.equals(nextPromoterId)) {
                        if (nextRecordPO.getEndTime() != null) {
                            seatsEta = this.getSeatsEta(nextRecordPO.getEndTime(), nextCreateTime, nextRecordPO.getCtiSessionStatus(), new SeatsEtaBO());
                        }
                        map.put(nextRecordPO.getPromoterId(), seatsEta);
                        ++k;
                        continue;
                    }
                    SeatsEtaBO seatsEtaBO = (SeatsEtaBO)map.get(nextRecordPO.getPromoterId());
                    if (seatsEtaBO == null) {
                        seatsEtaBo = this.getSeatsEta(nowCreateTime, nextCreateTime, nextRecordPO.getCtiSessionStatus(), new SeatsEtaBO());
                        map.put(nextRecordPO.getPromoterId(), seatsEtaBo);
                    } else {
                        seatsEtaBo = this.getSeatsEta(nowCreateTime, nextCreateTime, nextRecordPO.getCtiSessionStatus(), seatsEtaBO);
                        map.put(nextRecordPO.getPromoterId(), seatsEtaBo);
                    }
                }
            }
            ++k;
        }
        log.info("map:{}", (Object)JSONObject.toJSONString(map));
        return map;
    }

    private SeatsEtaBO getSeatsEta(Date nowCreateTime, Date nextCreateTime, String ctiSessionStatus, SeatsEtaBO seatsEtaBO) {
        log.info("\u5f00\u59cb\u8ba1\u7b97\u5750\u5e2d\u5404\u4e2a\u72b6\u6001\u65f6\u957f");
        if (ctiSessionStatus.equals("AgentLogout")) {
            return seatsEtaBO;
        }
        Long signInLength = seatsEtaBO.getSignInLength();
        Long busyLength = seatsEtaBO.getBusyLength();
        Long leisureLength = seatsEtaBO.getLeisureLength();
        Integer leisureNum = seatsEtaBO.getLeisureNum();
        Long afterCallBusy = seatsEtaBO.getAfterCallBusy();
        Long agentLockedLength = seatsEtaBO.getAgentLockedLength();
        Long agentWorkingLength = seatsEtaBO.getAgentWorkingLength();
        Long agentOtherWorkLength = seatsEtaBO.getAgentOtherWorkLength();
        long timeLength = (nowCreateTime.getTime() - nextCreateTime.getTime()) / 1000L;
        if (ctiSessionStatus.equals("AgentLogin")) {
            signInLength = signInLength + timeLength;
        }
        if (ctiSessionStatus.equals("AgentNotReady")) {
            busyLength = busyLength + timeLength;
        }
        if (ctiSessionStatus.equals("AgentReady")) {
            leisureLength = leisureLength + timeLength;
            Integer n = leisureNum;
            Integer n2 = leisureNum = Integer.valueOf(leisureNum + 1);
        }
        if (ctiSessionStatus.equals("AgentAfterCallWork")) {
            afterCallBusy = afterCallBusy + timeLength;
        }
        if (ctiSessionStatus.equals("AgentLocked")) {
            agentLockedLength = timeLength;
        }
        if (ctiSessionStatus.equals("AgentWorking")) {
            agentWorkingLength = timeLength;
        }
        if (ctiSessionStatus.equals("AgentOtherWork")) {
            agentOtherWorkLength = timeLength;
        }
        seatsEtaBO.setSignInLength(signInLength);
        seatsEtaBO.setBusyLength(busyLength);
        seatsEtaBO.setLeisureLength(leisureLength);
        seatsEtaBO.setLeisureNum(leisureNum);
        seatsEtaBO.setAfterCallBusy(afterCallBusy);
        seatsEtaBO.setAgentLockedLength(agentLockedLength);
        seatsEtaBO.setAgentWorkingLength(agentWorkingLength);
        seatsEtaBO.setAgentOtherWorkLength(agentOtherWorkLength);
        return seatsEtaBO;
    }

    private BladeTenantBO getTenantInfo(String tenantId) {
        GetBladeTenantInfoReqBO infoReqBO = new GetBladeTenantInfoReqBO();
        infoReqBO.setTenantCode(tenantId);
        GetBladeTenantInfoRspBO bladeTenantInfo = this.bladeTenantInterService.getBladeTenantInfo(infoReqBO);
        BladeTenantBO bladeTenantBO = new BladeTenantBO();
        if (bladeTenantInfo.getRspCode().equals("0000")) {
            bladeTenantBO = (BladeTenantBO)bladeTenantInfo.getData();
        }
        return bladeTenantBO;
    }
}

