/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.statistics;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.dc.base.bo.Req;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.bladetenant.inter.BladeTenantInterService;
import com.tydic.nicc.dc.bo.bladetenant.BladeTenantBO;
import com.tydic.nicc.dc.bo.bladetenant.GetBladeTenantInfoReqBO;
import com.tydic.nicc.dc.bo.bladetenant.GetBladeTenantInfoRspBO;
import com.tydic.nicc.dc.bo.bladetenant.GetBladeTenantListReqBO;
import com.tydic.nicc.dc.bo.bladetenant.GetBladeTenantListRspBO;
import com.tydic.nicc.dc.bo.dept.QueryDeptRspBo;
import com.tydic.nicc.dc.bo.user.BladeUserBO;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.dept.inter.BladeDeptInterService;
import com.tydic.nicc.dc.jobNumber.inter.DcJobNumberInterService;
import com.tydic.nicc.dc.user.inter.BladeUserInterService;
import com.tydic.nicc.ocs.bo.ExportRspBO;
import com.tydic.nicc.ocs.bo.QuerySeatsDayStatisticsReqBO;
import com.tydic.nicc.ocs.bo.QuerySeatsDayStatisticsRspBO;
import com.tydic.nicc.ocs.history.excelbo.ExcelSeatsDayStatisticsBO;
import com.tydic.nicc.ocs.mapper.ObCallRecordDAO;
import com.tydic.nicc.ocs.mapper.ObCallRecordStatisticsDAO;
import com.tydic.nicc.ocs.mapper.ObCustServeRecordDAO;
import com.tydic.nicc.ocs.mapper.ObTaskInfoDAO;
import com.tydic.nicc.ocs.mapper.po.ObCallRecordPO;
import com.tydic.nicc.ocs.mapper.po.ObCallRecordStatisticsPO;
import com.tydic.nicc.ocs.mapper.po.ObCustServeRecordPO;
import com.tydic.nicc.ocs.mapper.po.ObTaskInfoPO;
import com.tydic.nicc.ocs.service.SeatsStatisticsService;
import com.tydic.nicc.ocs.utils.DateUtil;
import com.tydic.nicc.ocs.utils.ExcelHelper;
import com.tydic.nicc.ocs.utils.TaskInfoUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

@DubboService
public class SeatsStatisticsServiceImpl
implements SeatsStatisticsService {
    private static final Logger log = LoggerFactory.getLogger(SeatsStatisticsServiceImpl.class);
    @Resource
    private ObCallRecordDAO obCallRecordDAO;
    @Resource
    private ObCustServeRecordDAO obCustServeRecordDAO;
    @Resource
    private ObCallRecordStatisticsDAO obCallRecordStatisticsDAO;
    @Resource
    private ObTaskInfoDAO obTaskInfoDAO;
    @DubboReference
    private BladeTenantInterService bladeTenantInterService;
    @DubboReference
    private BladeUserInterService bladeUserInterService;
    @DubboReference
    private DcJobNumberInterService dcJobNumberInterService;
    @DubboReference
    private BladeDeptInterService bladeDeptInterService;
    @Resource
    private ExcelHelper excelHelper;
    @Value(value="${file.path.ftUrl:http://192.168.10.112:8088/upload/}")
    private String path;
    Map<String, Object> map = new HashMap<String, Object>();

    public Rsp seatsDayStatistics(String date) {
        log.info("\u8fdb\u5165\u5750\u5e2d\u5355\u65e5\u7edf\u8ba1\u62a5\u8868\u7edf\u8ba1\u63a5\u53e3\uff0cdate\uff1a{}", (Object)date);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            if (StringUtils.isEmpty((Object)date)) {
                date = format.format(new Date());
            }
            Date beforeDate = DateUtil.getBeforeDate(format.parse(date));
            Date startTime = DateUtil.getStartTime(beforeDate);
            Date endTime = DateUtil.getEndTime(beforeDate);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(beforeDate);
            Integer year = calendar.get(1);
            Integer month = calendar.get(2) + 1;
            Integer day = calendar.get(5);
            GetBladeTenantListRspBO rspBO = this.bladeTenantInterService.getBladeTenantList(new GetBladeTenantListReqBO());
            if (!"0000".equals(rspBO.getRspCode())) {
                log.error("\u672a\u67e5\u8be2\u5230\u79df\u6237\u4fe1\u606f\uff01");
                return BaseRspUtils.createErrorRsp((String)"\u672a\u67e5\u8be2\u5230\u79df\u6237\u4fe1\u606f\uff01");
            }
            List bladeTenantBOS = rspBO.getRows();
            if (bladeTenantBOS == null || bladeTenantBOS.size() == 0) {
                log.error("\u672a\u67e5\u8be2\u5230\u79df\u6237\u4fe1\u606f\uff01");
                return BaseRspUtils.createErrorRsp((String)"\u672a\u67e5\u8be2\u5230\u79df\u6237\u4fe1\u606f\uff01");
            }
            for (BladeTenantBO tenantBO : bladeTenantBOS) {
                ArrayList<ObCallRecordStatisticsPO> callRecordStatisticsPOS = new ArrayList<ObCallRecordStatisticsPO>();
                List userBOS = this.bladeUserInterService.queryBladeUsers(tenantBO.getTenantId());
                log.info("\u83b7\u53d6\u5f53\u524d\u79df\u6237\u4e0b\u5750\u5e2d\u5217\u8868\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)userBOS));
                ObCallRecordPO obCallRecordPO = new ObCallRecordPO();
                obCallRecordPO.setStartTime(format.format(startTime));
                obCallRecordPO.setEndTime(format.format(endTime));
                obCallRecordPO.setTenantId(tenantBO.getTenantId());
                obCallRecordPO.setTenantOtherName(tenantBO.getTenantOtherName());
                log.info("\u83b7\u53d6\u3010{}\u3011\u5916\u547c\u8bb0\u5f55Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)format.format(beforeDate), (Object)JSONObject.toJSONString((Object)obCallRecordPO));
                List obCallRecordPOS = this.obCallRecordDAO.getCallRecords(obCallRecordPO);
                if (null == (obCallRecordPOS = obCallRecordPOS.stream().filter(po -> !"2".equals(po.getCallType())).collect(Collectors.toList())) || obCallRecordPOS.size() <= 0) continue;
                for (ObCallRecordPO recordPO : obCallRecordPOS) {
                    Integer successNum = 0;
                    ObCallRecordStatisticsPO statisticsPO = new ObCallRecordStatisticsPO();
                    ObCustServeRecordPO obCustServeRecordPO = new ObCustServeRecordPO();
                    obCustServeRecordPO.setTenantOtherName(tenantBO.getTenantOtherName());
                    obCustServeRecordPO.setTenantId(tenantBO.getTenantId());
                    obCustServeRecordPO.setHandleUser(recordPO.getUserId());
                    obCustServeRecordPO.setStartTime(startTime);
                    obCustServeRecordPO.setEndTime(endTime);
                    obCustServeRecordPO.setTaskId(recordPO.getTaskId());
                    successNum = this.obCustServeRecordDAO.getServiceRecords(obCustServeRecordPO);
                    log.info("\u5f53\u524duserId\u3010{}\u3011, \u4efb\u52a1ID\uff1a\u3010{}\u3011\uff0c \u67e5\u8be2\u5750\u5e2d\u5916\u547c\u6210\u529f\u6570\u91cf\uff1a{}", new Object[]{recordPO.getUserId(), recordPO.getTaskId(), successNum});
                    if (StringUtils.isEmpty((Object)recordPO.getJobNumber())) {
                        log.info("\u5f53\u524d\u5916\u547c\u8bb0\u5f55\u672a\u83b7\u53d6\u5230\u5de5\u53f7\u4fe1\u606f\uff0c \u8df3\u8fc7\u6b64\u6b21\u5faa\u73af");
                        continue;
                    }
                    List users = userBOS.stream().filter(user -> recordPO.getJobNumber().equals(user.getJobNumberCode())).collect(Collectors.toList());
                    statisticsPO.setCallNum(recordPO.getCallNum());
                    statisticsPO.setConnNum(recordPO.getConnNum());
                    statisticsPO.setSuccessNum(successNum);
                    statisticsPO.setTenantId(tenantBO.getTenantId());
                    statisticsPO.setDeptId(((BladeUserBO)users.get(0)).getDeptId());
                    statisticsPO.setSeatesId(((BladeUserBO)users.get(0)).getId().toString());
                    statisticsPO.setAgentDn(recordPO.getJobNumber());
                    statisticsPO.setCreateTime(format.format(new Date()));
                    statisticsPO.setObYear(year.toString());
                    statisticsPO.setObMonth(month.toString());
                    statisticsPO.setObDay(day.toString());
                    statisticsPO.setTaskId(recordPO.getTaskId());
                    statisticsPO.setCallTime(format.format(beforeDate));
                    statisticsPO.setDuration(recordPO.getDuration());
                    callRecordStatisticsPOS.add(statisticsPO);
                }
                if (null == callRecordStatisticsPOS || callRecordStatisticsPOS.size() <= 0) continue;
                log.info("\u5355\u65e5\u5750\u5e2d\u5916\u547c\u7edf\u8ba1\u62a5\u8868Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString(callRecordStatisticsPOS));
                this.obCallRecordStatisticsDAO.inserts(callRecordStatisticsPOS);
            }
        }
        catch (Exception e) {
            log.error("\u5355\u65e5\u5750\u5e2d\u5916\u547c\u7edf\u8ba1\u62a5\u8868\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRsp((Object)"");
    }

    public RspList<QuerySeatsDayStatisticsRspBO> querySeatsDayStatistics(QuerySeatsDayStatisticsReqBO reqBO) {
        log.info("\u8fdb\u5165\u5750\u5e2d\u65e5\u62a5\u8868\u67e5\u8be2\uff0c \u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        List<Object> rspBOS = new ArrayList<QuerySeatsDayStatisticsRspBO>();
        Integer count = 0;
        try {
            ArrayList tenantIds = new ArrayList();
            Map<String, String> id_name = null;
            Req req = new Req();
            req.setTenantCode(reqBO.getTenantCode());
            req.setIn_tenantCode(reqBO.getIn_tenantCode());
            req.setRoleSet(reqBO.getRoleSet());
            req.setReqData((Object)reqBO.getTenantIds());
            List bladeTenants = this.bladeTenantInterService.getBalseTenantList(req);
            if (bladeTenants != null && !bladeTenants.isEmpty()) {
                id_name = bladeTenants.stream().collect(Collectors.toMap(BladeTenantBO::getTenantId, BladeTenantBO::getTenantName));
            }
            if (tenantIds.isEmpty() && null != id_name) {
                tenantIds.addAll(id_name.keySet());
            }
            if (StringUtils.isEmpty((Object)reqBO.getStartTime())) {
                return BaseRspUtils.createErrorRspList((String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)reqBO.getEndTime())) {
                return BaseRspUtils.createErrorRspList((String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ObCallRecordStatisticsPO statisticsPO = new ObCallRecordStatisticsPO();
            statisticsPO.setStartTime(reqBO.getStartTime());
            statisticsPO.setEndTime(reqBO.getEndTime());
            statisticsPO.setTenantIds(tenantIds);
            log.info("\u5750\u5e2d\u65e5\u62a5\u8868\u67e5\u8be2mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)statisticsPO));
            List statisticsPOS = this.obCallRecordStatisticsDAO.selectSeats(statisticsPO);
            if (statisticsPOS != null && statisticsPOS.size() > 0) {
                for (ObCallRecordStatisticsPO po : statisticsPOS) {
                    QuerySeatsDayStatisticsRspBO rspBO = new QuerySeatsDayStatisticsRspBO();
                    BeanUtils.copyProperties((Object)po, (Object)rspBO);
                    rspBO.setDuration(po.getDuration());
                    rspBO.setAvgDuration(Long.valueOf(po.getDuration() / Long.parseLong(po.getCallNum().toString())));
                    rspBO.setCallSate(TaskInfoUtil.getRate(po.getConnNum(), po.getCallNum()));
                    rspBO.setSuccessSate(TaskInfoUtil.getRate(po.getSuccessNum(), po.getConnNum()));
                    rspBO.setCallTime(po.getCallTime().substring(0, po.getCallTime().indexOf(":") - 2).trim());
                    rspBO.setTenantId(po.getTenantId());
                    BladeTenantBO tenantInfo = (BladeTenantBO)this.map.get(po.getTenantId());
                    if (null != tenantInfo) {
                        rspBO.setTenantName(tenantInfo.getTenantName());
                    } else {
                        tenantInfo = this.getTenantInfo(po.getTenantId());
                        if (null != tenantInfo) {
                            this.map.put(po.getTenantId(), tenantInfo);
                            rspBO.setTenantName(tenantInfo.getTenantName());
                        }
                    }
                    rspBO.setSeatesId(po.getSeatesId());
                    BladeUserBO userBO = this.bladeUserInterService.queryUserInfo(po.getSeatesId());
                    log.info("\u83b7\u53d6\u5750\u5e2d\u4fe1\u606f\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)userBO));
                    if (null != userBO) {
                        this.map.put(po.getSeatesId(), userBO);
                        rspBO.setSeatesName(userBO.getName());
                        rspBO.setLoginName(userBO.getAccount());
                    }
                    ArrayList<String> deptNames = new ArrayList<String>();
                    if (!StringUtils.isEmpty((Object)po.getDeptId())) {
                        String[] split;
                        for (String str : split = po.getDeptId().split(",")) {
                            QueryDeptRspBo deptInfo = (QueryDeptRspBo)this.map.get(str);
                            if (null != deptInfo) {
                                deptNames.add(deptInfo.getDeptName());
                                continue;
                            }
                            deptInfo = this.bladeDeptInterService.getDeptInfo(str);
                            if (null == deptInfo) continue;
                            this.map.put(str, deptInfo);
                            deptNames.add(deptInfo.getDeptName());
                        }
                    }
                    String deptName = String.join((CharSequence)",", deptNames);
                    rspBO.setDeptName(deptName);
                    rspBO.setTaskId(po.getTaskId());
                    ObTaskInfoPO obTaskInfoPO = (ObTaskInfoPO)this.map.get(po.getTaskId());
                    if (null != obTaskInfoPO) {
                        rspBO.setTaskName(obTaskInfoPO.getTaskName());
                    } else {
                        obTaskInfoPO = this.obTaskInfoDAO.selectByPrimaryKey(po.getTaskId());
                        log.info("\u83b7\u53d6\u4efb\u52a1\u4fe1\u606f\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obTaskInfoPO));
                        if (null != obTaskInfoPO) {
                            this.map.put(po.getTaskId(), obTaskInfoPO);
                            rspBO.setTaskName(obTaskInfoPO.getTaskName());
                        }
                    }
                    rspBOS.add(rspBO);
                }
            }
            if (!StringUtils.isEmpty((Object)reqBO.getTaskName())) {
                rspBOS = this.filterList(rspBOS, reqBO.getTaskName());
            }
            if (!StringUtils.isEmpty((Object)reqBO.getDeptId())) {
                rspBOS = this.filterListByDept(rspBOS, reqBO.getDeptId());
            }
            count = rspBOS.size();
            rspBOS = rspBOS.stream().skip(reqBO.getLimit() * (reqBO.getPage() - 1)).limit(reqBO.getLimit()).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            return BaseRspUtils.createErrorRspList((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRspList(rspBOS, (long)count.intValue());
    }

    public Rsp exportSeatsDayStatistics(QuerySeatsDayStatisticsReqBO reqBO) {
        log.info("\u8fdb\u5165\u5750\u5e2d\u65e5\u62a5\u8868\u5bfc\u51fa\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        ExportRspBO exportRspBO = new ExportRspBO();
        try {
            Integer limit = reqBO.getLimit();
            reqBO.setLimit(1);
            RspList<QuerySeatsDayStatisticsRspBO> rspBO = this.querySeatsDayStatistics(reqBO);
            if (!"0000".equals(rspBO.getRspCode())) {
                log.error("\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)rspBO.getRspDesc());
                return BaseRspUtils.createErrorRsp((String)rspBO.getRspDesc());
            }
            int pageCount = (int)rspBO.getCount();
            if (pageCount == 0) {
                return BaseRspUtils.createSuccessRsp((Object)"", (String)"\u672a\u83b7\u53d6\u5230\u5916\u547c\u8bb0\u5f55");
            }
            int pageNumber = (pageCount - 1) / limit + 1;
            reqBO.setLimit(limit.intValue());
            Integer index = 1;
            ArrayList<ExcelSeatsDayStatisticsBO> excelBOS = new ArrayList<ExcelSeatsDayStatisticsBO>();
            for (int i = 1; i <= pageNumber; ++i) {
                List rows;
                reqBO.setPage(i);
                RspList<QuerySeatsDayStatisticsRspBO> rsp = this.querySeatsDayStatistics(reqBO);
                if (!"0000".equals(rsp.getRspCode()) || (rows = rsp.getRows()) == null || rows.size() <= 0) continue;
                for (QuerySeatsDayStatisticsRspBO bo : rows) {
                    ExcelSeatsDayStatisticsBO excelBO = new ExcelSeatsDayStatisticsBO();
                    BeanUtils.copyProperties((Object)bo, (Object)excelBO);
                    excelBO.setCallNum(bo.getCallNum());
                    excelBO.setIndexCode(index.toString());
                    Integer n = index;
                    Integer n2 = index = Integer.valueOf(index + 1);
                    excelBOS.add(excelBO);
                }
            }
            log.info("\u5750\u5e2d\u65e5\u62a5\u8868\u5bfc\u51fa\uff0cexcelBOS\uff1a{}", (Object)JSONObject.toJSONString(excelBOS));
            String filePath = null;
            try {
                String tenantId = StringUtils.isEmpty((Object)reqBO.getTenantCode()) ? reqBO.getIn_tenantCode() : reqBO.getTenantCode();
                String fileName = "\u5750\u5e2d\u65e5\u62a5\u7edf\u8ba1\u62a5\u8868_" + tenantId + "_" + System.currentTimeMillis();
                filePath = this.excelHelper.writeExcel(excelBOS, ExcelSeatsDayStatisticsBO.class, fileName);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error(e.getMessage());
                return BaseRspUtils.createErrorRsp((String)"\u5bfc\u51fa\u5931\u8d25\uff01");
            }
            filePath = this.path + filePath.substring(filePath.lastIndexOf("/") + 1);
            log.info("filePath:{}", (Object)filePath);
            exportRspBO.setFilePath(filePath);
            exportRspBO.setFileName(filePath.substring(filePath.lastIndexOf("/") + 1));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            return BaseRspUtils.createErrorRsp((String)"\u5bfc\u51fa\u5931\u8d25\uff01");
        }
        return BaseRspUtils.createSuccessRsp((Object)exportRspBO);
    }

    private List<QuerySeatsDayStatisticsRspBO> filterList(List<QuerySeatsDayStatisticsRspBO> rspBOS, String patternName) {
        ArrayList<QuerySeatsDayStatisticsRspBO> bos = new ArrayList<QuerySeatsDayStatisticsRspBO>();
        Pattern pattern = Pattern.compile(patternName);
        for (QuerySeatsDayStatisticsRspBO rspBO : rspBOS) {
            Boolean aBoolean = this.getPatternName(pattern, rspBO.getTaskName());
            if (!aBoolean.booleanValue()) continue;
            bos.add(rspBO);
        }
        return bos;
    }

    private List<QuerySeatsDayStatisticsRspBO> filterListByDept(List<QuerySeatsDayStatisticsRspBO> rspBOS, String patternName) {
        ArrayList<QuerySeatsDayStatisticsRspBO> bos = new ArrayList<QuerySeatsDayStatisticsRspBO>();
        Pattern pattern = Pattern.compile(patternName);
        for (QuerySeatsDayStatisticsRspBO rspBO : rspBOS) {
            Boolean aBoolean = this.getPatternName(pattern, rspBO.getDeptName());
            if (!aBoolean.booleanValue()) continue;
            bos.add(rspBO);
        }
        return bos;
    }

    private Boolean getPatternName(Pattern pattern, String str) {
        if (!StringUtils.isEmpty((Object)str)) {
            Matcher matcher = pattern.matcher(str);
            return matcher.find();
        }
        return false;
    }

    private BladeTenantBO getTenantInfo(String tenantId) {
        GetBladeTenantInfoReqBO infoReqBO = new GetBladeTenantInfoReqBO();
        infoReqBO.setTenantCode(tenantId);
        GetBladeTenantInfoRspBO bladeTenantInfo = this.bladeTenantInterService.getBladeTenantInfo(infoReqBO);
        BladeTenantBO bladeTenantBO = new BladeTenantBO();
        if ("0000".equals(bladeTenantInfo.getRspCode())) {
            bladeTenantBO = (BladeTenantBO)bladeTenantInfo.getData();
        }
        return bladeTenantBO;
    }
}

