/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.subscribe;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.data.service.acust.AcustOrderInformationService;
import com.tydic.nicc.data.service.bundlecomm.ObBundleCommInfoService;
import com.tydic.nicc.dc.base.bo.LoginInfo;
import com.tydic.nicc.dc.base.bo.Req;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.bladetenant.inter.BladeTenantInterService;
import com.tydic.nicc.dc.bo.bladetenant.BladeTenantBO;
import com.tydic.nicc.dc.bo.bladetenant.GetBladeTenantInfoReqBO;
import com.tydic.nicc.dc.bo.bladetenant.GetBladeTenantInfoRspBO;
import com.tydic.nicc.dc.bo.user.BladeUserBO;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.user.inter.BladeUserInterService;
import com.tydic.nicc.ocs.bo.ProductSubscribeBO;
import com.tydic.nicc.ocs.bo.QualityProductSubscribeReqBO;
import com.tydic.nicc.ocs.bo.QueryProductSubscribeReqBO;
import com.tydic.nicc.ocs.bo.QueryProductSubscribeRspBO;
import com.tydic.nicc.ocs.bo.SubmitProductSubscribeReqBO;
import com.tydic.nicc.ocs.bo.SubscribeProductReqBO;
import com.tydic.nicc.ocs.constant.ProductSubscribeConstant;
import com.tydic.nicc.ocs.mapper.ObCallRecordDAO;
import com.tydic.nicc.ocs.mapper.ObCustServeRecordDAO;
import com.tydic.nicc.ocs.mapper.ObDataTargetDAO;
import com.tydic.nicc.ocs.mapper.ObProductSubscribeDAO;
import com.tydic.nicc.ocs.mapper.ObTaskInfoDAO;
import com.tydic.nicc.ocs.mapper.po.ObCallRecordPO;
import com.tydic.nicc.ocs.mapper.po.ObDataTargetPO;
import com.tydic.nicc.ocs.mapper.po.ObProductSubscribePO;
import com.tydic.nicc.ocs.mapper.po.ObTaskInfoPO;
import com.tydic.nicc.ocs.mapper.vo.CustRecordVO;
import com.tydic.nicc.ocs.service.ProductSubscribeService;
import com.tydic.nicc.ocs.subscribe.TenantBO;
import com.tydic.nicc.ocs.utils.DateUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;

@DubboService
public class ProductSubscribeServiceImpl
implements ProductSubscribeService {
    private static final Logger log = LoggerFactory.getLogger(ProductSubscribeServiceImpl.class);
    @Resource
    private ObProductSubscribeDAO obProductSubscribeDAO;
    @Resource
    private ObCustServeRecordDAO obCustServeRecordDAO;
    @Resource
    private ObTaskInfoDAO obTaskInfoDAO;
    @Resource
    private ObCallRecordDAO obCallRecordDAO;
    @Resource
    private ObDataTargetDAO obDataTargetDAO;
    @DubboReference
    private BladeTenantInterService bladeTenantInterService;
    @DubboReference
    private BladeUserInterService bladeUserInterService;
    @DubboReference
    private AcustOrderInformationService acustOrderInformationService;
    @DubboReference
    private ObBundleCommInfoService obBundleCommInfoService;
    public static final Map<String, TenantBO> tenantMap = MapUtil.newConcurrentHashMap((int)100);

    public Rsp submitProductSubscribe(SubmitProductSubscribeReqBO reqBO) {
        log.info("\u8fdb\u5165\u63d0\u4ea4\u8ba2\u8d2d\u4ea7\u54c1\u63a5\u53e3\uff0c \u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        LoginInfo userInfo = reqBO.getLoginInfo();
        try {
            String tenantId = reqBO.getTenantCode();
            if (StringUtils.isEmpty((Object)tenantId)) {
                if (StringUtils.isEmpty((Object)reqBO.getIn_tenantCode())) {
                    return BaseRspUtils.createErrorRsp((String)"\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
                tenantId = reqBO.getIn_tenantCode();
            }
            if (StringUtils.isEmpty((Object)reqBO.getUcId())) {
                return BaseRspUtils.createErrorRsp((String)"ucId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)reqBO.getProductId())) {
                return BaseRspUtils.createErrorRsp((String)"\u4ea7\u54c1Id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)reqBO.getTaskId())) {
                return BaseRspUtils.createErrorRsp((String)"\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)reqBO.getProductName())) {
                return BaseRspUtils.createErrorRsp((String)"\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            LoginInfo loginInfo = reqBO.getLoginInfo();
            String userId = loginInfo.getUserId();
            TenantBO tenantInfo = this.getTenantInfo(tenantId);
            String dataID = null;
            if (StringUtils.isEmpty((Object)reqBO.getDataId())) {
                ObDataTargetPO dataTargetPO = new ObDataTargetPO();
                dataTargetPO.setTenantId(tenantId);
                dataTargetPO.setTenantOtherName(tenantInfo.getTenantOtherName());
                dataTargetPO.setTaskId(reqBO.getTaskId());
                dataTargetPO.setMobileNo(reqBO.getCalled());
                ObDataTargetPO targetPO = this.obDataTargetDAO.selectByMobileNo(dataTargetPO);
                log.info("\u83b7\u53d6\u4efb\u52a1\u6570\u636eMapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)targetPO));
                if (null != targetPO) {
                    dataID = targetPO.getDataId();
                }
            } else {
                dataID = reqBO.getDataId();
            }
            ObProductSubscribePO subscribePO = new ObProductSubscribePO();
            subscribePO.setTenantId(tenantId);
            subscribePO.setUcId(reqBO.getUcId());
            subscribePO.setCalled(reqBO.getCalled());
            subscribePO.setTaskId(reqBO.getTaskId());
            subscribePO.setProductId(reqBO.getProductId());
            subscribePO.setProductName(reqBO.getProductName());
            subscribePO.setCustomerId(userInfo.getUserId());
            subscribePO.setJobNumber(userId);
            subscribePO.setCreateTime(DateUtil.getDateTime());
            subscribePO.setDataId(dataID);
            String channel = this.obBundleCommInfoService.getBundleCommInfo(reqBO.getProductId());
            subscribePO.setSubscribeChannel(Integer.valueOf(channel));
            this.obProductSubscribeDAO.updateByProduct(subscribePO);
            this.obProductSubscribeDAO.insertSelective(subscribePO);
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            return BaseRspUtils.createErrorRsp((String)"\u8ba2\u8d2d\u4ea7\u54c1\u5931\u8d25");
        }
        return BaseRspUtils.createSuccessRsp((Object)"");
    }

    public RspList queryProductSubscribe(QueryProductSubscribeReqBO reqBO) {
        log.info("\u8fdb\u5165\u67e5\u8be2\u8ba2\u8d2d\u8d28\u68c0\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        List<Object> rspBOS = new ArrayList<QueryProductSubscribeRspBO>();
        Integer count = 0;
        try {
            String startTime = reqBO.getStartTime();
            String endTime = reqBO.getEndTime();
            if (StringUtils.isEmpty((Object)startTime) || StringUtils.isEmpty((Object)endTime)) {
                startTime = DateUtil.getDayStartTimeStr(new Date());
                endTime = DateUtil.getDayEndTimeStr(new Date());
            }
            List roleNames = this.bladeUserInterService.getUserRoleInfo(reqBO.getLoginInfo().getUserId());
            ArrayList<String> tenantIds = new ArrayList<String>();
            List bladeTenants = null;
            Set roleSet = reqBO.getRoleSet();
            if (reqBO.getTenantIds() != null && reqBO.getTenantIds().size() > 0) {
                tenantIds.addAll(reqBO.getTenantIds());
            } else {
                tenantIds.add(reqBO.getTenantCode());
                for (String role : roleNames) {
                    if (null == roleSet || StringUtils.isEmpty((Object)role) || !role.equals("system:admin") && !role.equals("system:administrator")) continue;
                    Req req = new Req();
                    req.setIn_tenantCode(reqBO.getIn_tenantCode());
                    req.setRoleSet(roleSet);
                    req.setTenantCode(reqBO.getTenantCode());
                    bladeTenants = this.bladeTenantInterService.getBalseTenantList(req);
                    if (null == bladeTenants) break;
                    tenantIds.addAll(bladeTenants.stream().map(x -> x.getTenantId()).collect(Collectors.toList()));
                    break;
                }
            }
            ObProductSubscribePO obProductSubscribePO = new ObProductSubscribePO();
            obProductSubscribePO.setTenantIds(tenantIds);
            obProductSubscribePO.setQualityStatus(null != reqBO.getQualityStatus() ? (ProductSubscribeConstant.QUALITY_STATUS_2.equals(reqBO.getQualityStatus()) ? null : reqBO.getQualityStatus()) : null);
            obProductSubscribePO.setReceiptStatus(null != reqBO.getReceiptStatus() ? (ProductSubscribeConstant.SUBSCRIBE_STATUS_2.equals(reqBO.getReceiptStatus()) ? null : reqBO.getReceiptStatus()) : null);
            obProductSubscribePO.setStartTime(startTime);
            obProductSubscribePO.setEndTime(endTime);
            obProductSubscribePO.setCalled(reqBO.getCalled());
            log.info("\u67e5\u8be2\u8ba2\u8d2d\u8d28\u68c0\u5217\u8868Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obProductSubscribePO));
            List productSubscribePOS = this.obProductSubscribeDAO.selectProductSubscribe(obProductSubscribePO);
            log.info("\u67e5\u8be2\u8ba2\u8d2d\u8d28\u68c0\u5217\u8868Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)productSubscribePOS));
            if (null != productSubscribePOS && productSubscribePOS.size() > 0) {
                BladeTenantBO tenant = this.getTenant(reqBO.getTenantCode());
                tenantIds.add(tenant.getParentTenantId());
                List userBOS = this.bladeUserInterService.queryBladeUsers(tenantIds);
                log.info("tenantIds:{}, userBOS:{}", (Object)JSONObject.toJSONString(tenantIds), (Object)JSONObject.toJSONString((Object)userBOS));
                for (ObProductSubscribePO subscribePO : productSubscribePOS) {
                    QueryProductSubscribeRspBO rspBO2 = new QueryProductSubscribeRspBO();
                    if (subscribePO.getCustomerId().equals(reqBO.getLoginInfo().getUserId())) {
                        log.info("\u5f53\u524d\u8ba2\u8d2d\u4ebaId:{}, \u4e0d\u5c55\u793a\u81ea\u5df1\u63d0\u4ea4\u7684\u8ba2\u8d2d\u8bb0\u5f55\uff0c\u8df3\u8fc7");
                        continue;
                    }
                    BeanUtils.copyProperties((Object)subscribePO, (Object)rspBO2);
                    rspBO2.setId(subscribePO.getId().toString());
                    TenantBO tenantInfo = this.getTenantInfo(subscribePO.getTenantId());
                    if (null == tenantInfo) {
                        return BaseRspUtils.createErrorRspList((String)"\u672a\u83b7\u53d6\u5230\u79df\u6237\u4fe1\u606f");
                    }
                    List custRecordVOS = this.obCustServeRecordDAO.selectCustServiceByUcId(tenantInfo.getTenantOtherName(), subscribePO.getUcId());
                    log.info("\u5f53\u524ducId\uff1a{}, \u83b7\u53d6\u5750\u5e2d\u670d\u52a1\u8bb0\u5f55Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)subscribePO.getUcId(), (Object)JSONObject.toJSONString((Object)custRecordVOS));
                    if (null == custRecordVOS || custRecordVOS.size() == 0) {
                        log.info("\u5f53\u524d\u672a\u67e5\u8be2\u5230\u5750\u5e2d\u63d0\u4ea4\u8bb0\u5f55\uff0c\u8df3\u8fc7");
                        continue;
                    }
                    CustRecordVO custRecordVO = (CustRecordVO)custRecordVOS.get(0);
                    if (!"1".equals(custRecordVO.getIsConn()) || !"1".equals(custRecordVO.getObsIsConn())) {
                        log.info("\u5f53\u524d\u901a\u8bdd\u672a\u63a5\u901a\uff0c\u4e0d\u5c55\u793a");
                        continue;
                    }
                    rspBO2.setCaller(custRecordVO.getCalling());
                    rspBO2.setUserPurpose(custRecordVO.getHandleResults());
                    rspBO2.setRemark(custRecordVO.getHandleRemark());
                    rspBO2.setStartTalkTime(custRecordVO.getStartTime());
                    rspBO2.setEndTalkTime(custRecordVO.getEndTime());
                    rspBO2.setCustomerName(this.getName(userBOS, subscribePO.getCustomerId()));
                    rspBO2.setRecordFile(custRecordVO.getRecordFile());
                    rspBO2.setSuggestProduct(custRecordVO.getSuggestProduct());
                    if (null != subscribePO.getQualityId()) {
                        rspBO2.setQualityStatus(null != subscribePO.getQualityStatus() ? String.valueOf(subscribePO.getQualityStatus()) : null);
                        rspBO2.setQualityName(!StringUtils.isEmpty((Object)subscribePO.getQualityId()) ? this.getName(userBOS, subscribePO.getQualityId()) : null);
                    }
                    rspBO2.setQualityStatusStr(ProductSubscribeConstant.QUALITY_STATUS.getQualityStatusStr(subscribePO.getQualityStatus()));
                    if (null != subscribePO.getSubscribeId()) {
                        rspBO2.setSubscribeStatus(null != subscribePO.getSubscribeStatus() ? String.valueOf(subscribePO.getSubscribeStatus()) : null);
                        rspBO2.setReceiptStatus(null != subscribePO.getReceiptStatus() ? String.valueOf(subscribePO.getReceiptStatus()) : null);
                        rspBO2.setSubscribeName(!StringUtils.isEmpty((Object)subscribePO.getSubscribeId()) ? this.getName(userBOS, subscribePO.getSubscribeId()) : null);
                    }
                    rspBO2.setReceiptStatusStr(ProductSubscribeConstant.SUBSCRIBE_STATUS.getSubscribeStatus(subscribePO.getReceiptStatus()));
                    rspBO2.setDuration(Long.valueOf(null == custRecordVO.getDuration() ? 0L : custRecordVO.getDuration()));
                    ObTaskInfoPO obTaskInfoPO = this.obTaskInfoDAO.selectByPrimaryKey(subscribePO.getTaskId());
                    rspBO2.setTaskName(obTaskInfoPO.getTaskName());
                    rspBO2.setMainProductName(obTaskInfoPO.getProductName());
                    rspBOS.add(rspBO2);
                }
            }
            if (null != (rspBOS = this.getMap(rspBOS)) && rspBOS.size() > 0) {
                if (!StringUtils.isEmpty((Object)reqBO.getCalled())) {
                    rspBOS = rspBOS.stream().filter(rspBO -> reqBO.getCalled().equals(rspBO.getCalled())).collect(Collectors.toList());
                }
                if (!StringUtils.isEmpty((Object)reqBO.getTaskName())) {
                    rspBOS = this.filterTaskName(rspBOS, reqBO.getTaskName());
                }
                if (!StringUtils.isEmpty((Object)reqBO.getCustName())) {
                    rspBOS = this.filterCustName(rspBOS, reqBO.getCustName());
                }
                if (!StringUtils.isEmpty((Object)reqBO.getQualityName())) {
                    rspBOS = this.filterQualityName(rspBOS, reqBO.getQualityName());
                }
                if (!StringUtils.isEmpty((Object)reqBO.getSubscribeName())) {
                    rspBOS = this.filterSubscribeName(rspBOS, reqBO.getSubscribeName());
                }
            }
            count = rspBOS.size();
            rspBOS = rspBOS.stream().sorted(Comparator.comparing(QueryProductSubscribeRspBO::getCreateTime).reversed()).collect(Collectors.toList());
            rspBOS = rspBOS.stream().skip(reqBO.getLimit() * (reqBO.getPage() - 1)).limit(reqBO.getLimit()).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            return BaseRspUtils.createErrorRspList((String)"\u672a\u67e5\u8be2\u5230\u8ba2\u8d2d\u8bb0\u5f55");
        }
        return BaseRspUtils.createSuccessRspList(rspBOS, (long)count.intValue());
    }

    public Rsp qualityProductSubscribe(QualityProductSubscribeReqBO reqBO) {
        log.info("\u8fdb\u5165\u8d28\u68c0\u5f55\u97f3\u63a5\u53e3\uff0c \u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        LoginInfo userInfo = reqBO.getLoginInfo();
        try {
            if (StringUtils.isEmpty((Object)reqBO.getUcId())) {
                return BaseRspUtils.createErrorRsp((String)"ucId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == reqBO.getQualityStatus()) {
                return BaseRspUtils.createErrorRsp((String)"\u8d28\u68c0\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ObProductSubscribePO productSubscribePO = new ObProductSubscribePO();
            productSubscribePO.setUcId(reqBO.getUcId());
            List subscribePOS = this.obProductSubscribeDAO.selectByIdAndUcId(productSubscribePO);
            log.info("\u67e5\u8be2\u8ba2\u8d2d\u8bb0\u5f55Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)subscribePOS));
            if (null == subscribePOS || subscribePOS.size() == 0) {
                return BaseRspUtils.createErrorRsp((String)"\u672a\u67e5\u8be2\u5230\u8ba2\u8d2d\u8bb0\u5f55");
            }
            if (null != ((ObProductSubscribePO)subscribePOS.get(0)).getQualityId()) {
                return BaseRspUtils.createErrorRsp((String)"\u5f53\u524d\u8ba2\u8d2d\u8bb0\u5f55\u5df2\u8d28\u68c0\u5b8c\u6210");
            }
            productSubscribePO.setQualityStatus(reqBO.getQualityStatus());
            productSubscribePO.setQualityId(userInfo.getUserId());
            productSubscribePO.setQualityTime(DateUtil.getDateTime());
            log.info("\u4fee\u6539\u8d28\u68c0\u72b6\u6001Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)productSubscribePO));
            this.obProductSubscribeDAO.updateByUcId(productSubscribePO);
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u8d28\u68c0\u72b6\u6001\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            return BaseRspUtils.createErrorRsp((String)"\u4e1a\u52a1\u5904\u7406\u5931\u8d25");
        }
        return BaseRspUtils.createSuccessRsp((Object)"");
    }

    public Rsp subscribeProduct(SubscribeProductReqBO reqBO) {
        log.info("\u8fdb\u5165\u8ba2\u8d2d\u4ea7\u54c1\u63a5\u53e3\uff0c \u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        LoginInfo userInfo = reqBO.getLoginInfo();
        try {
            if (null == reqBO.getIds() || reqBO.getIds().size() == 0) {
                return BaseRspUtils.createErrorRsp((String)"\u4e3b\u952eID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)reqBO.getSubscribeChannel())) {
                return BaseRspUtils.createErrorRsp((String)"\u8ba2\u8d2d\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a");
            }
            for (String id : reqBO.getIds()) {
                ObProductSubscribePO subscribePO = this.obProductSubscribeDAO.selectByPrimaryKey(Long.valueOf(Long.parseLong(id)));
                log.info("\u5f53\u524d\u4e3b\u952e\uff1a{}\uff0c \u67e5\u8be2Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)id, (Object)JSONObject.toJSONString((Object)subscribePO));
                if (null == subscribePO) {
                    log.error("\u5165\u53c2\u9519\u8bef\uff0c\u672a\u67e5\u8be2\u5230\u8ba2\u8d2d\u4fe1\u606f");
                    return BaseRspUtils.createErrorRsp((String)"\u5165\u53c2\u9519\u8bef\uff0c\u672a\u67e5\u8be2\u5230\u8ba2\u8d2d\u4fe1\u606f");
                }
                if (null == subscribePO.getQualityId()) {
                    return BaseRspUtils.createErrorRsp((String)"\u8bf7\u5b8c\u6210\u8d28\u68c0\u540e\u518d\u64cd\u4f5c");
                }
                if (ProductSubscribeConstant.QUALITY_STATUS_1.equals(subscribePO.getQualityStatus())) {
                    return BaseRspUtils.createErrorRsp((String)"\u672a\u901a\u8fc7\u5f55\u97f3\u8d28\u68c0\uff0c\u65e0\u6cd5\u8ba2\u8d2d\u6b64\u4ea7\u54c1");
                }
                ObProductSubscribePO productSubscribePO = new ObProductSubscribePO();
                if (ProductSubscribeConstant.SUBSCRIBE_CHANNEL_1.equals(reqBO.getSubscribeChannel())) {
                    Integer subscribeStatus = null;
                    log.info("\u5f53\u524d\u8ba2\u8d2d\u6e20\u9053\u4e3a\u4e00\u4ef6\u8ba2\u8d2d\uff0c \u8c03\u7528\u4e00\u4ef6\u8ba2\u8d2d\u63a5\u53e3");
                    Map<String, Object> param = this.getParam(subscribePO);
                    Rsp rsp = this.acustOrderInformationService.orderInfoPush(param);
                    if ("0000".equals(rsp.getRspCode())) {
                        log.info("\u4e00\u952e\u8ba2\u8d2d\u63a5\u53e3\u8c03\u7528\u6210\u529f");
                        subscribeStatus = ProductSubscribeConstant.SUBSCRIBE_STATUS_0;
                    } else {
                        log.info("\u4e00\u952e\u8ba2\u8d2d\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a{}", (Object)rsp.getRspDesc());
                        subscribeStatus = ProductSubscribeConstant.SUBSCRIBE_STATUS_1;
                    }
                    productSubscribePO.setSubscribeStatus(subscribeStatus);
                    productSubscribePO.setReceiptStatus(subscribeStatus);
                } else {
                    productSubscribePO.setSubscribeStatus(ProductSubscribeConstant.SUBSCRIBE_STATUS_0);
                }
                productSubscribePO.setId(Long.valueOf(Long.parseLong(id)));
                productSubscribePO.setSubscribeId(userInfo.getUserId());
                productSubscribePO.setSubscribeChannel(reqBO.getSubscribeChannel());
                productSubscribePO.setSubscribeTime(DateUtil.getDateTime());
                this.obProductSubscribeDAO.updateByPrimaryKeySelective(productSubscribePO);
            }
        }
        catch (Exception e) {
            log.error("\u8ba2\u8d2d\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            return BaseRspUtils.createErrorRsp((String)"\u4e1a\u52a1\u5904\u7406\u5931\u8d25");
        }
        return BaseRspUtils.createSuccessRsp((Object)"");
    }

    public List<ProductSubscribeBO> getSuccessProduct(ProductSubscribeBO subscribeBO) {
        log.info("\u8fdb\u5165\u83b7\u53d6\u63a8\u8350\u6210\u529f\u4ea7\u54c1\u63a5\u53e3\uff0c \u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)subscribeBO));
        ObProductSubscribePO obProductSubscribePO = new ObProductSubscribePO();
        obProductSubscribePO.setCalled(subscribeBO.getCalled());
        obProductSubscribePO.setTenantId(subscribeBO.getTenantId());
        obProductSubscribePO.setUcId(subscribeBO.getUcId());
        log.info("\u83b7\u53d6\u63a8\u8350\u6210\u529f\u4ea7\u54c1Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obProductSubscribePO));
        List subscribePOS = this.obProductSubscribeDAO.selectSuccessProduct(obProductSubscribePO);
        log.info("\u83b7\u53d6\u63a8\u8350\u6210\u529f\u4ea7\u54c1Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)subscribePOS));
        ArrayList<ProductSubscribeBO> subscribeBOS = new ArrayList<ProductSubscribeBO>();
        if (null != subscribePOS && subscribePOS.size() > 0) {
            for (ObProductSubscribePO subscribePO : subscribePOS) {
                ProductSubscribeBO bo = new ProductSubscribeBO();
                BeanUtils.copyProperties((Object)subscribePO, (Object)bo);
                bo.setProductName(subscribePO.getProductName());
                subscribeBOS.add(bo);
            }
        }
        return subscribeBOS;
    }

    private String getName(List<BladeUserBO> userBOS, String userId) {
        List customer = userBOS.stream().filter(user -> userId.equals(user.getId().toString())).collect(Collectors.toList());
        String name = null;
        if (null != customer) {
            name = ((BladeUserBO)customer.get(0)).getName();
        }
        return name;
    }

    private List<QueryProductSubscribeRspBO> filterTaskName(List<QueryProductSubscribeRspBO> rspBOS, String taskName) {
        ArrayList<QueryProductSubscribeRspBO> bos = new ArrayList<QueryProductSubscribeRspBO>();
        Pattern pattern = Pattern.compile(taskName);
        for (QueryProductSubscribeRspBO rspBO : rspBOS) {
            Boolean aBoolean = this.getPatternName(pattern, rspBO.getTaskName());
            if (!aBoolean.booleanValue()) continue;
            bos.add(rspBO);
        }
        return bos;
    }

    private List<QueryProductSubscribeRspBO> filterCustName(List<QueryProductSubscribeRspBO> rspBOS, String custName) {
        ArrayList<QueryProductSubscribeRspBO> bos = new ArrayList<QueryProductSubscribeRspBO>();
        Pattern pattern = Pattern.compile(custName);
        for (QueryProductSubscribeRspBO rspBO : rspBOS) {
            Boolean aBoolean = this.getPatternName(pattern, rspBO.getCustomerName());
            if (!aBoolean.booleanValue()) continue;
            bos.add(rspBO);
        }
        return bos;
    }

    private List<QueryProductSubscribeRspBO> filterQualityName(List<QueryProductSubscribeRspBO> rspBOS, String qualityName) {
        ArrayList<QueryProductSubscribeRspBO> bos = new ArrayList<QueryProductSubscribeRspBO>();
        Pattern pattern = Pattern.compile(qualityName);
        for (QueryProductSubscribeRspBO rspBO : rspBOS) {
            Boolean aBoolean = this.getPatternName(pattern, rspBO.getQualityName());
            if (!aBoolean.booleanValue()) continue;
            bos.add(rspBO);
        }
        return bos;
    }

    private List<QueryProductSubscribeRspBO> filterSubscribeName(List<QueryProductSubscribeRspBO> rspBOS, String subscribeName) {
        ArrayList<QueryProductSubscribeRspBO> bos = new ArrayList<QueryProductSubscribeRspBO>();
        Pattern pattern = Pattern.compile(subscribeName);
        for (QueryProductSubscribeRspBO rspBO : rspBOS) {
            Boolean aBoolean = this.getPatternName(pattern, rspBO.getSubscribeName());
            if (!aBoolean.booleanValue()) continue;
            bos.add(rspBO);
        }
        return bos;
    }

    private Boolean getPatternName(Pattern pattern, String str) {
        Matcher matcher;
        if (!StringUtils.isEmpty((Object)str) && (matcher = pattern.matcher(str)).find()) {
            return true;
        }
        return false;
    }

    private Map<String, Object> getParam(ObProductSubscribePO subscribePO) {
        log.info("\u5f00\u59cb\u7ec4\u88c5\u8c03\u7528\u8ba2\u8d2d\u63a5\u53e3\u6240\u9700\u53c2\u6570");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("taskId", subscribePO.getTaskId());
        map.put("dataId", subscribePO.getDataId());
        map.put("productId", subscribePO.getProductId());
        TenantBO tenantInfo = this.getTenantInfo(subscribePO.getTenantId());
        ObCallRecordPO callRecordPO = new ObCallRecordPO();
        callRecordPO.setTenantOtherName(tenantInfo.getTenantOtherName());
        callRecordPO.setTenantId(subscribePO.getTenantId());
        callRecordPO.setUcId(subscribePO.getUcId());
        ObCallRecordPO recordPO = this.obCallRecordDAO.selectByUcId(callRecordPO);
        log.info("\u83b7\u53d6\u5916\u547c\u8bb0\u5f55\u4fe1\u606fMapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)recordPO));
        map.put("recordId", recordPO.getRecordId());
        BladeUserBO userBO = this.bladeUserInterService.queryUserInfo(subscribePO.getCustomerId());
        map.put("userCode", userBO.getAccount());
        map.put("userId", subscribePO.getCustomerId());
        map.put("mobileNo", subscribePO.getCalled());
        map.put("tenantId", subscribePO.getTenantId());
        return map;
    }

    public BladeTenantBO getTenant(String tenantId) {
        GetBladeTenantInfoReqBO infoReqBO = new GetBladeTenantInfoReqBO();
        infoReqBO.setTenantCode(tenantId);
        GetBladeTenantInfoRspBO bladeTenantInfo = this.bladeTenantInterService.getBladeTenantInfo(infoReqBO);
        BladeTenantBO bladeTenantBO = new BladeTenantBO();
        if (bladeTenantInfo.getRspCode().equals("0000")) {
            bladeTenantBO = (BladeTenantBO)bladeTenantInfo.getData();
        }
        return bladeTenantBO;
    }

    private TenantBO getTenantInfo(String tenantId) {
        if (!StringUtils.isEmpty((Object)tenantMap.get(tenantId))) {
            return tenantMap.get(tenantId);
        }
        GetBladeTenantInfoReqBO infoReqBO = new GetBladeTenantInfoReqBO();
        infoReqBO.setTenantCode(tenantId);
        GetBladeTenantInfoRspBO bladeTenantInfo = this.bladeTenantInterService.getBladeTenantInfo(infoReqBO);
        if (bladeTenantInfo.getRspCode().equals("0000")) {
            BladeTenantBO bladeTenantBO = (BladeTenantBO)bladeTenantInfo.getData();
            TenantBO tenantBO = new TenantBO();
            tenantBO.setTenantId(tenantId);
            tenantBO.setTenantName(bladeTenantBO.getTenantName());
            tenantBO.setTenantOtherName(bladeTenantBO.getTenantOtherName());
            tenantMap.put(tenantId, tenantBO);
            return tenantBO;
        }
        return null;
    }

    private List<QueryProductSubscribeRspBO> getMap(List<QueryProductSubscribeRspBO> rspBOS) {
        HashMap map = new HashMap();
        for (QueryProductSubscribeRspBO rspBO : rspBOS) {
            String key = rspBO.getUcId();
            if (map.containsKey(key)) {
                List subscribeRspBOS = (List)map.get(key);
                subscribeRspBOS.add(rspBO);
                continue;
            }
            ArrayList<QueryProductSubscribeRspBO> bos = new ArrayList<QueryProductSubscribeRspBO>();
            bos.add(rspBO);
            map.put(key, bos);
        }
        ArrayList<QueryProductSubscribeRspBO> bos = new ArrayList<QueryProductSubscribeRspBO>();
        for (List value : map.values()) {
            String receiptStatusStr = "\u672a\u8ba2\u8d2d";
            ArrayList<String> productNames = new ArrayList<String>();
            ArrayList<String> successProducts = new ArrayList<String>();
            HashMap<String, String> productMap = new HashMap<String, String>();
            boolean flag = true;
            QueryProductSubscribeRspBO rspBO = new QueryProductSubscribeRspBO();
            for (QueryProductSubscribeRspBO bo : value) {
                BeanUtils.copyProperties((Object)bo, (Object)rspBO);
                productMap.put(bo.getId(), bo.getProductName());
                productNames.add(bo.getProductName());
                if (null != bo.getSubscribeStatus()) {
                    flag = false;
                }
                if (String.valueOf(ProductSubscribeConstant.SUBSCRIBE_STATUS_0).equals(bo.getReceiptStatus())) {
                    successProducts.add(bo.getProductName());
                    receiptStatusStr = "\u6210\u529f";
                    continue;
                }
                if (!String.valueOf(ProductSubscribeConstant.SUBSCRIBE_STATUS_1).equals(bo.getReceiptStatus()) || "\u6210\u529f".equals(receiptStatusStr)) continue;
                receiptStatusStr = "\u5931\u8d25";
            }
            rspBO.setSuccessSuggestProduct(String.join((CharSequence)",", productNames));
            rspBO.setSuccessProduct(String.join((CharSequence)",", successProducts));
            rspBO.setProductMsg(JSONObject.toJSONString(productMap));
            rspBO.setReceiptStatusStr(receiptStatusStr);
            rspBO.setIsSubscribe(Boolean.valueOf(flag));
            bos.add(rspBO);
        }
        log.info("bos:{}", (Object)JSONObject.toJSONString(bos));
        return bos;
    }
}

