/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.task.info.impl;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.dc.ability.bo.SkillGroupBO;
import com.tydic.nicc.dc.base.bo.LoginInfo;
import com.tydic.nicc.dc.base.bo.Req;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.bladetenant.inter.BladeTenantInterService;
import com.tydic.nicc.dc.bo.bladetenant.BladeTenantBO;
import com.tydic.nicc.dc.bo.bladetenant.GetBladeTenantInfoReqBO;
import com.tydic.nicc.dc.bo.bladetenant.GetBladeTenantInfoRspBO;
import com.tydic.nicc.dc.bo.skillGroup.DcSkillGroupInfoBO;
import com.tydic.nicc.dc.bo.user.BladeUserBO;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.skillGroup.inter.SkillGroupInterService;
import com.tydic.nicc.dc.smstemplate.DcSmsTemplateService;
import com.tydic.nicc.dc.user.inter.BladeUserInterService;
import com.tydic.nicc.ocs.bo.AddTaskCombineServiceBO;
import com.tydic.nicc.ocs.bo.AddTaskCombineServiceReqBO;
import com.tydic.nicc.ocs.bo.AddTaskInfoBO;
import com.tydic.nicc.ocs.bo.AddTaskInfoRspBO;
import com.tydic.nicc.ocs.bo.ChildTaskBO;
import com.tydic.nicc.ocs.bo.GetTaskDataReqBO;
import com.tydic.nicc.ocs.bo.ObTaskAllotBO;
import com.tydic.nicc.ocs.bo.QryTacticsReqBO;
import com.tydic.nicc.ocs.bo.QueryTaskDataTargetReqBO;
import com.tydic.nicc.ocs.bo.QueryTaskDataTargetRspBO;
import com.tydic.nicc.ocs.bo.QueryTaskInfoBO;
import com.tydic.nicc.ocs.bo.QueryTaskInfoListBO;
import com.tydic.nicc.ocs.bo.QueryTaskInfoListReqBO;
import com.tydic.nicc.ocs.bo.QueryTaskInfoListRspBO;
import com.tydic.nicc.ocs.bo.QueryTaskInfoReqBO;
import com.tydic.nicc.ocs.bo.QueryTaskInfoRspBO;
import com.tydic.nicc.ocs.bo.QueryTaskQuickRspBO;
import com.tydic.nicc.ocs.bo.QueryTaskSmsTemplateRspBO;
import com.tydic.nicc.ocs.bo.QueryTaskUserReqBO;
import com.tydic.nicc.ocs.bo.QueryTaskVoiceRspBO;
import com.tydic.nicc.ocs.bo.TaskInfoBO;
import com.tydic.nicc.ocs.bo.TaskRelationBO;
import com.tydic.nicc.ocs.bo.TaskRelationParamBO;
import com.tydic.nicc.ocs.bo.TaskRelationParamsBO;
import com.tydic.nicc.ocs.bo.TenantBO;
import com.tydic.nicc.ocs.bo.TestCallReqBO;
import com.tydic.nicc.ocs.bo.UpdateTaskReqBO;
import com.tydic.nicc.ocs.bo.UpdateTaskRspBO;
import com.tydic.nicc.ocs.busi.TaskBusiService;
import com.tydic.nicc.ocs.cache.AreaCache;
import com.tydic.nicc.ocs.constant.TaskConstant;
import com.tydic.nicc.ocs.exception.OcsException;
import com.tydic.nicc.ocs.isv.PredictiveTaskService;
import com.tydic.nicc.ocs.mapper.ObCallRecordDAO;
import com.tydic.nicc.ocs.mapper.ObDataTargetDAO;
import com.tydic.nicc.ocs.mapper.ObIvrTaskDAO;
import com.tydic.nicc.ocs.mapper.ObTaskAllotDAO;
import com.tydic.nicc.ocs.mapper.ObTaskInfoDAO;
import com.tydic.nicc.ocs.mapper.ObTaskTenantDAO;
import com.tydic.nicc.ocs.mapper.po.ObDataTargetPO;
import com.tydic.nicc.ocs.mapper.po.ObIvrTaskPO;
import com.tydic.nicc.ocs.mapper.po.ObTaskAllotPO;
import com.tydic.nicc.ocs.mapper.po.ObTaskInfoPO;
import com.tydic.nicc.ocs.mapper.po.ObTaskTenantPO;
import com.tydic.nicc.ocs.service.IsvTaskProxyService;
import com.tydic.nicc.ocs.service.TaskConfigRelationService;
import com.tydic.nicc.ocs.service.TaskDataTargetService;
import com.tydic.nicc.ocs.service.TaskInfoService;
import com.tydic.nicc.ocs.service.TaskTacticsService;
import com.tydic.nicc.ocs.type.CallTaskStatus;
import com.tydic.nicc.ocs.utils.TaskEnum;
import com.tydic.nicc.ocs.utils.TaskInfoUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.util.StringUtils;
import org.tio.utils.hutool.StrUtil;

@DubboService
public class TaskInfoServiceImpl
implements TaskInfoService {
    private static final Logger log = LoggerFactory.getLogger(TaskInfoServiceImpl.class);
    private static final String DELETE_FLAG_0 = "0";
    private static final String DELETE_FLAG_1 = "1";
    private static final Integer STATUS_0 = 0;
    private static final Integer STATUS_1 = 1;
    private static final String SUCCESS_MESSAGE = "SUCCESS";
    @Resource
    private ObTaskInfoDAO obTaskInfoDAO;
    @Resource
    private ObIvrTaskDAO ivrTaskDAO;
    @Resource
    private ObTaskAllotDAO obTaskAllotDAO;
    @Resource
    private ObDataTargetDAO obDataTargetDAO;
    @Resource
    private ObCallRecordDAO obCallRecordDAO;
    @Resource
    private ObTaskTenantDAO obTaskTenantDAO;
    @Autowired
    private TaskConfigRelationService taskConfigRelationService;
    @Autowired
    private TaskDataTargetService taskDataTargetService;
    @Autowired
    private TaskTacticsService taskTacticsService;
    @Autowired
    private TaskBusiService taskBusiService;
    @Autowired
    private PredictiveTaskService predictiveTaskService;
    @DubboReference
    private DcSmsTemplateService dcSmsTemplateService;
    @DubboReference
    private SkillGroupInterService skillGroupInterService;
    @DubboReference
    private BladeUserInterService bladeUserInterService;
    @DubboReference
    private BladeTenantInterService bladeTenantInterService;
    @Autowired
    private IsvTaskProxyService isvTaskProxyService;
    public static final Map<String, BladeTenantBO> tenantMap = MapUtil.newConcurrentHashMap((int)100);

    @Transactional(rollbackFor={Exception.class})
    public Rsp addTaskCombineService(AddTaskCombineServiceReqBO req) {
        log.info("\u8fdb\u5165\u65b0\u589e\u4efb\u52a1\u7ec4\u5408\u670d\u52a1\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)req));
        String taskId = "";
        try {
            AddTaskCombineServiceBO reqBO = req.getReqData();
            AddTaskInfoBO addTaskInfoBO = reqBO.getAddTaskInfoBO();
            Rsp rsp = this.checkParam(req);
            if (!"0000".equals(rsp.getRspCode())) {
                return rsp;
            }
            List callResultSets = reqBO.getCallResultSets();
            if (StringUtils.isEmpty((Object)addTaskInfoBO.getTaskId())) {
                ObTaskInfoPO obTaskInfoPO = new ObTaskInfoPO();
                obTaskInfoPO.setTenantId(req.getTenantCode());
                obTaskInfoPO.setTaskName(addTaskInfoBO.getTaskName());
                ObTaskInfoPO taskInfoPO = this.obTaskInfoDAO.selectByName(obTaskInfoPO);
                log.info("\u6839\u636e\u4efb\u52a1\u540d\u79f0\u67e5\u8be2Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)taskInfoPO));
                if (taskInfoPO != null) {
                    return BaseRspUtils.createErrorRsp((String)"\u5df2\u5b58\u5728\u540c\u540d\u4efb\u52a1\uff01");
                }
                taskId = TaskInfoUtil.get16UUID();
                addTaskInfoBO.setTaskId(taskId);
                addTaskInfoBO.setPortFlag(Integer.valueOf(0));
            } else {
                taskId = addTaskInfoBO.getTaskId();
                addTaskInfoBO.setTaskId(taskId);
                addTaskInfoBO.setPortFlag(Integer.valueOf(1));
            }
            addTaskInfoBO.setCallResultSet(JSONObject.toJSONString((Object)callResultSets));
            addTaskInfoBO.setTenantId(req.getTenantCode());
            AddTaskInfoRspBO rspBO = this.addTaskInfo(addTaskInfoBO);
            if (!rspBO.getStatus().equals(STATUS_0)) {
                return BaseRspUtils.createErrorRsp((String)"\u65b0\u589e\u5931\u8d25");
            }
            if ("grab".equals(addTaskInfoBO.getTaskType())) {
                List obTaskTenantPOS = this.obTaskTenantDAO.selectByTaskId(taskId);
                if (obTaskTenantPOS == null || obTaskTenantPOS.size() == 0) {
                    this.insertTaskTenant(taskId, reqBO.getTenantIds());
                } else {
                    ArrayList<Long> ids = new ArrayList<Long>();
                    for (ObTaskTenantPO taskTenantPO : obTaskTenantPOS) {
                        ids.add(taskTenantPO.getId());
                    }
                    this.obTaskTenantDAO.updateByIds(ids, TaskConstant.IS_DELETE_1);
                    this.insertTaskTenant(taskId, reqBO.getTenantIds());
                }
            }
            TaskRelationBO taskRelationBO = new TaskRelationBO();
            if (!StringUtils.isEmpty((Object)reqBO.getTemplateId())) {
                log.info("\u8c03\u7528\u63d2\u5165\u77ed\u4fe1\u6a21\u677f\u65b9\u6cd5");
                taskRelationBO = this.taskConfigRelationService.taskSmsTemplateRelation(new TaskRelationParamBO(taskId, reqBO.getTemplateId(), ""));
            }
            if (!addTaskInfoBO.getCallType().equals("2")) {
                if (reqBO.getQuickIds() != null && reqBO.getQuickIds().size() > 0) {
                    log.info("\u8c03\u7528\u63d2\u5165\u5e38\u7528\u8bed\u65b9\u6cd5");
                    TaskRelationParamsBO relationParamBO = new TaskRelationParamsBO("", new ArrayList(), "");
                    relationParamBO.setTaskId(taskId);
                    relationParamBO.setRelationParams(reqBO.getQuickIds());
                    relationParamBO.setQuickJosn(addTaskInfoBO.getQuickJson());
                    taskRelationBO = this.taskConfigRelationService.taskQuickRelation(relationParamBO);
                    if (taskRelationBO == null || !taskRelationBO.getStatus().equals(STATUS_0)) {
                        log.error(taskRelationBO.getMessage());
                        throw new RuntimeException(taskRelationBO.getMessage());
                    }
                }
            } else {
                this.taskConfigRelationService.taskRelationVoice(new TaskRelationParamBO(taskId, addTaskInfoBO.getVoiceId(), addTaskInfoBO.getVoiceName()));
            }
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        return BaseRspUtils.createSuccessRsp((Object)taskId);
    }

    private void insertTaskTenant(String taskId, List<String> tenantIds) {
        for (String tenantId : tenantIds) {
            ObTaskTenantPO taskTenantPO = new ObTaskTenantPO();
            taskTenantPO.setTaskId(taskId);
            taskTenantPO.setTenantId(tenantId);
            taskTenantPO.setDeleteFlag(TaskConstant.IS_DELETE_0);
            this.obTaskTenantDAO.insertSelective(taskTenantPO);
        }
    }

    private Rsp checkParam(AddTaskCombineServiceReqBO req) {
        AddTaskCombineServiceBO reqBO = req.getReqData();
        if (reqBO == null) {
            return BaseRspUtils.createErrorRsp((String)"\u5165\u53c2\u9519\u8bef");
        }
        AddTaskInfoBO addTaskInfoBO = reqBO.getAddTaskInfoBO();
        if (addTaskInfoBO == null) {
            return BaseRspUtils.createErrorRsp((String)"\u4efb\u52a1\u4e3b\u4f53\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)addTaskInfoBO.getTaskType())) {
            return BaseRspUtils.createErrorRsp((String)"\u8bf7\u9009\u62e9\u4efb\u52a1\u7c7b\u578b");
        }
        if ("grab".equals(addTaskInfoBO.getTaskType())) {
            if (reqBO.getTenantIds() == null || reqBO.getTenantIds().size() == 0) {
                return BaseRspUtils.createErrorRsp((String)"\u8bf7\u914d\u7f6e\u79df\u6237\uff01");
            }
        } else if (StringUtils.isEmpty((Object)req.getTenantCode())) {
            return BaseRspUtils.createErrorRsp((String)"\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)addTaskInfoBO.getTaskName())) {
            return BaseRspUtils.createErrorRsp((String)"\u8bf7\u8f93\u5165\u4efb\u52a1\u540d\u79f0");
        }
        if (StringUtils.isEmpty((Object)addTaskInfoBO.getStartTime()) || StringUtils.isEmpty((Object)addTaskInfoBO.getEndTime())) {
            return BaseRspUtils.createErrorRsp((String)"\u8bf7\u8f93\u5165\u4efb\u52a1\u5f00\u59cb\u65f6\u95f4\u4e0e\u7ed3\u675f\u65f6\u95f4");
        }
        if (StringUtils.isEmpty((Object)addTaskInfoBO.getCallType())) {
            return BaseRspUtils.createErrorRsp((String)"\u8bf7\u9009\u62e9\u5916\u547c\u65b9\u5f0f");
        }
        if (addTaskInfoBO.getCallType().equals(DELETE_FLAG_0)) {
            if (reqBO.getCallResultSets() == null || reqBO.getCallResultSets().size() == 0) {
                return BaseRspUtils.createErrorRsp((String)"\u8bf7\u9009\u62e9\u5916\u547c\u7ed3\u679c\u96c6");
            }
            if (StringUtils.isEmpty((Object)addTaskInfoBO.getSkillId())) {
                return BaseRspUtils.createErrorRsp((String)"\u8bf7\u9009\u62e9\u6280\u80fd\u7ec4");
            }
        }
        if (addTaskInfoBO.getCallType().equals(DELETE_FLAG_1)) {
            if (reqBO.getCallResultSets() == null || reqBO.getCallResultSets().size() == 0) {
                return BaseRspUtils.createErrorRsp((String)"\u8bf7\u9009\u62e9\u5916\u547c\u7ed3\u679c\u96c6");
            }
            if (StringUtils.isEmpty((Object)addTaskInfoBO.getAllotMode())) {
                return BaseRspUtils.createErrorRsp((String)"\u8bf7\u9009\u62e9\u5206\u914d\u65b9\u5f0f");
            }
        }
        if (addTaskInfoBO.getCallType().equals("2") && (StringUtils.isEmpty((Object)addTaskInfoBO.getVoiceId()) || StringUtils.isEmpty((Object)addTaskInfoBO.getVoiceName()))) {
            return BaseRspUtils.createErrorRsp((String)"\u8bf7\u9009\u62e9\u5916\u547c\u8bed\u97f3");
        }
        return BaseRspUtils.createSuccessRsp((Object)"");
    }

    public RspList<QueryTaskInfoListRspBO> queryTaskInfoList(QueryTaskInfoListReqBO req) {
        log.info("\u8fdb\u5165\u67e5\u8be2\u4efb\u52a1\u5217\u8868\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)req));
        long startTime = System.currentTimeMillis();
        List<Object> rspBOS = new ArrayList();
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Long count = 0L;
        try {
            QueryTaskInfoListBO reqBO = req.getReqData();
            if (reqBO == null) {
                return BaseRspUtils.createErrorRspList((String)"\u5165\u53c2\u9519\u8bef");
            }
            if (StringUtils.isEmpty((Object)reqBO.getStartTime())) {
                return BaseRspUtils.createErrorRspList((String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)reqBO.getEndTime())) {
                return BaseRspUtils.createErrorRspList((String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ArrayList tenantIds = reqBO.getTenantIds();
            if (tenantIds == null) {
                tenantIds = new ArrayList();
            }
            Req bladeReq = new Req();
            bladeReq.setRoleSet(req.getRoleSet());
            bladeReq.setReqData(tenantIds);
            bladeReq.setIn_tenantCode(req.getIn_tenantCode());
            bladeReq.setRoleSet(req.getRoleSet());
            List bladeTenants = this.bladeTenantInterService.getBalseTenantList(bladeReq);
            Map<String, String> tenantMap = null;
            if (null != bladeTenants && !bladeTenants.isEmpty()) {
                tenantIds.addAll(bladeTenants.stream().map(x -> x.getTenantId()).collect(Collectors.toList()));
                tenantMap = bladeTenants.stream().collect(Collectors.toMap(BladeTenantBO::getTenantId, BladeTenantBO::getTenantName));
            }
            ObTaskInfoPO obTaskInfoPO = new ObTaskInfoPO();
            obTaskInfoPO.setTaskName(reqBO.getTaskName());
            obTaskInfoPO.setStartTime(reqBO.getStartTime());
            obTaskInfoPO.setEndTime(reqBO.getEndTime());
            obTaskInfoPO.setTaskType(reqBO.getTaskType());
            obTaskInfoPO.setTaskStatus(reqBO.getTaskStatus());
            obTaskInfoPO.setAllotMode(reqBO.getAllotMode());
            obTaskInfoPO.setCallType(reqBO.getCallType());
            obTaskInfoPO.setTenantIds(tenantIds);
            obTaskInfoPO.setCreateTime(format.format(date));
            log.info("\u67e5\u8be2\u4efb\u52a1\u5217\u8868Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obTaskInfoPO));
            long taskListStartTime = System.currentTimeMillis();
            List obTaskInfoPOS = this.obTaskInfoDAO.selectTaskInfoList(obTaskInfoPO);
            long taskListEndTime = System.currentTimeMillis();
            log.info("\u67e5\u8be2\u4efb\u52a1\u5217\u8868\u8017\u65f6\uff1b{}\u79d2", (Object)((taskListEndTime - taskListStartTime) / 1000L));
            ObTaskTenantPO taskTenantPO = new ObTaskTenantPO();
            taskTenantPO.setTenantIds(tenantIds);
            taskTenantPO.setDeleteFlag(TaskConstant.IS_DELETE_0);
            List taskTenantPOS = this.obTaskTenantDAO.selectByTenantIds(taskTenantPO);
            log.info("\u67e5\u8be2\u4efb\u52a1-\u79df\u6237\u5173\u7cfb\u8868Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)taskTenantPOS));
            List<String> taskIds = new ArrayList<String>();
            if (taskTenantPOS != null && taskTenantPOS.size() > 0) {
                for (ObTaskTenantPO po : taskTenantPOS) {
                    taskIds.add(po.getTaskId());
                }
                taskIds = taskIds.stream().distinct().collect(Collectors.toList());
                obTaskInfoPO.setTaskIds(taskIds);
                log.info("\u67e5\u8be2\u62a2\u5355\u4efb\u52a1Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obTaskInfoPO));
                List taskInfoPOS = this.obTaskInfoDAO.selectByTaskIds(obTaskInfoPO);
                if (taskInfoPOS != null && taskInfoPOS.size() > 0) {
                    obTaskInfoPOS.addAll(taskInfoPOS);
                    obTaskInfoPOS = obTaskInfoPOS.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ObTaskInfoPO>(Comparator.comparing(ObTaskInfoPO::getTaskId))), ArrayList::new));
                }
            }
            long grabTaskEndTime = System.currentTimeMillis();
            log.info("\u67e5\u8be2\u62a2\u5355\u4efb\u52a1\u8017\u65f6\uff1b{}\u79d2", (Object)((grabTaskEndTime - taskListEndTime) / 1000L));
            if (obTaskInfoPOS != null && obTaskInfoPOS.size() > 0) {
                for (ObTaskInfoPO po : obTaskInfoPOS) {
                    QueryTaskInfoListRspBO queryTaskInfoListRspBO = new QueryTaskInfoListRspBO();
                    BeanUtils.copyProperties((Object)po, (Object)queryTaskInfoListRspBO);
                    if (null != tenantMap) {
                        queryTaskInfoListRspBO.setTenantName(tenantMap.get(po.getTenantId()));
                    }
                    if (StringUtils.isEmpty((Object)queryTaskInfoListRspBO.getTenantName())) {
                        BladeTenantBO tenantInfo = this.getTenantInfo(po.getTenantId());
                        if (null == tenantInfo) {
                            log.info("\u79df\u6237ID\uff1a{}\uff0c \u672a\u67e5\u8be2\u5230\u79df\u6237\u4fe1\u606f\uff0c\u8df3\u8fc7", (Object)po.getTenantId());
                            continue;
                        }
                        queryTaskInfoListRspBO.setTenantName(tenantInfo.getTenantName());
                    }
                    queryTaskInfoListRspBO.setTaskTypeName(TaskEnum.TASK_TYPE.getTaskTypeName(po.getTaskType()));
                    queryTaskInfoListRspBO.setTaskStatusName(TaskEnum.TASK_STATUS.getTaskStatusName(po.getTaskStatus()));
                    queryTaskInfoListRspBO.setCallTypeName(TaskEnum.CALL_TYPE.getCallTypeName(po.getCallType()));
                    queryTaskInfoListRspBO.setTaskSource(po.getTaskSource());
                    queryTaskInfoListRspBO.setCity(StringUtils.isEmpty((Object)AreaCache.getArea(po.getCity())) ? po.getCity() : AreaCache.getArea(po.getCity()));
                    queryTaskInfoListRspBO.setWaitingCount(String.valueOf(po.getDataNumber()));
                    queryTaskInfoListRspBO.setTaskStartTime(po.getStartTime());
                    queryTaskInfoListRspBO.setTaskEndTime(po.getEndTime());
                    if (!StringUtils.isEmpty((Object)po.getAllotMode())) {
                        queryTaskInfoListRspBO.setAllotModeName(TaskEnum.ALLOT_MODE.getAllotModeName(po.getAllotMode()));
                    }
                    rspBOS.add(queryTaskInfoListRspBO);
                }
                long taskDataEndTime = System.currentTimeMillis();
                log.info("\u5904\u7406\u4efb\u52a1\u6570\u636e\u8017\u65f6\uff1b{}\u79d2", (Object)((taskDataEndTime - grabTaskEndTime) / 1000L));
            }
            if (rspBOS != null && rspBOS.size() > 0) {
                Integer size = rspBOS.size();
                count = Long.parseLong(size.toString());
                rspBOS = rspBOS.stream().sorted(Comparator.comparing(QueryTaskInfoListRspBO::getCreateTime).reversed()).collect(Collectors.toList());
                rspBOS = rspBOS.stream().skip(req.getLimit() * (req.getPage() - 1)).limit(req.getLimit()).collect(Collectors.toList());
                for (QueryTaskInfoListRspBO queryTaskInfoListRspBO : rspBOS) {
                    BladeTenantBO tenantInfo1 = this.getTenantInfo(queryTaskInfoListRspBO.getTenantId());
                    if (null != tenantInfo1) continue;
                    log.info("\u67e5\u8be2\u79df\u6237{}\u5931\u8d25", (Object)queryTaskInfoListRspBO.getTenantId());
                }
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            return BaseRspUtils.createErrorRspList((String)e.getMessage());
        }
        long endTime = System.currentTimeMillis();
        log.info("\u67e5\u8be2\u4efb\u52a1\u5217\u8868\u8017\u65f6\uff1b{}\u79d2", (Object)((endTime - startTime) / 1000L));
        return BaseRspUtils.createSuccessRspList(rspBOS, (long)count);
    }

    public Rsp<QueryTaskInfoRspBO> queryTaskInfo(QueryTaskInfoReqBO req) {
        log.info("\u8fdb\u5165\u67e5\u8be2\u4efb\u52a1\u8be6\u60c5\u63a5\u53e3\uff0c \u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)req));
        QueryTaskInfoRspBO queryTaskInfoRspBO = new QueryTaskInfoRspBO();
        try {
            QueryTaskInfoBO reqBO = req.getReqData();
            if (reqBO == null) {
                return BaseRspUtils.createErrorRsp((String)"\u5165\u53c2\u9519\u8bef");
            }
            if (StringUtils.isEmpty((Object)reqBO.getTaskId())) {
                return BaseRspUtils.createErrorRsp((String)"\u4efb\u52a1ID\u4e3a\u7a7a");
            }
            String tenantId = req.getTenantCode();
            if (StringUtils.isEmpty((Object)tenantId)) {
                if (StringUtils.isEmpty((Object)reqBO.getTenantId())) {
                    return BaseRspUtils.createErrorRsp((String)"\u79df\u6237\u7f16\u7801\u4e3a\u7a7a");
                }
                tenantId = reqBO.getTenantId();
            }
            ObTaskInfoPO obTaskInfoPO = new ObTaskInfoPO();
            obTaskInfoPO.setTaskId(reqBO.getTaskId());
            log.info("\u67e5\u8be2\u4efb\u52a1\u8be6\u60c5Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obTaskInfoPO));
            ObTaskInfoPO po = this.obTaskInfoDAO.selectTaskInfo(obTaskInfoPO);
            log.info("\u67e5\u8be2\u4efb\u52a1\u8be6\u60c5Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)po));
            if (po != null) {
                QueryTaskVoiceRspBO rspBO;
                Rsp groupInfo;
                BeanUtils.copyProperties((Object)po, (Object)queryTaskInfoRspBO);
                queryTaskInfoRspBO.setMaxCallNum(po.getMaxCallNum());
                queryTaskInfoRspBO.setCalling(po.getCalling());
                queryTaskInfoRspBO.setTaskTypeName(TaskEnum.TASK_TYPE.getTaskTypeName(po.getTaskType()));
                queryTaskInfoRspBO.setCallTypeName(TaskEnum.CALL_TYPE.getCallTypeName(po.getCallType()));
                queryTaskInfoRspBO.setAllotModeName(TaskEnum.ALLOT_MODE.getAllotModeName(po.getAllotMode()));
                queryTaskInfoRspBO.setProductId(po.getProductId());
                queryTaskInfoRspBO.setProductName(po.getProductName());
                if ("grab".equals(po.getTaskType())) {
                    ArrayList<String> tenantIds = new ArrayList<String>();
                    ArrayList<String> tenantIdsStr = new ArrayList<String>();
                    List taskTenantPOS = this.obTaskTenantDAO.selectByTaskId(po.getTaskId());
                    log.info("\u83b7\u53d6\u62a2\u5355\u4efb\u52a1\u5173\u8054\u79df\u6237Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)taskTenantPOS));
                    if (taskTenantPOS != null && taskTenantPOS.size() > 0) {
                        for (ObTaskTenantPO taskTenantPO : taskTenantPOS) {
                            tenantIds.add(taskTenantPO.getTenantId());
                            BladeTenantBO tenantInfo = this.getTenantInfo(taskTenantPO.getTenantId());
                            tenantIdsStr.add(tenantInfo.getTenantName());
                        }
                        queryTaskInfoRspBO.setTenantIds(tenantIds);
                        queryTaskInfoRspBO.setTenantIdsStr(tenantIdsStr);
                    }
                }
                if (!StringUtils.isEmpty((Object)po.getSkillId()) && (groupInfo = this.skillGroupInterService.getSkillGroupInfo(po.getSkillId(), po.getTenantId())).getRspCode().equals("0000")) {
                    DcSkillGroupInfoBO infoBO = (DcSkillGroupInfoBO)groupInfo.getData();
                    queryTaskInfoRspBO.setSkillGroupCode(infoBO.getSkillGroupCode());
                }
                QueryTaskSmsTemplateRspBO rsp = this.taskConfigRelationService.queryTaskSmsTemplate(po.getTaskId());
                log.info("\u83b7\u53d6\u77ed\u4fe1\u6a21\u677fID\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)rsp));
                if (rsp != null) {
                    queryTaskInfoRspBO.setTemplateId(rsp.getTemplateId());
                    if (!StringUtils.isEmpty((Object)rsp.getTemplateId()) && (rspBO = this.dcSmsTemplateService.querySmsTemplate(rsp.getTemplateId())) != null) {
                        queryTaskInfoRspBO.setTemplateName(rspBO.getTemplateName());
                    }
                }
                if (!po.getCallType().equals("2")) {
                    if (!StringUtils.isEmpty((Object)po.getCallResultSet())) {
                        List callResultSet = JSONObject.parseArray((String)po.getCallResultSet(), String.class);
                        queryTaskInfoRspBO.setCallResultSets(callResultSet);
                    }
                    List rspBOS = this.taskConfigRelationService.queryTaskQuick(po.getTaskId());
                    log.info("\u83b7\u53d6\u5e38\u7528\u8bedID\u96c6\u5408\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)rspBOS));
                    if (rspBOS != null && rspBOS.size() > 0) {
                        ArrayList<String> ids = new ArrayList<String>();
                        ArrayList<String> names = new ArrayList<String>();
                        for (QueryTaskQuickRspBO bo : rspBOS) {
                            ids.add(bo.getQuickId());
                            names.add(bo.getQuickName());
                        }
                        queryTaskInfoRspBO.setQuickIds(ids);
                        if (names != null && names.size() > 0) {
                            queryTaskInfoRspBO.setQuickName(String.join((CharSequence)",", names));
                        }
                        queryTaskInfoRspBO.setQuickJson(((QueryTaskQuickRspBO)rspBOS.get(0)).getQuickJson());
                    }
                } else {
                    rspBO = this.taskConfigRelationService.queryTaskVoice(po.getTaskId());
                    if (rspBO != null) {
                        queryTaskInfoRspBO.setVoiceId(rspBO.getVoiceId());
                        queryTaskInfoRspBO.setVoiceName(rspBO.getVoiceName());
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
        return BaseRspUtils.createSuccessRsp((Object)queryTaskInfoRspBO);
    }

    public AddTaskInfoRspBO addTaskInfo(AddTaskInfoBO addTaskInfoBO) {
        AddTaskInfoRspBO rspBO = new AddTaskInfoRspBO();
        log.info("\u8fdb\u5165\u65b0\u589e\u4efb\u52a1\u4e3b\u4f53\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)addTaskInfoBO));
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        BladeTenantBO tenantInfo = this.getTenantInfo(addTaskInfoBO.getTenantId());
        log.info("\u83b7\u53d6\u79df\u6237\u4fe1\u606f\u63a5\u53e3\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)tenantInfo));
        ObTaskInfoPO obTaskInfoPO = new ObTaskInfoPO();
        obTaskInfoPO.setTaskId(addTaskInfoBO.getTaskId());
        obTaskInfoPO.setTaskName(addTaskInfoBO.getTaskName());
        obTaskInfoPO.setTaskType(addTaskInfoBO.getTaskType());
        obTaskInfoPO.setTaskStatus("waiting");
        obTaskInfoPO.setCity(addTaskInfoBO.getCity());
        obTaskInfoPO.setStartTime(addTaskInfoBO.getStartTime());
        obTaskInfoPO.setEndTime(addTaskInfoBO.getEndTime());
        obTaskInfoPO.setGrabTimeLimit(addTaskInfoBO.getGrabTimeLimit());
        obTaskInfoPO.setTotalUserLimit(addTaskInfoBO.getTotalUserLimit());
        obTaskInfoPO.setPrice(addTaskInfoBO.getPrice());
        obTaskInfoPO.setMaxCallNum(addTaskInfoBO.getMaxCallNum());
        obTaskInfoPO.setAllotMode(addTaskInfoBO.getAllotMode());
        obTaskInfoPO.setTenantId(addTaskInfoBO.getTenantId());
        obTaskInfoPO.setTenantSortCode(tenantInfo.getTenantOtherName());
        obTaskInfoPO.setIsIndex(addTaskInfoBO.getIsIndex());
        obTaskInfoPO.setIcon(addTaskInfoBO.getIcon());
        obTaskInfoPO.setCallType(addTaskInfoBO.getCallType());
        obTaskInfoPO.setDataTaskId(addTaskInfoBO.getDataTaskId());
        obTaskInfoPO.setVoiceUrl(addTaskInfoBO.getVoiceUrl());
        if (DELETE_FLAG_0.equals(addTaskInfoBO.getCallType())) {
            obTaskInfoPO.setSkillId(addTaskInfoBO.getSkillId());
        }
        obTaskInfoPO.setCalling(addTaskInfoBO.getCalling());
        obTaskInfoPO.setDeleteFlag(DELETE_FLAG_0);
        obTaskInfoPO.setCallHide(addTaskInfoBO.getCallHide());
        obTaskInfoPO.setCallResultSet(addTaskInfoBO.getCallResultSet());
        obTaskInfoPO.setTenantSortCode(addTaskInfoBO.getTenantSortCode());
        obTaskInfoPO.setProductId(addTaskInfoBO.getProductId());
        obTaskInfoPO.setProductName(addTaskInfoBO.getProductName());
        obTaskInfoPO.setTaskSource(StringUtils.isEmpty((Object)addTaskInfoBO.getTaskSource()) ? null : addTaskInfoBO.getTaskSource());
        int num = 0;
        if (addTaskInfoBO.getPortFlag() == 0) {
            obTaskInfoPO.setCreateTime(format.format(new Date()));
            log.info("\u65b0\u589e\u4efb\u52a1\u4e3b\u4f53Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obTaskInfoPO));
            num = this.obTaskInfoDAO.insertSelective(obTaskInfoPO);
            try {
                if (addTaskInfoBO.isCreateIsv()) {
                    this.isvTaskProxyService.createIsvTask(addTaskInfoBO.getTaskId(), addTaskInfoBO.getTenantId());
                }
            }
            catch (Exception e) {
                log.error("\u8c03\u7528isv\u4efb\u52a1\u521b\u5efa\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            }
            rspBO.setMessage(obTaskInfoPO.getTaskId());
        } else {
            log.info("\u4fee\u6539\u4efb\u52a1\u4e3b\u4f53Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obTaskInfoPO));
            this.obTaskInfoDAO.updateTaskInfo(obTaskInfoPO);
            try {
                this.isvTaskProxyService.updateIsvTask(addTaskInfoBO.getTaskId(), addTaskInfoBO.getTenantId());
            }
            catch (Exception e) {
                log.error("\u8c03\u7528isv\u4efb\u52a1\u4fee\u6539\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            }
        }
        rspBO.setStatus(STATUS_0);
        rspBO.setMessage(SUCCESS_MESSAGE);
        return rspBO;
    }

    @Transactional(rollbackFor={Exception.class})
    public UpdateTaskRspBO updateTask(UpdateTaskReqBO reqBO) throws Exception {
        UpdateTaskRspBO rspBO;
        block28: {
            log.info("\u8fdb\u5165\u4fee\u6539\u4efb\u52a1\u72b6\u6001\u63a5\u53e3\uff0c \u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
            rspBO = new UpdateTaskRspBO();
            Date date = new Date();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                if (StringUtils.isEmpty((Object)reqBO.getTenantCode())) {
                    rspBO.setRspCode("8888");
                    rspBO.setRspDesc("\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    return rspBO;
                }
                if (StringUtils.isEmpty((Object)reqBO.getTaskId())) {
                    rspBO.setRspCode("8888");
                    rspBO.setRspDesc("\u4efb\u52a1Id\u4e0d\u80fd\u4e3a\u7a7a");
                    return rspBO;
                }
                if (reqBO.getPortFlag() == null) {
                    rspBO.setRspCode("8888");
                    rspBO.setRspDesc("\u63a5\u53e3\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
                    return rspBO;
                }
                ObTaskInfoPO obTaskInfoPO = new ObTaskInfoPO();
                obTaskInfoPO.setTenantId(reqBO.getTenantCode());
                obTaskInfoPO.setTaskId(reqBO.getTaskId());
                ObTaskInfoPO taskInfoPO = this.obTaskInfoDAO.selectTaskInfo(obTaskInfoPO);
                log.info("\u6839\u636e\u79df\u6237\u7f16\u7801\u4e0e\u4efb\u52a1ID\u67e5\u8be2Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)taskInfoPO));
                if (taskInfoPO == null) {
                    rspBO.setRspCode("8888");
                    rspBO.setRspDesc("\u5165\u53c2\u9519\u8bef");
                    return rspBO;
                }
                if (reqBO.getPortFlag() == 0) {
                    if (StringUtils.isEmpty((Object)reqBO.getTaskStatus())) {
                        rspBO.setRspCode("8888");
                        rspBO.setRspDesc("\u4efb\u52a1\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
                        return rspBO;
                    }
                    if (reqBO.getTaskStatus().equals("running")) {
                        Date endTime = format.parse(taskInfoPO.getEndTime());
                        if (date.getTime() > endTime.getTime()) {
                            rspBO.setRspCode("8888");
                            rspBO.setRspDesc("\u5f53\u524d\u4efb\u52a1\u5df2\u7ed3\u675f\uff01");
                            return rspBO;
                        }
                        if (!taskInfoPO.getCallType().equals("2")) {
                            ObTaskInfoPO infoPO = new ObTaskInfoPO();
                            infoPO.setTenantId(reqBO.getTenantCode());
                            infoPO.setSkillId(taskInfoPO.getSkillId());
                            infoPO.setTaskStatus("running");
                            ObTaskInfoPO info = this.obTaskInfoDAO.selectBySkillId(infoPO);
                            log.info("\u6839\u636e\u6280\u80fd\u7ec4ID\u67e5\u8be2Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)info));
                            if (info != null) {
                                rspBO.setRspCode("8888");
                                rspBO.setRspDesc("\u5f53\u524d\u4efb\u52a1\u6240\u7ed1\u5b9a\u6280\u80fd\u7ec4\u5df2\u7ed1\u5b9a\u5176\u4ed6\u6b63\u5728\u542f\u52a8\u7684\u4efb\u52a1\uff0c\u65e0\u6cd5\u542f\u52a8\uff01");
                                return rspBO;
                            }
                        }
                        if (taskInfoPO.getCallType().equals(DELETE_FLAG_0)) {
                            QryTacticsReqBO tacticsReqBO = new QryTacticsReqBO();
                            tacticsReqBO.setTaskId(taskInfoPO.getTaskId());
                            tacticsReqBO.setTenantCode(taskInfoPO.getTenantId());
                            RspList rspList = this.taskTacticsService.qryTactics(tacticsReqBO);
                            if (rspList.getRows() == null || rspList.getRows().size() == 0) {
                                rspBO.setRspCode("8888");
                                rspBO.setRspDesc("\u5f53\u524d\u4efb\u52a1\u672a\u914d\u7f6e\u4efb\u52a1\u7b56\u7565\uff0c\u8bf7\u5b8c\u6210\u914d\u7f6e\u540e\u518d\u6b21\u64cd\u4f5c\uff01");
                                return rspBO;
                            }
                        }
                        if (!"2".equals(taskInfoPO.getCallType()) && !"grab".equals(taskInfoPO.getTaskType())) {
                            QueryTaskUserReqBO userReqBO = new QueryTaskUserReqBO();
                            userReqBO.setTaskId(taskInfoPO.getTaskId());
                            userReqBO.setCallType(taskInfoPO.getCallType());
                            userReqBO.setAllotType(Integer.valueOf(999));
                            userReqBO.setTenantCode(reqBO.getTenantCode());
                            RspList taskUserList = this.taskConfigRelationService.queryTaskUser(userReqBO);
                            if (taskUserList.getRows() == null || taskUserList.getRows().size() == 0) {
                                rspBO.setRspCode("8888");
                                rspBO.setRspDesc("\u5f53\u524d\u4efb\u52a1\u672a\u7ed1\u5b9a\u4eba\u5458\uff0c\u8bf7\u5b8c\u6210\u914d\u7f6e\u540e\u518d\u6b21\u64cd\u4f5c\uff01");
                                return rspBO;
                            }
                        }
                        QueryTaskDataTargetReqBO dataTargetReqBO = new QueryTaskDataTargetReqBO();
                        dataTargetReqBO.setTenantCode(taskInfoPO.getTenantId());
                        dataTargetReqBO.setTaskId(taskInfoPO.getTaskId());
                        dataTargetReqBO.setIsBind(TaskConstant.IS_BIND_0);
                        RspList boRspList = this.taskDataTargetService.queryTaskDataTarget(dataTargetReqBO);
                        if (boRspList.getRows() == null || boRspList.getRows().size() == 0) {
                            rspBO.setRspCode("8888");
                            rspBO.setRspDesc("\u5f53\u524d\u4efb\u52a1\u672a\u7ed1\u5b9a\u4efb\u52a1\u6570\u636e\uff0c\u8bf7\u5b8c\u6210\u914d\u7f6e\u540e\u518d\u6b21\u64cd\u4f5c\uff01");
                            return rspBO;
                        }
                    }
                    obTaskInfoPO.setTaskStatus(reqBO.getTaskStatus());
                } else {
                    if (taskInfoPO.getTaskStatus().equals("running")) {
                        rspBO.setRspCode("8888");
                        rspBO.setRspDesc("\u5f53\u524d\u4efb\u52a1\u6b63\u5728\u8fd0\u884c\u4e2d\uff0c\u8bf7\u6682\u505c\u4efb\u52a1\u540e\u518d\u6b21\u64cd\u4f5c\uff01");
                        return rspBO;
                    }
                    obTaskInfoPO.setDeleteFlag(DELETE_FLAG_1);
                }
                log.info("\u4fee\u6539\u4efb\u52a1\u72b6\u6001Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obTaskInfoPO));
                int updNum = this.obTaskInfoDAO.updateTaskInfo(obTaskInfoPO);
                if (updNum == 0) {
                    rspBO.setRspCode("8888");
                    rspBO.setRspDesc("\u4fee\u6539\u5931\u8d25");
                    return rspBO;
                }
                if (reqBO.getPortFlag() == 0) {
                    try {
                        if ("running".equals(reqBO.getTaskStatus())) {
                            this.isvTaskProxyService.startIsvTask(reqBO.getTaskId(), reqBO.getTenantCode());
                        } else if ("waiting".equals(reqBO.getTaskStatus()) || "suspend".equals(reqBO.getTaskStatus())) {
                            this.isvTaskProxyService.stopIsvTask(reqBO.getTaskId(), reqBO.getTenantCode());
                        } else if ("finish".equals(reqBO.getTaskStatus())) {
                            this.isvTaskProxyService.endIsvTask(reqBO.getTaskId(), reqBO.getTenantCode());
                        }
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                        TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                        throw e;
                    }
                }
                rspBO.setRspCode("0000");
                rspBO.setRspDesc("\u4e1a\u52a1\u5904\u7406\u6210\u529f");
            }
            catch (Exception e) {
                log.error("\u4fee\u6539\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
                rspBO.setRspCode("8888");
                rspBO.setRspDesc("\u4fee\u6539\u4efb\u52a1\u72b6\u6001\u5931\u8d25");
                if (!(e instanceof OcsException)) break block28;
                rspBO.setRspDesc(e.getMessage());
            }
        }
        return rspBO;
    }

    public TaskInfoBO qryTaskInfoByDataTaskID(String dataTaskID) {
        if (StringUtils.isEmpty((Object)dataTaskID)) {
            return null;
        }
        ObTaskInfoPO obTaskInfo = this.obTaskInfoDAO.selectByDataTaskID(dataTaskID);
        if (null == obTaskInfo) {
            return null;
        }
        TaskInfoBO taskInfo = new TaskInfoBO();
        BeanUtils.copyProperties((Object)obTaskInfo, (Object)taskInfo);
        return taskInfo;
    }

    public void addChildTask(ChildTaskBO childTask) {
        if (null == childTask) {
            return;
        }
        ObIvrTaskPO ivrTask = new ObIvrTaskPO();
        ivrTask.setCreateParam(childTask.getCreateParam());
        ivrTask.setIvrListId(childTask.getIvrListId());
        ivrTask.setIvrTaskId(childTask.getIvrTaskId());
        ivrTask.setTenantCode(childTask.getTenantCode());
        ivrTask.setTaskId(childTask.getTaskId());
        this.ivrTaskDAO.insertSelective(ivrTask);
        ivrTask.getId();
    }

    public List<TaskInfoBO> qryTaskInfoBy(TaskInfoBO taskInfo) {
        ArrayList<TaskInfoBO> res = new ArrayList<TaskInfoBO>();
        if (null == taskInfo) {
            return res;
        }
        ObTaskInfoPO selectPO = new ObTaskInfoPO();
        selectPO.setUploadSign(DELETE_FLAG_0);
        selectPO.setTaskId(taskInfo.getTaskId());
        selectPO.setDataTaskId(taskInfo.getDataTaskId());
        selectPO.setCurrentTime(taskInfo.getEffTimeNode());
        List taskInfos = this.obTaskInfoDAO.selectToUploadTask(selectPO, taskInfo.getTenantIdList());
        if (null == taskInfos || taskInfos.isEmpty()) {
            return res;
        }
        for (ObTaskInfoPO info : taskInfos) {
            TaskInfoBO taskInfoBO = new TaskInfoBO();
            BeanUtils.copyProperties((Object)info, (Object)taskInfoBO);
            taskInfoBO.setVoiceUrl(info.getVoiceUrl());
            taskInfoBO.setEffTimeNode(taskInfo.getEffTimeNode());
            res.add(taskInfoBO);
        }
        return res;
    }

    public TaskInfoBO queryTaskInfoByTaskID(String taskId) {
        if (StringUtils.isEmpty((Object)taskId)) {
            return null;
        }
        ObTaskInfoPO obTaskInfo = this.obTaskInfoDAO.selectByPrimaryKey(taskId);
        if (null == obTaskInfo) {
            return null;
        }
        TaskInfoBO taskInfo = new TaskInfoBO();
        BeanUtils.copyProperties((Object)obTaskInfo, (Object)taskInfo);
        return taskInfo;
    }

    public RspList getTaskDetail(GetTaskDataReqBO reqBO) {
        log.info("\u8fdb\u5165\u83b7\u53d6\u4efb\u52a1\u660e\u7ec6\u63a5\u53e3\uff0c \u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)reqBO));
        List<Object> rspBOS = new ArrayList();
        Integer count = 0;
        try {
            if (StringUtils.isEmpty((Object)reqBO.getTenantCode())) {
                return BaseRspUtils.createErrorRspList((String)"\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            LoginInfo loginInfo = reqBO.getLoginInfo();
            if (loginInfo == null) {
                return BaseRspUtils.createErrorRspList((String)"\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)reqBO.getTaskId())) {
                return BaseRspUtils.createErrorRspList((String)"\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (reqBO.getAllotType() == null) {
                return BaseRspUtils.createErrorRspList((String)"\u5206\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ObTaskInfoPO obTaskInfoPO = this.obTaskInfoDAO.selectByPrimaryKey(reqBO.getTaskId());
            log.info("\u6839\u636e\u4efb\u52a1ID\u67e5\u8be2Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obTaskInfoPO));
            if (null == obTaskInfoPO) {
                return BaseRspUtils.createErrorRspList((String)"\u672a\u67e5\u8be2\u5230\u4efb\u52a1\u4fe1\u606f");
            }
            if (!"running".equals(obTaskInfoPO.getTaskStatus())) {
                return BaseRspUtils.createErrorRspList((String)"\u5f53\u524d\u4efb\u52a1\u5df2\u6682\u505c\u6216\u5df2\u7ed3\u675f");
            }
            String objId = loginInfo.getUserId();
            if (reqBO.getAllotType() == TaskConstant.ALLOT_TYPE_1) {
                BladeUserBO userBO = this.bladeUserInterService.queryUserInfo(loginInfo.getUserId());
                if (userBO == null) {
                    return BaseRspUtils.createErrorRspList((String)"\u5f53\u524d\u5750\u5e2d\u4fe1\u606f\u6709\u8bef");
                }
                objId = userBO.getDeptId();
            }
            ArrayList<String> dataIds = new ArrayList<String>();
            List<Object> allotBOS = new ArrayList();
            if (TaskConstant.ALLOT_TYPE_2.equals(reqBO.getAllotType())) {
                log.info("\u5f53\u524d\u5206\u5355\u6a21\u5f0f\u4e3a\u81ea\u52a8\u5206\u5355");
                allotBOS = this.getAllotBO(reqBO.getTaskId(), "", reqBO.getAllotType(), reqBO.getTenantCode());
                if (allotBOS != null && allotBOS.size() > 0) {
                    for (ObTaskAllotBO obTaskAllotBO : allotBOS) {
                        dataIds.add(obTaskAllotBO.getDataId());
                    }
                }
            } else {
                allotBOS = this.getAllotBO(reqBO.getTaskId(), objId, reqBO.getAllotType(), reqBO.getTenantCode());
                if (allotBOS != null && allotBOS.size() > 0) {
                    for (ObTaskAllotBO obTaskAllotBO : allotBOS) {
                        dataIds.add(obTaskAllotBO.getDataId());
                    }
                }
            }
            if (dataIds != null && dataIds.size() > 0) {
                BladeTenantBO tenantInfo = this.getTenantInfo(reqBO.getTenantCode());
                if (tenantInfo == null) {
                    return BaseRspUtils.createErrorRspList((String)"\u5f53\u524d\u79df\u6237\u7f16\u7801\u6709\u8bef");
                }
                ObDataTargetPO obDataTargetPO = new ObDataTargetPO();
                obDataTargetPO.setDataIds(dataIds);
                obDataTargetPO.setTenantId(reqBO.getTenantCode());
                obDataTargetPO.setTenantOtherName(tenantInfo.getTenantOtherName());
                obDataTargetPO.setDataStatus("assigned");
                log.info("\u83b7\u53d6\u4efb\u52a1\u6570\u636eMapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obDataTargetPO));
                List targetPOS = this.obDataTargetDAO.getDataInfo(obDataTargetPO);
                log.info("\u83b7\u53d6\u4efb\u52a1\u6570\u636eMapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)targetPOS));
                if (targetPOS != null && targetPOS.size() > 0) {
                    for (ObDataTargetPO targetPO : targetPOS) {
                        QueryTaskDataTargetRspBO rspBO = new QueryTaskDataTargetRspBO();
                        BeanUtils.copyProperties((Object)targetPO, (Object)rspBO);
                        rspBOS.add(rspBO);
                    }
                }
            }
            count = rspBOS.size();
            rspBOS = rspBOS.stream().skip(reqBO.getLimit() * (reqBO.getPage() - 1)).limit(reqBO.getLimit()).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            return BaseRspUtils.createErrorRspList((String)("\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage()));
        }
        return BaseRspUtils.createSuccessRspList(rspBOS, (long)count.intValue());
    }

    private List<ObTaskAllotBO> getAllotBO(String taskId, String objId, Integer allotType, String tenantId) {
        log.info("\u5f00\u59cb\u83b7\u53d6\u5206\u5355\u4fe1\u606f");
        ArrayList<ObTaskAllotBO> allotBOS = new ArrayList<ObTaskAllotBO>();
        ObTaskAllotPO obTaskAllotPO = new ObTaskAllotPO();
        obTaskAllotPO.setTenantId(tenantId);
        obTaskAllotPO.setTaskId(taskId);
        obTaskAllotPO.setAllotType(allotType);
        if (TaskConstant.ALLOT_TYPE_0.equals(allotType)) {
            obTaskAllotPO.setUserId(objId);
        } else if (TaskConstant.ALLOT_TYPE_1.equals(allotType)) {
            obTaskAllotPO.setDeptId(objId);
        }
        log.info("\u83b7\u53d6\u5206\u5355\u4fe1\u606fMapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)obTaskAllotPO));
        List obTaskAllotPOS = this.obTaskAllotDAO.selectByTaskId(obTaskAllotPO);
        if (obTaskAllotPOS != null && obTaskAllotPOS.size() > 0) {
            for (ObTaskAllotPO allotPO : obTaskAllotPOS) {
                ObTaskAllotBO allotBO = new ObTaskAllotBO();
                BeanUtils.copyProperties((Object)allotPO, (Object)allotBO);
                allotBOS.add(allotBO);
            }
        }
        return allotBOS;
    }

    private BladeTenantBO getTenantInfo(String tenantId) {
        if (!StringUtils.isEmpty((Object)tenantMap.get(tenantId))) {
            return tenantMap.get(tenantId);
        }
        GetBladeTenantInfoReqBO infoReqBO = new GetBladeTenantInfoReqBO();
        infoReqBO.setTenantCode(tenantId);
        GetBladeTenantInfoRspBO bladeTenantInfo = this.bladeTenantInterService.getBladeTenantInfo(infoReqBO);
        BladeTenantBO bladeTenantBO = new BladeTenantBO();
        if (bladeTenantInfo.getRspCode().equals("0000")) {
            bladeTenantBO = (BladeTenantBO)bladeTenantInfo.getData();
        }
        return bladeTenantBO;
    }

    public ChildTaskBO getChildTask(String taskID, String tenantID) {
        ObIvrTaskPO ivrTask = this.ivrTaskDAO.qryChildTask(taskID, tenantID);
        if (ivrTask == null) {
            return null;
        }
        ChildTaskBO childTask = new ChildTaskBO();
        BeanUtils.copyProperties((Object)ivrTask, (Object)childTask);
        return childTask;
    }

    public int updateTaskTenantSortCode(String taskId, String tenantOtherName) {
        return this.obTaskInfoDAO.updateTaskTenantSortCode(taskId, tenantOtherName);
    }

    public int updateTaskSignOnUpload(TaskInfoBO taskInfo) {
        String taskId = taskInfo.getTaskId();
        String uploadSign = taskInfo.getUploadSign();
        if (StringUtils.isEmpty((Object)taskId) || StringUtils.isEmpty((Object)uploadSign)) {
            return 0;
        }
        String newUploadSign = DELETE_FLAG_1;
        taskInfo.setUploadSign(newUploadSign);
        return this.obTaskInfoDAO.updateTaskSignOnUpload(taskId, uploadSign, newUploadSign);
    }

    public int updateTaskSignOnUploaded(TaskInfoBO taskInfo) {
        String taskId = taskInfo.getTaskId();
        String uploadSign = taskInfo.getUploadSign();
        if (StringUtils.isEmpty((Object)taskId) || StringUtils.isEmpty((Object)uploadSign)) {
            return 0;
        }
        String newUploadSign = DELETE_FLAG_0;
        taskInfo.setUploadSign(newUploadSign);
        return this.obTaskInfoDAO.updateTaskSignOnUpload(taskId, uploadSign, newUploadSign);
    }

    public Rsp testCall(TestCallReqBO reqBO) {
        Rsp rsp = new Rsp();
        try {
            rsp.setRspCode("0000");
            rsp.setRspDesc("\u4e1a\u52a1\u5904\u7406\u6210\u529f");
            String tenantID = reqBO.getTenantCode();
            String taskID = reqBO.getTaskId();
            String called = reqBO.getCalled();
            if (StringUtils.isEmpty((Object)taskID) || StringUtils.isEmpty((Object)tenantID) || StringUtils.isEmpty((Object)called)) {
                rsp.setRspCode("8888");
                rsp.setRspDesc("\u79df\u6237\u7f16\u7801\u3001\u4efb\u52a1ID\u3001\u88ab\u53eb\u53f7\u7801\u5747\u4e0d\u80fd\u4e3a\u7a7a");
                return rsp;
            }
            TaskInfoBO taskInfoBO = this.getTaskInfo(taskID, tenantID);
            if (!CallTaskStatus.waiting.name().equals(taskInfoBO.getTaskStatus()) && !CallTaskStatus.running.name().equals(taskInfoBO.getTaskStatus())) {
                rsp.setRspCode("8888");
                rsp.setRspDesc("\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u5b8c\u6210\u8bd5\u547c");
                return rsp;
            }
            this.isvTaskProxyService.testCall(taskID, tenantID, called, taskInfoBO);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            rsp.setRspCode("8888");
            rsp.setRspDesc("\u8bd5\u547c\u5931\u8d25");
        }
        return rsp;
    }

    public RspList getTaskDetailInter(GetTaskDataReqBO reqBO) {
        List rows;
        log.info("getTaskDetailInter\u63a5\u53e3\u5165\u53c2={}", (Object)JSONObject.toJSONString((Object)reqBO));
        RspList taskDetail = this.getTaskDetail(reqBO);
        if (null != taskDetail && null != (rows = taskDetail.getRows()) && rows.size() > 0) {
            if (TaskConstant.ALLOT_TYPE_0.equals(reqBO.getAllotType())) {
                return BaseRspUtils.createSuccessRspList((List)rows, (long)taskDetail.getCount());
            }
            ArrayList tt = new ArrayList();
            tt.add(rows.get(0));
            return BaseRspUtils.createSuccessRspList(tt, (long)tt.size());
        }
        return BaseRspUtils.createErrorRspList((String)"\u67e5\u8be2\u5931\u8d25");
    }

    public void addTaskTenant(String taskId, List<String> tenantIds) {
        if (null == tenantIds || tenantIds.size() < 1) {
            return;
        }
        if (StringUtils.isEmpty((Object)taskId)) {
            return;
        }
        for (String tenantId : tenantIds) {
            if (StringUtils.isEmpty((Object)tenantId)) continue;
            ObTaskTenantPO tenantPO = new ObTaskTenantPO();
            tenantPO.setTaskId(taskId);
            tenantPO.setTenantId(tenantId);
            this.obTaskTenantDAO.insertSelective(tenantPO);
        }
    }

    public List<TaskInfoBO> getTaskInfo(String tenantId) {
        log.info("\u79df\u6237ID:{}, \u5f00\u59cb\u83b7\u53d6\u6240\u6709\u6709\u6548\u4efb\u52a1\u4fe1\u606f", (Object)tenantId);
        List taskInfoPOS = this.obTaskInfoDAO.selectByTenantId(tenantId);
        log.info("\u83b7\u53d6\u4efb\u52a1\u4fe1\u606f\u96c6\u5408Mapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)taskInfoPOS));
        ArrayList<TaskInfoBO> bos = new ArrayList<TaskInfoBO>();
        if (null != taskInfoPOS && taskInfoPOS.size() > 0) {
            for (ObTaskInfoPO po : taskInfoPOS) {
                TaskInfoBO infoBO = new TaskInfoBO();
                BeanUtils.copyProperties((Object)po, (Object)infoBO);
                bos.add(infoBO);
            }
        }
        return bos;
    }

    public RspList getGrabTenantList(String taskId) {
        log.info("\u5f00\u59cb\u83b7\u53d6\u62a2\u5355\u4efb\u52a1\u4e0b\u6709\u6743\u9650\u7684\u79df\u6237\u4fe1\u606f\uff0c taskId\uff1a{}", (Object)taskId);
        ArrayList<TenantBO> tenantBOS = new ArrayList<TenantBO>();
        try {
            List taskTenantPOS = this.obTaskTenantDAO.selectByTaskId(taskId);
            log.info("\u83b7\u53d6\u62a2\u5355\u4efb\u52a1\u5173\u8054\u79df\u6237\u4fe1\u606fMapper\u5c42\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)taskTenantPOS));
            if (null != taskTenantPOS && taskTenantPOS.size() > 0) {
                for (ObTaskTenantPO tenantPO : taskTenantPOS) {
                    TenantBO tenantBO = new TenantBO();
                    BladeTenantBO tenantInfo = this.getTenantInfo(tenantPO.getTenantId());
                    if (null == tenantInfo) {
                        log.info("\u5f53\u524d\u79df\u6237ID\uff1a{}\uff0c \u672a\u83b7\u53d6\u5230\u79df\u6237\u4fe1\u606f\uff0c\u8df3\u8fc7", (Object)tenantPO.getTenantId());
                        continue;
                    }
                    tenantBO.setTenantName(tenantInfo.getTenantName());
                    tenantBO.setTenantId(tenantPO.getTenantId());
                    tenantBOS.add(tenantBO);
                }
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            return BaseRspUtils.createErrorRspList((String)"\u67e5\u8be2\u5931\u8d25");
        }
        log.info("\u83b7\u53d6\u62a2\u5355\u4efb\u52a1\u4e0b\u6709\u6743\u9650\u7684\u79df\u6237\u4fe1\u606f\u63a5\u53e3\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString(tenantBOS));
        return BaseRspUtils.createSuccessRspList(tenantBOS, (long)tenantBOS.size());
    }

    public int updateUpdateTime(String taskID) {
        if (StringUtils.isEmpty((Object)taskID)) {
            return 0;
        }
        return this.obTaskInfoDAO.updateUpTime(taskID);
    }

    public String[] getIdleSkillGroup(String taskId, String tenantId, String groupType) {
        if (StringUtils.isEmpty((Object)taskId)) {
            return null;
        }
        SkillGroupBO skillGroupBO = new SkillGroupBO();
        skillGroupBO.setTenantCode(tenantId);
        skillGroupBO.setShowGroupType(groupType);
        RspList rspList = this.skillGroupInterService.getSkillByInfo(skillGroupBO);
        log.info("query:{},\u83b7\u53d6\u5230\u6700\u9ad8\u6280\u80fd\u7b49\u7ea7\u4f18\u5148\u6280\u80fd\u7ec4\uff1a{}", (Object)JSONObject.toJSONString((Object)skillGroupBO), (Object)JSONObject.toJSONString((Object)rspList));
        if (null != rspList && null != rspList.getRows()) {
            SkillGroupBO sk;
            Iterator iterator = rspList.getRows().iterator();
            while (iterator.hasNext() && null != (sk = (SkillGroupBO)iterator.next())) {
                String skillCode = sk.getSkillGroupCode();
                String skillGroupId = sk.getSkillGroupId();
                String acdDn = sk.getAcdDn();
                if (StrUtil.isEmpty((CharSequence)skillCode) || StrUtil.isEmpty((CharSequence)skillGroupId)) continue;
                ObTaskInfoPO obTaskInfoPO = new ObTaskInfoPO();
                obTaskInfoPO.setSkillId(skillGroupId);
                obTaskInfoPO.setTenantId(tenantId);
                List list = this.obTaskInfoDAO.selectValidTaskInfoList(obTaskInfoPO);
                if (null != list && !list.isEmpty()) continue;
                return new String[]{skillCode, skillGroupId, acdDn};
            }
        }
        return null;
    }

    TaskInfoBO getTaskInfo(String taskID, String tenantID) {
        TaskInfoBO taskInfo = new TaskInfoBO();
        taskInfo.setTaskId(taskID);
        taskInfo.setTenantId(tenantID);
        return this.taskBusiService.qryTask(taskInfo);
    }
}

