/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.utils;

import java.net.URI;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class RequestApiHelper {
    private static final Logger log = LoggerFactory.getLogger(RequestApiHelper.class);
    @Resource
    private RestTemplate restTemplate;

    public String monitorSkillGetApi(String url, List<String> params, String topic) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)url);
        builder.queryParam("topic", new Object[]{topic});
        if (params != null && params.size() > 0) {
            params.forEach(param -> builder.queryParam("skill_ids", new Object[]{param}));
        }
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Type", "application/json; charset=UTF-8");
            RequestEntity requestEntity = null;
            requestEntity = RequestEntity.get((URI)builder.build().toUri()).headers(headers).build();
            log.debug("\u63a5\u53e3\u8c03\u7528\u53c2\u6570:{}", (Object)requestEntity);
            ResponseEntity exchange = this.restTemplate.exchange(builder.build().toUri(), HttpMethod.GET, (HttpEntity)requestEntity, String.class);
            if (exchange.getStatusCode().is2xxSuccessful()) {
                String rspBody = (String)exchange.getBody();
                log.debug("\u8fd4\u56de\u7ed3\u679c: {}", (Object)rspBody);
                return rspBody;
            }
            log.error("\u63a5\u53e3\u8c03\u7528\u9519\u8bef:RequestEntity = {}, ResponseEntity = {}", (Object)requestEntity, (Object)exchange);
        }
        catch (HttpClientErrorException e) {
            log.error("\u63a5\u53e3\u8c03\u7528\u5931\u8d25:statusCode = {}, errMsg = {}", (Object)e.getStatusCode(), (Object)e.getMessage());
        }
        catch (Exception e) {
            log.error("\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u7f51\u7edc\u94fe\u63a5\u9519\u8bef: {}", (Object)e.getMessage());
        }
        return "";
    }
}

