/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class SpringContextUtil
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SpringContextUtil.class);
    private static ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringContextUtil.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static Object getBean(String beanName) {
        return applicationContext.getBean(beanName);
    }

    public static <T> T getBean(String beanName, Class<T> requiredType) {
        if (null == applicationContext) {
            log.error("applicationContext null", (Object)beanName);
            return null;
        }
        try {
            return (T)applicationContext.getBean(beanName, requiredType);
        }
        catch (NoSuchBeanDefinitionException e) {
            log.info("No bean named '{}' available", (Object)beanName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Object getBean(Class<?> clas) {
        return applicationContext.getBean(clas);
    }
}

