/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.isv;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class RestHelper {
    private static final Logger log = LoggerFactory.getLogger(RestHelper.class);
    @Autowired
    private RestTemplate restTemplate;

    public String post(String url, @Nullable Object request) {
        ResponseEntity entity = this.restTemplate.postForEntity(url, request, String.class, new Object[0]);
        log.info("post Url:{},Result:{}", (Object)url, (Object)JSONObject.toJSONString((Object)entity));
        if (entity != null && HttpStatus.OK.equals((Object)entity.getStatusCode())) {
            return (String)entity.getBody();
        }
        return null;
    }

    public String get(String url) {
        ResponseEntity entity = this.restTemplate.getForEntity(url, String.class, new Object[0]);
        if (entity != null && HttpStatus.OK.equals((Object)entity.getStatusCode())) {
            return (String)entity.getBody();
        }
        return null;
    }

    public <T> T get(String url, Class<T> tClass) {
        ResponseEntity entity = this.restTemplate.getForEntity(url, tClass, new Object[0]);
        if (entity != null && HttpStatus.OK.equals((Object)entity.getStatusCode())) {
            return (T)entity.getBody();
        }
        return null;
    }

    public <T> T post(String url, @Nullable Object request, Class<T> responseType) {
        ResponseEntity entity = this.restTemplate.postForEntity(url, request, responseType, new Object[0]);
        log.info("RestHelper Url:{}  request param:{} result:{}", new Object[]{url, JSONObject.toJSONString((Object)request), JSONObject.toJSONString((Object)entity)});
        if (entity != null && HttpStatus.OK.equals((Object)entity.getStatusCode())) {
            return (T)entity.getBody();
        }
        return null;
    }

    private static String mergeUrl(String proxyUrl, Map<String, String> request) {
        StringBuilder sb = new StringBuilder(proxyUrl).append("?proxy=1");
        for (String key : request.keySet()) {
            sb.append("&").append(key).append("={").append(key).append("}");
        }
        return sb.toString();
    }
}

