/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.isv.controller;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.ocs.isv.dto.EventDTO;
import com.tydic.nicc.ocs.isv.dto.EventPushResultDTO;
import com.tydic.nicc.ocs.isv.dto.GainResultsRspDTO;
import com.tydic.nicc.ocs.isv.service.GainResultsService;
import com.tydic.nicc.ocs.isv.service.IsvEventService;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/e1R5MV2JIQ2IThZM/"})
public class IsvEventController {
    private static final Logger log = LoggerFactory.getLogger(IsvEventController.class);
    @Resource
    IsvEventService isvEventService;
    @Autowired
    private GainResultsService gainResultsService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"push"})
    public EventPushResultDTO doEvent(@RequestBody EventDTO eventList) {
        Long inTime = System.currentTimeMillis();
        EventPushResultDTO resultDTO = new EventPushResultDTO();
        resultDTO.setCode(0);
        resultDTO.setDesc("SUCCESS");
        try {
            if (null == eventList) {
                EventPushResultDTO eventPushResultDTO = resultDTO;
                return eventPushResultDTO;
            }
            this.isvEventService.doEvent(eventList);
        }
        catch (Exception e) {
            log.error("\u72b6\u6001\u901a\u77e5\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            log.info("doEvent deal time :{}ms,\n doEvent message body:{}", (Object)(System.currentTimeMillis() - inTime), (Object)JSONObject.toJSONString((Object)eventList));
        }
        return resultDTO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"gainResults"})
    public GainResultsRspDTO gainResults(HttpServletRequest request, @RequestBody String record) {
        log.info("GainResultsReqDTO\uff1a{}", (Object)JSONObject.toJSONString((Object)record));
        GainResultsRspDTO resultDTO = new GainResultsRspDTO();
        long startTime = System.currentTimeMillis();
        if (StringUtils.isEmpty((Object)record)) {
            resultDTO.setStatus(1);
            resultDTO.setMessage("\u5916\u547c\u6570\u636e\u4e3a\u7a7a\uff01");
            return resultDTO;
        }
        try {
            String tenantCode = request.getParameter("tenantCode");
            String callType = request.getParameter("callType");
            String taskId = request.getParameter("taskId");
            String taskType = request.getParameter("taskType");
            log.info("url\u643a\u5e26\u53c2\u6570 tenantCode\uff1a{}\uff0c callType\uff1a{}\uff0c taskId\uff1a{}", new Object[]{tenantCode, callType, taskId});
            JSONObject recordJson = JSONObject.parseObject((String)record);
            recordJson.put("callType", (Object)callType);
            recordJson.put("taskId", (Object)taskId);
            recordJson.put("taskType", (Object)taskType);
            record = JSONObject.toJSONString((Object)recordJson);
            this.gainResultsService.gainResults(record, tenantCode);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5916\u547c\u6570\u636e\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            resultDTO.setStatus(1);
            resultDTO.setMessage("\u83b7\u53d6\u5916\u547c\u6570\u636e\u5931\u8d25\uff01");
        }
        finally {
            log.info("\u6267\u884c\u65f6\u95f4:{}, record:{}", (Object)(System.currentTimeMillis() - startTime), (Object)record);
        }
        resultDTO.setStatus(0);
        resultDTO.setMessage("success");
        return resultDTO;
    }
}

