/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.isv.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.ocs.config.CodeConfig;
import com.tydic.nicc.ocs.isv.CallControlService;
import com.tydic.nicc.ocs.isv.RestHelper;
import com.tydic.nicc.ocs.isv.bo.ISVRequestBO;
import com.tydic.nicc.ocs.isv.bo.ISVRestResponseBO;
import com.tydic.nicc.ocs.isv.bo.MackCallReqBO;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class CallControlServiceImpl
implements CallControlService {
    private static final Logger log = LoggerFactory.getLogger(CallControlServiceImpl.class);
    private static final String MAKE_CALL = "MAKE_CALL";
    private static final String ANSWER_CALL = "ANSWER_CALL";
    private static final String HANGUP_CALL = "HANGUP_CALL";
    private static final String HOLD_CALL = "HOLD_CALL";
    private static final String RETRIEVE_CALL = "RETRIEVE_CALL";
    private static final String START_MUTE = "START_MUTE";
    private static final String STOP_MUTE = "STOP_MUTE";
    @Autowired
    CodeConfig codeConfig;
    @Autowired
    private RestHelper restHelper;

    public ISVRestResponseBO makeCall(MackCallReqBO req) {
        return this.doAction(MAKE_CALL, (ISVRequestBO)req);
    }

    public ISVRestResponseBO answerCall(ISVRequestBO req) {
        return this.doAction(ANSWER_CALL, req);
    }

    public ISVRestResponseBO hangupCall(ISVRequestBO req) {
        return this.doAction(HANGUP_CALL, req);
    }

    public ISVRestResponseBO holdCall(ISVRequestBO req) {
        return this.doAction(HOLD_CALL, req);
    }

    public ISVRestResponseBO retrieveCall(ISVRequestBO req) {
        return this.doAction(RETRIEVE_CALL, req);
    }

    public ISVRestResponseBO startMute(ISVRequestBO req) {
        return this.doAction(START_MUTE, req);
    }

    public ISVRestResponseBO stopMute(ISVRequestBO req) {
        return this.doAction(STOP_MUTE, req);
    }

    public ISVRestResponseBO doAction(String serviceName, ISVRequestBO req) {
        Map qryMap;
        ISVRestResponseBO rsp;
        String url = this.codeConfig.getOcsUrl(serviceName, req.getTenantId());
        if (!StringUtils.isEmpty((Object)req.getSessionId())) {
            url = url + "&sessionId=" + req.getSessionId();
        }
        if (null != (rsp = this.restHelper.post(url, qryMap = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)req), Map.class), ISVRestResponseBO.class))) {
            rsp.setCode(rsp.getCode());
            rsp.setDesc(rsp.getDesc());
            if (0 == rsp.getCode()) {
                rsp.setMsgCode("0000");
            } else {
                rsp.setMsgCode("9999");
            }
        } else {
            rsp.setMsgCode("9999");
        }
        return rsp;
    }
}

