/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.isv.impl;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.bladetenant.inter.BladeTenantInterService;
import com.tydic.nicc.dc.bo.bladetenant.BladeTenantBO;
import com.tydic.nicc.dc.bo.bladetenant.GetBladeTenantInfoReqBO;
import com.tydic.nicc.dc.bo.bladetenant.GetBladeTenantInfoRspBO;
import com.tydic.nicc.dc.bo.jobNumber.JobNumberBO;
import com.tydic.nicc.dc.bo.jobNumber.QueryJobNumberRecordInfoBO;
import com.tydic.nicc.dc.jobNumber.inter.DcJobNumberInterService;
import com.tydic.nicc.ocs.bo.QueryUserLinkProductReqBO;
import com.tydic.nicc.ocs.cache.LocalCache;
import com.tydic.nicc.ocs.cache.WsCache;
import com.tydic.nicc.ocs.constant.CallRecordConstant;
import com.tydic.nicc.ocs.isv.GainCallRecordService;
import com.tydic.nicc.ocs.isv.bo.CallRecordBO;
import com.tydic.nicc.ocs.isv.impl.TenantBO;
import com.tydic.nicc.ocs.mapper.ObCallRecordDAO;
import com.tydic.nicc.ocs.mapper.ObCalledRecordDAO;
import com.tydic.nicc.ocs.mapper.po.ObCallRecordPO;
import com.tydic.nicc.ocs.mapper.po.ObCalledRecordPO;
import com.tydic.nicc.ocs.service.TaskQueryAboutService;
import com.tydic.nicc.ocs.type.CallTaskType;
import com.tydic.nicc.ocs.utils.DateUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class GainCallRecordServiceImpl
implements GainCallRecordService {
    private static final Logger log = LoggerFactory.getLogger(GainCallRecordServiceImpl.class);
    private Integer END_TYPE_YC_1 = 1;
    private Integer END_TYPE_YC_2 = 2;
    private Integer END_TYPE_YC_3 = 3;
    private Integer END_TYPE_YC_4 = 4;
    private Integer END_TYPE_YC_5 = 5;
    private Integer END_TYPE_YC_6 = 6;
    private Integer END_TYPE_YC_7 = 7;
    private Integer END_TYPE_YC_8 = 8;
    public static final Map<String, TenantBO> agnetTenantMap = MapUtil.newConcurrentHashMap((int)2000);
    public static final Map<String, TenantBO> tenantMap = MapUtil.newConcurrentHashMap((int)100);
    public static volatile Date UPDATE_TIME = new Date();
    private String SYS_DEFAULT_TENENT_ID = "10010";
    private String SYS_TEST_DEFAULT_TENENT_ID = "10011";
    @Resource
    private ObCallRecordDAO obCallRecordDAO;
    @Resource
    private ObCalledRecordDAO obCalledRecordDAO;
    @Resource
    private TaskQueryAboutService taskQueryAboutService;
    @Resource
    WsCache wsCache;
    @DubboReference
    private BladeTenantInterService bladeTenantInterService;
    @DubboReference
    private DcJobNumberInterService dcJobNumberInterService;

    public void insertCallRecord(String tenantCode, String taskType, List<CallRecordBO> callRecordBOS) {
        log.info("\u8fdb\u5165\u65b0\u589e\u5916\u547c\u8bb0\u5f55\u63a5\u53e3\uff0c\u5165\u53c2:{}, \u79df\u6237\u7f16\u7801\uff1a{}, taskType:{}", new Object[]{JSONObject.toJSONString(callRecordBOS), tenantCode, taskType});
        if (callRecordBOS == null || callRecordBOS.size() == 0) {
            log.error("\u53c2\u6570\u4fe1\u606f\u4e3a\u7a7a");
            return;
        }
        TenantBO tenantBO = this.getTenantInfo(tenantCode);
        String tenantOtherName = null;
        String tempTenamtOtherName = null;
        if (null == tenantBO) {
            log.error("\u672a\u77e5\u7684\u79df\u6237\u4fe1\u606f\uff1a{}", (Object)tenantCode);
            return;
        }
        tempTenamtOtherName = tenantOtherName = tenantBO.getTenantOtherName();
        ArrayList<ObCallRecordPO> records = new ArrayList<ObCallRecordPO>();
        for (CallRecordBO recordBO : callRecordBOS) {
            if ("OVTM".equals(recordBO.getRecordState())) continue;
            ObCallRecordPO record = this.getRecord(recordBO);
            record.setTenantId(tenantCode);
            if ("1".equals(record.getObsIsConn())) {
                String suggestProduct = this.getSuggestProduct(record.getTenantId(), record.getTaskId(), record.getCalled());
                record.setSuggestProduct(suggestProduct);
            }
            records.add(record);
        }
        if (records != null && records.size() > 0) {
            for (ObCallRecordPO recordPO : records) {
                if (CallTaskType.grab.name().equals(taskType) && !StringUtils.isEmpty((Object)recordPO.getJobNumber())) {
                    tenantBO = this.getAgentTenant(recordPO.getJobNumber());
                    log.info("\u6839\u636e\u5de5\u53f7\u83b7\u53d6\u79df\u6237\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)tenantBO));
                    if (null != tenantBO) {
                        tenantOtherName = tenantBO.getTenantOtherName();
                        recordPO.setTenantId(tenantBO.getTenantId());
                        recordPO.setTenantName(tenantBO.getTenantName());
                    }
                    if (StringUtils.isEmpty((Object)tenantOtherName)) {
                        tenantOtherName = tempTenamtOtherName;
                    }
                }
                if (!StringUtils.isEmpty((Object)recordPO.getJobNumber()) && StringUtils.isEmpty((Object)recordPO.getUserId())) {
                    try {
                        recordPO.setUserId(this.wsCache.getAgentDnBandUser(recordPO.getJobNumber()));
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
                ObCallRecordPO obCallRecordPO = this.obCallRecordDAO.selectByCallId(tenantOtherName, recordPO.getCallId());
                log.info("\u6839\u636eCallId\u67e5\u8be2Mapper\u5c42\u51fa\u53c2\uff1a{},tenantOtherName\uff1a{}", (Object)JSONObject.toJSONString((Object)obCallRecordPO), (Object)tenantOtherName);
                recordPO.setTenantOtherName(tenantOtherName);
                if (obCallRecordPO != null) {
                    recordPO.setRecordId(obCallRecordPO.getRecordId());
                    log.info("\u4fee\u6539\u5916\u547c\u8bb0\u5f55Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)recordPO));
                    this.obCallRecordDAO.updateByPrimaryKey(recordPO);
                } else {
                    log.info("\u63d2\u5165\u5916\u547c\u8bb0\u5f55Mapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)recordPO));
                    this.obCallRecordDAO.insertSelective(recordPO);
                }
                String tableName = LocalCache.getCallRecordTableNameByModelNO((String)recordPO.getCalled());
                log.info("tableName:{}", (Object)tableName);
                ObCalledRecordPO obCalledRecordPO = new ObCalledRecordPO();
                obCalledRecordPO.setTableName(tableName);
                obCalledRecordPO.setTaskId(recordPO.getTaskId());
                obCalledRecordPO.setTenantId(recordPO.getTenantId());
                obCalledRecordPO.setCallId(recordPO.getCallId());
                obCalledRecordPO.setCalling(recordPO.getCalling());
                obCalledRecordPO.setCalled(recordPO.getCalled());
                obCalledRecordPO.setCallType(recordPO.getCallType());
                obCalledRecordPO.setIsConn(recordPO.getIsConn());
                obCalledRecordPO.setObsIsConn(recordPO.getObsIsConn());
                obCalledRecordPO.setCallTime(recordPO.getStartTime());
                obCalledRecordPO.setCreateTime(new Date());
                obCalledRecordPO.setUcId(recordPO.getUcId());
                this.obCalledRecordDAO.insertSelective(obCalledRecordPO);
            }
        }
    }

    private ObCallRecordPO getRecord(CallRecordBO recordBO) {
        ObCallRecordPO record = new ObCallRecordPO();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            record.setRecordId(UUID.randomUUID().toString().trim().replaceAll("-", ""));
            String startTime = recordBO.getStartTime();
            if (StringUtils.isEmpty((Object)startTime)) {
                startTime = recordBO.getCreateTime();
            }
            long contactLength = 0L;
            if (!StringUtils.isEmpty((Object)recordBO.getAgentTalkTime()) && !StringUtils.isEmpty((Object)recordBO.getAgentEndTime())) {
                Date agentTalkTime = format.parse(recordBO.getAgentTalkTime());
                Date agentEndTime = format.parse(recordBO.getAgentEndTime());
                contactLength = (agentEndTime.getTime() - agentTalkTime.getTime()) / 1000L;
            }
            if (!StringUtils.isEmpty((Object)startTime)) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(format.parse(startTime));
                record.setObYear(calendar.get(1) + "");
                record.setObMonth(calendar.get(2) + 1 + "");
                record.setObDay(calendar.get(5) + "");
                record.setObHour(calendar.get(11) + "");
            }
            record.setJobNumber(recordBO.getAgentId());
            record.setCallId(recordBO.getCallId());
            record.setDataId(recordBO.getCustId());
            record.setCreateTime(format.format(new Date()));
            record.setCalling(recordBO.getAni());
            record.setCalled(recordBO.getDnis());
            record.setTalkTime(recordBO.getTalkTime());
            Integer endType = recordBO.getEndType();
            if (recordBO.getCallType().equals("0")) {
                if (endType == this.END_TYPE_YC_1) {
                    record.setIsConn("1");
                    record.setObsIsConn("1");
                } else if (endType == this.END_TYPE_YC_2 || endType == this.END_TYPE_YC_5 || endType == this.END_TYPE_YC_6 || endType == this.END_TYPE_YC_7) {
                    record.setIsConn("0");
                    record.setObsIsConn("0");
                } else if (endType == this.END_TYPE_YC_3 || endType == this.END_TYPE_YC_4) {
                    record.setIsConn("0");
                    record.setObsIsConn("1");
                }
            } else if (recordBO.getCallType().equals("2")) {
                if (endType == 1) {
                    record.setIsConn("1");
                    record.setObsIsConn("1");
                } else {
                    record.setIsConn("0");
                    record.setObsIsConn("0");
                }
            }
            record.setCallType(recordBO.getCallType());
            record.setRingTime(recordBO.getAgentRingTime());
            record.setStartTime(record.getStartTime());
            record.setEndTime(record.getEndTime());
            record.setContactLength(Long.toString(contactLength));
            record.setRecordFile(recordBO.getRecordUrl());
            record.setTaskId(recordBO.getCallTaskId());
            record.setStartTime(startTime);
            record.setEndTime(recordBO.getEndTime());
            record.setCity(StringUtils.isEmpty((Object)recordBO.getExtendField9()) ? recordBO.getAreaCode() : recordBO.getExtendField9());
            record.setUcId(recordBO.getUcId());
            record.setRemark(recordBO.getExtendField1());
            record.setEndType(recordBO.getEndType());
            record.setRecordState(recordBO.getRecordState());
            record.setIsTaskData(CallRecordConstant.IS_TASK_DATA_0);
            record.setTrunkDn(recordBO.getTrunkDn());
            if (!StringUtils.isEmpty((Object)recordBO.getAgentId())) {
                JobNumberBO jobNumberBO = this.dcJobNumberInterService.queryJobNumberInfo(recordBO.getAgentId());
                record.setUserId(null != jobNumberBO ? jobNumberBO.getUserId() : null);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return record;
    }

    private TenantBO getTenantInfo(String tenantId) {
        if (!StringUtils.isEmpty((Object)tenantMap.get(tenantId))) {
            return tenantMap.get(tenantId);
        }
        GetBladeTenantInfoReqBO infoReqBO = new GetBladeTenantInfoReqBO();
        infoReqBO.setTenantCode(tenantId);
        GetBladeTenantInfoRspBO bladeTenantInfo = this.bladeTenantInterService.getBladeTenantInfo(infoReqBO);
        if (bladeTenantInfo.getRspCode().equals("0000")) {
            BladeTenantBO bladeTenantBO = (BladeTenantBO)bladeTenantInfo.getData();
            TenantBO tenantBO = new TenantBO();
            tenantBO.setTenantId(tenantId);
            tenantBO.setTenantName(bladeTenantBO.getTenantName());
            tenantBO.setTenantOtherName(bladeTenantBO.getTenantOtherName());
            tenantMap.put(tenantId, tenantBO);
            return tenantBO;
        }
        return null;
    }

    private TenantBO getAgentTenant(String agentId) {
        TenantBO tenantBO;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(UPDATE_TIME);
        calendar.add(10, 12);
        if (calendar.after(new Date()) || agnetTenantMap.isEmpty()) {
            this.loadJobMap();
        }
        if (!StringUtils.isEmpty((Object)agnetTenantMap.get(agentId))) {
            return agnetTenantMap.get(agentId);
        }
        JobNumberBO jobNumberBO = this.dcJobNumberInterService.queryJobNumberInfo(agentId);
        if (null != jobNumberBO && null != (tenantBO = this.getTenantInfo(jobNumberBO.getTenantCode()))) {
            agnetTenantMap.put(agentId, tenantBO);
            return agnetTenantMap.get(agentId);
        }
        return null;
    }

    private synchronized void loadJobMap() {
        String tenantId;
        String endTime;
        Date currentDate = new Date();
        String startTime = DateUtil.getDayStartTimeStr((Date)currentDate);
        List list = this.dcJobNumberInterService.getJobNumberBindRecord(startTime, endTime = DateUtil.getDayEndTimeStr((Date)currentDate), tenantId = null);
        if (null != list && !list.isEmpty()) {
            agnetTenantMap.clear();
            for (QueryJobNumberRecordInfoBO query : list) {
                agnetTenantMap.put(query.getJobNumber(), this.getTenantInfo(query.getTenantId()));
            }
        }
        UPDATE_TIME = new Date();
    }

    private String getSuggestProduct(String tenantId, String taskId, String called) {
        String suggestProduct = "";
        QueryUserLinkProductReqBO reqBO = new QueryUserLinkProductReqBO();
        reqBO.setPhone(called);
        reqBO.setTaskId(taskId);
        reqBO.setTenantCode(tenantId);
        RspList rspList = this.taskQueryAboutService.qryUserLinkProduct(reqBO);
        if (!"0000".equals(rspList.getRspCode())) {
            return suggestProduct;
        }
        List rows = rspList.getRows();
        if (null == rows || rows.size() == 0) {
            return suggestProduct;
        }
        ArrayList products = new ArrayList();
        rows.stream().forEach(bo -> products.add(bo.getProductName()));
        suggestProduct = String.join((CharSequence)",", products);
        return suggestProduct;
    }
}

