/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.isv.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.nicc.ocs.bo.CancelBatchBO;
import com.tydic.nicc.ocs.bo.CancelRecordBO;
import com.tydic.nicc.ocs.bo.ImportBO;
import com.tydic.nicc.ocs.config.CodeConfig;
import com.tydic.nicc.ocs.isv.ListService;
import com.tydic.nicc.ocs.isv.RestHelper;
import com.tydic.nicc.ocs.isv.bo.ISVRequestBO;
import com.tydic.nicc.ocs.isv.dto.CancelBatchRequest;
import com.tydic.nicc.ocs.isv.dto.CancelRecordRequest;
import com.tydic.nicc.ocs.isv.dto.ImportListRequest;
import com.tydic.nicc.ocs.utils.FileUtil;
import java.io.File;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.tomcat.util.security.MD5Encoder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ListServiceImpl
implements ListService {
    private static final String LIST_IMPORT = "LIST_IMPORT";
    private static final String CANCEL_BATCH = "CANCEL_BATCH";
    private static final String CANCLE_RECORD = "CANCLE_RECORD";
    @Autowired
    CodeConfig codeConfig;
    @Autowired
    private RestHelper restHelper;

    public ImportBO importListFile(ImportBO importBO) {
        String oscUrl = this.codeConfig.getCodeStrValue(CodeConfig.CODE_BUSI.OCS_URL, LIST_IMPORT);
        String tenantToken = this.codeConfig.getCodeStrValue(CodeConfig.CODE_BUSI.SYS_PARAM, CodeConfig.CODE_NAME.tenantToken);
        ImportListRequest listRequestBO = new ImportListRequest();
        listRequestBO.setBatchId(importBO.getBatchId());
        listRequestBO.setListId(importBO.getListId());
        listRequestBO.setType(importBO.getType());
        listRequestBO.setTenantId(importBO.getTenantId());
        String qryStr = JSONObject.toJSONString((Object)listRequestBO);
        Map qryMap = (Map)JSONObject.parseObject((String)qryStr, Map.class);
        oscUrl = this.mergeUrl(oscUrl, tenantToken, qryMap);
        String result = FileUtil.uploadFile((String)oscUrl, (MultipartFile)FileUtil.fileToMultipartFile((File)importBO.getDateFile()), (String)qryStr);
        return (ImportBO)JSONObject.parseObject((String)result, ImportBO.class);
    }

    public ImportBO importListJSON(ImportBO importBO) {
        String oscUrl = this.codeConfig.getCodeStrValue(CodeConfig.CODE_BUSI.OCS_URL, LIST_IMPORT);
        String tenantToken = this.codeConfig.getCodeStrValue(CodeConfig.CODE_BUSI.SYS_PARAM, CodeConfig.CODE_NAME.tenantToken);
        ImportListRequest listRequestBO = new ImportListRequest();
        listRequestBO.setBatchId(importBO.getBatchId());
        listRequestBO.setListId(importBO.getListId());
        listRequestBO.setType(importBO.getType());
        listRequestBO.setTenantId(importBO.getTenantId());
        String qryStr = JSONObject.toJSONString((Object)listRequestBO);
        Map qryMap = (Map)JSONObject.parseObject((String)qryStr, Map.class);
        oscUrl = this.mergeUrl(oscUrl, tenantToken, qryMap);
        String jsonStr = JSONObject.toJSONString((Object)importBO.getListData());
        return this.restHelper.post(oscUrl, JSONObject.parseObject((String)jsonStr), ImportBO.class);
    }

    public CancelBatchBO cancelBatch(CancelBatchBO cancelBatchBO) {
        CancelBatchRequest cancelBatchRequest = new CancelBatchRequest();
        cancelBatchRequest.setBatchId(cancelBatchBO.getBatchId());
        cancelBatchRequest.setListId(cancelBatchBO.getListId());
        cancelBatchRequest.setTenantId(cancelBatchBO.getTenantId());
        return this.doAction(CANCEL_BATCH, cancelBatchRequest, CancelBatchBO.class);
    }

    public CancelRecordBO cancelRecord(CancelRecordBO cancelRecord) {
        CancelRecordRequest cancelRecordRequest = new CancelRecordRequest();
        cancelRecordRequest.setBatchId(cancelRecord.getBatchId());
        cancelRecordRequest.setListId(cancelRecord.getListId());
        return this.doAction(CANCLE_RECORD, cancelRecordRequest, CancelRecordBO.class);
    }

    private <T> T doAction(String serviceName, ISVRequestBO baseBO, Class<T> ocsRspClass) {
        String url = this.codeConfig.getOcsUrl(serviceName, baseBO.getTenantId());
        String jsonString = JSONObject.toJSONString((Object)baseBO, (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[0]);
        return this.restHelper.post(url, jsonString, ocsRspClass);
    }

    private String mergeUrl(String proxyUrl, String tenantToken, Map<String, String> request) {
        String tenantCode = null;
        String timestamp = null;
        StringBuilder sb = new StringBuilder(proxyUrl).append("?proxy=1");
        for (String key : request.keySet()) {
            if ("tenantId".equals(key)) {
                tenantCode = request.get(key);
            } else if ("timestamp".equals(key)) {
                timestamp = request.get(key);
            } else if ("data".equals(key)) continue;
            sb.append("&").append(key).append("=").append(request.get(key)).append("");
        }
        timestamp = null == timestamp ? DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss") : timestamp;
        String binaryStr = tenantCode + tenantToken + timestamp;
        String signature = MD5Encoder.encode((byte[])binaryStr.getBytes());
        sb.append("&signature=").append(signature);
        return sb.toString();
    }
}

