/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.isv.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.ocs.bo.AdjustTaskBO;
import com.tydic.nicc.ocs.bo.AdjustTaskListBO;
import com.tydic.nicc.ocs.bo.BaseBO;
import com.tydic.nicc.ocs.bo.CreateIsvTaskResultBO;
import com.tydic.nicc.ocs.bo.CreatePreTaskBO;
import com.tydic.nicc.ocs.bo.DownloadRecordBO;
import com.tydic.nicc.ocs.bo.EndTaskBO;
import com.tydic.nicc.ocs.bo.MonitorTaskBO;
import com.tydic.nicc.ocs.bo.MonitorTaskReqBO;
import com.tydic.nicc.ocs.bo.QueryBatchBO;
import com.tydic.nicc.ocs.bo.QueryBatchResultBO;
import com.tydic.nicc.ocs.bo.QueryCallerBO;
import com.tydic.nicc.ocs.bo.QueryPeriodBO;
import com.tydic.nicc.ocs.bo.QueryPeriodResultBO;
import com.tydic.nicc.ocs.bo.StartBatchBO;
import com.tydic.nicc.ocs.bo.StartTaskBO;
import com.tydic.nicc.ocs.bo.StopBatchBO;
import com.tydic.nicc.ocs.bo.StopTaskBO;
import com.tydic.nicc.ocs.bo.TestCallBO;
import com.tydic.nicc.ocs.bo.UpdatePeriodBO;
import com.tydic.nicc.ocs.bo.UpdatePeriodResultBO;
import com.tydic.nicc.ocs.bo.UpdateTaskBO;
import com.tydic.nicc.ocs.config.CodeConfig;
import com.tydic.nicc.ocs.isv.PredictiveTaskService;
import com.tydic.nicc.ocs.isv.RestHelper;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PredictiveTaskServiceImpl
implements PredictiveTaskService {
    private static final Logger log = LoggerFactory.getLogger(PredictiveTaskServiceImpl.class);
    @Autowired
    CodeConfig codeConfig;
    @Autowired
    private RestHelper restHelper;
    private static final String CRAETE_TASK = "CRAETE_TASK";
    private static final String START_TASK = "START_TASK";
    private static final String STOP_TASK = "STOP_TASK";
    private static final String END_TASK = "END_TASK";
    private static final String ADJUST_TASK = "ADJUST_TASK";
    private static final String MONITOR_TASK = "MONITOR_TASK";
    private static final String UPDATE_TASK = "UPDATE_TASK";
    private static final String QUERY_PERIOD = "QUERY_PERIOD";
    private static final String UPDATE_PERIOD = "UPDATE_PERIOD";
    private static final String QUERY_CALLER = "QUERY_CALLER";
    private static final String DOWNLOAD_RECORD = "DOWNLOAD_RECORD";
    private static final String STOP_BATCH = "STOP_BATCH";
    private static final String START_BATCH = "START_BATCH";
    private static final String QUERY_BATCH = "QUERY_BATCH";
    private static final String CALL_TEST = "CALL_TEST";

    public CreateIsvTaskResultBO createTask(CreatePreTaskBO request) {
        return this.doAction(CRAETE_TASK, (BaseBO)request, CreateIsvTaskResultBO.class);
    }

    public BaseBO startTask(StartTaskBO request) {
        return this.doGetAction(START_TASK, request.getTaskId(), (BaseBO)request, BaseBO.class);
    }

    public BaseBO stopTask(StopTaskBO request) {
        return this.doGetAction(STOP_TASK, request.getTaskId(), (BaseBO)request, BaseBO.class);
    }

    public BaseBO endTask(EndTaskBO request) {
        return this.doGetAction(END_TASK, request.getTaskId(), (BaseBO)request, BaseBO.class);
    }

    public BaseBO adjustTask(AdjustTaskBO request) {
        return this.doAdjustTaskGet(ADJUST_TASK, request, BaseBO.class);
    }

    public BaseBO adjustTasks(AdjustTaskListBO request) {
        BaseBO base = new BaseBO();
        if (null == request && null == request.getAdjustTasks()) {
            return base;
        }
        Map param = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)request.getAdjustTasks()), Map.class);
        return this.doAction(ADJUST_TASK, request.getTenantId(), param, BaseBO.class);
    }

    public BaseBO<MonitorTaskBO> monitorTask(MonitorTaskReqBO request) {
        String strVal = this.doGetAction(MONITOR_TASK, request.getTaskId(), (BaseBO)request, String.class);
        if (StringUtils.isEmpty((Object)strVal)) {
            return null;
        }
        BaseBO rspBO = (BaseBO)JSONObject.parseObject((String)strVal, BaseBO.class);
        if (null == rspBO) {
            return null;
        }
        if (0 != rspBO.getStatus()) {
            return null;
        }
        Object object = rspBO.getResult();
        if (null == object) {
            return null;
        }
        BaseBO result = new BaseBO();
        result.setStatus(rspBO.getStatus());
        MonitorTaskBO monitorTaskBO = (MonitorTaskBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)rspBO.getResult()), MonitorTaskBO.class);
        result.setResult((Object)monitorTaskBO);
        return result;
    }

    public BaseBO updateTask(UpdateTaskBO request) {
        return this.doAction(UPDATE_TASK, (BaseBO)request, BaseBO.class);
    }

    public QueryPeriodResultBO queryPeriod(QueryPeriodBO request) {
        return this.doGetAction(QUERY_PERIOD, request.getTaskId(), (BaseBO)request, QueryPeriodResultBO.class);
    }

    public BaseBO updatePeriod(UpdatePeriodBO request) {
        return (BaseBO)this.doAction(UPDATE_PERIOD, (BaseBO)request, UpdatePeriodResultBO.class);
    }

    public UpdatePeriodResultBO queryCaller(QueryCallerBO request) {
        return this.doAction(QUERY_CALLER, (BaseBO)request, UpdatePeriodResultBO.class);
    }

    public UpdatePeriodResultBO downloadRecord(DownloadRecordBO request) {
        return this.doAction(DOWNLOAD_RECORD, (BaseBO)request, UpdatePeriodResultBO.class);
    }

    public BaseBO stopBatch(StopBatchBO request) {
        return this.doAction(STOP_BATCH, (BaseBO)request, BaseBO.class);
    }

    public BaseBO startBatch(StartBatchBO request) {
        return this.doAction(START_BATCH, (BaseBO)request, BaseBO.class);
    }

    public QueryBatchResultBO queryBatch(QueryBatchBO request) {
        return this.doAction(QUERY_BATCH, (BaseBO)request, QueryBatchResultBO.class);
    }

    public BaseBO testCall(TestCallBO testCallBO) {
        return this.doGet(CALL_TEST, (BaseBO)testCallBO, BaseBO.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseBO doAdjustTaskGet(String serviceName, AdjustTaskBO request, Class<BaseBO> tClass) {
        BaseBO baseBO;
        BaseBO result = null;
        String url = null;
        try {
            url = this.codeConfig.getOcsGetUrl(serviceName, request.getTenantId(), request.getTaskId(), null);
            url = this.merryUrl(url, request);
            log.info("get url:{},param :{}", (Object)url, (Object)JSONObject.toJSONString((Object)request));
            baseBO = result = this.restHelper.get(url, BaseBO.class);
        }
        catch (Throwable throwable) {
            log.info("url :{};\n result:{}", url, (Object)JSONObject.toJSONString(result));
            throw throwable;
        }
        log.info("url :{};\n result:{}", (Object)url, (Object)JSONObject.toJSONString((Object)result));
        return baseBO;
    }

    private <T> T doAction(String serviceName, BaseBO baseBO, Class<T> ocsRspClass) {
        String url = this.codeConfig.getOcsUrl(serviceName, baseBO.getTenantId());
        log.info("post url:{},param :{}", (Object)url, (Object)JSONObject.toJSONString((Object)baseBO));
        Map qryMap = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)baseBO), Map.class);
        return this.restHelper.post(url, qryMap, ocsRspClass);
    }

    private <T> T doAction(String serviceName, String tenantId, Map param, Class<T> ocsRspClass) {
        String url = this.codeConfig.getOcsUrl(serviceName, tenantId);
        return this.restHelper.post(url, param, ocsRspClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T doGetAction(String serviceName, String taskId, BaseBO baseBO, Class<T> ocsRspClass) {
        T t;
        T result = null;
        String url = null;
        try {
            url = this.codeConfig.getOcsGetUrl(serviceName, baseBO.getTenantId(), taskId, null);
            log.info("get url:{},param :{}", (Object)url, (Object)JSONObject.toJSONString((Object)baseBO));
            t = result = (T)this.restHelper.get(url, ocsRspClass);
        }
        catch (Throwable throwable) {
            log.info("doGetAction url :{};\n result:{}", url, (Object)JSONObject.toJSONString(result));
            throw throwable;
        }
        log.info("doGetAction url :{};\n result:{}", (Object)url, (Object)JSONObject.toJSONString(result));
        return t;
    }

    private <T> T doGet(String serviceName, BaseBO param, Class<T> tClass) {
        String url = this.packUrl(serviceName, param);
        log.info("doGet Url :{}", (Object)url);
        return this.restHelper.get(url, tClass);
    }

    private String packUrl(String serviceName, BaseBO param) {
        String url = this.codeConfig.getOcsUrl(serviceName, param.getTenantId());
        BaseBO baseBO = (BaseBO)BeanUtil.copyProperties((Object)param, BaseBO.class, (String[])new String[0]);
        Map baseMap = BeanUtil.beanToMap((Object)baseBO);
        Map paramMap = BeanUtil.beanToMap((Object)param);
        StringBuffer sb = new StringBuffer(url);
        if (url.indexOf("?") < 0) {
            sb.append("?");
        }
        for (Object key : paramMap.keySet()) {
            if (baseMap.containsKey(key) || StringUtils.isEmpty(paramMap.get(key))) continue;
            if (!url.endsWith("?") && !url.endsWith("&")) {
                sb.append("&");
            }
            sb.append(key).append("=").append(paramMap.get(key));
        }
        return sb.toString();
    }

    private String merryUrl(String url, AdjustTaskBO request) {
        Map paramMap = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)request), Map.class);
        StringBuffer sb = new StringBuffer(url);
        for (String key : paramMap.keySet()) {
            if ("tenantId".equals(key) || "taskId".equals(key)) continue;
            sb.append("&").append(key).append("=").append(paramMap.get(key));
        }
        return sb.toString();
    }
}

