/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.isv.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.ocs.bo.BaseBO;
import com.tydic.nicc.ocs.config.CodeConfig;
import com.tydic.nicc.ocs.isv.RestHelper;
import com.tydic.nicc.ocs.isv.StatusControlService;
import com.tydic.nicc.ocs.isv.bo.AgentStateBO;
import com.tydic.nicc.ocs.isv.bo.CustStatusChangeBO;
import com.tydic.nicc.ocs.isv.bo.ForceLogoutBO;
import com.tydic.nicc.ocs.isv.bo.GetAgentStatusBO;
import com.tydic.nicc.ocs.isv.bo.ISVRequestBO;
import com.tydic.nicc.ocs.isv.bo.ISVRestResponseBO;
import com.tydic.nicc.ocs.isv.bo.LogoutBO;
import com.tydic.nicc.ocs.isv.bo.ReadyReqBO;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class StatusControlServiceImpl
implements StatusControlService {
    private static final Logger log = LoggerFactory.getLogger(StatusControlServiceImpl.class);
    private static final String LOGIN = "LOGIN";
    private static final String LOGOUT = "LOGOUT";
    private static final String NOT_READY = "NOT_READY";
    private static final String READY = "READY";
    private static final String FORCE_LOGOUT = "FORCE_LOGOUT";
    private static final String GET_AGENT_STATUS = "GET_AGENT_STATUS";
    private static final String GET_SESSION_STATUS = "GET_SESSION_STATUS";
    @Autowired
    private CodeConfig codeConfig;
    @Autowired
    private RestHelper restHelper;

    public ISVRestResponseBO<CustStatusChangeBO> login(CustStatusChangeBO req) {
        return this.doISVAction(LOGIN, (ISVRequestBO)req, CustStatusChangeBO.class);
    }

    public ISVRestResponseBO<LogoutBO> logout(ISVRequestBO req) {
        return this.doISVAction(LOGOUT, req, LogoutBO.class);
    }

    public ISVRestResponseBO<Object> notReady(ReadyReqBO req) {
        return this.doISVAction(NOT_READY, (ISVRequestBO)req, Object.class);
    }

    public ISVRestResponseBO<Object> ready(ReadyReqBO req) {
        return this.doISVAction(READY, (ISVRequestBO)req, Object.class);
    }

    public ISVRestResponseBO getSessionStatus(ISVRequestBO isvReques) {
        return this.doGet(GET_SESSION_STATUS, isvReques, ISVRestResponseBO.class);
    }

    public ISVRestResponseBO<AgentStateBO> getAgentState(GetAgentStatusBO req) {
        ISVRestResponseBO rsp = this.doGet(GET_AGENT_STATUS, (ISVRequestBO)req, ISVRestResponseBO.class);
        log.info("GET_AGENT_STATUS :param:{},result:{}", (Object)JSONObject.toJSONString((Object)req), (Object)JSONObject.toJSONString((Object)rsp));
        ISVRestResponseBO result = new ISVRestResponseBO();
        if (null != rsp) {
            result.setCode(rsp.getCode());
            result.setDesc(rsp.getDesc());
            if (0 == rsp.getCode()) {
                result.setMsgCode("0000");
                Object data = rsp.getData();
                if (null != data) {
                    result.setData(JSONObject.parseObject((String)JSONObject.toJSONString((Object)data), AgentStateBO.class));
                }
            } else {
                result.setCode(Integer.valueOf(1));
                result.setMsgCode("9999");
            }
        } else {
            result.setCode(Integer.valueOf(1));
            result.setMsgCode("9999");
        }
        return result;
    }

    public ISVRestResponseBO forceLogout(ForceLogoutBO forceLogout) {
        return this.doISVAction(FORCE_LOGOUT, (ISVRequestBO)forceLogout, ISVRestResponseBO.class);
    }

    private <T> ISVRestResponseBO<T> doISVAction(String serviceName, ISVRequestBO req, Class<T> t) {
        ISVRestResponseBO result = new ISVRestResponseBO();
        String url = this.codeConfig.getOcsUrl(serviceName, req.getTenantId());
        if (!StringUtils.isEmpty((Object)req.getSessionId())) {
            url = url + "&sessionId=" + req.getSessionId();
        }
        Map qryMap = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)req), Map.class);
        log.info("url:{}====requestParam:{}", (Object)url, (Object)JSONObject.toJSONString((Object)qryMap));
        String resultStr = this.restHelper.post(url, qryMap);
        log.info("url:{}===responseParam:{}", (Object)url, (Object)resultStr);
        if (!StringUtils.isEmpty((Object)resultStr)) {
            ISVRestResponseBO rsp = (ISVRestResponseBO)JSONObject.parseObject((String)resultStr, ISVRestResponseBO.class);
            if (null != rsp) {
                result.setCode(rsp.getCode());
                result.setDesc(rsp.getDesc());
                if (0 == rsp.getCode()) {
                    result.setMsgCode("0000");
                    Object data = rsp.getData();
                    if (null != data) {
                        result.setData(JSONObject.parseObject((String)JSONObject.toJSONString((Object)data), t));
                    }
                } else {
                    result.setMsgCode("9999");
                }
            } else {
                result.setMsgCode("9999");
            }
        } else {
            result.setMsgCode("9999");
        }
        return result;
    }

    private <T> T doGet(String serviceName, ISVRequestBO param, Class<T> tClass) {
        String url = this.packUrl(serviceName, param);
        log.info("doGet Url :{}", (Object)url);
        return this.restHelper.get(url, tClass);
    }

    private String packUrl(String serviceName, ISVRequestBO param) {
        String url = this.codeConfig.getOcsUrl(serviceName, param.getTenantId());
        BaseBO baseBO = (BaseBO)BeanUtil.copyProperties((Object)param, BaseBO.class, (String[])new String[0]);
        Map baseMap = BeanUtil.beanToMap((Object)baseBO);
        Map paramMap = BeanUtil.beanToMap((Object)param);
        StringBuffer sb = new StringBuffer(url);
        if (url.indexOf("?") < 0) {
            sb.append("?");
        }
        for (Object key : paramMap.keySet()) {
            if (baseMap.containsKey(key) || null == paramMap.get(key)) continue;
            if (!url.endsWith("?") && !url.endsWith("&")) {
                sb.append("&");
            }
            sb.append(key).append("=").append(paramMap.get(key));
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        ISVRestResponseBO result = new ISVRestResponseBO();
        String resultStr = "{\n\t\"code\": 0,\n\t\"data\": {\n\t\t\"agentId\": \"870090\",\n\t\t\"agentDn\": \"870090\",\n\t\t\"agentName\": \"870090\",\n\t\t\"agentType\": 1,\n\t\t\"agentIp\": \"136.24.248.195\",\n\t\t\"phoneIp\": \"136.28.62.205\",\n\t\t\"skillDesc\": \"19011=1;\",\n\t\t\"loginId\": \"20220302182652000_045_CTI01\",\n\t\t\"loginTime\": \"2022-03-02 18:26:51.975\",\n\t\t\"logoutTime\": \"2022-03-02 19:13:01.516\",\n\t\t\"sessionId\": \"c10621d0-afa0-46ff-a1a1-398a892fd1df\",\n\t\t\"appId\": null\n\t}\n}";
        if (!StringUtils.isEmpty((Object)resultStr)) {
            ISVRestResponseBO rsp = (ISVRestResponseBO)JSONObject.parseObject((String)resultStr, ISVRestResponseBO.class);
            if (null != rsp) {
                result.setCode(rsp.getCode());
                result.setDesc(rsp.getDesc());
                if (0 == rsp.getCode()) {
                    result.setMsgCode("0000");
                    Object data = rsp.getData();
                    if (null != data) {
                        result.setData(JSONObject.parseObject((String)JSONObject.toJSONString((Object)data), LogoutBO.class));
                    }
                } else {
                    result.setMsgCode("9999");
                }
            } else {
                result.setMsgCode("9999");
            }
        } else {
            result.setMsgCode("9999");
        }
        System.out.println(JSONObject.toJSONString((Object)result));
    }
}

