/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.isv.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.ocs.ability.EventAbilityService;
import com.tydic.nicc.ocs.handler.bo.EventBO;
import com.tydic.nicc.ocs.isv.service.AsyncService;
import com.tydic.nicc.ocs.utils.SessionMap;
import java.util.ArrayList;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AsyncServiceImpl
implements AsyncService {
    private static final Logger log = LoggerFactory.getLogger(AsyncServiceImpl.class);
    @Autowired
    EventAbilityService eventAbilityService;
    private String EVENT_LIST_KEY = "eventList";
    private Long eventUnti = 600000L;

    @Override
    public void executeAsync(String strBody) {
        if (strBody == null || "".equals(strBody)) {
            return;
        }
        JSONObject events = JSONObject.parseObject((String)strBody);
        if (events == null || events.isEmpty()) {
            return;
        }
        if (!events.containsKey((Object)this.EVENT_LIST_KEY)) {
            return;
        }
        JSONArray eventList = events.getJSONArray(this.EVENT_LIST_KEY);
        ArrayList<EventBO> es = new ArrayList<EventBO>();
        for (Object object : eventList) {
            EventBO event = (EventBO)JSONObject.parseObject((String)JSONObject.toJSONString(object), EventBO.class);
            if (null != event && null != event.getStartTime()) {
                long startTime = event.getStartTime().getTime();
                long nowLongtime = Calendar.getInstance().getTimeInMillis();
                if (nowLongtime - startTime > this.eventUnti) {
                    log.info("\u65f6\u95f4\u8d85\u8fc710\u5206\u949f\u81ea\u52a8\u653e\u5f03\uff1a{}", (Object)JSONObject.toJSONString((Object)event));
                    continue;
                }
            }
            if (event.getCurrStatus() != null && !"".equals(event.getCurrStatus())) {
                event.setSessionStatus(SessionMap.HS_OCS.hsStatusMapOcsStatus((Integer)event.getCurrStatus()));
            }
            if (event.getLastStatus() != null && !"".equals(event.getLastStatus())) {
                event.setLastSessionStatus(SessionMap.HS_OCS.hsStatusMapOcsStatus((Integer)event.getLastStatus()));
            }
            event.setCurrStatusName(SessionMap.HS_STATUS_NAME.nameAs((Integer)event.getCurrStatus()));
            event.setLastStatusName(SessionMap.HS_STATUS_NAME.nameAs((Integer)event.getLastStatus()));
            es.add(event);
        }
        if (!es.isEmpty()) {
            this.eventAbilityService.dealEvent(es);
        }
    }

    public static void main(String[] args) {
        System.out.println(JSONObject.parseObject((String)"{\"sessionId\": \"90060ea8-d79e-4b64-b063-51513fc32705\",\"platformId\": \"CTI01\",\"eventId\": 13,\"eventClass\": \"StatusChangedEvent\",\"eventName\": \"Notify\",\"eventType\": 3,\"currStatus\": 28,\"lastStatus\": 28,\"reasonCode\": 15,\"reasonDesc\": \"200 OK\",\"startTime\": \"2022-03-03 17:42:26.749\",\"contactId\": \"20220303173757295_1_930_CTI01\",\"oriAni\": \"870074\",\"oriDnis\": \"15559333781\",\"deviceDn\": \"870074\",\"deviceType\": 1,\"channelType\": 1,\"callType\": 1,\"callDirection\": 2,\"callId\": 10327,\"callingParty\": \"10016\",\"calledParty\": \"15559333781\",\"thirdParty\": null,\"otherParty\": \"15559333781\",\"tenantId\": \"1\",\"timestamp\": \"2022-03-03 17:42:26.748\",\"fileName\": null,\"fileDuration\": null,\"recordType\": null,\"ccid\": \"20220303173757280_968_CTI01\",\"ucid\": \"9bb34abc-9ad5-11ec-8ab5-159ffb0d53ea\",\"scid\": \"73232415-1578-123b-54a2-5254005c12c8\",\"headKey\": \"015410\",\"headValue\": \"ACTIVE_OUT\",\"toneResult\": null,\"toneSimilarity\": null,\"asrSpeechResult\": null,\"asrSpeechType\": null,\"asrCompletionCause\": null}", EventBO.class));
    }
}

