/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.isv.service.impl;

import com.tydic.nicc.ocs.cache.WsCache;
import com.tydic.nicc.ocs.handler.bo.EventBO;
import com.tydic.nicc.ocs.isv.service.EventCheckService;
import com.tydic.nicc.ocs.isv.utils.KeyUtil;
import com.tydic.nicc.ocs.mapper.ObEventCheckDAO;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class EventCheckServiceImpl
implements EventCheckService {
    @Resource
    ObEventCheckDAO eventCheckDAO;
    @Autowired
    WsCache wsCache;

    @Override
    public boolean checkEvent(String key) {
        int count = this.eventCheckDAO.select(key);
        if (count > 0) {
            return false;
        }
        this.eventCheckDAO.insertKey(key);
        return true;
    }

    @Override
    public List<EventBO> checkEvents(List<EventBO> eventList) {
        List<Object> results = new ArrayList();
        ArrayList<String> strings = new ArrayList<String>();
        for (EventBO eventBO : eventList) {
            if (null == eventBO) continue;
            Long eventId = eventBO.getEventId();
            String sessionId = eventBO.getSessionId();
            if (StringUtils.isEmpty((Object)eventId) || StringUtils.isEmpty((Object)sessionId)) continue;
            String key = KeyUtil.md5Key(sessionId, eventId);
            eventBO.setSerialNo(key);
            strings.add(key);
        }
        List rs = this.eventCheckDAO.selects(strings);
        if (null == rs || rs.isEmpty()) {
            results = eventList;
        } else {
            for (EventBO eventBO : eventList) {
                if (rs.contains(eventBO.getSerialNo())) continue;
                results.add(eventBO);
            }
        }
        if (!results.isEmpty()) {
            this.eventCheckDAO.insertBatch(results.stream().map(EventBO::getSerialNo).collect(Collectors.toList()));
        }
        return results;
    }

    @Override
    public List<EventBO> checkEventsByCache(List<EventBO> eventList) {
        ArrayList<EventBO> results = new ArrayList<EventBO>();
        for (EventBO eventBO : eventList) {
            if (null == eventBO || StringUtils.isEmpty((Object)eventBO.getEventId()) || StringUtils.isEmpty((Object)eventBO.getSessionId()) || !this.wsCache.isIdempotent(eventBO.getSessionId(), eventBO.getEventId())) continue;
            results.add(eventBO);
        }
        return results;
    }
}

