/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.isv.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.ocs.isv.GainCallRecordService;
import com.tydic.nicc.ocs.isv.bo.CallRecordBO;
import com.tydic.nicc.ocs.isv.service.GainResultsService;
import com.tydic.nicc.ocs.mapper.ObCallRecordMessageDAO;
import com.tydic.nicc.ocs.mapper.po.ObCallRecordMessagePO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class GainResultsServiceImpl
implements GainResultsService {
    private static final Logger log = LoggerFactory.getLogger(GainResultsServiceImpl.class);
    private String RECORD_DATA_KEY = "data";
    @Autowired
    private GainCallRecordService gainCallRecordService;
    @Resource
    private ObCallRecordMessageDAO obCallRecordMessageDAO;
    @Value(value="${replace.target:/data/hisan/record}")
    private String target;
    @Value(value="${replace.replacement:http://192.168.10.182:8080}")
    private String replacement;

    @Override
    public void gainResults(String record, String tenantCode) {
        log.info("\u8fdb\u5165\u5904\u7406recordJson\u6570\u636e\u63a5\u53e3");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (StringUtils.isEmpty((Object)record)) {
            return;
        }
        JSONObject recordJson = (JSONObject)JSONObject.parseObject((String)record, JSONObject.class);
        if (null == recordJson || recordJson.isEmpty()) {
            return;
        }
        if (!recordJson.containsKey((Object)this.RECORD_DATA_KEY)) {
            return;
        }
        JSONArray recordDatas = recordJson.getJSONArray(this.RECORD_DATA_KEY);
        log.info("\u5904\u7406\u5916\u547c\u8bb0\u5f55\u3010{}\u3011\u6761", (Object)recordDatas.size());
        Object taskId = recordJson.get((Object)"taskId");
        Object callType = recordJson.get((Object)"callType");
        Object objTaskType = recordJson.get((Object)"taskType");
        String taskTye = null;
        if (null != objTaskType) {
            taskTye = objTaskType.toString();
        }
        ArrayList<CallRecordBO> callRecordBOS = new ArrayList<CallRecordBO>();
        ArrayList<ObCallRecordMessagePO> messagePOS = new ArrayList<ObCallRecordMessagePO>();
        for (Object object : recordDatas) {
            CallRecordBO recordBO = (CallRecordBO)JSONObject.parseObject((String)JSONObject.toJSONString(object), CallRecordBO.class);
            ObCallRecordMessagePO messagePO = (ObCallRecordMessagePO)JSONObject.parseObject((String)JSONObject.toJSONString(object), ObCallRecordMessagePO.class);
            messagePO.setGmtTime(format.format(new Date()));
            messagePO.setTenantCode(tenantCode);
            messagePOS.add(messagePO);
            recordBO.setRecordUrl(!StringUtils.isEmpty((Object)recordBO.getRecordUrl()) ? recordBO.getRecordUrl().replace(this.target, this.replacement) : null);
            recordBO.setCallType(callType.toString());
            recordBO.setCallTaskId(taskId.toString());
            recordBO.setStartTime(messagePO.getStartTime());
            recordBO.setEndTime(messagePO.getEndTime());
            recordBO.setContactLength(messagePO.getDuration().toString());
            callRecordBOS.add(recordBO);
        }
        if (messagePOS != null && messagePOS.size() > 0) {
            log.info("\u8bb0\u5f55\u539f\u59cb\u5916\u547c\u8bb0\u5f55\u6570\u636eMapper\u5c42\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString(messagePOS));
            this.obCallRecordMessageDAO.inserts(messagePOS);
        }
        this.gainCallRecordService.insertCallRecord(tenantCode, taskTye, callRecordBOS);
    }
}

