/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.ocs.isv.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.ocs.bo.SessionBO;
import com.tydic.nicc.ocs.busi.SessionInfoService;
import com.tydic.nicc.ocs.cache.WsCache;
import com.tydic.nicc.ocs.handler.DoEventService;
import com.tydic.nicc.ocs.handler.bo.EventBO;
import com.tydic.nicc.ocs.handler.bo.UserJoinInfoBO;
import com.tydic.nicc.ocs.isv.dto.EventDTO;
import com.tydic.nicc.ocs.isv.service.EventCheckService;
import com.tydic.nicc.ocs.isv.service.IsvEventService;
import com.tydic.nicc.ocs.isv.utils.KeyUtil;
import com.tydic.nicc.ocs.utils.SessionMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class IsvEventServiceImpl
implements IsvEventService {
    private static final Logger log = LoggerFactory.getLogger(IsvEventServiceImpl.class);
    @Resource
    EventCheckService eventCheckService;
    @Resource
    DoEventService doEventService;
    @Resource
    WsCache wsCache;
    private static final String STATUS_CHANGED_EVENT_VALUE = "StatusChangedEvent";
    private static final String HEAD_KEY_YC = "X-wetalk-customId";
    @Autowired
    private SessionInfoService sessionService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doEvent(EventDTO eventDTO) {
        long current2;
        long current0;
        long current;
        block12: {
            if (null == eventDTO || null == eventDTO.getEventList()) {
                return;
            }
            current = 0L;
            current0 = 0L;
            List<EventBO> eventList = eventDTO.getEventList();
            long current1 = System.currentTimeMillis();
            ArrayList<SessionBO> sessionList = new ArrayList<SessionBO>();
            ArrayList<EventBO> activeList = new ArrayList<EventBO>();
            List<EventBO> eventCheakedList = this.eventCheckService.checkEventsByCache(eventList);
            current += System.currentTimeMillis() - current1;
            if (null == eventCheakedList && eventCheakedList.isEmpty()) {
                return;
            }
            for (EventBO event : eventCheakedList) {
                try {
                    if (!StringUtils.isEmpty((Object)event.getCurrStatus())) {
                        event.setSessionStatus(SessionMap.HS_OCS.hsStatusMapOcsStatus((Integer)event.getCurrStatus()));
                    }
                    if (!StringUtils.isEmpty((Object)event.getLastStatus())) {
                        event.setLastSessionStatus(SessionMap.HS_OCS.hsStatusMapOcsStatus((Integer)event.getLastStatus()));
                    }
                    event.setCurrStatusName(SessionMap.HS_STATUS_NAME.nameAs((Integer)event.getCurrStatus()));
                    event.setLastStatusName(SessionMap.HS_STATUS_NAME.nameAs((Integer)event.getLastStatus()));
                    long current22 = System.currentTimeMillis();
                    this.pushEvent(event);
                    current0 += System.currentTimeMillis() - current22;
                    sessionList.add(this.packSessionBO(event));
                    if (STATUS_CHANGED_EVENT_VALUE.equals(event.getEventClass()) || null == event.getHeadKey() || HEAD_KEY_YC.equals(event.getHeadKey())) continue;
                    activeList.add(event);
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException && "0991".equals(e.getMessage())) {
                        return;
                    }
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            current2 = System.currentTimeMillis();
            try {
                if (null == sessionList || sessionList.isEmpty()) break block12;
                this.sessionService.insertSessionList(sessionList, activeList);
            }
            catch (Exception e) {
                try {
                    log.error(e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    log.info("eventCheckService.checkEvent :{}ms,pushEvent :{}ms,insertSessionList:{}ms", new Object[]{current, current0, System.currentTimeMillis() - current2});
                    throw throwable;
                }
                log.info("eventCheckService.checkEvent :{}ms,pushEvent :{}ms,insertSessionList:{}ms", new Object[]{current, current0, System.currentTimeMillis() - current2});
            }
        }
        log.info("eventCheckService.checkEvent :{}ms,pushEvent :{}ms,insertSessionList:{}ms", new Object[]{current, current0, System.currentTimeMillis() - current2});
    }

    private SessionBO packSessionBO(EventBO event) {
        String ctiSessionID = event.getSessionId();
        String joinTaskID = null;
        String sessionKey = null;
        UserJoinInfoBO userJoinInfoBO = null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)ctiSessionID)) {
            joinTaskID = this.wsCache.getTaskByCti(ctiSessionID);
            sessionKey = this.wsCache.getSessionIdByCti(ctiSessionID);
            userJoinInfoBO = this.wsCache.getUserLinkedInfo(event.getAgentId());
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty(joinTaskID) && null != userJoinInfoBO) {
            joinTaskID = userJoinInfoBO.getJoinTaskID();
        }
        SessionBO session = new SessionBO();
        session.setJoinTaskID(joinTaskID);
        session.setCtiSessionTime(event.getStartTime());
        session.setSessionStatus(event.getSessionStatus());
        session.setSessionId(sessionKey);
        if (null != userJoinInfoBO) {
            session.setTenantCode(userJoinInfoBO.getTenantCode());
        }
        session.setLastSessionStatusName(event.getLastStatusName());
        session.setSessionStatusName(session.getSessionStatusName());
        session.setCitSeesionID(ctiSessionID);
        session.setSessionStatus(event.getSessionStatus());
        session.setJobCode(event.getAgentId());
        session.setSessionStatusName(event.getCurrStatusName());
        session.setCtiSessionTime(null == event.getStartTime() ? new Date() : event.getStartTime());
        return session;
    }

    private void pushEvent(EventBO eventBO) {
        try {
            if (!StringUtils.isEmpty((Object)eventBO.getEventClass())) {
                if (STATUS_CHANGED_EVENT_VALUE.equals(eventBO.getEventClass())) {
                    this.doEventService.doEvent(eventBO);
                }
            } else {
                log.debug("Unknown event :{},event body :{}", (Object)eventBO.getEventClass(), (Object)JSONObject.toJSONString((Object)eventBO));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void main(String[] args) {
        String sessionId = "e3fa7c20-1234-4a50-a4ea-06c95a4c2ef5";
        long eventId = 10L;
        long cu = System.currentTimeMillis();
        for (int i = 0; i < 100; ++i) {
            KeyUtil.md5Key(sessionId, eventId);
        }
        System.out.println(System.currentTimeMillis() - cu);
    }
}

