/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.scoket.nettyscoket.server;

import com.tydic.nicc.scoket.nettyscoket.server.WebSocketChannelInitializer;
import com.tydic.nicc.scoket.nettyscoket.server.config.NettyScoketServerConfig;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.Future;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyWebScoketServer
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(NettyWebScoketServer.class);
    private WebSocketChannelInitializer webSocketChannelInitializer;
    private NettyScoketServerConfig nettyScoketServerConfig;
    private ChannelFuture serverChannelFuture;
    private EventLoopGroup bossGroup;
    private EventLoopGroup wokerGroup;

    public NettyWebScoketServer(WebSocketChannelInitializer webSocketChannelInitializer, NettyScoketServerConfig nettyScoketServerConfig) {
        this.webSocketChannelInitializer = webSocketChannelInitializer;
        this.nettyScoketServerConfig = nettyScoketServerConfig;
    }

    public void run() {
        this.startServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startServer() {
        this.bossGroup = new NioEventLoopGroup();
        this.wokerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap serverBootstrap = new ServerBootstrap();
            long begin = System.currentTimeMillis();
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)serverBootstrap.group(this.bossGroup, this.wokerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).option(ChannelOption.TCP_NODELAY, (Object)this.nettyScoketServerConfig.getTcpNodelay())).option(ChannelOption.SO_BACKLOG, (Object)this.nettyScoketServerConfig.getSoBacklog())).childOption(ChannelOption.SO_KEEPALIVE, (Object)this.nettyScoketServerConfig.getSoKeepalive()).childHandler((ChannelHandler)this.webSocketChannelInitializer);
            long end = System.currentTimeMillis();
            logger.info("Netty Websocket\u670d\u52a1\u5668\u542f\u52a8\u5b8c\u6210\uff0c\u8017\u65f6 " + (end - begin) + " ms\uff0c\u5df2\u7ed1\u5b9a\u7aef\u53e3 " + this.nettyScoketServerConfig.getScketPort() + " \u7b49\u5f85\u5ba2\u6237\u7aef\u8fde\u63a5");
            this.serverChannelFuture = serverBootstrap.bind((SocketAddress)new InetSocketAddress(this.nettyScoketServerConfig.getScketPort())).sync();
            this.serverChannelFuture.channel().closeFuture().sync();
        }
        catch (Exception e) {
            logger.error("Server Exceprion:" + e);
        }
        finally {
            this.bossGroup.shutdownGracefully();
            this.wokerGroup.shutdownGracefully();
        }
    }

    public void closeServer() {
        this.serverChannelFuture.channel().close();
        Future bossGroupFuture = this.bossGroup.shutdownGracefully();
        Future workerGroupFuture = this.wokerGroup.shutdownGracefully();
        try {
            bossGroupFuture.await();
            workerGroupFuture.await();
        }
        catch (InterruptedException ignore) {
            ignore.printStackTrace();
        }
    }
}

