/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.unicom_broadband.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import com.tydic.nicc.dc.boot.starter.util.FileUtils;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import com.tydic.nicc.unicom_broadband.api.BroadBandApi;
import com.tydic.nicc.unicom_broadband.api.bo.StatBO;
import com.tydic.nicc.unicom_broadband.api.bo.StatReqBO;
import com.tydic.nicc.unicom_broadband.mapper.ExecSql;
import com.tydic.nicc.unicom_broadband.mapper.StatDao;
import com.tydic.nicc.unicom_broadband.mapper.po.CityPO;
import com.tydic.nicc.unicom_broadband.mapper.po.ProvCodePO;
import com.tydic.nicc.unicom_broadband.mapper.po.StatReqPO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@DS(value="nicc-im")
@Service
public class BroadBandSerivceImpl
implements BroadBandApi {
    private static final Logger log = LoggerFactory.getLogger(BroadBandSerivceImpl.class);
    @Resource
    private StatDao statDao;
    @Resource
    private ExecSql execSql;
    private String sqlFilePath;

    public void execSqlTask() {
        String[] sqls;
        String s = "";
        try {
            s = FileUtils.readFileContent((String)this.sqlFilePath);
        }
        catch (IOException e) {
            log.error("error ", (Throwable)e);
        }
        if (StringUtils.isEmpty((CharSequence)s)) {
            log.error("error : {}", (Object)"get sql file failure!");
            return;
        }
        Date var1 = new Date();
        Date var2 = DateTimeUtil.DateAddDayOfYear((int)-1);
        String startTime = DateTimeUtil.getTimeShortString((Date)var1, (String)"yyyy-MM-dd 00:00:00");
        String endTime = DateTimeUtil.getTimeShortString((Date)var2, (String)"yyyy-MM-dd 00:00:00");
        s = s.replace("startTime", startTime);
        s = s.replace("endTime", endTime);
        log.info("sql :{}", (Object)s);
        for (String sql : sqls = s.split(";")) {
            this.execSql.execSql(sql);
        }
        log.info("sql execute finish!");
    }

    public RspList queryLeaveMsgStat(StatReqBO reqBO) {
        log.info("entrance [queryLeaveMsgStat] params :{}", (Object)JSON.toJSONString((Object)reqBO));
        StatReqPO reqPO = new StatReqPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)reqPO);
        if (StringUtils.isEmpty((CharSequence)reqBO.getStartDate())) {
            reqPO.setStartDate(DateTimeUtil.getTimeShortString((Date)new Date(), (String)"yyyyMMdd"));
        } else {
            reqPO.setStartDate(DateTimeUtil.getTimeShortString((Date)DateTimeUtil.convertAsDate((String)reqPO.getStartDate()), (String)"yyyyMMdd"));
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getEndDate())) {
            reqPO.setEndDate(DateTimeUtil.getTimeShortString((Date)new Date(), (String)"yyyyMMdd"));
        } else {
            reqPO.setEndDate(DateTimeUtil.getTimeShortString((Date)DateTimeUtil.convertAsDate((String)reqPO.getEndDate()), (String)"yyyyMMdd"));
        }
        ArrayList bos = new ArrayList();
        Page page = PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
        this.statDao.queryStat(reqPO);
        NiccCommonUtil.copyList((List)page.getResult(), bos, StatBO.class);
        return BaseRspUtils.createSuccessRspList(bos, (long)page.getTotal());
    }

    public RspList queryProv() {
        List<ProvCodePO> provCodePOS = this.statDao.selectProv();
        return BaseRspUtils.createSuccessRspList(provCodePOS);
    }

    public RspList queryCity() {
        List<CityPO> cityPOS = this.statDao.selectCity();
        return BaseRspUtils.createSuccessRspList(cityPOS);
    }
}

