/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.unicom_broadband.service.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import com.tydic.nicc.common.bo.im.es.ImMessageEsDocument;
import com.tydic.nicc.common.eums.user.UserTypeField;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import com.tydic.nicc.imes.api.bo.UnicomImHistoryQueryReqBO;
import com.tydic.nicc.imes.api.report.ImMessageEsReportApi;
import com.tydic.nicc.unicom_broadband.api.ChatRecordService;
import com.tydic.nicc.unicom_broadband.api.bo.ChatHistoryBO;
import com.tydic.nicc.unicom_broadband.api.bo.ChatRecord;
import com.tydic.nicc.unicom_broadband.api.bo.CsUserInfo;
import com.tydic.nicc.unicom_broadband.api.bo.CustUserInfo;
import com.tydic.nicc.unicom_broadband.api.bo.HistoryReq;
import com.tydic.nicc.unicom_broadband.mapper.ChatRecordMapper;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ChatRecordServiceImpl
implements ChatRecordService {
    private static final Logger log = LoggerFactory.getLogger(ChatRecordServiceImpl.class);
    @Resource
    private ChatRecordMapper chatRecordMapper;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", check=false)
    private ImMessageEsReportApi imMessageEsReportApi;

    public RspList<ChatHistoryBO> history(HistoryReq req) {
        Page res = PageHelper.startPage((int)req.getPage(), (int)req.getLimit());
        long a = System.currentTimeMillis();
        this.chatRecordMapper.qryRange(req);
        long b = System.currentTimeMillis();
        log.info("\u4f1a\u8bdd\u5386\u53f2\u67e5\u8be2 \u67e5\u8be2\u8303\u56f4\uff1a{}/ms", (Object)(b - a));
        List range = res.getResult();
        if (CollectionUtils.isEmpty((Collection)range)) {
            return BaseRspUtils.createSuccessRspList(new ArrayList());
        }
        Map head = (Map)range.get(0);
        Map tail = (Map)range.get(range.size() - 1);
        String headCsUserId = (String)head.get("csUserId") + (String)head.get("custUserId") + (String)head.get("channel_code");
        String tailCsUserId = (String)tail.get("csUserId") + (String)tail.get("custUserId") + (String)tail.get("channel_code");
        req.setConcatHeadUserId(headCsUserId);
        req.setConcatTailUserId(tailCsUserId);
        a = System.currentTimeMillis();
        List<Map> list = this.chatRecordMapper.qryChatHistory(req);
        b = System.currentTimeMillis();
        log.info("\u4f1a\u8bdd\u5386\u53f2\u67e5\u8be2 \u67e5\u8be2\u8303\u56f4\u5185\u6240\u6709\u6570\u636e\uff1a{}/ms", (Object)(b - a));
        a = System.currentTimeMillis();
        List<ChatHistoryBO> row = this.convertChatRecord(list);
        b = System.currentTimeMillis();
        log.info("\u4f1a\u8bdd\u5386\u53f2\u67e5\u8be2 \u8f6c\u6362\u683c\u5f0f\uff1a{}/ms", (Object)(b - a));
        return BaseRspUtils.createSuccessRspList(row, (long)res.getTotal());
    }

    public RspList<ChatHistoryBO> getHistoryList(UnicomImHistoryQueryReqBO queryReqBO) {
        log.info("\u5386\u53f2\u4f1a\u8bdd\u67e5\u8be2:{}", (Object)queryReqBO);
        if (ObjectUtils.allNotNull((Object[])new Object[]{queryReqBO.getStartDate(), queryReqBO.getEndDate()})) {
            long rangeTime = queryReqBO.getEndDate().getTime() - queryReqBO.getStartDate().getTime();
            ArrayList historyBOS = Lists.newArrayList();
            queryReqBO.setPage(1);
            queryReqBO.setLimit(2000);
            ArrayList documents = Lists.newArrayList();
            this.getAllDocuments(documents, queryReqBO);
            Map<String, List<ImMessageEsDocument>> listMap = documents.stream().collect(Collectors.groupingBy(ImMessageEsDocument::getC2cKey));
            listMap.forEach((c2cKey, imMessageEsDocuments) -> {
                ImMessageEsDocument document = (ImMessageEsDocument)imMessageEsDocuments.get(0);
                ChatHistoryBO historyBO = new ChatHistoryBO();
                historyBO.setC2cKey(c2cKey);
                CsUserInfo csInfo = new CsUserInfo();
                CustUserInfo custInfo = new CustUserInfo();
                custInfo.setUserName(document.getUserName());
                csInfo.setUserName(document.getCsName());
                csInfo.setProvince(document.getProvince());
                csInfo.setCity(document.getCity());
                csInfo.setChannelCode(document.getGroup());
                if (UserTypeField.USER.getIntCode().equals(document.getFromType())) {
                    custInfo.setUserId(document.getFromNo());
                    csInfo.setUserId(document.getToNo());
                } else {
                    custInfo.setUserId(document.getToNo());
                    csInfo.setUserId(document.getFromNo());
                }
                historyBO.setCsUserInfo(csInfo);
                historyBO.setCustUserInfo(custInfo);
                historyBO.setMsgList(this.parseMsgList((List<ImMessageEsDocument>)imMessageEsDocuments));
                historyBOS.add(historyBO);
            });
            return BaseRspUtils.createSuccessRspList((List)historyBOS);
        }
        return BaseRspUtils.createErrorRspList((String)"\u8bf7\u9009\u62e9\u67e5\u8be2\u65e5\u671f!");
    }

    private final List<ChatRecord> parseMsgList(List<ImMessageEsDocument> docs) {
        ArrayList list = Lists.newArrayList();
        for (ImMessageEsDocument doc : docs) {
            ChatRecord chatRecord = new ChatRecord();
            chatRecord.setChatKey(doc.getChatKey());
            chatRecord.setMsgForm(String.valueOf(doc.getMsgForm()));
            chatRecord.setSessionId(doc.getSessionId());
            chatRecord.setFromNo(doc.getFromNo());
            chatRecord.setToNo(doc.getToNo());
            chatRecord.setChannelCode(doc.getChannelCode());
            chatRecord.setMsgTime(String.valueOf(doc.getMsgTime().getTime()));
            chatRecord.setMsgId(doc.getMsgId());
            chatRecord.setMsgContent(doc.getMsgContent());
            list.add(chatRecord);
        }
        return list;
    }

    private List<ImMessageEsDocument> getAllDocuments(List<ImMessageEsDocument> documents, UnicomImHistoryQueryReqBO queryReqBO) {
        RspList imMsgDocumentRspList = this.imMessageEsReportApi.getUnicomHistory(queryReqBO);
        documents.addAll(imMsgDocumentRspList.getRows());
        if (imMsgDocumentRspList.isSuccess() && (long)documents.size() < imMsgDocumentRspList.getCount()) {
            queryReqBO.setPage(queryReqBO.getPage() + 1);
            this.getAllDocuments(documents, queryReqBO);
        }
        return documents;
    }

    private List<ChatHistoryBO> convertChatRecord(List<Map> list) {
        ArrayList<ChatHistoryBO> rstList = new ArrayList<ChatHistoryBO>();
        String csUserId = "";
        String custUserId = "";
        String channelCode = "";
        ChatHistoryBO history = null;
        Map map = null;
        for (int i = 0; i < list.size(); ++i) {
            map = list.get(i);
            if (!(csUserId.equals(map.get("csUserId")) && custUserId.equals(map.get("custUserId")) && channelCode.equals(map.get("channel_code")))) {
                csUserId = (String)map.get("csUserId");
                custUserId = (String)map.get("custUserId");
                channelCode = (String)map.get("channel_code");
                history = new ChatHistoryBO();
                CsUserInfo csUserInfo = new CsUserInfo();
                csUserInfo.setUserId(csUserId);
                csUserInfo.setChannelCode((String)map.get("channel_code"));
                csUserInfo.setCity((String)map.get("city"));
                csUserInfo.setExtUid((String)map.get("csExtUid"));
                csUserInfo.setProvince((String)map.get("province"));
                csUserInfo.setUserName((String)map.get("csUserName"));
                history.setCsUserInfo(csUserInfo);
                CustUserInfo custUserInfo = new CustUserInfo();
                custUserInfo.setUserId(custUserId);
                custUserInfo.setExtUid((String)map.get("custExtUid"));
                custUserInfo.setUserName((String)map.get("custUserName"));
                history.setCustUserInfo(custUserInfo);
                history.setMsgList(new ArrayList());
                rstList.add(history);
            }
            ChatRecord record = new ChatRecord();
            record.setChatKey((String)map.get("chat_key"));
            record.setFromNo((String)map.get("from_no"));
            record.setMsgContent((String)map.get("msg_content"));
            record.setMsgForm(map.get("msg_form").toString());
            record.setMsgId((String)map.get("msg_id"));
            record.setMsgTime(DateTimeUtil.getTimeShortString((Date)new Date(((Timestamp)map.get("msg_time")).getTime()), (String)"yyyy-MM-dd HH:mm:ss"));
            record.setSessionId((String)map.get("info_session_id"));
            record.setToNo((String)map.get("to_no"));
            history.getMsgList().add(record);
        }
        return rstList;
    }
}

