/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.unicom_broadband.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.unicom_broadband.Utils.BroadUtils;
import com.tydic.nicc.unicom_broadband.api.ChatStscService;
import com.tydic.nicc.unicom_broadband.api.bo.ChatStscBO;
import com.tydic.nicc.unicom_broadband.api.bo.ChatStscReq;
import com.tydic.nicc.unicom_broadband.mapper.ChatStscMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@DS(value="broadband_read_db")
public class ChatStscServiceImpl
implements ChatStscService {
    private static final Logger log = LoggerFactory.getLogger(ChatStscServiceImpl.class);
    @Resource
    ChatStscMapper chatStscMapper;

    public RspList<ChatStscBO> chatStsc(ChatStscReq req) {
        String convertRes;
        String channelType = req.getChannelType();
        if (StringUtils.isEmpty((CharSequence)channelType)) {
            return BaseRspUtils.createErrorRspList((String)"channelType \u4e0d\u5f97\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)req.getChannelCode()) && StringUtils.isNotEmpty((CharSequence)(convertRes = BroadUtils.convertChannelType(channelType)))) {
            req.setChannelCode(convertRes);
        }
        String tableName = "10".equals(channelType) ? "cs_kuandai" : "cs_chaojiban";
        Page res = PageHelper.startPage((int)req.getPage(), (int)req.getLimit());
        this.chatStscMapper.complexQuery(req);
        ArrayList<ChatStscBO> chatStscList = res.getResult();
        if (chatStscList == null || chatStscList.isEmpty()) {
            chatStscList = new ArrayList<ChatStscBO>();
        } else {
            List<Map> list = this.chatStscMapper.qryUnreplyLevel(req);
            this.fillUnreplyData(chatStscList, list, channelType);
        }
        return BaseRspUtils.createSuccessRspList(chatStscList, (long)res.getTotal());
    }

    private void fillUnreplyData(List<ChatStscBO> stscList, List<Map> unreplyList, String channelType) {
        int i;
        if (unreplyList == null || unreplyList.isEmpty()) {
            return;
        }
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
        for (i = 0; i < stscList.size(); ++i) {
            indexMap.put(stscList.get(i).getUserId() + "_" + stscList.get(i).getChannelCode(), i);
        }
        block13: for (i = 0; i < unreplyList.size(); ++i) {
            Map map = unreplyList.get(i);
            String key = map.get("cs_uid") + "_" + map.get("channel_code");
            String unreplyLevel = (String)map.get("unreply_level");
            Object o = indexMap.get(key);
            if (ObjectUtils.isEmpty(o)) continue;
            ChatStscBO bo = stscList.get((Integer)o);
            String channelCode = bo.getChannelCode();
            String convertRes = BroadUtils.convertChannelType(channelType);
            if (StringUtils.isNotEmpty((CharSequence)channelCode) && StringUtils.isNotEmpty((CharSequence)convertRes) && channelCode.toUpperCase().contains(convertRes)) {
                bo.setChannelType(channelType);
            }
            switch (unreplyLevel) {
                case "1m": {
                    bo.setUnreplyCountIn1Minute(Integer.valueOf(Integer.parseInt(map.get("mcount").toString())));
                    bo.setUnreplyRateIn1Minute(Double.valueOf((double)bo.getUnreplyCountIn1Minute().intValue() * 100.0 / (double)bo.getTotalUserMsgCount().intValue()));
                    continue block13;
                }
                case "5m": {
                    bo.setUnreplyCountIn5Minute(Integer.valueOf(Integer.parseInt(map.get("mcount").toString())));
                    bo.setUnreplyRateIn5Minute(Double.valueOf((double)bo.getUnreplyCountIn5Minute().intValue() * 100.0 / (double)bo.getTotalUserMsgCount().intValue()));
                    continue block13;
                }
                case "15m": {
                    bo.setUnreplyCountIn15Minute(Integer.valueOf(Integer.parseInt(map.get("mcount").toString())));
                    bo.setUnreplyRateIn15Minute(Double.valueOf((double)bo.getUnreplyCountIn15Minute().intValue() * 100.0 / (double)bo.getTotalUserMsgCount().intValue()));
                    continue block13;
                }
                case "24h": {
                    bo.setUnreplyCountIn24Hour(Integer.valueOf(Integer.parseInt(map.get("mcount").toString())));
                    bo.setUnreplyRateIn24Hour(Double.valueOf((double)bo.getUnreplyCountIn24Hour().intValue() * 100.0 / (double)bo.getTotalUserMsgCount().intValue()));
                    continue block13;
                }
            }
        }
    }

    public RspList qryIndex(ChatStscReq req) {
        String channelType = req.getChannelType();
        if (StringUtils.isEmpty((CharSequence)channelType)) {
            return BaseRspUtils.createErrorRspList((String)"channelType \u4e0d\u5f97\u4e3a\u7a7a");
        }
        String convertRes = BroadUtils.convertChannelType(channelType);
        if (StringUtils.isEmpty((CharSequence)req.getChannelCode()) && StringUtils.isNotEmpty((CharSequence)convertRes)) {
            req.setChannelCode(convertRes);
        }
        Page res = PageHelper.startPage((int)req.getPage(), (int)req.getLimit());
        this.chatStscMapper.qryIndex(req);
        List result = res.getResult();
        if (CollectionUtils.isEmpty((Collection)result)) {
            return BaseRspUtils.createSuccessRspList(new ArrayList());
        }
        for (Map map : result) {
            String channelCode = (String)map.get("channelCode");
            if (!StringUtils.isNotEmpty((CharSequence)channelCode) || !StringUtils.isNotEmpty((CharSequence)convertRes) || !channelCode.toUpperCase().contains(convertRes)) continue;
            map.put("channelType", channelType);
        }
        return BaseRspUtils.createSuccessRspList((List)result, (long)res.getTotal());
    }
}

