/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.unicom_broadband.timetask;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.tydic.nicc.dc.boot.starter.entity.RedisLockEntity;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import com.tydic.nicc.dc.boot.starter.util.FileUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.unicom_broadband.api.bo.ChatStscReq;
import com.tydic.nicc.unicom_broadband.mapper.ChatStscMapper;
import com.tydic.nicc.unicom_broadband.mapper.ExecSql;
import com.tydic.nicc.unicom_broadband.mapper.po.SimpleChatRecordPO;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@DS(value="broadband_write_db")
public class ChatStscTask {
    private static final Logger log = LoggerFactory.getLogger(ChatStscTask.class);
    private static final String SYNC_CHAR_RECORD_CHECK_LOCK_KEY = "SYNC_CHAR_RECORD_CHECK_LOCK";
    private static final String CAL_CHAT_REPLY_INDEX_CHECK_LOCK_KEY = "CAL_CHAT_REPLY_INDEX_CHECK_LOCK";
    private static final String CAL_UNREPLY_CHAT_RECORDS_CHECK_LOCK_KEY = "CAL_UNREPLY_CHAT_RECORDS_CHECK_LOCK";
    @Resource
    ChatStscMapper chatStscMapper;
    @Resource
    private RedisHelper redisHelper;
    @Resource
    ExecSql execSql;
    @Value(value="${exec.sql.path}")
    private String sqlFilePath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="0 */5 * * * ?")
    public void syncCharRecord() {
        RedisLockEntity redisLockEntity = RedisLockEntity.builder().lockKey(SYNC_CHAR_RECORD_CHECK_LOCK_KEY).requestId(IdWorker.nextAutoIdStr()).build();
        boolean locked = this.redisHelper.lock(redisLockEntity, 0L, 30L);
        if (locked) {
            try {
                log.info("\u7559\u8a00\u56de\u590d5min\u4efb\u52a1\u5f00\u59cb\u6267\u884c...");
                ChatStscReq req = new ChatStscReq();
                String[] dateTimePairs = this.getDateTimePairsByMinute(-5);
                req.setTenantCode("9999");
                req.setStartDate(dateTimePairs[0]);
                req.setEndDate(dateTimePairs[1]);
                log.info("\u540c\u6b65\u4f1a\u8bdd\u8bb0\u5f55\u5f00\u59cb\uff0c\u5f00\u59cb\u65f6\u95f4{},\u7ed3\u675f\u65f6\u95f4{}", (Object)dateTimePairs[0], (Object)dateTimePairs[1]);
                long currMills = System.currentTimeMillis();
                int rst = this.chatStscMapper.copyChatRecord(req);
                log.info("\u540c\u6b65\u4f1a\u8bdd\u8bb0\u5f55\u7ed3\u675f\uff0c\u5f00\u59cb\u65f6\u95f4{},\u7ed3\u675f\u65f6\u95f4{},\u540c\u6b65\u6570\u636e\u6761\u6570{},\u8017\u65f6{}ms", new Object[]{dateTimePairs[0], dateTimePairs[1], rst, System.currentTimeMillis() - currMills});
            }
            catch (Exception e) {
                log.error("\u540c\u6b65\u4f1a\u8bdd\u8bb0\u5f55\u5f02\u5e38:", (Throwable)e);
            }
            finally {
                this.redisHelper.unlockLua(redisLockEntity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="30 40 2 * * ?")
    public void calChatReplyIndex() {
        RedisLockEntity redisLockEntity = RedisLockEntity.builder().lockKey(CAL_CHAT_REPLY_INDEX_CHECK_LOCK_KEY).requestId(IdWorker.nextAutoIdStr()).build();
        boolean locked = this.redisHelper.lock(redisLockEntity);
        if (locked) {
            log.info("\u8ba1\u7b97\u804a\u5929\u56de\u590d\u4efb\u52a1\u5f00\u59cb\u6267\u884c...");
            try {
                String[] sqls;
                String s = "";
                try {
                    s = FileUtils.readFileContent((String)this.sqlFilePath);
                }
                catch (IOException e) {
                    log.error("error ", (Throwable)e);
                    throw e;
                }
                if (StringUtils.isEmpty((CharSequence)s)) {
                    log.error("error : {}", (Object)"get sql file failure!");
                    return;
                }
                Date var1 = new Date();
                Date var2 = DateTimeUtil.DateAddDayOfYear((int)-1);
                String currDate = DateTimeUtil.getTimeShortString((Date)var1, (String)"yyyyMMdd");
                String ststDate = DateTimeUtil.getTimeShortString((Date)var2, (String)"yyyyMMdd");
                s = s.replaceAll("\\$currDate", currDate);
                s = s.replaceAll("\\$ststDate", ststDate);
                log.info("sql :{}", (Object)s);
                for (String sql : sqls = s.split(";")) {
                    this.execSql.execSql(sql);
                }
                log.info("sql execute finish!");
            }
            catch (IOException e) {
                log.error("\u8ba1\u7b97\u804a\u5929\u56de\u590d\u4efb\u52a1\u5f02\u5e38:", (Throwable)e);
            }
            finally {
                this.redisHelper.unlockLua(redisLockEntity);
            }
        }
    }

    private String[] getDateTimePairsByMinute(int interval) {
        long currMills = System.currentTimeMillis();
        if (interval < 0) {
            return new String[]{DateTimeUtil.getTimeShortString((Date)new Date(currMills + (long)(2 * interval) * 60L * 1000L), (String)"yyyy-MM-dd HH:mm"), DateTimeUtil.getTimeShortString((Date)new Date(currMills + (long)interval * 60L * 1000L), (String)"yyyy-MM-dd HH:mm")};
        }
        return new String[]{DateTimeUtil.getTimeShortString((Date)new Date(currMills + (long)interval * 60L * 1000L), (String)"yyyy-MM-dd HH:mm"), DateTimeUtil.getTimeShortString((Date)new Date(currMills + (long)(2 * interval) * 60L * 1000L), (String)"yyyy-MM-dd HH:mm")};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="0 */10 * * * ?")
    public void calUnreplyChatRecords() {
        RedisLockEntity redisLockEntity = RedisLockEntity.builder().lockKey(CAL_UNREPLY_CHAT_RECORDS_CHECK_LOCK_KEY).requestId(IdWorker.nextAutoIdStr()).build();
        boolean locked = this.redisHelper.lock(redisLockEntity);
        if (locked) {
            try {
                log.info("\u7559\u8a00\u56de\u590d10min\u4efb\u52a1\u5f00\u59cb\u6267\u884c...");
                ChatStscReq req = new ChatStscReq();
                req.setStartDate(this.getDateTimePairsByMinute(-1440)[1]);
                req.setEndDate(this.getDateTimePairsByMinute(-5)[1]);
                Date compareDate = null;
                Date cacheDate = null;
                try {
                    cacheDate = compareDate = new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(req.getEndDate());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    log.error("\u4f1a\u8bdd\u7559\u8a00\u56de\u590d \u65f6\u95f4\u8f6c\u6362\u9519\u8bef\uff1a", (Throwable)e);
                }
                log.info("\u8ba1\u7b97\u672a\u8bfb\u6570\u636e\u5f00\u59cb\uff0c\u5f00\u59cb\u65f6\u95f4{},\u7ed3\u675f\u65f6\u95f4{}", (Object)req.getStartDate(), (Object)req.getEndDate());
                long currMills = System.currentTimeMillis();
                List<SimpleChatRecordPO> list = this.chatStscMapper.selectUnreplyMsg(req);
                HashMap<String, SimpleChatRecordPO> map = new HashMap<String, SimpleChatRecordPO>();
                HashMap<String, List<SimpleChatRecordPO>> tmpMsgMap = new HashMap<String, List<SimpleChatRecordPO>>();
                SimpleChatRecordPO po = null;
                String chatKey = null;
                for (int i = 0; i < list.size(); ++i) {
                    po = list.get(i);
                    chatKey = po.getCsUid() + "_" + po.getUserId();
                    if (!map.containsKey(chatKey)) {
                        map.put(chatKey, po);
                        tmpMsgMap.put(chatKey, new ArrayList());
                        this.doUnreply(map, tmpMsgMap, po, chatKey, compareDate);
                        continue;
                    }
                    if (((SimpleChatRecordPO)map.get(chatKey)).getFromType().equals(po.getFromType())) {
                        this.doUnreply(map, tmpMsgMap, po, chatKey, compareDate);
                        continue;
                    }
                    compareDate = po.getMsgTime();
                    this.doReply(map, tmpMsgMap, po, chatKey, compareDate);
                    compareDate = cacheDate;
                }
                this.updAllUnreply(tmpMsgMap, compareDate);
                log.info("\u8ba1\u7b97\u672a\u8bfb\u6570\u636e\u7ed3\u675f\uff0c\u5f00\u59cb\u65f6\u95f4{},\u7ed3\u675f\u65f6\u95f4{},\u8ba1\u7b97\u6570\u636e\u6761\u6570{},\u8017\u65f6{}ms", new Object[]{req.getStartDate(), req.getEndDate(), list.size(), System.currentTimeMillis() - currMills});
            }
            catch (Exception e) {
                log.error("\u7559\u8a00\u56de\u590d10min\u4efb\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
            }
            finally {
                this.redisHelper.unlockLua(redisLockEntity);
            }
        }
    }

    private void doUnreply(Map<String, SimpleChatRecordPO> map, Map<String, List<SimpleChatRecordPO>> tmpMsgMap, SimpleChatRecordPO po, String chatKey, Date compareDate) {
        tmpMsgMap.get(chatKey).add(po);
    }

    private void doReply(Map<String, SimpleChatRecordPO> map, Map<String, List<SimpleChatRecordPO>> tmpMsgMap, SimpleChatRecordPO po, String chatKey, Date compareDate) {
        this.updUnreply(tmpMsgMap, chatKey, compareDate, "1");
        if ("2".equals(po.getFromType())) {
            po.setChannelCode(tmpMsgMap.get(chatKey).get(0).getChannelCode());
            this.chatStscMapper.updChannelCode(po.getMsgId(), tmpMsgMap.get(chatKey).get(0).getChannelCode());
        } else {
            tmpMsgMap.get(chatKey).get(0).setChannelCode(po.getChannelCode());
            this.updChannelCode(tmpMsgMap, chatKey);
        }
        this.chatStscMapper.updReplyRecord(po.getMsgId(), po.getMsgTime().getTime() - tmpMsgMap.get(chatKey).get(0).getMsgTime().getTime());
        map.put(chatKey, po);
        tmpMsgMap.get(chatKey).clear();
        this.doUnreply(map, tmpMsgMap, po, chatKey, compareDate);
    }

    private void updUnreply(Map<String, List<SimpleChatRecordPO>> tmpMsgMap, String chatKey, Date compareDate, String hasReply) {
        for (SimpleChatRecordPO tmpPo : tmpMsgMap.get(chatKey)) {
            String unreplyLevel = this.calUnreplyLevel(tmpPo.getMsgTime(), compareDate);
            if ("24h".equals(unreplyLevel)) {
                hasReply = "0";
            }
            this.chatStscMapper.updUnreplyRecord(tmpPo.getMsgId(), hasReply, unreplyLevel);
        }
    }

    private void updChannelCode(Map<String, List<SimpleChatRecordPO>> tmpMsgMap, String chatKey) {
        for (SimpleChatRecordPO tmpPo : tmpMsgMap.get(chatKey)) {
            this.chatStscMapper.updChannelCode(tmpPo.getMsgId(), tmpMsgMap.get(chatKey).get(0).getChannelCode());
        }
    }

    private void updAllUnreply(Map<String, List<SimpleChatRecordPO>> tmpMsgMap, Date compareDate) {
        for (String chatKey : tmpMsgMap.keySet()) {
            this.updUnreply(tmpMsgMap, chatKey, compareDate, "0");
        }
    }

    private String calUnreplyLevel(Date date, Date compareDate) {
        long mills = compareDate.getTime() - date.getTime();
        if (mills <= 60000L) {
            return "";
        }
        if (mills <= 300000L) {
            return "1m";
        }
        if (mills <= 900000L) {
            return "5m";
        }
        if (mills <= 86400000L) {
            return "15m";
        }
        return "24h";
    }
}

