package com.tydic.dyc.agr.model.agrchange.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.agrchange.AgrChngApplyDo;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.model.agrchange.qrybo.*;
import com.tydic.dyc.agr.repository.AgrAgrChngRepository;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 标题:IAgrChngApplyModelImpl
 * 说明:TODO
 * 时间:2022/9/8 11:21
 * 作者:代愿愿
 */
@Service
public class IAgrChngApplyModelImpl implements IAgrChngApplyModel {
    @Autowired
    private AgrAgrChngRepository agrAgrChngRepository;

    @Override
    public void createAgrMainChng(AgrChngApplyDo agrChngApplyDo) {
        //协议变更申请新增
        this.agrAgrChngRepository.saveAgrChngApply(agrChngApplyDo);
        //协议主体变更新增
        this.agrAgrChngRepository.saveAgrMainChng(agrChngApplyDo);
    }

    @Override
    public void updateAgrMainChng(AgrChngApplyDo agrChngApplyDo) {
        //协议变更申请修改
        this.agrAgrChngRepository.updateAgrChngApply(agrChngApplyDo);
        //协议主体变更删除
        this.agrAgrChngRepository.deleteAgrMainChng(agrChngApplyDo);
        //协议主体变更新增
        this.agrAgrChngRepository.saveAgrMainChng(agrChngApplyDo);
    }

    @Override
    public void createAgrChngApply(AgrChngApplyDo agrChngApplyDo) {
        this.agrAgrChngRepository.saveAgrChngApply(agrChngApplyDo);
    }

    @Override
    public void updateAgrChngApply(AgrChngApplyDo agrChngApplyDo) {
        this.agrAgrChngRepository.updateAgrChngApply(agrChngApplyDo);
    }

    @Override
    public void deleteAgrItemChng(AgrChngApplyDo agrChngApplyDo) {
        //入参校验
        this.validationDeleteAgrItemChg(agrChngApplyDo);
        //调用删除协议变更详情
        this.agrAgrChngRepository.deleteAgrItemChng(agrChngApplyDo);
    }

    /**
     * 协议明细变更删除方法入参检验
     * @param agrChngApplyDo agrChngApplyDo
     */
    private void validationDeleteAgrItemChg(AgrChngApplyDo agrChngApplyDo){
        if(ObjectUtil.isEmpty(agrChngApplyDo)){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参不能为空");
        }
        if(ObjectUtil.isEmpty(agrChngApplyDo.getChngApplyId())){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[变更申请ID]不能为空");
        }
        if(ObjectUtil.isEmpty(agrChngApplyDo.getAgrId())){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议ID]不能为空");
        }
    }

    @Override
    public AgrChngApplyDo getAgrChngApplyDetail(AgrAgrChngApplyQryBo agrAgrChngApplyQryBo) {
        return this.agrAgrChngRepository.getAgrChngApplyDetail(agrAgrChngApplyQryBo);
    }

    @Override
    public AgrChngApplyDo getAgrMainChngDetail(AgrAgrChngApplyQryBo agrAgrChngApplyQryBo) {
        //调用协议主体变更详情查询
        AgrChngApplyDo agrChngApplyDo = this.agrAgrChngRepository.getAgrMainChngDetail(agrAgrChngApplyQryBo);
        return agrChngApplyDo;
    }

    @Override
    public void saveAgrItemChng(AgrChngApplyDo agrChngApplyDo) {
        //调用明细变更新增方法
        agrAgrChngRepository.saveAgrItemChng(agrChngApplyDo);
    }

    @Override
    public AgrItemChngListQryRspPageBo getAgrItemChngList(AgrItemChngListQryReqPageBo agrItemChngListQryReqPageBo) {
        return this.agrAgrChngRepository.getAgrItemChngList(agrItemChngListQryReqPageBo);
    }

    @Override
    public void updateAgrChngApplyMain(AgrChngApplyDo agrChngApplyDo) {
        this.agrAgrChngRepository.updateAgrChngApplyMain(agrChngApplyDo);
    }

    @Override
    public void deleteChngApply(AgrChngApplyDo agrChngApplyDo) {
        //协议变更申请详情查询
        AgrAgrChngApplyQryBo agrAgrChngApplyQryBo = AgrRu.js(agrChngApplyDo,AgrAgrChngApplyQryBo.class);
        AgrChngApplyDo agrChngApplyDetail = getAgrChngApplyDetail(agrAgrChngApplyQryBo);
        //获取变更类型
        Integer chngType = agrChngApplyDetail.getChngType();
        //判断变更类型为其它变更调用协议主题删除
        if(AgrCommConstant.AgreementChangeType.OTHER.equals(chngType)){
            this.agrAgrChngRepository.deleteAgrMainChng(agrChngApplyDo);
        }
        //判断变更类型为(非)其它变更调用协议变更申请主体删除
        if(!AgrCommConstant.AgreementChangeType.OTHER.equals(chngType)){
            this.agrAgrChngRepository.deleteAgrChngApplyMain(agrChngApplyDo);
        }
        //判断变更类型为补充或者调价调用协议明细变更删除
        if(AgrCommConstant.AgreementChangeType.CHANGE_PRICE.equals(chngType) || AgrCommConstant.AgreementChangeType.SUPPLEMENT.equals(chngType)){
            this.agrAgrChngRepository.deleteAgrItemChng(agrChngApplyDo);
        }
    }

    @Override
    public AgrAgrChngApplyListRspBO getAgrChngApplyList(AgrAgrChngApplyQryBo agrAgrChngApplyQryBo) {
        return this.agrAgrChngRepository.getAgrChngApplyList(agrAgrChngApplyQryBo);
    }

    @Override
    public void checkAgrChngItemSave(AgrChngApplyDo agrChngApplyDo) {
        this.agrAgrChngRepository.checkAgrChngItemSave(agrChngApplyDo);
    }

    @Override
    public void updateAgrChngItemSpecifyField(AgrChngApplyDo agrChngApplyDo) {
        this.agrAgrChngRepository.updateAgrChngItemSpecifyField(agrChngApplyDo);
    }

    @Override
    public AgrAgrChngApplyListQryRspPageBo getAllChngByPage(AgrAgrChngApplyListQryReqPageBo agrAgrChngApplyListQryReqPageBo) {
        return this.agrAgrChngRepository.getAllChngByPage(agrAgrChngApplyListQryReqPageBo);
    }

    @Override
    public AgrChngApplyDo getAgrMainChng(AgrAgrChngApplyQryBo agrAgrChngApplyQryBo) {
        return this.agrAgrChngRepository.getAgrMainChng(agrAgrChngApplyQryBo);
    }
}
